/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMethod;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMethodType;
import java.io.IOException;

public class CSharpMethodWithBody
extends CSharpMethod {
    private int m_numberOfStatements;
    private int m_cyclomaticComplexity;
    private int m_modifiedCyclomaticComplexity;
    private short m_numberOfLogicalOperations;
    private short m_maxNesting;

    public CSharpMethodWithBody(NamedElement parent) {
        super(parent);
    }

    public CSharpMethodWithBody(IModelServiceProvider msp, NamedElement parent, String name, CSharpMethodType kind, String[] typeParameters) {
        super(msp, parent, name, kind, typeParameters);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_numberOfStatements = reader.readInt();
        this.m_cyclomaticComplexity = reader.readInt();
        this.m_modifiedCyclomaticComplexity = reader.readInt();
        this.m_numberOfLogicalOperations = (short)reader.readInt();
        this.m_maxNesting = reader.readShort();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_numberOfStatements);
        writer.writeInt(this.m_cyclomaticComplexity);
        writer.writeInt(this.m_modifiedCyclomaticComplexity);
        writer.writeInt((int)this.m_numberOfLogicalOperations);
        writer.writeShort(this.m_maxNesting);
    }

    public void setCyclomaticComplexity(int cyclomaticComplexity) {
        this.m_cyclomaticComplexity = cyclomaticComplexity;
    }

    public void setModifiedCyclomaticComplexity(int modifiedCyclomaticComplexity) {
        this.m_modifiedCyclomaticComplexity = modifiedCyclomaticComplexity;
    }

    public void setNumberOfLogicalOperations(int numberOfLogicalOperations) {
        this.m_numberOfLogicalOperations = (short)numberOfLogicalOperations;
    }

    public void setNumberOfStatements(int numberOfStatements) {
        this.m_numberOfStatements = numberOfStatements;
    }

    @Override
    public int getMaxNesting() {
        return this.m_maxNesting;
    }

    public void setMaxNesting(int maxNesting) {
        this.m_maxNesting = (short)maxNesting;
    }

    public final int getSourceElementCount() {
        if (!this.isDefinedInEnclosingElement() || this.isExternal()) {
            return -1;
        }
        return 1 + this.m_numberOfStatements;
    }

    @Override
    public int getNumberOfStatements() {
        return this.m_numberOfStatements;
    }

    @Override
    public int getCyclomaticComplexity() {
        return this.m_cyclomaticComplexity;
    }

    @Override
    public int getExtendedCyclomaticComplexity() {
        return this.m_cyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @Override
    public int getModifiedExtendedCyclomaticComplexity() {
        return this.m_modifiedCyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @Override
    public int getModifiedCyclomaticComplexity() {
        return this.m_modifiedCyclomaticComplexity;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCSharpRoslynMethodWithBody(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitCSharpRoslynMethodWithBody(CSharpMethodWithBody var1);
    }
}

