/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.path;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNameContributor;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.IWorkspaceFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.ISourceElementCountProvider;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotRootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotSourceFilePath;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.element.CSharpStructureItem;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.element.ICSharpNamespaceFragment;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpFileType;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import java.util.List;

public final class CSharpSourceFile
extends SourceFile
implements ICSharpNamespaceFragment,
IComponent,
IRefactorable,
ISnapshotSourceFilePath {
    private IModelServiceProvider m_msp;
    private boolean m_excluded;
    private boolean m_ignoreIssues;

    public CSharpSourceFile(NamedElement parent) {
        super(parent);
    }

    public CSharpSourceFile(IModelServiceProvider msp, NamedElement parent, TFile file) {
        super(parent, file);
        assert (msp != null) : "Parameter 'msp' of method 'CSharpSourceFile' must not be null";
        this.m_msp = msp;
    }

    public boolean isExternal() {
        return false;
    }

    public FilePath getPhysicalFilePath() {
        return this;
    }

    public NamedElement getParent() {
        return this.getParent(this.m_msp);
    }

    public List<NamedElement> getChildren() {
        return this.getChildren(this.m_msp);
    }

    public NamedElement getOriginal() {
        return this.getOriginal(this.m_msp);
    }

    public NamedElement getRepresentative() {
        return this.getRepresentative(this.m_msp);
    }

    public void setModelServiceProvider(IModelServiceProvider msp) {
        assert (msp != null) : "Parameter 'msp' of method 'setModelServiceProvider' must not be null";
        this.m_msp = msp;
    }

    public Element.IPropertiesManager getPropertiesManager() {
        return this.m_msp.getPropertiesManager();
    }

    public ElementWithIssues.IIssueManager getIssueManager() {
        return this.m_msp.getIssueManager();
    }

    public IVirtualModel getCurrentModel() {
        return this.m_msp.getCurrentModel();
    }

    public IFileType getFileType() {
        return CSharpFileType.SOURCE_FILE;
    }

    @Override
    public boolean isGlobalNamespace() {
        return true;
    }

    @Override
    public ICSharpNamespaceFragment getNamespaceParent() {
        return null;
    }

    @Property
    public String getWorkspaceFilterName() {
        CSharpSourceFile original;
        CSharpSourceFile cSharpSourceFile = original = this.m_msp != null ? (CSharpSourceFile)this.m_msp.getCurrentModel().getOriginal((ElementWithIssues)this) : this;
        assert (original != null) : "'original' of method 'getWorkspaceFilterName' must not be null";
        IWorkspaceFilterNamePrefixProvider provider = (IWorkspaceFilterNamePrefixProvider)original.getParent(IWorkspaceFilterNamePrefixProvider.class, new Class[0]);
        assert (provider != null) : "'provider' of method 'getWorkspaceFilterName' must not be null";
        return provider.getWorkspaceFilterNamePrefix() + FileUtility.removeExtension((String)original.getName()).substring("./".length());
    }

    public String getArchitectureFilterName() {
        IArchitectureFilterNamePrefixProvider provider = (IArchitectureFilterNamePrefixProvider)this.getParent(IArchitectureFilterNamePrefixProvider.class, new Class[0]);
        assert (provider != null) : "Parameter 'provider' of method 'getArchitectureFilterName' must not be null";
        IArchitectureFilterNameContributor contributor = (IArchitectureFilterNameContributor)this.getParent(IArchitectureFilterNameContributor.class, new Class[0]);
        return provider.getArchitectureFilterNamePrefix() + (contributor != null ? contributor.getArchitectureFilterNamePart() : "") + FileUtility.removeExtension((String)this.getShortName());
    }

    public void setIsExcluded(boolean excluded) {
        this.m_excluded = excluded;
    }

    @Property
    public boolean isExcluded() {
        return this.m_excluded;
    }

    public void setIgnoreIssues(boolean ignore) {
        this.m_ignoreIssues = ignore;
    }

    @Property
    public boolean ignoreIssues() {
        return this.m_ignoreIssues;
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    public int getSize() {
        int sourceElementCount = 0;
        for (ISourceElementCountProvider next : this.getChildrenRecursively(ISourceElementCountProvider.class, new Class[0])) {
            int nextSec = next.getSourceElementCount();
            if (nextSec == -1) continue;
            sourceElementCount += nextSec;
        }
        return sourceElementCount;
    }

    public IStructureItem getStructureItem() {
        return CSharpStructureItem.CSHARP_SOURCE_FILE;
    }

    public ISnapshotRootDirectoryPath getRootDirectoryPath() {
        return (ISnapshotRootDirectoryPath)this.getParent(ISnapshotRootDirectoryPath.class, new Class[0]);
    }

    public List<SourceFile> getSources() {
        return Collections.singletonList(this);
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCSharpSourceFile(this);
        } else {
            super.accept(visitor);
        }
    }

    public String toString() {
        if (this.m_msp != null && this.m_msp.getCurrentModel().getOriginal((ElementWithIssues)this) != this) {
            StringBuilder builder = new StringBuilder("[Clone] ");
            builder.append(super.toString());
            return builder.toString();
        }
        return super.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCSharpSourceFile(CSharpSourceFile var1);
    }
}

