/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.system.SignatureElement;
import java.io.IOException;

public final class SourceFileSettingsSignature
extends SignatureElement {
    private static final String SEPARATOR = "_";
    private String m_path;

    public SourceFileSettingsSignature(NamedElement parent) {
        super(parent);
    }

    public SourceFileSettingsSignature(NamedElement parent, String path, String signature) {
        super(parent, signature);
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'SourceFileSettingsSignature' must not be empty";
        this.m_path = path;
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_path = reader.readString();
    }

    public String getShortName() {
        return SourceFileSettingsSignature.createIdentifier(this.m_path, super.getShortName());
    }

    public String getFullyQualifiedNamePart() {
        StringBuilder fqNamePart = new StringBuilder();
        fqNamePart.append((CharSequence)this.m_path.chars().filter(c -> c != 58).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append));
        return fqNamePart.append(SEPARATOR).append(super.getShortName()).toString();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_path);
    }

    public static String createIdentifier(String path, String signature) {
        return path + SEPARATOR + signature;
    }
}

