/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElementWithChildren;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppHasSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppNamespaceMember;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.IHasFqnSerialNumber;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.NameHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDeclaresDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppParameterAndReturnTypeExtractor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignatureParser;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignaturePrinter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.OldSignatureHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class CppRoutine
extends ProgrammingElementWithChildren
implements ICppHasSignature,
ICppNamespaceMember,
IRoutine,
IHasFqnSerialNumber {
    protected static final short INLINE_BIT = 1;
    protected static final short VIRTUAL_BIT = 2;
    protected static final short FINAL_BIT = 4;
    protected static final short PURE_VIRTUAL_BIT = 8;
    protected static final short STATIC_BIT = 16;
    protected static final short DELETED_BIT = 32;
    protected static final short DEFAULTED_BIT = 64;
    protected static final short IN_ANONYMOUS_NAMESPACE = 128;
    private String m_signature = CppSignature.UNDEFINED_ROUTINE;
    private short m_numberOfParameters = (short)-1;
    private short m_booleanPropertyBits = 0;
    private short m_numberOfTemplateArgumemts;
    private short m_serialNumberForQualifiedName = 0;

    protected CppRoutine(NamedElement parent) {
        super(parent);
    }

    protected CppRoutine(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, short numberOfTemplateArgs) {
        super(msp, parent, name, lineNumber);
        this.m_numberOfTemplateArgumemts = numberOfTemplateArgs;
    }

    public final ProgrammingElement getOriginal() {
        return (ProgrammingElement)this.getOriginal(this.getModelServiceProvider());
    }

    public final ProgrammingElement getRepresentative() {
        return (ProgrammingElement)this.getRepresentative(this.getModelServiceProvider());
    }

    public boolean isTemplate() {
        return this.m_numberOfTemplateArgumemts > 0;
    }

    @Override
    public void setSerialNumberForQualifiedName(short serialNumberFoQualifiedName) {
        this.m_serialNumberForQualifiedName = serialNumberFoQualifiedName;
    }

    @Override
    public final ProgrammingElement getProgrammingElement() {
        return this;
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        String result = this.getShortName() + CppSignaturePrinter.print(this.m_signature, false).replace("::", ".");
        if (this.m_serialNumberForQualifiedName > 0) {
            result = result + INNER_NAME_PARTS_SEPARATOR + Short.toString(this.m_serialNumberForQualifiedName);
        }
        return result;
    }

    public final boolean isMember() {
        return true;
    }

    public List<? extends ProgrammingElement> getDefinitions() {
        if (this.isDefinition()) {
            return super.getDefinitions();
        }
        ArrayList<CppRoutine> result = new ArrayList<CppRoutine>();
        for (ParserDependency dep : this.getOutgoingDependencies(new IParserDependencyType[]{CppDependencyType.DECLARES})) {
            result.add((CppRoutine)dep.getTo());
        }
        return result;
    }

    @IntProperty
    public int getNumberOfStatements() {
        return -1;
    }

    @IntProperty
    public int getMaxNesting() {
        return -1;
    }

    @IntProperty
    public int getCyclomaticComplexity() {
        return -1;
    }

    @IntProperty
    public int getExtendedCyclomaticComplexity() {
        return -1;
    }

    @IntProperty
    public int getModifiedExtendedCyclomaticComplexity() {
        return -1;
    }

    @IntProperty
    public int getModifiedCyclomaticComplexity() {
        return -1;
    }

    public List<String> getArgumentTypes() {
        List<String> result = CppParameterAndReturnTypeExtractor.getReturnAndParameterTypes((ProgrammingElement)this, this.m_signature);
        return result.subList(1, result.size());
    }

    public String getReturnType() {
        return CppParameterAndReturnTypeExtractor.getReturnAndParameterTypes((ProgrammingElement)this, this.m_signature).get(0);
    }

    protected final boolean hasBooleanProperty(short bit) {
        return (this.m_booleanPropertyBits & bit) != 0;
    }

    protected final void setPropertyBit(short bit, boolean set) {
        this.m_booleanPropertyBits = set ? (short)(this.m_booleanPropertyBits | bit) : (short)(this.m_booleanPropertyBits & ~bit);
    }

    public final boolean isInline() {
        return this.hasBooleanProperty((short)1);
    }

    public final void setInline(boolean isInline) {
        this.setPropertyBit((short)1, isInline);
    }

    public final void setStatic(boolean isStatic) {
        this.setPropertyBit((short)16, isStatic);
    }

    public final boolean isStatic() {
        return this.hasBooleanProperty((short)16);
    }

    public final void setDeleted(boolean isDeleted) {
        this.setPropertyBit((short)32, isDeleted);
    }

    public final void setInAnonymousNamespace(boolean inAnonymousNamespace) {
        this.setPropertyBit((short)128, inAnonymousNamespace);
    }

    public final boolean isDeleted() {
        return this.hasBooleanProperty((short)32);
    }

    public final void setDefaulted(boolean isDefaulted) {
        this.setPropertyBit((short)64, isDefaulted);
    }

    public final boolean isDefaulted() {
        return this.hasBooleanProperty((short)64);
    }

    public final void setVirtual(boolean isVirtual) {
        this.setPropertyBit((short)2, isVirtual);
    }

    public final boolean isVirtual() {
        return this.hasBooleanProperty((short)2);
    }

    public final void setFinal(boolean isFinal) {
        this.setPropertyBit((short)4, isFinal);
    }

    public final boolean isFinal() {
        return this.hasBooleanProperty((short)4);
    }

    @Override
    public final String getSignature() {
        return this.m_signature;
    }

    @Override
    public final void setSignature(String signature) {
        assert (signature != null && signature.length() > 0) : "'signature' must not be null";
        this.m_signature = signature;
    }

    public final void setNumberOfParameters(int numberOfParameters) {
        assert (numberOfParameters <= Short.MAX_VALUE) : "number of parameters cannot be greater than 32767";
        this.m_numberOfParameters = (short)numberOfParameters;
    }

    @IntProperty
    public final int getNumberOfParameters() {
        return this.m_numberOfParameters;
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        if (reader.getVersion() <= 16) {
            CppSignature sig = new CppSignature(reader);
            this.m_signature = OldSignatureHelper.convert(sig, CppSignatureParser.UNDEFINED_ROUTINE);
        } else {
            this.m_signature = reader.readString();
        }
        this.m_numberOfParameters = reader.readShort();
        this.m_booleanPropertyBits = reader.readShort();
        if (reader.getVersion() >= 14) {
            this.m_numberOfTemplateArgumemts = reader.readShort();
            this.m_serialNumberForQualifiedName = reader.readShort();
        }
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_signature);
        writer.writeShort(this.m_numberOfParameters);
        writer.writeShort(this.m_booleanPropertyBits);
        writer.writeShort(this.m_numberOfTemplateArgumemts);
        writer.writeShort(this.m_serialNumberForQualifiedName);
    }

    public final String getName() {
        return NameHelper.getFullName((NamedElement)this) + CppSignaturePrinter.print(this.m_signature, false);
    }

    public final String getPresentationName(boolean parentIsPresented) {
        if (!parentIsPresented) {
            return this.getName();
        }
        return this.getShortName() + CppSignaturePrinter.print(this.m_signature, false);
    }

    public CppRoutine getDefinition() {
        return this;
    }

    @Override
    public abstract boolean isDefinition();

    public final boolean isPureVirtual() {
        return this.hasBooleanProperty((short)8);
    }

    public final void setPureVirtual(boolean set) {
        this.setPropertyBit((short)8, set);
    }

    protected final int clearInvalidDefinitionsImp() {
        int count = 0;
        for (ParserDependency dep : this.getOutgoingDependencies(new IParserDependencyType[]{CppDependencyType.DECLARES})) {
            if (!dep.getTo().isValid()) {
                dep.getFrom().removeDependency(dep);
                continue;
            }
            ++count;
        }
        return count;
    }

    protected final int addDefinitionImp(CppRoutine definition) {
        assert (definition != null) : "Parameter 'definition' of method 'addDefinition' must not be null";
        boolean found = false;
        int count = 0;
        for (ParserDependency dep : this.getOutgoingDependencies(new IParserDependencyType[]{CppDependencyType.DECLARES})) {
            if (dep.getTo() == definition) {
                found = true;
            }
            ++count;
        }
        if (!found) {
            this.addDependency(new CppDeclaresDependency((ProgrammingElement)this, (ProgrammingElement)definition));
            ++count;
        }
        return count;
    }

    public int clearInvalidDefinitions() {
        assert (false) : "should only be called on declarations";
        return 0;
    }

    public int addDefinition(CppRoutine routine) {
        assert (routine != null) : "Parameter 'routine' of method 'addDefinition' must not be null";
        return 0;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppRoutine(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppRoutine(CppRoutine var1);
    }
}

