/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser;

import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RuntimeInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeInfo.class);
    private static final String BUNDLE_CLASSPATH = "Bundle-ClassPath";

    private RuntimeInfo() {
    }

    private static List<String> getBundleClasspathHeader(String bundleId) {
        if (org.eclipse.core.runtime.Platform.isRunning()) {
            return RuntimeInfo.getBundleClasspathHeaderOsgi(bundleId);
        }
        return RuntimeInfo.getBundleClasspathHeaderJunit(bundleId);
    }

    private static List<String> getBundleClasspathHeaderOsgi(String bundleId) {
        assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'getBundleClasspathHeaderOsgi' must not be empty";
        Bundle bundle = org.eclipse.core.runtime.Platform.getBundle((String)bundleId);
        if (bundle != null) {
            String cp = (String)bundle.getHeaders().get(BUNDLE_CLASSPATH);
            if (cp != null && !cp.isEmpty()) {
                List result = StringUtility.splitAndTrim((String)cp, (String)",");
                return result;
            }
        } else {
            LOGGER.error("Couldn't find bundle '{}'", (Object)bundleId);
        }
        return Collections.emptyList();
    }

    private static List<String> getBundleClasspathHeaderJunit(String bundleId) {
        assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'getBundleClasspathHeaderJunit' must not be empty";
        try {
            Manifest manifest = new Manifest(new FileInputStream(new File("../" + bundleId + "/META-INF/MANIFEST.MF")));
            Attributes attr = manifest.getMainAttributes();
            String cp = attr.getValue(BUNDLE_CLASSPATH);
            if (cp != null && !cp.isEmpty()) {
                List result = StringUtility.splitAndTrim((String)cp, (String)",");
                return result;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static String getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        assert (javaHome != null && javaHome.length() > 0) : "System property 'java.home' must be set";
        LOGGER.info("Java home for java executable is {}", (Object)javaHome);
        String extension = Platform.isWindows() ? ".exe" : "";
        String java = "java" + extension;
        String javaw = "javaw" + extension;
        Object result = null;
        File javaHomeDirectory = new File(javaHome);
        if (javaHomeDirectory.exists() && javaHomeDirectory.isDirectory()) {
            File jreBin;
            File bin = new File(javaHomeDirectory, "bin");
            if (bin.exists() && bin.isDirectory()) {
                File binJava = new File(bin, java);
                File binJavaw = new File(bin, javaw);
                if (binJava.exists() && binJava.canExecute()) {
                    result = binJava.getAbsolutePath();
                } else if (binJavaw.exists() && binJavaw.canExecute()) {
                    result = binJavaw.getAbsolutePath();
                }
            }
            if ((jreBin = new File(javaHomeDirectory, "jre/bin")).exists() && jreBin.isDirectory()) {
                File jreBinJava = new File(jreBin, java);
                File jreBinJavaw = new File(jreBin, javaw);
                if (jreBinJava.exists() && jreBinJava.canExecute()) {
                    result = jreBinJava.getAbsolutePath();
                } else if (jreBinJavaw.exists() && jreBinJavaw.canExecute()) {
                    result = jreBinJavaw.getAbsolutePath();
                }
            }
        } else {
            LOGGER.error("java.home must point to an existing directory");
        }
        if (result == null) {
            result = java;
        }
        LOGGER.info("Java executable is {}", result);
        return result;
    }

    public static List<String> getBundleInternalClasspath(String bundleId) throws FileNotFoundException {
        assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'getBundleClasspath' must not be empty";
        ArrayList<String> result = new ArrayList<String>();
        List<String> classpathHeader = RuntimeInfo.getBundleClasspathHeader(bundleId);
        if (classpathHeader.isEmpty()) {
            File baseDirectory = RuntimeInfo.getFileInBundle(bundleId, ".");
            result.add(baseDirectory.getAbsolutePath());
            return result;
        }
        for (String next : classpathHeader) {
            File nextFile = RuntimeInfo.getFileInBundle(bundleId, next);
            result.add(nextFile.getAbsolutePath());
        }
        return result;
    }

    private static File getFileInBundleOsgi(String bundleId, String pathInBundle) {
        URL url;
        String urlString;
        boolean isBaseDirectory;
        block8: {
            assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'getFileInBundleOsgi' must not be empty";
            assert (pathInBundle != null && pathInBundle.length() > 0) : "Parameter 'pathInBundle' of method 'getFileInBundleOsgi' must not be empty";
            isBaseDirectory = ".".equals(pathInBundle);
            urlString = "platform:///plugin/" + bundleId + "/" + (isBaseDirectory ? "" : pathInBundle);
            url = FileLocator.find((URL)new URI(urlString).toURL());
            if (url != null) break block8;
            LOGGER.error("Couldn't find file '{}' in osgi bundle '{}'", (Object)urlString, (Object)bundleId);
            return null;
        }
        try {
            URL fileUrl = FileLocator.toFileURL((URL)url);
            URI fileUri = new URI(fileUrl.getProtocol(), fileUrl.getPath(), null).normalize();
            File file = new File(fileUri);
            if (isBaseDirectory && file.isDirectory()) {
                File targetClasses;
                File buildEclipse = new File(file, "build.eclipse");
                if (buildEclipse.exists() && buildEclipse.isDirectory()) {
                    file = buildEclipse;
                }
                if ((targetClasses = new File(file, "target/classes")).exists() && targetClasses.isDirectory()) {
                    file = targetClasses;
                }
            }
            LOGGER.debug("Found {} for {}", (Object)file.getAbsolutePath(), (Object)urlString);
            return file;
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            LOGGER.error("Couldn't find '{}': '{}'", (Object)urlString, (Object)e.getMessage());
            return null;
        }
    }

    private static File getFileInBundleJunit(String bundleId, String pathInBundle) {
        assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'getFileInBundleJunit' must not be empty";
        assert (pathInBundle != null && pathInBundle.length() > 0) : "Parameter 'pathInBundle' of method 'getFileInBundleJunit' must not be empty";
        boolean isBaseDirectory = ".".equals(pathInBundle);
        if (isBaseDirectory && !new File("../" + bundleId).exists()) {
            File libDirectory = new File("../com.hello2morrow.sonargraph.language.provider.cplusplus/lib");
            File[] fileArray = libDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File bundle = fileArray[n2];
                if (bundle.getName().startsWith(bundleId + "_") && bundle.getName().endsWith(".jar")) {
                    return bundle;
                }
                ++n2;
            }
        }
        String fileString = "../" + bundleId + "/" + (isBaseDirectory ? "" : pathInBundle);
        File file = new File(fileString);
        if (isBaseDirectory && file.isDirectory()) {
            File targetClasses;
            File buildEclipse = new File(file, "build.eclipse");
            if (buildEclipse.exists() && buildEclipse.isDirectory()) {
                file = buildEclipse;
            }
            if ((targetClasses = new File(file, "target/classes")).exists() && targetClasses.isDirectory()) {
                file = targetClasses;
            }
        }
        LOGGER.info("Found {} for bundle: {} and path: {}", new Object[]{file.getAbsolutePath(), bundleId, pathInBundle});
        return file;
    }

    public static File getFileInBundle(String bundleId, String pathInBundle) throws FileNotFoundException {
        File result = org.eclipse.core.runtime.Platform.isRunning() ? RuntimeInfo.getFileInBundleOsgi(bundleId, pathInBundle) : RuntimeInfo.getFileInBundleJunit(bundleId, pathInBundle);
        if (result != null) {
            return result;
        }
        String message = String.format("'%s' in bundle '%s' couldn't be found", pathInBundle, bundleId);
        LOGGER.error(message);
        throw new FileNotFoundException(message);
    }
}

