/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.visualstudio;

import com.hello2morrow.sonargraph.core.model.system.settings.IVisualStudioProjectReferenceInfo;
import com.hello2morrow.sonargraph.core.model.system.settings.IVisualStudioProjectType;
import com.hello2morrow.sonargraph.core.model.system.settings.SolutionFileInfo;
import com.hello2morrow.sonargraph.core.model.system.settings.VisualStudioProjectType;
import com.hello2morrow.sonargraph.core.persistence.system.settings.SolutionFileReader;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusProjectReferenceInfo;
import de.schlichtherle.truezip.file.TFile;
import java.util.Arrays;

public class CPlusPlusSolutionFileReader
extends SolutionFileReader {
    public CPlusPlusSolutionFileReader(TFile solutionFile) {
        super(solutionFile);
    }

    protected boolean isValidProjectType(IVisualStudioProjectReferenceInfo reference) {
        assert (reference != null) : "Parameter 'reference' of method 'isValidProjectType' must not be null";
        boolean match = Arrays.asList(VisualStudioProjectType.values()).stream().anyMatch(t -> t.getProjectTypeId().equals(reference.getProjectType().getProjectTypeId()));
        return match;
    }

    protected IVisualStudioProjectReferenceInfo createProjectReference(IVisualStudioProjectType type, String name, TFile projectFile, String projectFilePathWithEscapedEnvVars) {
        assert (type != null) : "Parameter 'type' of method 'createProjectReference' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createProjectReference' must not be empty";
        assert (projectFile != null) : "Parameter 'projectFile' of method 'createProjectReference' must not be null";
        CPlusPlusProjectReferenceInfo reference = new CPlusPlusProjectReferenceInfo(projectFile, name, projectFilePathWithEscapedEnvVars);
        reference.setProjectType(type);
        return reference;
    }

    protected IVisualStudioProjectType getProjectType(String type) {
        assert (type != null) : "Parameter 'type' of method 'getProjectType' must not be null";
        return VisualStudioProjectType.getType((String)type);
    }

    protected boolean isValidProjectFileExtension(String extension) {
        assert (extension != null && extension.length() > 0) : "Parameter 'extension' of method 'isValidProjectFileExtension' must not be empty";
        return extension.equals(CPlusPlusFileType.VISUAL_STUDIO_PROJECT_FILE.getDefaultExtension());
    }

    protected boolean isDuplicateNameOrAssemblyNameOrProjectKey(SolutionFileInfo solution, IVisualStudioProjectReferenceInfo projectReference) {
        return false;
    }
}

