/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeader;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSource;
import java.io.IOException;

public final class CompilationUnitFragment
extends NamedElementContainer {
    private CppHeader m_associatedHeader;
    private int m_lineNumber;

    public CompilationUnitFragment(NamedElement parent) {
        super(parent);
    }

    public CompilationUnitFragment(NamedElement parent, CppHeader associatedHeader, int lineNumber) {
        super(parent);
        assert (associatedHeader != null) : "Parameter 'associated' of method 'CompilationUnitFragment' must not be null";
        this.m_associatedHeader = associatedHeader;
        this.m_lineNumber = lineNumber;
    }

    public String getImageResourceName() {
        return "CppHeaderIncludeFile";
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public boolean isValid() {
        return super.isValid() && this.m_associatedHeader.isValid();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        assert (this.m_associatedHeader != null) : "m_associatedHeader must not be null";
        writer.write((ISnapshotWriter.IStorable)this.m_associatedHeader);
        writer.writeInt(this.m_lineNumber);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_associatedHeader = (CppHeader)reader.read(CppHeader.class, new SnapshotArgument[0]);
        assert (this.m_associatedHeader != null);
        this.m_associatedHeader.addFragment(this);
        this.m_lineNumber = reader.readInt();
    }

    public String getName() {
        return this.m_associatedHeader.getName();
    }

    public String getShortName() {
        return this.m_associatedHeader.getShortName();
    }

    public String getFullyQualifiedNamePart() {
        return this.m_associatedHeader.getFullyQualifiedNamePart() + "-" + this.m_lineNumber;
    }

    public String getPresentationName(boolean parentIsPresented) {
        return this.m_associatedHeader.getPresentationName(parentIsPresented);
    }

    public CppHeader getAssociatedHeader() {
        return this.m_associatedHeader;
    }

    public void setAssociatedHeader(CppHeader associatedHeader) {
        this.m_associatedHeader = associatedHeader;
    }

    public boolean isExternal() {
        return this.m_associatedHeader.isExternal();
    }

    public void remove() {
        this.discard();
        super.remove();
    }

    public void discard() {
        this.discardChildren();
        this.m_associatedHeader.removeFragment(this);
    }

    public void discardChildren() {
        for (CompilationUnitFragment fragment : this.getChildren(CompilationUnitFragment.class)) {
            fragment.discard();
        }
    }

    public CppSource getElement() {
        return this.m_associatedHeader;
    }

    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append(this.m_associatedHeader.toString());
        return builder.toString();
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppCompilationUnitFragment(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppCompilationUnitFragment(CompilationUnitFragment var1);
    }
}

