/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.CObjectRenderer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDGVisitor;

public class EDG {
    private static EDGVisitor visitor;

    static {
        System.loadLibrary("edg");
    }

    public static native Position getPositionFromSequenceNumber(long var0, int var2);

    public static native IlHeader ilHeader();

    public static native void configure(int var0, int var1, int var2);

    public static native int edgMain(int var0, String[] var1);

    public static int invokeParser(String[] args, EDGVisitor v) {
        int result = -1;
        try {
            visitor = v;
            result = EDG.edgMain(args.length, args);
        }
        finally {
            visitor = null;
        }
        return result;
    }

    private static void analyze() {
        if (visitor != null) {
            EDG.ilHeader().accept(visitor);
        }
    }

    public static enum AccessSpecifier {
        AS_PUBLIC,
        AS_PROTECTED,
        AS_PRIVATE,
        AS_INACCESSIBLE;


        public static AccessSpecifier fromInt(int i) {
            return AccessSpecifier.values()[i];
        }
    }

    public static enum AddressBaseKind {
        ABK_ROUTINE,
        ABK_VARIABLE,
        ABK_CONSTANT,
        ABK_TEMPORARY,
        ABK_UUIDOF,
        ABK_TYPEID,
        ABK_CLI_TYPEID,
        ABK_CLI_ARRAY,
        ABK_LABEL,
        ABK_PARAM_REF,
        ABK_LAST;


        public static AddressBaseKind fromInt(int i) {
            return AddressBaseKind.values()[i];
        }
    }

    public static enum AnonymousUnionKind {
        AUK_NONE,
        AUK_VARIABLE,
        AUK_FIELD;


        public static AnonymousUnionKind fromInt(int i) {
            return AnonymousUnionKind.values()[i];
        }
    }

    public static class ArgOperand
    extends CObject {
        public ArgOperand(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitArgOperand(this);
        }
    }

    public static class AsmEntry
    extends CObject {
        public AsmEntry(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitAsmEntry(this);
        }

        @Override
        public native SourceCorrespondence sourceCorresp();

        public native AsmEntry next();

        public native Constant asmString();

        public native boolean gnuAsmForm();

        public native boolean isVolatile();

        public native boolean hasVolatileKeyword();

        public native boolean hasInlineKeyword();

        public native boolean isAsmGoto();

        public native AsmOperand operands();

        public native NamedRegisterList clobbers();

        public native LabelList labels();
    }

    public static class AsmOperand
    extends CObject {
        public AsmOperand(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitAsmOperand(this);
        }

        public native AsmOperand next();

        public native String name();

        public native boolean isOutputOperand();

        public native String constraintsString();

        public native SourcePosition position();

        public native ExprNode expression();
    }

    public static class Attribute
    extends CObject {
        public Attribute(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitAttribute(this);
        }

        public native Attribute next();

        public native AttributeKind kind();

        public native AttributeFamily family();

        public native AttributeLocation syntacticLocation();

        public native boolean onPrimaryDeclaration();

        public native boolean transformsTypeSpecifier();

        public native boolean mustBePreservedInTransUnitCopy();

        public native boolean isPackExpansion();

        public native boolean isStdGccAttribute();

        public native boolean isImplicitAbiTagAttribute();

        public native boolean namespaceFromUsing();

        public native boolean isInvalidNamespace();

        public native String name();

        public native String namespaceName();

        public native AttributeArg arguments();

        public native AttributeGroup group();

        public native SourcePosition position();

        public native SourcePosition endPosition();

        public native PackExpansionDescr packExpansionDescr();
    }

    public static class AttributeArg
    extends CObject {
        public AttributeArg(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitAttributeArg(this);
        }

        public native AttributeArg next();

        public native TokenKind tokenKind();

        public native AttributeArgKind kind();

        public native boolean isPackExpansion();

        public native PackExpansionDescr packExpansionDescr();

        public native SourcePosition position();

        public native SourcePosition endPosition();
    }

    public static class AttributeArgConstant
    extends AttributeArg {
        public AttributeArgConstant(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitAttributeArgConstant(this);
        }

        public native Constant constant();
    }

    public static class AttributeArgExpr
    extends AttributeArg {
        public AttributeArgExpr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitAttributeArgExpr(this);
        }

        public native ExprNode expr();
    }

    public static enum AttributeArgKind {
        AAK_EMPTY,
        AAK_RAW_TOKEN,
        AAK_TOKEN,
        AAK_CONSTANT,
        AAK_TYPE,
        AAK_EXPRESSION,
        AAK_LAST;


        public static AttributeArgKind fromInt(int i) {
            return AttributeArgKind.values()[i];
        }
    }

    public static class AttributeArgToken
    extends AttributeArg {
        public AttributeArgToken(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitAttributeArgToken(this);
        }

        public native String token();
    }

    public static class AttributeArgType
    extends AttributeArg {
        public AttributeArgType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitAttributeArgType(this);
        }

        public native Type type();
    }

    public static enum AttributeFamily {
        AF_INTERNAL,
        AF_STD,
        AF_GNU,
        AF_MS_DECLSPEC,
        AF_ALIGNAS,
        AF_HAS_ATTRIBUTE,
        AF_LAST;


        public static AttributeFamily fromInt(int i) {
            return AttributeFamily.values()[i];
        }
    }

    public static class AttributeGroup
    extends CObject {
        public AttributeGroup(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitAttributeGroup(this);
        }

        public native SourcePosition position();

        public native SourcePosition endPosition();
    }

    public static enum AttributeKind {
        AK_UNRECOGNIZED,
        AK_EMPTY_ATTR,
        AK_ATTR_USING_PREFIX,
        AK_ALIGN,
        AK_BASE_CHECK,
        AK_CARRIES_DEPENDENCY,
        AK_DEPRECATED,
        AK_FINAL,
        AK_HIDING,
        AK_KNOWN_SEMANTICS,
        AK_NORETURN,
        AK_OVERRIDE,
        AK_NODISCARD,
        AK_NOOP_DTOR,
        AK_MAYBE_UNUSED,
        AK_FALLTHROUGH,
        AK_LIKELY,
        AK_UNLIKELY,
        AK_NO_UNIQUE_ADDRESS,
        AK_ENABLE_IF,
        AK_OVERLOADABLE,
        AK_PASS_OBJECT_SIZE,
        AK_DIAGNOSE_IF,
        AK_UNAVAILABLE,
        AK_NAKED,
        AK_NOINLINE,
        AK_NOTHROW,
        AK_PURE,
        AK_SECTION,
        AK_ALIAS,
        AK_ALLOC_SIZE,
        AK_ALWAYS_INLINE,
        AK_ARTIFICIAL,
        AK_CDECL,
        AK_CLEANUP,
        AK_COLD,
        AK_COMMON,
        AK_CONST,
        AK_CONSTRUCTOR,
        AK_DESTRUCTOR,
        AK_ERROR,
        AK_EXTERNALLY_VISIBLE,
        AK_FASTCALL,
        AK_FLATTEN,
        AK_FORMAT,
        AK_FORMAT_ARG,
        AK_GNU_INLINE,
        AK_HOT,
        AK_IFUNC,
        AK_INTERNAL_LINKAGE,
        AK_MALLOC,
        AK_MAY_ALIAS,
        AK_MODE,
        AK_NO_INSTRUMENT_FUNCTION,
        AK_NO_CHECK_MEMORY_USAGE,
        AK_NOCOMMON,
        AK_NONNULL,
        AK_NOPLT,
        AK_PACKED,
        AK_SENTINEL,
        AK_STDCALL,
        AK_STRONG,
        AK_TARGET,
        AK_TLS_MODEL,
        AK_TRANSPARENT_UNION,
        AK_UNUSED,
        AK_USED,
        AK_WARN_UNUSED_RESULT,
        AK_WARNING,
        AK_WEAK,
        AK_WEAKREF,
        AK_ABI_TAG,
        AK_APPDOMAIN,
        AK_ASSEMBLY_INFO,
        AK_DLLEXPORT,
        AK_DLLIMPORT,
        AK_EDG_INTERIOR_PTR_ALIAS,
        AK_EDG_PIN_PTR_ALIAS,
        AK_EMPTY_BASES,
        AK_GUARD,
        AK_HYBRID_PATCHABLE,
        AK_IMPLEMENTATION_KEY,
        AK_INTRIN_TYPE,
        AK_JITINTRINSIC,
        AK_NO_INIT_ALL,
        AK_NOALIAS,
        AK_NON_USER_CODE,
        AK_NOVTABLE,
        AK_PROCESS,
        AK_PROPERTY,
        AK_RESTRICT,
        AK_SAFEBUFFERS,
        AK_SELECTANY,
        AK_SPECTRE,
        AK_THREAD,
        AK_UUID,
        AK_LAYOUT_AS_EXTERNAL,
        AK_NO_EMPTY_IDENTITY_INTERFACE,
        AK_NO_FTM,
        AK_NO_REFCOUNT,
        AK_NO_RELEASE_RETURN,
        AK_NO_WEAKREFERENCESOURCE,
        AK_ONE_PHASE_CONSTRUCTED,
        AK_ALLOCATOR,
        AK_NO_SANITIZE_ADDRESS,
        AK_AVAILABILITY,
        AK_USING_IF_EXISTS,
        AK_ANNOTATION,
        AK_CONDITIONAL_EXPLICIT,
        AK_PRAGMA_PACK_STATE,
        AK_LAST;


        public static AttributeKind fromInt(int i) {
            return AttributeKind.values()[i];
        }
    }

    public static enum AttributeLocation {
        AL_IMPLICIT,
        AL_PREFIX,
        AL_TAG_NAME,
        AL_POST_TAG_DEFINITION,
        AL_BASE_SPECIFIER,
        AL_SPECIFIER,
        AL_DECLARATOR_ID,
        AL_POST_PTR_OR_REF,
        AL_POST_ARRAY,
        AL_POST_FUNC,
        AL_POSTFIX,
        AL_PREDECLARATOR,
        AL_ID_EQUIVALENT,
        AL_TRAILING_RETURN,
        AL_POST_INITIALIZER,
        AL_NAMESPACE,
        AL_GNU_NAMESPACE,
        AL_LABEL,
        AL_EXPLICIT,
        AL_ENUMERATOR,
        AL_ID_EQUIVALENT_AS_POSTFIX,
        AL_BUILTIN_HAS_ATTRIBUTE,
        AL_MODULE,
        AL_POST_USING_DECLARATOR,
        AL_LAMBDA_EXPRESSION,
        AL_LAST;


        public static AttributeLocation fromInt(int i) {
            return AttributeLocation.values()[i];
        }
    }

    public static class BaseClass
    extends CObject {
        public BaseClass(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitBaseClass(this);
        }

        public native BaseClass next();

        public native BaseClass nextDirect();

        public native Attribute attributes();

        public native MsAttribute msAttributes();

        public native Type type();

        public native Type origType();

        public native Type derivedClass();

        public native TransUnitCorresp transUnitCorresp();

        public native SourcePosition declPosition();

        public native SourceRange baseSpecifierRange();

        public native boolean direct();

        public native boolean isVirtual();

        public native boolean ambiguous();

        public native boolean sharesVirtualFunctionInfo();

        public native boolean ignoreDuringDependentLookup();

        public native boolean isOptimizedEmptyBase();

        public native boolean isPackExpansion();

        public native boolean isImplicitDirectBase();

        public native boolean hasPublicDerivation();

        public native int directBaseNumber();

        public native long offset();

        public native long pointerOffset();

        public native BaseClass pointerBaseClass();

        public native BaseClassDerivation derivation();
    }

    public static class BaseClassDerivation
    extends CObject {
        public BaseClassDerivation(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitBaseClassDerivation(this);
        }

        public native BaseClassDerivation next();

        public native DerivationStep path();

        public native DerivationStep pathTail();

        public native boolean direct();

        public native boolean preferred();

        public native AccessSpecifier access();
    }

    public static class BaseClassOverridingVirtualFunctions
    extends BaseClass {
        public BaseClassOverridingVirtualFunctions(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitBaseClassOverridingVirtualFunctions(this);
        }

        public native OverridingVirtualFunction overridingVirtualFunctions();
    }

    public static class BaseClassPackExpansionDescr
    extends BaseClass {
        public BaseClassPackExpansionDescr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitBaseClassPackExpansionDescr(this);
        }

        public native PackExpansionDescr packExpansionDescr();
    }

    public static enum BasedTypeKind {
        BTK_QUALIFIED,
        BTK_RVALUE_REFERENCE,
        BTK_REFERENCE,
        BTK_PTR_TO_MEMBER,
        BTK_UNQUALIFIED_ARRAY_TYPE,
        BTK_HANDLE,
        BTK_TRACKING_REF,
        BTK_INTERIOR_PTR,
        BTK_PIN_PTR,
        BTK_CPPCX_BOX,
        BTK_POINTER,
        BTK_NO_NOEXCEPT_EXCEPTION_SPEC;


        public static BasedTypeKind fromInt(int i) {
            return BasedTypeKind.values()[i];
        }
    }

    public static class BasedTypeListMember
    extends CObject {
        public BasedTypeListMember(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitBasedTypeListMember(this);
        }

        public native BasedTypeListMember next();

        public native Type basedType();

        public native BasedTypeKind kind();

        public native boolean frontEndOnly();
    }

    public static class Block
    extends CObject {
        public Block(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitBlock(this);
        }

        public native SourcePosition finalPosition();

        public native Scope assocScope();

        public native ObjectLifetime lifetime();

        public native boolean endOfBlockReachable();

        public native boolean isStatementExpression();

        public native boolean implicitScopeNotAllowed();
    }

    public static enum BuiltinOperationKind {
        BOK_OFFSETOF,
        BOK_HAS_ASSIGN,
        BOK_HAS_COPY,
        BOK_HAS_NOTHROW_ASSIGN,
        BOK_HAS_NOTHROW_CONSTRUCTOR,
        BOK_HAS_NOTHROW_COPY,
        BOK_HAS_TRIVIAL_ASSIGN,
        BOK_HAS_TRIVIAL_CONSTRUCTOR,
        BOK_HAS_TRIVIAL_COPY,
        BOK_HAS_TRIVIAL_DESTRUCTOR,
        BOK_HAS_USER_DESTRUCTOR,
        BOK_HAS_VIRTUAL_DESTRUCTOR,
        BOK_IS_ABSTRACT,
        BOK_IS_BASE_OF,
        BOK_IS_CLASS,
        BOK_IS_CONVERTIBLE_TO,
        BOK_IS_EMPTY,
        BOK_IS_ENUM,
        BOK_IS_POD,
        BOK_IS_POLYMORPHIC,
        BOK_IS_UNION,
        BOK_TYPES_COMPATIBLE,
        BOK_INTADDR,
        BOK_IS_TRIVIAL,
        BOK_IS_STANDARD_LAYOUT,
        BOK_IS_TRIVIALLY_COPYABLE,
        BOK_IS_LITERAL_TYPE,
        BOK_HAS_TRIVIAL_MOVE_CONSTRUCTOR,
        BOK_HAS_TRIVIAL_MOVE_ASSIGN,
        BOK_HAS_NOTHROW_MOVE_ASSIGN,
        BOK_IS_CONSTRUCTIBLE,
        BOK_IS_NOTHROW_CONSTRUCTIBLE,
        BOK_HAS_FINALIZER,
        BOK_IS_DELEGATE,
        BOK_IS_INTERFACE_CLASS,
        BOK_IS_REF_ARRAY,
        BOK_IS_REF_CLASS,
        BOK_IS_SEALED,
        BOK_IS_SIMPLE_VALUE_CLASS,
        BOK_IS_VALUE_CLASS,
        BOK_IS_FINAL,
        BOK_IS_TRIVIALLY_CONSTRUCTIBLE,
        BOK_IS_DESTRUCTIBLE,
        BOK_IS_NOTHROW_DESTRUCTIBLE,
        BOK_IS_TRIVIALLY_DESTRUCTIBLE,
        BOK_IS_NOTHROW_ASSIGNABLE,
        BOK_IS_TRIVIALLY_ASSIGNABLE,
        BOK_BUILTIN_SHUFFLE,
        BOK_BUILTIN_COMPLEX,
        BOK_IS_VALID_WINRT_TYPE,
        BOK_IS_WIN_CLASS,
        BOK_IS_WIN_INTERFACE,
        BOK_BUILTIN_SHUFFLEVECTOR,
        BOK_BUILTIN_CONVERTVECTOR,
        BOK_IS_ASSIGNABLE,
        BOK_IS_TRIVIALLY_COPY_ASSIGNABLE,
        BOK_IS_ASSIGNABLE_NO_PRECONDITION_CHECK,
        BOK_BUILTIN_ADDRESSOF,
        BOK_HAS_UNIQUE_OBJECT_REPRESENTATIONS,
        BOK_IS_AGGREGATE,
        BOK_REFERENCE_BINDS_TO_TEMPORARY,
        BOK_IS_SAME,
        BOK_IS_SAME_AS,
        BOK_IS_FUNCTION,
        BOK_BUILTIN_HAS_ATTRIBUTE,
        BOK_BUILTIN_BIT_CAST,
        BOK_IS_LAYOUT_COMPATIBLE,
        BOK_IS_POINTER_INTERCONVERTIBLE_BASE_OF,
        BOK_IS_POINTER_INTERCONVERTIBLE_WITH_CLASS,
        BOK_BUILTIN_IS_POINTER_INTERCONVERTIBLE_WITH_CLASS,
        BOK_IS_CORRESPONDING_MEMBER,
        BOK_BUILTIN_IS_CORRESPONDING_MEMBER,
        BOK_EDG_IS_DEDUCIBLE,
        BOK_IS_ARRAY,
        BOK_ARRAY_RANK,
        BOK_ARRAY_EXTENT,
        BOK_IS_ARITHMETIC,
        BOK_IS_COMPLETE_TYPE,
        BOK_IS_COMPOUND,
        BOK_IS_CONST,
        BOK_IS_FLOATING_POINT,
        BOK_IS_FUNDAMENTAL,
        BOK_IS_INTEGRAL,
        BOK_IS_LVALUE_REFERENCE,
        BOK_IS_MEMBER_FUNCTION_POINTER,
        BOK_IS_MEMBER_OBJECT_POINTER,
        BOK_IS_MEMBER_POINTER,
        BOK_IS_OBJECT,
        BOK_IS_POINTER,
        BOK_IS_REFERENCE,
        BOK_IS_RVALUE_REFERENCE,
        BOK_IS_SCALAR,
        BOK_IS_SIGNED,
        BOK_IS_UNSIGNED,
        BOK_IS_VOID,
        BOK_IS_VOLATILE,
        BOK_IS_BOUNDED_ARRAY,
        BOK_IS_UNBOUNDED_ARRAY,
        BOK_IS_REFERENCEABLE,
        BOK_IS_NOTHROW_CONVERTIBLE,
        BOK_REFERENCE_CONSTRUCTS_FROM_TEMPORARY,
        BOK_REFERENCE_CONVERTS_FROM_TEMPORARY,
        BOK_IS_CONVERTIBLE,
        BOK_IS_TRIVIALLY_EQUALITY_COMPARABLE,
        BOK_IS_SCOPED_ENUM,
        BOK_IS_TRIVIALLY_RELOCATABLE,
        BOK_LAST;


        public static BuiltinOperationKind fromInt(int i) {
            return BuiltinOperationKind.values()[i];
        }
    }

    public static abstract class CObject {
        private final long ptr;

        public CObject(long ptr) {
            this.ptr = ptr;
        }

        public Object[] renderFields() {
            return CObjectRenderer.renderFields(this);
        }

        public abstract void accept(EDGVisitor var1);

        public SourceCorrespondence sourceCorresp() {
            return null;
        }

        public String toString() {
            return CObjectRenderer.renderObject(this);
        }

        public boolean equals(Object other) {
            if (!(other instanceof CObject)) {
                return false;
            }
            return ((CObject)other).ptr == this.ptr;
        }

        public int hashCode() {
            return (int)this.ptr;
        }
    }

    public static enum CallingConvention {
        CC_DEFAULT,
        CC_CDECL,
        CC_FASTCALL,
        CC_STDCALL,
        CC_THISCALL,
        CC_VECTORCALL,
        CC_CLRCALL,
        CC_LAST;


        public static CallingConvention fromInt(int i) {
            return CallingConvention.values()[i];
        }
    }

    public static class ClassListEntry
    extends CObject {
        public ClassListEntry(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitClassListEntry(this);
        }

        public native ClassListEntry next();

        public native Type classType();
    }

    public static class ClassTypeSupplement
    extends CObject {
        public ClassTypeSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitClassTypeSupplement(this);
        }

        public native BaseClass baseClasses();

        public native BaseClass directBaseClasses();

        public native long sizeWithoutVirtualBaseClasses();

        public native int alignmentWithoutVirtualBaseClasses();

        public native int highestVirtualFunctionNumber();

        public native long virtualFunctionInfoOffset();

        public native BaseClass virtualFunctionInfoBaseClass();

        public native String uuidString();

        public native long declModifiers();

        public native TypeKind origTypeKind();

        public native InheritanceKind inheritanceKind();

        public native boolean inheritanceKindIsExplicit();

        public native boolean hasDirectPropertyOrEvent();

        public native int declaredAssemblyVisibility();

        public native int assemblyVisibility();

        public native int cliClassTypeKind();

        public native boolean isHideBySig();

        public native boolean isCliArray();

        public native boolean isCliAttribute();

        public native boolean isCppcxWriteOnlyArray();

        public native boolean isCppcxBox();

        public native boolean isPartial();

        public native boolean hasCoclassAttribute();

        public native boolean hasExplicitlyAlignedSubobject();

        public native int qualifiers();

        public native boolean hiddenNamesProcessed();

        public native boolean baseClassHidingInProgress();

        public native boolean isLambdaClosureClass();

        public native boolean isGenericLambdaClosureClass();

        public native boolean hasLambdaConversionFunction();

        public native boolean isInitializerList();

        public native boolean hasInitializerListCtor();

        public native boolean hasAnonymousUnionMember();

        public native boolean definedInVariableInitializer();

        public native boolean definedInFieldInitializer();

        public native boolean namedInInlineTemplateDirective();

        public native boolean definedInParentClass();

        public native boolean hasNodiscardAttribute();

        public native boolean hasFieldInitializer();

        public native boolean removedFromIl();

        public native boolean containsError();

        public native boolean containsErrorCached();

        public native boolean containsLocalType();

        public native boolean containsLocalTypeCached();

        public native boolean containsUnnamedNamespaceType();

        public native boolean containsUnnamedNamespaceTypeCached();

        public native boolean doesNotContainParentlessLambdaInDefaultArgument();

        public native boolean doesNotContainDeprecatedOrUnavailableType();

        public native AnonymousUnionKind anonymousUnionKind();

        public native Field anonymousUnionField();

        public native ClassListEntry befriendingClasses();

        public native RoutineListEntry friendRoutines();

        public native ClassListEntry friendClasses();

        public native Scope assocScope();

        public native Template assocTemplate();

        public native TemplateArg templateArgList();

        public native TemplateArg partialSpecTemplateArgList();

        public native PartialClassBody partialClassBodies();

        public native Routine assocOperatorNewRoutine();

        public native Routine assocOperatorDeleteRoutine();

        public native int minTemplateArguments();

        public native Routine lambdaParent_routine();

        public native Variable lambdaParent_variable();

        public native Field lambdaParent_field();

        public native long hashValue();

        public native Type correspondingBasicType();

        public native long assemblyScopeIndex();

        public native long metadataTypeDefToken();

        public native Routine baseDisposeBoolRoutine();

        public native Routine baseIdisposableDisposeRoutine();

        public native Routine baseObjectFinalizeRoutine();

        public native Type invocationType();

        public native EventInterface eventInterfaces();

        public native MsAttributeUsage attributeUsage();

        public native Type proxyOfType();
    }

    public static class CliMetadataFile
    extends CObject {
        public CliMetadataFile(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitCliMetadataFile(this);
        }

        public native String nameAsWritten();

        public native String fullName();

        public native CliMetadataFile next();

        public native SourcePosition position();

        public native int assemblyIndex();

        public native SourceFile assemblyFile();

        public native SourcePosition insertedPosition();

        public native boolean asFriend();

        public native boolean referencedByPreusing();

        public native boolean referencedBySystemUsing();
    }

    public static class ConditionSupplement
    extends CObject {
        public ConditionSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConditionSupplement(this);
        }

        public native Scope scope();

        public native DynamicInit dynamicInit();

        public native ExprNode expr();

        public native Statement initialization();
    }

    public static class ConstEvalReattemptState
    extends CObject {
        public ConstEvalReattemptState(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstEvalReattemptState(this);
        }

        public native boolean defaultArg();

        public native boolean defaultMemInit();
    }

    public static class Constant
    extends CObject {
        public Constant(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstant(this);
        }

        @Override
        public native SourceCorrespondence sourceCorresp();

        public native SourcePosition endPosition();

        public native Constant next();

        public native Type type();

        public native Type origType();

        public native ExprNode expr();

        public native ExprRescanInfoEntry rescanInfo();

        public native int characterKind();

        public native boolean implicitCast();

        public native boolean explicitCastApplied();

        public native boolean isReinterpretCast();

        public native boolean isReinterpretLikeCast();

        public native boolean nonArithmetic();

        public native boolean isSimpleZero();

        public native boolean nullPointerConstantRuledOut();

        public native boolean nullKeyword();

        public native boolean nullptrKeyword();

        public native boolean nativeNullptrKeyword();

        public native boolean ptrToMemConstantConstruct();

        public native boolean explicitBracesOnAggregate();

        public native boolean explicitParenthesesOnAggregate();

        public native boolean fromUndefinedPreprocId();

        public native boolean flexibleArrayInitializer();

        public native boolean usesDesignatedInitializers();

        public native boolean isLiteralField();

        public native boolean isPackExpansion();

        public native boolean isNamedConstantDefinition();

        public native boolean partialAggrValue();

        public native boolean isPartiallyInitialized();

        public native boolean implicitAggrElement();

        public native boolean isCompoundLiteral();

        public native boolean isResultOfConstexprCall();

        public native boolean isGenericInitializer();

        public native boolean constantForBaseClass();

        public native boolean constantForBaseClassFromConstexprFolding();

        public native boolean partOfConstexprMasterExpr();

        public native boolean localExprRef();

        public native boolean formedFromPromotedStorage();

        public native ConstantReprKind kind();
    }

    public static class ConstantAddress
    extends Constant {
        public ConstantAddress(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantAddress(this);
        }

        public native AddressBaseKind addressKind();

        public native int offset();

        public native SubobjectPath subobjectPath();
    }

    public static class ConstantAddressConstant
    extends ConstantAddress {
        public ConstantAddressConstant(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantAddressConstant(this);
        }

        public native Constant constant();
    }

    public static class ConstantAddressLabel
    extends ConstantAddress {
        public ConstantAddressLabel(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantAddressLabel(this);
        }

        public native Label label();
    }

    public static class ConstantAddressParamRef
    extends ConstantAddress {
        public ConstantAddressParamRef(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantAddressParamRef(this);
        }

        public native long paramNum();
    }

    public static class ConstantAddressRoutine
    extends ConstantAddress {
        public ConstantAddressRoutine(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantAddressRoutine(this);
        }

        public native Routine routine();
    }

    public static class ConstantAddressType
    extends ConstantAddress {
        public ConstantAddressType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantAddressType(this);
        }

        @Override
        public native Type type();
    }

    public static class ConstantAddressVariable
    extends ConstantAddress {
        public ConstantAddressVariable(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantAddressVariable(this);
        }

        public native Variable variable();
    }

    public static class ConstantAggregate
    extends Constant {
        public ConstantAggregate(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantAggregate(this);
        }

        public native Constant firstConstant();

        public native Constant lastConstant();

        public native boolean hasDynamicInitComponent();
    }

    public static class ConstantComplexValue
    extends Constant {
        public ConstantComplexValue(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantComplexValue(this);
        }

        public native InternalComplexValue complexValue();
    }

    public static class ConstantDesignator
    extends Constant {
        public ConstantDesignator(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantDesignator(this);
        }

        public native boolean isFieldDesignator();

        public native boolean isGeneric();

        public native boolean usesDirectInitSyntax();
    }

    public static class ConstantDesignatorArrayElement
    extends ConstantDesignator {
        public ConstantDesignatorArrayElement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantDesignatorArrayElement(this);
        }

        public native long arrayElement();
    }

    public static class ConstantDesignatorField
    extends ConstantDesignator {
        public ConstantDesignatorField(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantDesignatorField(this);
        }

        public native Field field();
    }

    public static class ConstantDesignatorFieldName
    extends ConstantDesignator {
        public ConstantDesignatorFieldName(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantDesignatorFieldName(this);
        }

        public native String fieldName();
    }

    public static class ConstantDesignatorSubscript
    extends ConstantDesignator {
        public ConstantDesignatorSubscript(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantDesignatorSubscript(this);
        }

        public native Constant subscript();
    }

    public static class ConstantDynamicInit
    extends Constant {
        public ConstantDynamicInit(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantDynamicInit(this);
        }

        public native DynamicInit ptr();
    }

    public static class ConstantFloatValue
    extends Constant {
        public ConstantFloatValue(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantFloatValue(this);
        }

        public native InternalFloatValue floatValue();
    }

    public static class ConstantInitRepeat
    extends Constant {
        public ConstantInitRepeat(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantInitRepeat(this);
        }

        public native Constant constant();

        public native long count();

        public native boolean multidimensionalAggrTailNotRepeated();
    }

    public static class ConstantIntegerValue
    extends Constant {
        public ConstantIntegerValue(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantIntegerValue(this);
        }

        public native long integerValue();
    }

    public static class ConstantLabelDifference
    extends Constant {
        public ConstantLabelDifference(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantLabelDifference(this);
        }

        public native Constant fromAddress();

        public native Constant toAddress();
    }

    public static class ConstantPtrToMember
    extends Constant {
        public ConstantPtrToMember(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantPtrToMember(this);
        }

        public native BaseClass castingBaseClass();

        public native NameReference nameReference();

        public native boolean castToBase();

        public native boolean isFunctionPtr();
    }

    public static class ConstantPtrToMemberField
    extends ConstantPtrToMember {
        public ConstantPtrToMemberField(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantPtrToMemberField(this);
        }

        public native Field field();
    }

    public static class ConstantPtrToMemberRoutine
    extends ConstantPtrToMember {
        public ConstantPtrToMemberRoutine(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantPtrToMemberRoutine(this);
        }

        public native Routine routine();
    }

    public static class ConstantReflection
    extends Constant {
        public ConstantReflection(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantReflection(this);
        }

        public native ReflectionValue reflection();
    }

    public static enum ConstantReprKind {
        CK_ERROR,
        CK_INTEGER,
        CK_STRING,
        CK_FLOAT,
        CK_COMPLEX,
        CK_IMAGINARY,
        CK_ADDRESS,
        CK_PTR_TO_MEMBER,
        CK_LABEL_DIFFERENCE,
        CK_DYNAMIC_INIT,
        CK_AGGREGATE,
        CK_INIT_REPEAT,
        CK_TEMPLATE_PARAM,
        CK_DESIGNATOR,
        CK_VOID,
        CK_REFLECTION,
        CK_LAST;


        public static ConstantReprKind fromInt(int i) {
            return ConstantReprKind.values()[i];
        }
    }

    public static class ConstantString
    extends Constant {
        public ConstantString(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantString(this);
        }

        public native long length();

        public native String value();

        public native int literalKind();

        public native boolean funcNameTok();
    }

    public static class ConstantTemplateParam
    extends Constant {
        public ConstantTemplateParam(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantTemplateParam(this);
        }

        public native TemplateParamConstantKind templateParamKind();

        public native boolean isQualifiedName();

        public native boolean hasAddressOf();

        public native boolean isPack();

        public native boolean hasGenericCastForNontypeTemplateParam();

        @Override
        public native boolean localExprRef();

        public native boolean doNotRescan();
    }

    public static class ConstantTemplateParamBound
    extends ConstantTemplateParam {
        public ConstantTemplateParamBound(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantTemplateParamBound(this);
        }

        public native Constant bound();
    }

    public static class ConstantTemplateParamConstant
    extends ConstantTemplateParam {
        public ConstantTemplateParamConstant(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantTemplateParamConstant(this);
        }

        public native Constant constant();
    }

    public static class ConstantTemplateParamCoordinates
    extends ConstantTemplateParam {
        public ConstantTemplateParamCoordinates(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantTemplateParamCoordinates(this);
        }

        public native TemplateParamCoordinate coordinates();
    }

    public static class ConstantTemplateParamDestructor
    extends ConstantTemplateParam {
        public ConstantTemplateParamDestructor(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantTemplateParamDestructor(this);
        }

        @Override
        public native Type type();

        public native boolean unqualified();
    }

    public static class ConstantTemplateParamExpr
    extends ConstantTemplateParam {
        public ConstantTemplateParamExpr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantTemplateParamExpr(this);
        }

        @Override
        public native ExprNode expr();
    }

    public static class ConstantTemplateParamTemplSizeof
    extends ConstantTemplateParam {
        public ConstantTemplateParamTemplSizeof(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantTemplateParamTemplSizeof(this);
        }

        @Override
        public native Type type();

        @Override
        public native ExprNode expr();

        public native boolean isStdAlignof();
    }

    public static class ConstantTemplateParamTemplateRef
    extends ConstantTemplateParam {
        public ConstantTemplateParamTemplateRef(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantTemplateParamTemplateRef(this);
        }

        public native Constant con();

        public native TemplateArg argList();
    }

    public static class ConstantTemplateParamUnknownFunction
    extends ConstantTemplateParam {
        public ConstantTemplateParamUnknownFunction(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstantTemplateParamUnknownFunction(this);
        }

        public native Type conversionType();

        public native PropertyOrEventDescr propertyOrEventDescr();

        public native Symbol symbol();

        public native OpnameKind opnameKind();

        public native SpecialFunctionKind specialKind();
    }

    public static class ConstexprIf
    extends CObject {
        public ConstexprIf(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstexprIf(this);
        }

        public native Statement thenStatement();

        public native Statement elseStatement();

        public native SourcePosition elsePosition();

        public native boolean valueKnown();

        public native boolean value();
    }

    public static class ConstructorInit
    extends CObject {
        public ConstructorInit(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstructorInit(this);
        }

        public native ConstructorInit next();

        public native ConstructorInitKind kind();

        public native boolean compilerGenerated();

        public native boolean isPackExpansion();

        public native boolean isBraced();

        public native boolean useFieldInitializer();

        public native DynamicInit initializer();

        public native ExprNode sourceExpr();

        public native SourceRange ctorInitRange();

        public native Type origType();
    }

    public static class ConstructorInitBaseClass
    extends ConstructorInit {
        public ConstructorInitBaseClass(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstructorInitBaseClass(this);
        }

        public native BaseClass baseClass();
    }

    public static class ConstructorInitField
    extends ConstructorInit {
        public ConstructorInitField(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitConstructorInitField(this);
        }

        public native Field field();
    }

    public static enum ConstructorInitKind {
        CIK_VIRTUAL_BASE_CLASS,
        CIK_DIRECT_BASE_CLASS,
        CIK_FIELD,
        CIK_DELEGATION;


        public static ConstructorInitKind fromInt(int i) {
            return ConstructorInitKind.values()[i];
        }
    }

    public static class CoroutineDescr
    extends CObject {
        public CoroutineDescr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitCoroutineDescr(this);
        }

        public native Type traits();

        public native Variable handle();

        public native Variable promise();

        public native Variable initAwaitResume();

        public native Variable thisParamCopy();

        public native Variable parameterCopies();

        public native Label finalSuspendLabel();

        public native ExprNode initialSuspendCall();

        public native ExprNode finalSuspendCall();

        public native ExprNode unhandledExceptionCall();

        public native ExprNode getReturnObjectCall();

        public native ExprNode allocFailureGroCall();

        public native Routine newRoutine();

        public native Routine deleteRoutine();

        public native SourcePosition position();

        public native boolean errorDescr();

        public native boolean hasReturnVoid();

        public native boolean bodyGenerated();
    }

    public static class CustomMsAttributeArg
    extends CObject {
        public CustomMsAttributeArg(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitCustomMsAttributeArg(this);
        }

        public native CustomMsAttributeArg next();

        public native Field field();

        public native ExprNode expression();
    }

    public static class DeclParseState
    extends CObject {
        public DeclParseState(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitDeclParseState(this);
        }
    }

    public static class DeclPositionSupplement
    extends CObject {
        public DeclPositionSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitDeclPositionSupplement(this);
        }

        public native SourceRange identifierRange();

        public native SourceRange specifiersRange();

        public native ElementPosition extraPositions();
    }

    public static class DeclPositionSupplementDeclaratorRange
    extends DeclPositionSupplement {
        public DeclPositionSupplementDeclaratorRange(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitDeclPositionSupplementDeclaratorRange(this);
        }

        public native SourceRange declaratorRange();
    }

    public static class DeclPositionSupplementEnumValueRange
    extends DeclPositionSupplement {
        public DeclPositionSupplementEnumValueRange(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitDeclPositionSupplementEnumValueRange(this);
        }

        public native SourceRange enumValueRange();
    }

    public static class DeclPositionSupplementNamespaceDefinitionRange
    extends DeclPositionSupplement {
        public DeclPositionSupplementNamespaceDefinitionRange(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitDeclPositionSupplementNamespaceDefinitionRange(this);
        }

        public native SourceRange namespaceDefinitionRange();
    }

    public static class DerivationStep
    extends CObject {
        public DerivationStep(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitDerivationStep(this);
        }

        public native DerivationStep next();

        public native DerivationStep prev();

        public native BaseClass baseClass();
    }

    public static class DynamicInit
    extends CObject {
        public DynamicInit(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitDynamicInit(this);
        }

        public native DynamicInit next();

        public native Variable variable();

        public native Routine destructor();

        public native ObjectLifetime lifetime();

        public native DynamicInit nextInDestructionList();

        public native ObjectLifetime initExprLifetime();

        public native DynamicInitKind kind();

        public native boolean staticTemp();

        public native boolean followsAnExecStatement();

        public native boolean insideConditionalExpression();

        public native boolean unordered();

        public native boolean hasTemporaryLifetime();

        public native boolean isConstructorInit();

        public native boolean isFreeingOfStorageOnException();

        public native boolean isArrayFreeing();

        public native boolean destructionIsForPartiallyConstructedAggregate();

        public native boolean overlapsTempsInInnerLifetime();

        public native boolean isExplicitCast();

        public native boolean isCompoundLiteral();

        public native boolean isBracedInitializer();

        public native boolean isPartiallyInitialized();

        public native boolean isResultForClassRvalueQuestionMark();

        public native boolean classRvalueInitializedThroughMasterEntry();

        public native boolean isResultForCommaOperator();

        public native boolean isReusedValue();

        public native boolean isCreationOfInitializerListObject();

        public native boolean isArrayForInitializerListObject();

        public native boolean isTopTemporaryForConstexprReferenceParam();

        public native ObjectLifetime lifetimeOfOverlappingTemps();

        public native DynamicInit masterEntry();

        public native ExprRescanInfoEntry rescanInfo();
    }

    public static class DynamicInitBitwiseCopy
    extends DynamicInit {
        public DynamicInitBitwiseCopy(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitDynamicInitBitwiseCopy(this);
        }

        public native ExprNode source();
    }

    public static class DynamicInitConstant
    extends DynamicInit {
        public DynamicInitConstant(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitDynamicInitConstant(this);
        }

        public native Constant ptr();

        public native Lambda lambda();

        public native boolean nonConstant();
    }

    public static class DynamicInitConstructor
    extends DynamicInit {
        public DynamicInitConstructor(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitDynamicInitConstructor(this);
        }

        public native Routine ptr();

        public native ExprNode args();

        public native boolean isCopyConstructorWithImpliedSource();

        public native boolean isImplicitCopyForCopyInitialization();

        public native boolean valueInitialization();

        public native boolean hasSequencedArguments();

        public native boolean isArrayCopy();
    }

    public static class DynamicInitExpression
    extends DynamicInit {
        public DynamicInitExpression(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitDynamicInitExpression(this);
        }

        public native ExprNode expression();
    }

    public static enum DynamicInitKind {
        DIK_NONE,
        DIK_ZERO,
        DIK_CONSTANT,
        DIK_EXPRESSION,
        DIK_CLASS_RESULT_VIA_CTOR,
        DIK_CONSTRUCTOR,
        DIK_NONCONSTANT_AGGREGATE,
        DIK_BITWISE_COPY,
        DIK_LAMBDA;


        public static DynamicInitKind fromInt(int i) {
            return DynamicInitKind.values()[i];
        }
    }

    public static class ElementPosition
    extends CObject {
        public ElementPosition(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitElementPosition(this);
        }

        public native ElementPosition next();

        public native SourcePosition position();

        public native ElementPositionKind kind();
    }

    public static enum ElementPositionKind {
        EPK_SPECIALIZATION_HEADER,
        EPK_NORETURN,
        EPK_LAST;


        public static ElementPositionKind fromInt(int i) {
            return ElementPositionKind.values()[i];
        }
    }

    public static class EventInterface
    extends CObject {
        public EventInterface(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitEventInterface(this);
        }

        public native EventInterface next();

        public native Type interfaceType();

        public native SourcePosition pos();
    }

    public static class ExceptionSpecification
    extends CObject {
        public ExceptionSpecification(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExceptionSpecification(this);
        }

        public native boolean isNoexcept();

        public native boolean indeterminate();

        public native boolean throwAny();

        public native boolean compilerGenerated();

        public native boolean fromAttribute();

        public native boolean argCached();

        public native boolean copyFromPrototype();

        public native SourceRange sourceRange();
    }

    public static class ExceptionSpecificationExceptionSpecificationTypeList
    extends ExceptionSpecification {
        public ExceptionSpecificationExceptionSpecificationTypeList(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExceptionSpecificationExceptionSpecificationTypeList(this);
        }

        public native ExceptionSpecificationType exceptionSpecificationTypeList();
    }

    public static class ExceptionSpecificationNoexceptArg
    extends ExceptionSpecification {
        public ExceptionSpecificationNoexceptArg(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExceptionSpecificationNoexceptArg(this);
        }

        public native Constant noexceptArg();
    }

    public static class ExceptionSpecificationRoutine
    extends ExceptionSpecification {
        public ExceptionSpecificationRoutine(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExceptionSpecificationRoutine(this);
        }

        public native Routine routine();
    }

    public static class ExceptionSpecificationTokenCache
    extends ExceptionSpecification {
        public ExceptionSpecificationTokenCache(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExceptionSpecificationTokenCache(this);
        }

        public native TokenCache tokenCache();
    }

    public static class ExceptionSpecificationType
    extends CObject {
        public ExceptionSpecificationType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExceptionSpecificationType(this);
        }

        public native ExceptionSpecificationType next();

        public native Type type();

        public native boolean redundant();

        public native boolean isPackExpansion();

        public native SourcePosition sourcePosition();
    }

    public static class ExprNode
    extends CObject {
        public ExprNode(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNode(this);
        }

        public native Type type();

        public native Type origLvalueType();

        public native ExprNode next();

        public native int kind();

        public native boolean isLvalue();

        public native boolean isXvalue();

        public native boolean resultIsNotUsed();

        public native boolean isInitializationGuard();

        public native boolean generatedDefaultArg();

        public native boolean markedAsGnuExtension();

        public native boolean isStaticCast();

        public native boolean isFunctionalNotationCast();

        public native boolean isBraceNotationCast();

        public native boolean isObjectlessNonstaticDataMemRef();

        public native boolean isPackExpansion();

        public native boolean isShallowCopy();

        public native boolean isSafeCast();

        public native boolean elementOfCliParamArrayArg();

        public native boolean isCliTypeid();

        public native boolean isParenthesized();

        public native boolean typeDefinitionNeeded();

        public native boolean volatileFetch();

        public native boolean doNotInterpret();

        public native boolean compilerGenerated();

        public native boolean isTypeConstraint();

        public native boolean wasLvalueTempInitializer();

        public native SourcePosition position();

        public native SourceRange exprRange();

        public native ExprRescanInfoEntry extra_rescanInfo();

        public native ExprNode extra_nextAvail();
    }

    public static class ExprNodeAwaitInfo
    extends ExprNode {
        public ExprNodeAwaitInfo(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeAwaitInfo(this);
        }

        public native ExprNode operand();

        public native ExprNode readyResumeSuspend();
    }

    public static class ExprNodeBracedInitList
    extends ExprNode {
        public ExprNodeBracedInitList(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeBracedInitList(this);
        }

        public native ExprNode bracedInitList();
    }

    public static class ExprNodeBuiltinChooseExpr
    extends ExprNode {
        public ExprNodeBuiltinChooseExpr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeBuiltinChooseExpr(this);
        }

        public native ExprNode operands();

        public native boolean chooseFirst();
    }

    public static class ExprNodeBuiltinOperation
    extends ExprNode {
        public ExprNodeBuiltinOperation(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeBuiltinOperation(this);
        }

        public native BuiltinOperationKind builtinOperationKind();

        public native ExprNode operands();
    }

    public static class ExprNodeC11Generic
    extends ExprNode {
        public ExprNodeC11Generic(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeC11Generic(this);
        }

        public native ExprNode operands();

        public native ExprNode result();
    }

    public static class ExprNodeCompoundReq
    extends ExprNode {
        public ExprNodeCompoundReq(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeCompoundReq(this);
        }

        public native ExprNode exprAndConstraint();

        public native boolean isNoexcept();
    }

    public static class ExprNodeConceptId
    extends ExprNode {
        public ExprNodeConceptId(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeConceptId(this);
        }

        public native Template conceptTemplate();

        public native TemplateArg args();
    }

    public static class ExprNodeCondition
    extends ExprNode {
        public ExprNodeCondition(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeCondition(this);
        }

        public native ConditionSupplement condition();
    }

    public static class ExprNodeConstEvalDeferred
    extends ExprNode {
        public ExprNodeConstEvalDeferred(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeConstEvalDeferred(this);
        }

        public native ExprNode wrapped();

        public native ConstEvalReattemptState reattemptState();
    }

    public static class ExprNodeConstant
    extends ExprNode {
        public ExprNodeConstant(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeConstant(this);
        }

        public native Constant ptr();

        public native NameReference nameReference();
    }

    public static class ExprNodeField
    extends ExprNode {
        public ExprNodeField(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeField(this);
        }

        public native Field ptr();

        public native NameReference nameReference();
    }

    public static class ExprNodeFold
    extends ExprNode {
        public ExprNodeFold(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeFold(this);
        }

        public native ExprNode operands();

        public native TokenKind operatorToken();

        public native boolean leftAssociative();
    }

    public static class ExprNodeGcnewInfo
    extends ExprNode {
        public ExprNodeGcnewInfo(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeGcnewInfo(this);
        }

        public native GcnewSupplement gcnewInfo();
    }

    public static class ExprNodeInit
    extends ExprNode {
        public ExprNodeInit(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeInit(this);
        }

        public native DynamicInit dynamicInit();

        public native Type source_type();

        public native Lambda source_lambda();
    }

    public static class ExprNodeInitializer
    extends ExprNode {
        public ExprNodeInitializer(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeInitializer(this);
        }

        public native DynamicInit dynInit();
    }

    public static enum ExprNodeKind {
        ENK_ERROR,
        ENK_OPERATION,
        ENK_CONSTANT,
        ENK_VARIABLE,
        ENK_FIELD,
        ENK_TEMP_INIT,
        ENK_LAMBDA,
        ENK_NEW_DELETE,
        ENK_GCNEW,
        ENK_THROW,
        ENK_CONDITION,
        ENK_OBJECT_LIFETIME,
        ENK_TYPEID,
        ENK_SIZEOF,
        ENK_SIZEOF_PACK,
        ENK_ALIGNOF,
        ENK_DATASIZEOF,
        ENK_ADDRESS_OF_ELLIPSIS,
        ENK_STATEMENT,
        ENK_REUSE_VALUE,
        ENK_ROUTINE,
        ENK_VLA_DEALLOC,
        ENK_TYPE_OPERAND,
        ENK_BUILTIN_OPERATION,
        ENK_PARAM_REF,
        ENK_BRACED_INIT_LIST,
        ENK_C11_GENERIC,
        ENK_BUILTIN_CHOOSE_EXPR,
        ENK_YIELD,
        ENK_AWAIT,
        ENK_FOLD,
        ENK_INITIALIZER,
        ENK_CONCEPT_ID,
        ENK_REQUIRES,
        ENK_COMPOUND_REQ,
        ENK_NESTED_REQ,
        ENK_CONST_EVAL_DEFERRED,
        ENK_TEMPLATE_NAME,
        ENK_TOKEN_SEQUENCE,
        ENK_RECLAIMED,
        ENK_LAST;


        public static ExprNodeKind fromInt(int i) {
            return ExprNodeKind.values()[i];
        }
    }

    public static class ExprNodeNestedReq
    extends ExprNode {
        public ExprNodeNestedReq(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeNestedReq(this);
        }

        public native ExprNode constraint();
    }

    public static class ExprNodeNewDelete
    extends ExprNode {
        public ExprNodeNewDelete(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeNewDelete(this);
        }

        public native NewDeleteSupplement newDelete();
    }

    public static class ExprNodeObjectLifetime
    extends ExprNode {
        public ExprNodeObjectLifetime(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeObjectLifetime(this);
        }

        public native ExprNode expr();

        public native ObjectLifetime ptr();
    }

    public static class ExprNodeOperation
    extends ExprNode {
        public ExprNodeOperation(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeOperation(this);
        }

        public native ExprOperatorKind operationKind();

        public native TypeKind typeKind();

        public native boolean returnsLvalueInsteadOfUsualRvalue();

        public native boolean isReinterpretCast();

        public native boolean isReinterpretLikeCast();

        public native boolean isConstCast();

        public native boolean isReferenceCast();

        public native boolean isRvalueReferenceCast();

        public native boolean isTrackingReferenceCast();

        public native boolean implicitInMemberNaming();

        public native boolean implicitStepOfExplicitCast();

        public native boolean isConversionCall();

        public native boolean argDependentLookupSuppressedOnCall();

        public native boolean callWithQualifiedFunctionName();

        public native boolean callUsesOperatorSyntax();

        public native boolean isGnuTwoOperandQuestionMark();

        public native boolean pointerOperandIsSecond();

        public native boolean isVirtualCall();

        public native int rewrittenPropertyReferenceKind();

        public native boolean requiresRuntimeCastCheck();

        public native boolean evalLeftToRight();

        public native boolean evalRightToLeft();

        public native boolean isConstevalCall();

        public native ExprNode operands();
    }

    public static class ExprNodeParamRef
    extends ExprNode {
        public ExprNodeParamRef(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeParamRef(this);
        }

        public native long paramNum();

        public native long levelsUp();
    }

    public static class ExprNodeRequiresExpr
    extends ExprNode {
        public ExprNodeRequiresExpr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeRequiresExpr(this);
        }

        public native ExprNode requirements();

        public native ParamType parameters();
    }

    public static class ExprNodeReusedValueInit
    extends ExprNode {
        public ExprNodeReusedValueInit(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeReusedValueInit(this);
        }

        public native DynamicInit reusedValueInit();
    }

    public static class ExprNodeRoutine
    extends ExprNode {
        public ExprNodeRoutine(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeRoutine(this);
        }

        public native Routine ptr();

        public native NameReference nameReference();
    }

    public static class ExprNodeSizeofInfo
    extends ExprNode {
        public ExprNodeSizeofInfo(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeSizeofInfo(this);
        }

        public native boolean isType();

        public native boolean isStdAlignof();
    }

    public static class ExprNodeSizeofInfoExpr
    extends ExprNodeSizeofInfo {
        public ExprNodeSizeofInfoExpr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeSizeofInfoExpr(this);
        }

        public native ExprNode expr();
    }

    public static class ExprNodeSizeofInfoType
    extends ExprNodeSizeofInfo {
        public ExprNodeSizeofInfoType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeSizeofInfoType(this);
        }

        @Override
        public native Type type();
    }

    public static class ExprNodeSizeofPack
    extends ExprNode {
        public ExprNodeSizeofPack(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeSizeofPack(this);
        }

        public native boolean isType();

        public native boolean isTemplateTemplate();
    }

    public static class ExprNodeSizeofPackExpr
    extends ExprNodeSizeofPack {
        public ExprNodeSizeofPackExpr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeSizeofPackExpr(this);
        }

        public native ExprNode expr();
    }

    public static class ExprNodeSizeofPackTempl
    extends ExprNodeSizeofPack {
        public ExprNodeSizeofPackTempl(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeSizeofPackTempl(this);
        }

        public native Template templ();
    }

    public static class ExprNodeSizeofPackType
    extends ExprNodeSizeofPack {
        public ExprNodeSizeofPackType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeSizeofPackType(this);
        }

        @Override
        public native Type type();
    }

    public static class ExprNodeStatement
    extends ExprNode {
        public ExprNodeStatement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeStatement(this);
        }

        public native Statement statement();
    }

    public static class ExprNodeTemplateName
    extends ExprNode {
        public ExprNodeTemplateName(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeTemplateName(this);
        }

        public native Template templateName();
    }

    public static class ExprNodeThrowInfo
    extends ExprNode {
        public ExprNodeThrowInfo(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeThrowInfo(this);
        }

        public native ThrowSupplement throwInfo();
    }

    public static class ExprNodeTokenSequence
    extends ExprNode {
        public ExprNodeTokenSequence(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeTokenSequence(this);
        }

        public native ExprNode interpolations();

        public native TokenSequence tokens();
    }

    public static class ExprNodeTypeOperand
    extends ExprNode {
        public ExprNodeTypeOperand(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeTypeOperand(this);
        }

        @Override
        public native Type type();

        public native NameReference nameReference();
    }

    public static class ExprNodeTypeidInfo
    extends ExprNode {
        public ExprNodeTypeidInfo(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeTypeidInfo(this);
        }

        public native ExprNode typeWithOptExpr();

        public native boolean isDynamic();
    }

    public static class ExprNodeVariable
    extends ExprNode {
        public ExprNodeVariable(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeVariable(this);
        }

        public native Variable ptr();

        public native NameReference nameReference();
    }

    public static class ExprNodeVlaVariable
    extends ExprNode {
        public ExprNodeVlaVariable(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprNodeVlaVariable(this);
        }

        public native Variable vlaVariable();
    }

    public static enum ExprOperatorKind {
        EOK_ADDRESS_OF,
        EOK_REFERENCE_TO,
        EOK_HANDLE_TO,
        EOK_INDIRECT,
        EOK_REF_INDIRECT,
        EOK_CAST,
        EOK_LVALUE_CAST,
        EOK_REF_CAST,
        EOK_LVALUE_ADJUST,
        EOK_CLASS_RVALUE_ADJUST,
        EOK_BOX,
        EOK_HANDLE_TO_BOX,
        EOK_UNBOX,
        EOK_UNBOX_LVALUE,
        EOK_BASE_CLASS_CAST,
        EOK_DERIVED_CLASS_CAST,
        EOK_PM_BASE_CLASS_CAST,
        EOK_PM_DERIVED_CLASS_CAST,
        EOK_DYNAMIC_CAST,
        EOK_REF_DYNAMIC_CAST,
        EOK_BOOL_CAST,
        EOK_ARRAY_TO_POINTER,
        EOK_DOT_VACUOUS_DESTRUCTOR_CALL,
        EOK_POINTS_TO_VACUOUS_DESTRUCTOR_CALL,
        EOK_ASSUME,
        EOK_NOEXCEPT,
        EOK_PARENS,
        EOK_NEGATE,
        EOK_UNARY_PLUS,
        EOK_COMPLEMENT,
        EOK_NOT,
        EOK_VECTOR_NOT,
        EOK_VECTOR_FILL,
        EOK_XCONJ,
        EOK_REAL_PART,
        EOK_IMAG_PART,
        EOK_POST_INCR,
        EOK_POST_DECR,
        EOK_PRE_INCR,
        EOK_PRE_DECR,
        EOK_ADD,
        EOK_SUBTRACT,
        EOK_MULTIPLY,
        EOK_DIVIDE,
        EOK_REMAINDER,
        EOK_JMULTIPLY,
        EOK_JDIVIDE,
        EOK_FJADD,
        EOK_JFADD,
        EOK_FJSUBTRACT,
        EOK_JFSUBTRACT,
        EOK_PADD,
        EOK_PSUBTRACT,
        EOK_PDIFF,
        EOK_SHIFTL,
        EOK_SHIFTR,
        EOK_AND,
        EOK_OR,
        EOK_XOR,
        EOK_EQ,
        EOK_NE,
        EOK_GT,
        EOK_LT,
        EOK_GE,
        EOK_LE,
        EOK_SPACESHIP,
        EOK_VECTOR_EQ,
        EOK_VECTOR_NE,
        EOK_VECTOR_GT,
        EOK_VECTOR_LT,
        EOK_VECTOR_GE,
        EOK_VECTOR_LE,
        EOK_GNU_MIN,
        EOK_GNU_MAX,
        EOK_ASSIGN,
        EOK_ADD_ASSIGN,
        EOK_SUBTRACT_ASSIGN,
        EOK_MULTIPLY_ASSIGN,
        EOK_DIVIDE_ASSIGN,
        EOK_REMAINDER_ASSIGN,
        EOK_SHIFTL_ASSIGN,
        EOK_SHIFTR_ASSIGN,
        EOK_AND_ASSIGN,
        EOK_OR_ASSIGN,
        EOK_XOR_ASSIGN,
        EOK_PADD_ASSIGN,
        EOK_PSUBTRACT_ASSIGN,
        EOK_BASSIGN,
        EOK_LAND,
        EOK_LOR,
        EOK_VECTOR_LAND,
        EOK_VECTOR_LOR,
        EOK_COMMA,
        EOK_SUBSCRIPT,
        EOK_VECTOR_SUBSCRIPT,
        EOK_DOT_FIELD,
        EOK_POINTS_TO_FIELD,
        EOK_PM_FIELD,
        EOK_PM_POINTS_TO_FIELD,
        EOK_DOT_PM_FUNC_PTR,
        EOK_POINTS_TO_PM_FUNC_PTR,
        EOK_DOT_STATIC,
        EOK_POINTS_TO_STATIC,
        EOK_VIRTUAL_FUNCTION_PTR,
        EOK_QUESTION,
        EOK_VECTOR_QUESTION,
        EOK_CALL,
        EOK_DOT_MEMBER_CALL,
        EOK_POINTS_TO_MEMBER_CALL,
        EOK_DOT_PM_CALL,
        EOK_POINTS_TO_PM_CALL,
        EOK_CLI_SUBSCRIPT,
        EOK_VA_START,
        EOK_VA_ARG,
        EOK_VA_END,
        EOK_VA_COPY,
        EOK_VA_START_SINGLE_OPERAND,
        EOK_LVALUE,
        EOK_AWAIT,
        EOK_YIELD,
        EOK_SPLICE,
        EOK_ERROR,
        EOK_LAST;


        public static ExprOperatorKind fromInt(int i) {
            return ExprOperatorKind.values()[i];
        }
    }

    public static class ExprRescanInfoEntry
    extends CObject {
        public ExprRescanInfoEntry(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitExprRescanInfoEntry(this);
        }
    }

    public static class Field
    extends CObject {
        public Field(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitField(this);
        }

        @Override
        public native SourceCorrespondence sourceCorresp();

        public native Field next();

        public native Type type();

        public native long offset();

        public native char offsetBitRemainder();

        public native byte bitSize();

        public native int alignment();

        public native boolean isPacked();

        public native boolean isBitField();

        public native boolean bitFieldIsSigned();

        public native boolean isAnonymousParentObject();

        public native boolean isMutable();

        public native boolean compilerGenerated();

        public native boolean isInitCapture();

        public native boolean isCapturedThis();

        public native boolean isCapturedPackElement();

        public native boolean isInitonly();

        public native boolean vlaTreatedAsZeroLengthArray();

        public native boolean hasInitializer();

        public native boolean initIsCtorDependent();

        public native boolean hasDirectBracedInitializer();

        public native boolean hasNonconstantInitializer();

        public native boolean bitSizeConstantExprInLocalExprNodeRef();

        public native boolean hasNoUniqueAddressAttribute();

        public native boolean isOptimizedEmptyClass();

        public native DynamicInit initializer();

        public native IlEntityListEntry entitiesDefinedInInitializer();

        public native Constant bitSizeConstant();

        public native PropertyOrEventDescr propertyOrEventDescr();

        public native long declaredBitSize();

        public native SourceRange initializerRange();
    }

    public static enum FloatKind {
        FK_FLOAT16,
        FK_FP16,
        FK_FLOAT,
        FK_FLOAT32X,
        FK_DOUBLE,
        FK_FLOAT64X,
        FK_LONG_DOUBLE,
        FK_FLOAT80,
        FK_FLOAT128,
        FK_FIRST_EXTENDED_TYPE,
        FK_STD_FLOAT16,
        FK_STD_FLOAT32,
        FK_STD_FLOAT64,
        FK_STD_FLOAT128,
        FK_LAST;


        public static FloatKind fromInt(int i) {
            return FloatKind.values()[i];
        }
    }

    public static class ForEachLoop
    extends CObject {
        public ForEachLoop(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitForEachLoop(this);
        }

        public native boolean usesPrevDeclIterator();

        public native Variable iterator_variable();

        public native Variable iterator_prevDecl_variable();

        public native Field iterator_prevDecl_field();

        public native ExprNode iterator_prevDecl_assignExpr();

        public native Variable collectionExprRef();

        public native Scope forEachScope();

        public native Scope iteratorScope();

        public native Variable temporaryVariable();

        public native ForEachPatternKind kind();
    }

    public static class ForEachLoopCliArrayPattern
    extends ForEachLoop {
        public ForEachLoopCliArrayPattern(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitForEachLoopCliArrayPattern(this);
        }

        public native Variable upperBoundVars();

        public native Variable loopVars();
    }

    public static class ForEachLoopCliPattern
    extends ForEachLoop {
        public ForEachLoopCliPattern(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitForEachLoopCliPattern(this);
        }

        public native ExprNode movenextCallExpression();
    }

    public static class ForEachLoopStlArrayPattern
    extends ForEachLoop {
        public ForEachLoopStlArrayPattern(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitForEachLoopStlArrayPattern(this);
        }

        public native Variable endVariable();

        public native ExprNode neCallExpr();

        public native ExprNode incrCallExpr();
    }

    public static enum ForEachPatternKind {
        SFEPK_NONE,
        SFEPK_STL_PATTERN,
        SFEPK_CLI_PATTERN,
        SFEPK_CLI_ARRAY_PATTERN,
        SFEPK_ARRAY_PATTERN;


        public static ForEachPatternKind fromInt(int i) {
            return ForEachPatternKind.values()[i];
        }
    }

    public static class ForLoop
    extends CObject {
        public ForLoop(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitForLoop(this);
        }

        public native Statement initialization();

        public native ExprNode increment();

        public native Scope forInitScope();
    }

    public static class FunctionDefDescr
    extends CObject {
        public FunctionDefDescr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitFunctionDefDescr(this);
        }

        public native Scope scope();

        public native int memoryRegion();
    }

    public static class GccPragmaDescr
    extends CObject {
        public GccPragmaDescr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitGccPragmaDescr(this);
        }

        public native GccPragmaKind kind();
    }

    public static enum GccPragmaKind {
        GCC_PK_NONE,
        GCC_PK_SYSTEM_HEADER,
        GCC_PK_TARGET,
        GCC_PK_PUSH_OPTIONS,
        GCC_PK_POP_OPTIONS,
        GCC_PK_RESET_OPTIONS,
        GCC_PK_LAST;


        public static GccPragmaKind fromInt(int i) {
            return GccPragmaKind.values()[i];
        }
    }

    public static class GcnewSupplement
    extends CObject {
        public GcnewSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitGcnewSupplement(this);
        }

        public native boolean hasNewInitializer();

        public native boolean isCliArray();

        public native Type type();

        public native ExprNode cliArrayDimensionLengths();

        public native DynamicInit dynamicInit();
    }

    public static class GenericConstraint
    extends CObject {
        public GenericConstraint(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitGenericConstraint(this);
        }

        public native GenericConstraintKind kind();

        public native boolean implicitConstraint();

        public native GenericConstraint next();

        public native Type type();

        public native TokenCache typeCache();

        public native SourcePosition position();
    }

    public static class GenericConstraintClause
    extends CObject {
        public GenericConstraintClause(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitGenericConstraintClause(this);
        }

        public native GenericConstraintClause next();

        public native Type type();

        public native SourcePosition typePosition();

        public native GenericConstraint constraints();

        public native SourcePosition wherePosition();

        public native SourcePosition colonPosition();
    }

    public static enum GenericConstraintKind {
        GCK_NONE,
        GCK_TYPE,
        GCK_NAKED_TYPE_PARAM,
        GCK_REF_CLASS,
        GCK_VALUE_CLASS,
        GCK_GCNEW,
        GCK_FAIL;


        public static GenericConstraintKind fromInt(int i) {
            return GenericConstraintKind.values()[i];
        }
    }

    public static class GnuRoutineSupplement
    extends CObject {
        public GnuRoutineSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitGnuRoutineSupplement(this);
        }

        public native String section();

        public native Routine aliasedRoutine();

        public native Routine inlinePartner();

        public native String asmName();
    }

    public static class Handler
    extends CObject {
        public Handler(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitHandler(this);
        }

        public native Handler next();

        public native SourcePosition catchPosition();

        public native Variable parameter();

        public native Statement statement();

        public native DynamicInit dynamicInit();
    }

    public static class HiddenName
    extends CObject {
        public HiddenName(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitHiddenName(this);
        }

        public native HiddenName next();

        public native boolean qualificationNeeded();

        public native boolean elaboratedTypeSpecifierNeeded();

        public native boolean partiallyHiddenByMicrosoftInjectedClassName();

        public native boolean isClassMember();

        public native boolean hiddenBySimulatedInjectedClassName();

        public native boolean hiddenByClassName();

        public native boolean hiddenByTemplateParameter();

        public native CObject entity();
    }

    public static class IlEntityListEntry
    extends CObject {
        public IlEntityListEntry(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitIlEntityListEntry(this);
        }

        public native IlEntityListEntry next();

        public native CObject entity();
    }

    public static enum IlEntryKind {
        IEK_NONE,
        IEK_SOURCE_FILE,
        IEK_CONSTANT,
        IEK_PARAM_TYPE,
        IEK_ROUTINE_TYPE_SUPPLEMENT,
        IEK_BASED_TYPE_LIST_MEMBER,
        IEK_TYPE,
        IEK_VARIABLE,
        IEK_FIELD,
        IEK_EXCEPTION_SPECIFICATION,
        IEK_EXCEPTION_SPECIFICATION_TYPE,
        IEK_ROUTINE,
        IEK_LABEL,
        IEK_EXPR_NODE,
        IEK_FOR_LOOP,
        IEK_RANGE_BASED_FOR_LOOP,
        IEK_FOR_EACH_LOOP,
        IEK_SWITCH_CASE_ENTRY,
        IEK_SWITCH_STMT_DESCR,
        IEK_HANDLER,
        IEK_TRY_SUPPLEMENT,
        IEK_MICROSOFT_TRY_SUPPLEMENT,
        IEK_BLOCK,
        IEK_STATEMENT,
        IEK_OBJECT_LIFETIME,
        IEK_SCOPE,
        IEK_ID_NAME,
        IEK_STRING_TEXT,
        IEK_OTHER_TEXT,
        IEK_INTERNAL_COMPLEX_VALUE,
        IEK_NAMESPACE,
        IEK_USING_DECL,
        IEK_DYNAMIC_INIT,
        IEK_LOCAL_STATIC_VARIABLE_INIT,
        IEK_VLA_DIMENSION,
        IEK_PARTIAL_CLASS_BODY,
        IEK_OVERRIDING_VIRTUAL_FUNCTION,
        IEK_DERIVATION_STEP,
        IEK_BASE_CLASS_DERIVATION,
        IEK_BASE_CLASS,
        IEK_CLASS_LIST_ENTRY,
        IEK_ROUTINE_LIST_ENTRY,
        IEK_VARIABLE_LIST_ENTRY,
        IEK_CONSTANT_LIST_ENTRY,
        IEK_CLASS_TYPE_SUPPLEMENT,
        IEK_TEMPLATE_PARAM_TYPE_SUPPLEMENT,
        IEK_CONSTRUCTOR_INIT,
        IEK_ASM_ENTRY,
        IEK_ASM_OPERAND,
        IEK_NAMED_REGISTER_LIST,
        IEK_LABEL_LIST,
        IEK_TEMPLATE_ARG,
        IEK_NEW_DELETE_SUPPLEMENT,
        IEK_GCNEW_SUPPLEMENT,
        IEK_THROW_SUPPLEMENT,
        IEK_CONDITION_SUPPLEMENT,
        IEK_SOURCE_SEQUENCE_ENTRY,
        IEK_SRC_SEQ_SECONDARY_DECL,
        IEK_SRC_SEQ_END_OF_CONSTRUCT,
        IEK_SRC_SEQ_SUBLIST,
        IEK_INSTANTIATION_DIRECTIVE,
        IEK_HIDDEN_NAME,
        IEK_PRAGMA,
        IEK_TEMPLATE,
        IEK_MACRO,
        IEK_ELEMENT_POSITION,
        IEK_DECL_POSITION_SUPPLEMENT,
        IEK_TEMPLATE_DECL,
        IEK_REQUIRES_CLAUSE,
        IEK_TEMPLATE_PARAMETER,
        IEK_NAME_REFERENCE,
        IEK_NAME_QUALIFIER,
        IEK_MS_ATTRIBUTE,
        IEK_MS_ATTRIBUTE_ARG,
        IEK_CUSTOM_MS_ATTRIBUTE_ARG,
        IEK_PROPERTY_INDEX_TYPE,
        IEK_PROPERTY_OR_EVENT_DESCR,
        IEK_GENERIC_CONSTRAINT_CLAUSE,
        IEK_GENERIC_CONSTRAINT,
        IEK_SEQ_NUMBER_LOOKUP_ENTRY,
        IEK_MACRO_INVOCATION_RECORD_BLOCK,
        IEK_LOCAL_EXPR_NODE_REF,
        IEK_STATIC_ASSERTION,
        IEK_LOCAL_SCOPE_REF,
        IEK_IL_ENTITY_LIST_ENTRY,
        IEK_LAMBDA,
        IEK_LAMBDA_CAPTURE,
        IEK_ATTRIBUTE,
        IEK_ATTRIBUTE_ARG,
        IEK_ATTRIBUTE_GROUP,
        IEK_TYPEREF_TYPE_SUPPLEMENT,
        IEK_INTEGER_TYPE_SUPPLEMENT,
        IEK_CLI_METADATA_FILE,
        IEK_GNU_ROUTINE_SUPPLEMENT,
        IEK_COROUTINE_DESCR,
        IEK_VARIABLE_TEMPLATE_INFO,
        IEK_EVENT_INTERFACE,
        IEK_SUBOBJECT_PATH,
        IEK_CONSTEXPR_IF,
        IEK_MODULE,
        IEK_MODULE_IMPORT_DECL,
        IEK_TOKEN_SEQUENCE,
        IEK_TOKEN_SEQUENCE_ENTRY,
        IEK_LAST;


        public static IlEntryKind fromInt(int i) {
            return IlEntryKind.values()[i];
        }
    }

    public static class IlHeader
    extends CObject {
        public IlHeader(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitIlHeader(this);
        }

        public native SourceFile primarySourceFile();

        public native Scope primaryScope();

        public native Routine mainRoutine();

        public native String compilerVersion();

        public native String timeOfCompilation();

        public native boolean plainCharsAreSigned();

        public native Scope[] regionScopeEntry();

        public native FunctionDefDescr functionDefTable();

        public native SourceLanguage sourceLanguage();

        public native int stdVersion();

        public native CliMetadataFile cliMetadataFiles();

        public native boolean pccCompatibilityMode();

        public native boolean enumTypeIsIntegral();

        public native int defaultMaxMemberAlignment();

        public native Macro macros();

        public native boolean microsoftMode();

        public native boolean cppcliEnabled();

        public native boolean cppcxEnabled();

        public native long microsoftVersion();

        public native boolean gccMode();

        public native boolean gppMode();

        public native boolean clangMode();

        public native long gnuVersion();

        public native long clangVersion();

        public native boolean shortEnums();

        public native boolean defaultNocommon();

        public native boolean gnuC89Inlining();

        public native boolean nearAndFarAreEnabled();

        public native boolean farDataPointers();

        public native boolean farCodePointers();

        public native boolean UCNIdentifiersUsed();

        public native boolean vlaUsed();

        public native boolean anyTemplatesSeen();

        public native boolean prototypeInstantiationsInIl();

        public native boolean ilHasAllPrototypeInstantiations();

        public native boolean ilHasCSemantics();

        public native Type nontagTypesUsedInExceptionOrRtti();

        public native SeqNumberLookupEntry seqNumberLookupEntries();

        public native long numSeqNumberLookupEntries();

        public native int numMacroInvocationRecords();

        public native long maxMacroInvocationDepth();

        public native MacroInvocationRecordBlock rootMacroInvocationRecordBlock();

        public native int targetConfigurationIndex();

        public native ModuleImportDecl importedModules();
    }

    public static enum InheritanceKind {
        IHK_NONE,
        IHK_SINGLE,
        IHK_MULTIPLE,
        IHK_VIRTUAL,
        IHK_INCOMPLETE;


        public static InheritanceKind fromInt(int i) {
            return InheritanceKind.values()[i];
        }
    }

    public static enum InitKind {
        INITK_NONE,
        INITK_STATIC,
        INITK_DYNAMIC,
        INITK_ZERO,
        INITK_FUNCTION_LOCAL,
        INITK_BINDING;


        public static InitKind fromInt(int i) {
            return InitKind.values()[i];
        }
    }

    public static class InstantiationDirective
    extends CObject {
        public InstantiationDirective(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitInstantiationDirective(this);
        }

        public native SourcePosition position();

        public native boolean doNotInstantiate();

        public native Attribute attributes();

        public native DeclPositionSupplement declPosInfo();

        public native CObject entity();
    }

    public static enum IntegerKind {
        IK_CHAR,
        IK_SIGNED_CHAR,
        IK_UNSIGNED_CHAR,
        IK_SHORT,
        IK_UNSIGNED_SHORT,
        IK_INT,
        IK_UNSIGNED_INT,
        IK_LONG,
        IK_UNSIGNED_LONG,
        IK_LONG_LONG,
        IK_UNSIGNED_LONG_LONG,
        IK_INT128,
        IK_UNSIGNED_INT128,
        IK_LAST;


        public static IntegerKind fromInt(int i) {
            return IntegerKind.values()[i];
        }
    }

    public static class IntegerTypeSupplement
    extends CObject {
        public IntegerTypeSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitIntegerTypeSupplement(this);
        }

        public native boolean enumeratorListSeen();

        public native boolean hasNodiscardAttribute();

        public native boolean underlyingTypeShouldUseUnsigned();

        public native int declaredAssemblyVisibility();

        public native int assemblyVisibility();

        public native long assemblyScopeIndex();

        public native long metadataTypeDefToken();

        public native String uuidString();

        public native Type boxedType();

        public native Type baseType();

        public native SourcePosition baseTypePosition();

        public native Template assocTemplate();
    }

    public static class InternalComplexValue
    extends CObject {
        public InternalComplexValue(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitInternalComplexValue(this);
        }

        public native InternalFloatValue real();

        public native InternalFloatValue imag();
    }

    public static class InternalFloatValue
    extends CObject {
        public InternalFloatValue(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitInternalFloatValue(this);
        }

        public native byte[] bytes();
    }

    public static class Label
    extends CObject {
        public Label(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitLabel(this);
        }

        @Override
        public native SourceCorrespondence sourceCorresp();

        public native Label next();

        public native boolean reachableByFallThrough();

        public native boolean breakLabel();

        public native boolean switchBreakLabel();

        public native boolean continueLabel();

        public native boolean leaveLabel();

        public native boolean addressTaken();

        public native boolean locallyDeclared();

        public native boolean isLikely();

        public native boolean isUnlikely();

        public native Statement execStmt();

        public native long numMicrosoftTrysInsideOf();
    }

    public static class LabelList
    extends CObject {
        public LabelList(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitLabelList(this);
        }

        public native LabelList next();

        public native Label label();
    }

    public static class Lambda
    extends CObject {
        public Lambda(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitLambda(this);
        }

        public native LambdaCapture captureList();

        public native Type closureClass();

        public native Routine lambdaRoutine();

        public native boolean isGeneric();

        public native boolean isMutable();

        public native boolean constexprSpecified();

        public native boolean constevalSpecified();

        public native boolean hasCaptureDefault();

        public native boolean defaultIsByReference();

        public native boolean explicitReturnType();

        public native boolean hasParameterDecl();

        public native boolean hasTemplateParamList();

        public native SourcePosition startPosition();

        public native SourcePosition captureEndPosition();

        public native SourcePosition mutablePosition();

        public native SourcePosition constexprPosition();
    }

    public static class LambdaCapture
    extends CObject {
        public LambdaCapture(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitLambdaCapture(this);
        }

        public native LambdaCapture next();

        public native Variable captured_variable();

        public native Field captured_initCaptureField();

        public native DynamicInit captured_initializer();

        public native Field captureInfo_sourceClosureField();

        public native LambdaCapture captureInfo_sourceCapture();

        public native DeclParseState captureInfo_initCaptureDps();

        public native Field closureField();

        public native boolean isInitCapture();

        public native boolean isIndirectInitCapture();

        public native boolean isParamRefCapture();

        public native boolean captureByReference();

        public native boolean isImplicit();

        public native boolean isPackExpansion();

        public native boolean isPackElement();

        public native boolean directInit();

        public native boolean parenthesizedInit();

        public native boolean fieldPending();

        public native boolean constCapture();

        public native SourcePosition position();

        public native SourcePosition endPosition();
    }

    public static class LocalExprNodeRef
    extends CObject {
        public LocalExprNodeRef(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitLocalExprNodeRef(this);
        }

        public native LocalExprNodeRef next();

        public native ExprNode expr();

        public native LocalExprNodeRefKind kind();

        public native CObject referrer();
    }

    public static enum LocalExprNodeRefKind {
        LERK_NONE,
        LERK_GENERIC_SIZEOF,
        LERK_TPL_PARAM_EXPR,
        LERK_ARRAY_BOUND,
        LERK_DEP_ARRAY_BOUND,
        LERK_DECLTYPE,
        LERK_BIT_FIELD_WIDTH,
        LERK_CONSTANT_EXPR;


        public static LocalExprNodeRefKind fromInt(int i) {
            return LocalExprNodeRefKind.values()[i];
        }
    }

    public static class LocalScopeRef
    extends CObject {
        public LocalScopeRef(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitLocalScopeRef(this);
        }

        public native LocalScopeRef next();

        public native Scope scope();

        public native CObject referrer();
    }

    public static class LocalStaticVariableInit
    extends CObject {
        public LocalStaticVariableInit(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitLocalStaticVariableInit(this);
        }

        public native LocalStaticVariableInit next();

        public native Variable variable();

        public native InitKind initKind();

        public native ObjectLifetime lifetime();

        public native Constant initializer_constant();

        public native DynamicInit initializer_dynamic();

        public native ExprNode initializer_boundExpr();
    }

    public static class Macro
    extends CObject {
        public Macro(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMacro(this);
        }

        @Override
        public native SourceCorrespondence sourceCorresp();

        public native Macro next();

        public native boolean isUndef();

        public native boolean isCommandLineDefinition();

        public native boolean isPredefined();

        public native boolean objectLike();

        public native SourceRange replacementTextRange();

        public native String text();
    }

    public static class MacroInvocationRecord
    extends CObject {
        public MacroInvocationRecord(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMacroInvocationRecord(this);
        }

        public native int parentMacroIndex();

        public native Macro assocMacro();

        public native SimpleSourcePosition start();

        public native SimpleSourcePosition end();
    }

    public static class MacroInvocationRecordBlock
    extends CObject {
        public MacroInvocationRecordBlock(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMacroInvocationRecordBlock(this);
        }

        public native int firstRecordInBlock();

        public native MacroInvocationRecordBlock leftSubtree();

        public native MacroInvocationRecordBlock rightSubtree();

        public native MacroInvocationRecordBlock prev();

        public native MacroInvocationRecordBlock next();

        public native MacroInvocationRecord record(int var1);
    }

    public static enum MicrosoftPragmaCommentType {
        MPCT_COMPILER,
        MPCT_EXESTR,
        MPCT_LIB,
        MPCT_LINKER,
        MPCT_USER,
        MPCT_LAST;


        public static MicrosoftPragmaCommentType fromInt(int i) {
            return MicrosoftPragmaCommentType.values()[i];
        }
    }

    public static enum MicrosoftPragmaConformKind {
        MPCK_FORSCOPE;


        public static MicrosoftPragmaConformKind fromInt(int i) {
            return MicrosoftPragmaConformKind.values()[i];
        }
    }

    public static class MicrosoftTrySupplement
    extends CObject {
        public MicrosoftTrySupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMicrosoftTrySupplement(this);
        }

        public native Statement guardedStatement();

        public native ExprNode exceptExpr();

        public native Statement cleanupStatement();

        public native SourcePosition exceptOrFinallyPosition();
    }

    public static class Module
    extends CObject {
        public Module(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitModule(this);
        }

        public native ModuleKind kind();

        public native String resolvedFile();

        public native ModuleFileKind fileKind();

        public native boolean containsUnsupportedConstructs();
    }

    public static class ModuleEntity
    extends CObject {
        public ModuleEntity(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitModuleEntity(this);
        }
    }

    public static enum ModuleFileKind {
        MFK_UNKNOWN,
        MFK_EDG_IFC,
        MFK_MS_IFC;


        public static ModuleFileKind fromInt(int i) {
            return ModuleFileKind.values()[i];
        }
    }

    public static class ModuleHeaderUnit
    extends Module {
        public ModuleHeaderUnit(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitModuleHeaderUnit(this);
        }

        public native boolean isSysInclude();

        public native boolean suppressMacroExport();

        public native String name();

        public native String resolvedHeader();
    }

    public static class ModuleImportDecl
    extends CObject {
        public ModuleImportDecl(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitModuleImportDecl(this);
        }

        public native ModuleImportDecl next();

        public native SourcePosition position();

        public native SourcePosition moduleNamePosition();

        public native Attribute attributes();

        public native Module moduleInfo();

        public native boolean implUnitImportingSelf();
    }

    public static enum ModuleKind {
        MK_NONE,
        MK_HEADER_UNIT,
        MK_UNIT,
        MK_UNIT_PARTITION;


        public static ModuleKind fromInt(int i) {
            return ModuleKind.values()[i];
        }
    }

    public static class ModuleUnit
    extends Module {
        public ModuleUnit(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitModuleUnit(this);
        }

        public native String name();
    }

    public static class ModuleUnitPartition
    extends Module {
        public ModuleUnitPartition(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitModuleUnitPartition(this);
        }

        public native String name();

        public native Module unit();
    }

    public static class MsAttribute
    extends CObject {
        public MsAttribute(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttribute(this);
        }

        public native MsAttribute next();

        public native MsAttribute nextInBlock();

        public native boolean isAttributeAttribute();

        public native SourcePosition position();

        public native SourceSequenceEntry sourceSequenceEntry();

        public native MsAttributeKind kind();

        public native long target();

        public native CObject entity();
    }

    public static class MsAttributeArg
    extends CObject {
        public MsAttributeArg(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttributeArg(this);
        }

        public native MsAttributeArg next();

        public native String paramName();

        public native MsAttributeArgKind kind();
    }

    public static class MsAttributeArgBoolValue
    extends MsAttributeArg {
        public MsAttributeArgBoolValue(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttributeArgBoolValue(this);
        }

        public native boolean boolValue();
    }

    public static class MsAttributeArgEnumValue
    extends MsAttributeArg {
        public MsAttributeArgEnumValue(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttributeArgEnumValue(this);
        }

        public native int enumValue();
    }

    public static class MsAttributeArgIntegerValue
    extends MsAttributeArg {
        public MsAttributeArgIntegerValue(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttributeArgIntegerValue(this);
        }

        public native long integerValue();
    }

    public static enum MsAttributeArgKind {
        MSAAK_NONE,
        MSAAK_INTEGER,
        MSAAK_BOOLEAN,
        MSAAK_STRING,
        MSAAK_UUID,
        MSAAK_ENUMERATION,
        MSAAK_OTHER;


        public static MsAttributeArgKind fromInt(int i) {
            return MsAttributeArgKind.values()[i];
        }
    }

    public static class MsAttributeArgOtherString
    extends MsAttributeArg {
        public MsAttributeArgOtherString(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttributeArgOtherString(this);
        }

        public native String otherString();
    }

    public static class MsAttributeArgStringConstant
    extends MsAttributeArg {
        public MsAttributeArgStringConstant(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttributeArgStringConstant(this);
        }

        public native Constant stringConstant();
    }

    public static class MsAttributeArgUuidString
    extends MsAttributeArg {
        public MsAttributeArgUuidString(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttributeArgUuidString(this);
        }

        public native String uuidString();
    }

    public static class MsAttributeCustomInfo
    extends MsAttribute {
        public MsAttributeCustomInfo(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttributeCustomInfo(this);
        }

        public native Type type();

        public native Routine constructor();

        public native ExprNode args();

        public native CustomMsAttributeArg namedArgs();
    }

    public static class MsAttributeInfo
    extends MsAttribute {
        public MsAttributeInfo(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttributeInfo(this);
        }

        public native MsAttributeKindDescr kindDescr();

        public native String name();

        public native String string();

        public native MsAttributeArg argList();
    }

    public static enum MsAttributeKind {
        MSAK_NONE,
        MSAK_UNRECOGNIZED,
        MSAK_MISC,
        MSAK_UUID,
        MSAK_CUSTOM,
        MSAK_COCLASS,
        MSAK_NO_INJECTED_TEXT,
        MSAK_LAST;


        public static MsAttributeKind fromInt(int i) {
            return MsAttributeKind.values()[i];
        }
    }

    public static class MsAttributeKindDescr
    extends CObject {
        public MsAttributeKindDescr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttributeKindDescr(this);
        }
    }

    public static class MsAttributeUsage
    extends CObject {
        public MsAttributeUsage(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitMsAttributeUsage(this);
        }

        public native long validOn();

        public native boolean allowMultiple();

        public native boolean inherited();
    }

    public static class NameQualifier
    extends CObject {
        public NameQualifier(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitNameQualifier(this);
        }

        public native NameQualifier next();

        public native NameQualifier previousQualifier();

        public native String name();

        public native boolean isClass();

        public native Type qualifier_classType();

        public native Namespace qualifier_namespacePtr();
    }

    public static class NameReference
    extends CObject {
        public NameReference(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitNameReference(this);
        }

        public native NameReference next();

        public native NameQualifier qualifier();

        public native long numTemplateArguments();

        public native SpecialFunctionKind specialKind();

        public native boolean isGlobalQualifiedName();

        public native boolean isTemplateId();

        public native boolean isSuperQualified();

        public native boolean isDecltypeQualified();

        public native boolean usedInPrimaryDeclarator();

        public native boolean fromPrototypeInstantiation();
    }

    public static class NameReferenceDestructorType
    extends NameReference {
        public NameReferenceDestructorType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitNameReferenceDestructorType(this);
        }

        public native Type destructorType();
    }

    public static class NameReferencePropertyOrEventDescr
    extends NameReference {
        public NameReferencePropertyOrEventDescr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitNameReferencePropertyOrEventDescr(this);
        }

        public native PropertyOrEventDescr propertyOrEventDescr();
    }

    public static enum NamedRegister {
        ANR_MEMORY,
        ANR_A,
        ANR_B,
        ANR_C,
        ANR_D,
        ANR_SI,
        ANR_DI,
        ANR_BP,
        ANR_SP,
        ANR_R8,
        ANR_R9,
        ANR_R10,
        ANR_R11,
        ANR_R12,
        ANR_R13,
        ANR_R14,
        ANR_R15,
        ANR_ST,
        ANR_ST1,
        ANR_ST2,
        ANR_ST3,
        ANR_ST4,
        ANR_ST5,
        ANR_ST6,
        ANR_ST7,
        ANR_MM0,
        ANR_MM1,
        ANR_MM2,
        ANR_MM3,
        ANR_MM4,
        ANR_MM5,
        ANR_MM6,
        ANR_MM7,
        ANR_F0,
        ANR_F1,
        ANR_F2,
        ANR_F3,
        ANR_F4,
        ANR_F5,
        ANR_F6,
        ANR_F7,
        ANR_F8,
        ANR_F9,
        ANR_F10,
        ANR_F11,
        ANR_F12,
        ANR_F13,
        ANR_F14,
        ANR_F15,
        ANR_FLAGS,
        ANR_FPSR,
        ANR_DIRFLAG,
        ANR_16,
        ANR_17,
        ANR_18,
        ANR_19,
        ANR_20,
        ANR_UNRECOGNIZED,
        ANR_LAST;


        public static NamedRegister fromInt(int i) {
            return NamedRegister.values()[i];
        }
    }

    public static class NamedRegisterList
    extends CObject {
        public NamedRegisterList(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitNamedRegisterList(this);
        }

        public native NamedRegisterList next();

        public native NamedRegister reg();
    }

    public static class Namespace
    extends CObject {
        public Namespace(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitNamespace(this);
        }

        @Override
        public native SourceCorrespondence sourceCorresp();

        public native Namespace next();

        public native Type proxyClass();

        public native long hashValue();

        public native boolean isNamespaceAlias();

        public native boolean isInline();

        public native boolean hasInternalLinkage();

        public native boolean namedInStrongUsing();

        public native boolean isStd();

        public native boolean hasGnuAbiTagAttribute();
    }

    public static class NamespaceAssocNamespace
    extends Namespace {
        public NamespaceAssocNamespace(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitNamespaceAssocNamespace(this);
        }

        public native Namespace assocNamespace();
    }

    public static class NamespaceAssocScope
    extends Namespace {
        public NamespaceAssocScope(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitNamespaceAssocScope(this);
        }

        public native Scope assocScope();
    }

    public static class NewDeleteSupplement
    extends CObject {
        public NewDeleteSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitNewDeleteSupplement(this);
        }

        public native boolean isNew();

        public native boolean placementNew();

        public native boolean alignedVersion();

        public native boolean arrayDelete();

        public native boolean globalNewOrDelete();

        public native boolean hasNewInitializer();

        public native boolean newInitializerIsBraceEnclosed();

        public native boolean newInitializerIsParenAggrInit();

        public native boolean deducibleType();

        public native boolean parenthesizedTypeId();

        public native Type type();

        public native Routine routine();

        public native ExprNode arg();

        public native DynamicInit dynamicInit();

        public native DynamicInit freeingOfStorageOnException();

        public native ExprNode numberOfElements();
    }

    public static class ObjectLifetime
    extends CObject {
        public ObjectLifetime(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitObjectLifetime(this);
        }

        public native ObjectLifetimeKind kind();

        public native boolean hasBlockAfterLabelChildLifetime();

        public native boolean hasImplicitChild();

        public native boolean blockLifetimeWithLabelOrGoto();

        public native DynamicInit destructions();

        public native ObjectLifetime parentLifetime();

        public native DynamicInit parentDestructionSublist();

        public native ObjectLifetime childLifetime();

        public native ObjectLifetime next();

        public native CObject entity();
    }

    public static enum ObjectLifetimeKind {
        OLK_GLOBAL_STATIC,
        OLK_BLOCK,
        OLK_BLOCK_AFTER_LABEL,
        OLK_FUNCTION_STATIC,
        OLK_EXPR_TEMPORARY,
        OLK_TRY_BLOCK;


        public static ObjectLifetimeKind fromInt(int i) {
            return ObjectLifetimeKind.values()[i];
        }
    }

    public static enum OpnameKind {
        ONK_NONE,
        ONK_NEW,
        ONK_DELETE,
        ONK_ARRAY_NEW,
        ONK_ARRAY_DELETE,
        ONK_PLUS,
        ONK_MINUS,
        ONK_STAR,
        ONK_DIVIDE,
        ONK_REMAINDER,
        ONK_EXCL_OR,
        ONK_AMPERSAND,
        ONK_OR,
        ONK_COMPL,
        ONK_NOT,
        ONK_ASSIGN,
        ONK_LT,
        ONK_GT,
        ONK_PLUS_ASSIGN,
        ONK_MINUS_ASSIGN,
        ONK_TIMES_ASSIGN,
        ONK_DIVIDE_ASSIGN,
        ONK_REMAINDER_ASSIGN,
        ONK_EXCL_OR_ASSIGN,
        ONK_AND_ASSIGN,
        ONK_OR_ASSIGN,
        ONK_SHIFT_LEFT,
        ONK_SHIFT_RIGHT,
        ONK_SHIFT_RIGHT_ASSIGN,
        ONK_SHIFT_LEFT_ASSIGN,
        ONK_EQ,
        ONK_NE,
        ONK_LE,
        ONK_GE,
        ONK_SPACESHIP,
        ONK_AND_AND,
        ONK_OR_OR,
        ONK_PLUS_PLUS,
        ONK_MINUS_MINUS,
        ONK_COMMA,
        ONK_ARROW_STAR,
        ONK_ARROW,
        ONK_FUNCTION_CALL,
        ONK_SUBSCRIPT,
        ONK_QUESTION,
        ONK_GNU_MIN,
        ONK_GNU_MAX,
        ONK_AWAIT,
        ONK_LAST;


        public static OpnameKind fromInt(int i) {
            return OpnameKind.values()[i];
        }
    }

    public static class OverridingVirtualFunction
    extends CObject {
        public OverridingVirtualFunction(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitOverridingVirtualFunction(this);
        }

        public native OverridingVirtualFunction next();

        public native Routine overridingFunction();

        public native Routine primaryFunction();

        public native BaseClass baseClass();

        public native BaseClass returnAdjustmentBaseClass();
    }

    public static class PackExpansionDescr
    extends CObject {
        public PackExpansionDescr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPackExpansionDescr(this);
        }
    }

    public static class ParamType
    extends CObject {
        public ParamType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitParamType(this);
        }

        public native ParamType next();

        public native Type type();

        public native Type declaredType();

        public native String name();

        public native boolean hasNameConflict();

        public native boolean passedViaCopyConstructor();

        public native boolean hasDefaultArg();

        public native boolean defaultArgAppearedInClassDefinition();

        public native boolean hasUnevaluatedTemplateDefault();

        public native boolean defaultBeingInstantiated();

        public native boolean typeInvolvesDeducedTemplateParam();

        public native boolean typeInvolvesTemplateParam();

        public native boolean isParameterPack();

        public native boolean isPackElement();

        public native boolean isAutoParam();

        public native int qualifiers();

        public native boolean isTransparent();

        public native boolean nonnull();

        public native boolean duplicateName();

        public native boolean isCliParamArray();

        public native boolean moveCtorOrAssignParameter();

        public native boolean copyOrMoveCtorParameter();

        public native boolean isRequiresExprParam();

        public native boolean isExplicitThis();

        public native long paramNum();

        public native ExprNode defaultArgExpr();

        public native ParamType origParamTypeForUnevaluatedDefaultArgExpr();

        public native IlEntityListEntry entitiesDefinedInDefaultArg();

        public native Attribute attributes();

        public native MsAttribute msAttributes();

        public native DeclPositionSupplement declPosInfo();

        public native PackExpansionDescr packExpansionDescr();
    }

    public static class PartialClassBody
    extends CObject {
        public PartialClassBody(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPartialClassBody(this);
        }

        public native PartialClassBody next();

        public native SourcePosition startPosition();

        public native SourcePosition endPosition();

        public native TokenCache bodyCache();

        public native TokenCache baseCache();
    }

    public static class Position {
        private final SourceFile file;
        private final int lineNumber;
        private final int column;

        public Position(SourceFile file, long lineNumber, int column) {
            this.file = file;
            this.lineNumber = (int)lineNumber;
            this.column = column;
        }

        public SourceFile getFile() {
            return this.file;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Position)) {
                return false;
            }
            Position pos = (Position)other;
            if (pos.lineNumber != this.lineNumber || pos.column != this.column) {
                return false;
            }
            if (pos.file == this.file) {
                return true;
            }
            if (pos.file == null || this.file == null) {
                return false;
            }
            return pos.file.fileName().equals(this.file.fileName());
        }

        public int hashCode() {
            if (this.file == null) {
                return 0;
            }
            return this.file.fileName().hashCode() * this.lineNumber * this.column;
        }

        public String toString() {
            if (this.file == null) {
                return "<unknown>";
            }
            return this.file.fileName() + " (" + Long.toString(this.lineNumber) + "," + Integer.toString(this.column) + ")";
        }
    }

    public static class Pragma
    extends CObject {
        public Pragma(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPragma(this);
        }

        public native Pragma next();

        public native PragmaKind kind();

        public native boolean ignoreInBackEnd();

        public native boolean isMicrosoftPragmaOperator();

        public native SourcePosition position();

        public native SourceSequenceEntry sourceSequenceEntry();

        public native String pragmaText();

        public native CObject entity();
    }

    public static class PragmaComment
    extends Pragma {
        public PragmaComment(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPragmaComment(this);
        }

        public native MicrosoftPragmaCommentType commentKind();

        public native Constant str();
    }

    public static class PragmaConform
    extends Pragma {
        public PragmaConform(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPragmaConform(this);
        }

        public native MicrosoftPragmaConformKind conformKind();

        public native boolean on();

        public native boolean off();

        public native boolean show();

        public native boolean push();

        public native boolean pop();

        public native String identifier();
    }

    public static class PragmaGcc
    extends Pragma {
        public PragmaGcc(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPragmaGcc(this);
        }

        public native GccPragmaDescr gcc();
    }

    public static class PragmaIdentString
    extends Pragma {
        public PragmaIdentString(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPragmaIdentString(this);
        }

        public native Constant identString();
    }

    public static class PragmaIncludeAlias
    extends Pragma {
        public PragmaIncludeAlias(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPragmaIncludeAlias(this);
        }

        public native String longFileName();

        public native String shortFileName();
    }

    public static enum PragmaKind {
        PK_NONE,
        PK_PRINTF_ARGS,
        PK_SCANF_ARGS,
        PK_LINT_ARGSUSED,
        PK_LINT_VARARGS_COUNT,
        PK_LINT_NOTREACHED,
        PK_INSTANTIATE,
        PK_DO_NOT_INSTANTIATE,
        PK_CAN_INSTANTIATE,
        PK_INLINE_TEMPLATE,
        PK_PACK,
        PK_IDENT_PRAGMA,
        PK_IDENT_DIRECTIVE,
        PK_WEAK,
        PK_ONCE,
        PK_HDRSTOP,
        PK_NO_PCH,
        PK_DEFINE_TYPE_INFO,
        PK_STDC,
        PK_REDEFINE_EXTNAME,
        PK_ENABLE_LDSCOPE,
        PK_DISABLE_LDSCOPE,
        PK_GCC_IMMEDIATE,
        PK_GCC_NEXT_TOKEN,
        PK_DIAG_SUPPRESS,
        PK_DIAG_REMARK,
        PK_DIAG_WARNING,
        PK_DIAG_ERROR,
        PK_DIAG_ONCE,
        PK_DIAG_DEFAULT,
        PK_DIAGNOSTIC,
        PK_DB_OPT,
        PK_DB_NAME,
        PK_PUSH_MACRO,
        PK_POP_MACRO,
        PK_START_MAP_REGION,
        PK_STOP_MAP_REGION,
        PK_COMMENT,
        PK_CONFORM,
        PK_INCLUDE_ALIAS,
        PK_LAST;


        public static PragmaKind fromInt(int i) {
            return PragmaKind.values()[i];
        }
    }

    public static class PragmaStdc
    extends Pragma {
        public PragmaStdc(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPragmaStdc(this);
        }

        public native StdcPragmaKind stdcKind();

        public native StdcPragmaValue value();
    }

    public static class PropertyIndexType
    extends CObject {
        public PropertyIndexType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPropertyIndexType(this);
        }

        public native PropertyIndexType next();

        public native Type type();

        public native SourcePosition position();
    }

    public static class PropertyOrEventDescr
    extends CObject {
        public PropertyOrEventDescr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPropertyOrEventDescr(this);
        }

        public native PropertyOrEventKind kind();

        public native boolean isTrivial();

        public native boolean isDefaultIndexed();

        public native boolean isVirtual();

        public native boolean isStatic();

        public native PropertyIndexType indices();

        public native String getRoutine_name();

        public native Routine getRoutine_ptr();

        public native String setRoutine_name();

        public native Routine setRoutine_ptr();

        public native Routine addRoutine();

        public native Routine removeRoutine();

        public native Routine raiseRoutine();

        public native SourcePosition propertyOrEventPosition();

        public native SourceRange indicesRange();

        public native SourceRange definitionRange();
    }

    public static class PropertyOrEventDescrField
    extends PropertyOrEventDescr {
        public PropertyOrEventDescrField(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPropertyOrEventDescrField(this);
        }

        public native Field field();
    }

    public static class PropertyOrEventDescrVariable
    extends PropertyOrEventDescr {
        public PropertyOrEventDescrVariable(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitPropertyOrEventDescrVariable(this);
        }

        public native Variable variable();
    }

    public static enum PropertyOrEventKind {
        PEK_DECLSPEC_PROPERTY,
        PEK_CLI_PROPERTY,
        PEK_CLI_EVENT;


        public static PropertyOrEventKind fromInt(int i) {
            return PropertyOrEventKind.values()[i];
        }
    }

    public static class RangeBasedForLoop
    extends CObject {
        public RangeBasedForLoop(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitRangeBasedForLoop(this);
        }

        public native Statement initialization();

        public native Variable iterator();

        public native Variable range();

        public native Scope rangeBasedForScope();

        public native Scope iteratorScope();

        public native Variable begin();

        public native Variable end();

        public native ExprNode neCallExpr();

        public native ExprNode incrCallExpr();

        public native boolean useAwait();
    }

    public static class ReflectionValue
    extends CObject {
        public ReflectionValue(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitReflectionValue(this);
        }

        public native int localScopeNumber();

        public native CObject entity();
    }

    public static class RequiresClause
    extends CObject {
        public RequiresClause(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitRequiresClause(this);
        }

        public native ExprNode constraint();

        public native SourcePosition requiresPos();
    }

    public static class Routine
    extends CObject {
        public Routine(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitRoutine(this);
        }

        @Override
        public native SourceCorrespondence sourceCorresp();

        public native Routine next();

        public native Type type();

        public native int functionDefNumber();

        public native int memoryRegion();

        public native long hashValue();

        public native StorageClass storageClass();

        public native StorageClass declaredStorageClass();

        public native SpecialFunctionKind specialKind();

        public native boolean addressTaken();

        public native boolean isVirtual();

        public native boolean overridesBaseMember();

        public native boolean pureVirtual();

        public native boolean isFinal();

        public native boolean override();

        public native boolean isAbstract();

        public native boolean sealed();

        public native boolean newMember();

        public native boolean interfaceSlot();

        public native boolean definitionCannotBeGenerated();

        public native boolean covariantReturnVirtualOverride();

        public native boolean isInline();

        public native boolean isDeclaredConstexpr();

        public native boolean isConstexpr();

        public native boolean isConsteval();

        public native boolean isConstexprIntrinsic();

        public native boolean compilerGenerated();

        public native boolean defined();

        public native boolean called();

        public native boolean isExplicitConstructor();

        public native boolean isExplicitConversionFunction();

        public native boolean isTrivialDefaultConstructor();

        public native boolean isTrivialCopyFunction();

        public native boolean isTrivialDestructor();

        public native boolean isInitializerListCtor();

        public native boolean isDelegatingCtor();

        public native boolean isInheritingCtor();

        public native boolean inheritsVirtually();

        public native boolean assignmentToThisDone();

        public native boolean isTemplateFunction();

        public native boolean isSpecialized();

        public native boolean specializedWithOldSyntax();

        public native boolean isPrototypeInstantiation();

        public native boolean neverThrows();

        public native boolean isInClassSpecialization();

        public native boolean explicitInstantiation();

        public native boolean classExplicitlyInstantiated();

        public native boolean explicitDoNotInstantiate();

        public native boolean hasNodiscardAttribute();

        public native boolean neverInline();

        public native boolean isPure();

        public native boolean isNaked();

        public native boolean declaredOnlyAsFriend();

        public native boolean explicitExternInline();

        public native boolean directLinkageSpecifierOnNondefDecl();

        public native boolean isReverseConversionFunction();

        public native boolean isGenericDefinition();

        public native boolean isGenericInstance();

        public native boolean isInitializationRoutine();

        public native boolean isFinalizationRoutine();

        public native boolean isWeak();

        public native boolean isWeakref();

        public native boolean isGnuAlias();

        public native boolean isIfunc();

        public native boolean hasGnuUsedAttribute();

        public native boolean hasGnuAbiTagAttribute();

        public native boolean inGnuAbiTagNamespace();

        public native boolean implicitAbiTagsAdded();

        public native boolean allocatesMemory();

        public native boolean noInstrumentFunction();

        public native boolean noCheckMemoryUsage();

        public native boolean alwaysInline();

        public native boolean gnuC89Inline();

        public native boolean implicitAlias();

        public native boolean hasInternalLinkageAttribute();

        public native boolean containsTryBlock();

        public native boolean containsLocalClassType();

        public native boolean supersededExternal();

        public native boolean definedInFriendDecl();

        public native boolean definedOutsideOfParent();

        public native boolean explTemplateArgListUsed();

        public native boolean definitionForInliningOnly();

        public native boolean suppressInlineBody();

        public native boolean onInlineFunctionList();

        public native boolean needOutOfLineCopy();

        public native int fpContract();

        public native int fenvAccess();

        public native int cxLimitedRange();

        public native boolean containsStatementExpression();

        public native boolean isLambdaBody();

        public native boolean declaredUsingTypeWithoutLinkage();

        public native boolean isDefaulted();

        public native boolean isDeleted();

        public native boolean containsLocalStaticVariable();

        public native boolean embeddedSourceSequenceEntries();

        public native boolean consideredDeciderFunctionAtSomePoint();

        public native boolean isRawLiteralOperator();

        public native boolean isTlsInitRoutine();

        public native boolean hasDeducibleReturnType();

        public native boolean hasDeducedReturnType();

        public native boolean containsGenericLambda();

        public native boolean isCoroutine();

        public native boolean isTopLevelInMemRegion();

        public native boolean friendDefinedInInstantiation();

        public native boolean isIneligible();

        public native boolean hasPassObjectSizeAttr();

        public native boolean fromInjectedTokens();

        public native long declModifiers();

        public native RequiresClause trailingRequiresClause();

        public native int number_virtualFunction();

        public native int number_constexprIntrinsic();

        public native IlEntityListEntry overriddenFunctions();

        public native ClassListEntry friendsOrOriginator_befriendingClasses();

        public native Routine friendsOrOriginator_inheritedRoutine();

        public native TemplateArg templateArgList();

        public native Template assocTemplate();

        public native GnuRoutineSupplement gnuExtraInfo();

        public native Type declaredType();

        public native RoutineFixup routineFixup();

        public native UsingDecl generatingUsingDecl();

        public native Scope getScope();
    }

    public static class RoutineBuiltinFunctionKind
    extends Routine {
        public RoutineBuiltinFunctionKind(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitRoutineBuiltinFunctionKind(this);
        }

        public native int builtinFunctionKind();
    }

    public static class RoutineClassTemplate
    extends Routine {
        public RoutineClassTemplate(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitRoutineClassTemplate(this);
        }

        public native Template classTemplate();
    }

    public static class RoutineFixup
    extends CObject {
        public RoutineFixup(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitRoutineFixup(this);
        }
    }

    public static class RoutineLambdaCallOperator
    extends Routine {
        public RoutineLambdaCallOperator(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitRoutineLambdaCallOperator(this);
        }

        public native Routine lambdaCallOperator();
    }

    public static class RoutineListEntry
    extends CObject {
        public RoutineListEntry(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitRoutineListEntry(this);
        }

        public native RoutineListEntry next();

        public native Routine routine();
    }

    public static class RoutineOpnameKind
    extends Routine {
        public RoutineOpnameKind(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitRoutineOpnameKind(this);
        }

        public native OpnameKind opnameKind();
    }

    public static class RoutinePropertyOrEventDescr
    extends Routine {
        public RoutinePropertyOrEventDescr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitRoutinePropertyOrEventDescr(this);
        }

        public native PropertyOrEventDescr propertyOrEventDescr();
    }

    public static class RoutineTypeSupplement
    extends CObject {
        public RoutineTypeSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitRoutineTypeSupplement(this);
        }

        public native ParamType paramTypeList();

        public native Routine assocRoutine();

        public native boolean hasEllipsis();

        public native boolean prototyped();

        public native boolean oldStyleParamsScanned();

        public native boolean trailingReturnType();

        public native boolean lintArgsusedFlag();

        public native boolean valueReturnedByCctor();

        public native boolean assocRoutineIsCtor();

        public native boolean assocRoutineIsDtor();

        public native boolean assocRoutineIsLambdaBody();

        public native boolean suppressDiagnosticOnIncompleteReturnType();

        public native int routineNameLinkage();

        public native boolean routineNameLinkageIsExplicit();

        public native int qualifiers();

        public native int thisQualifiers();

        public native int refQualifiers();

        public native boolean doesNotReturn();

        public native boolean hasEnableIfAttribute();

        public native boolean resultShouldBeUsed();

        public native boolean isConst();

        public native boolean isVariadicInstance();

        public native boolean explicitCallingConvention();

        public native boolean hadBeenImplicitlyConst();

        public native boolean isConditionallyExplicit();

        public native boolean hasThisParam();

        public native short lintVarargsCount();

        public native PragmaKind argPragma();

        public native CallingConvention callingConvention();

        public native int fmtArg();

        public native int sentinelPos();

        public native Type thisClass();

        public native Scope prototypeScope();

        public native ExceptionSpecification exceptionSpecification();
    }

    public static class Scope
    extends CObject {
        public Scope(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitScope(this);
        }

        public native Scope next();

        public native Scope prev();

        public native Scope parent();

        public native int number();

        public native ScopeKind kind();

        public native boolean functionBodyProcessingFinished();

        public native boolean doNotFreeMemoryRegion();

        public native boolean isConstexprRoutine();

        public native boolean isStmtExprBlock();

        public native boolean isPlaceholderScope();

        public native boolean neededWalkDone();

        public native Statement assocBlock();

        public native ObjectLifetime lifetime();

        public native Constant constants();

        public native Type types();

        public native Variable variables();

        public native Variable nonstaticVariables();

        public native Label labels();

        public native Routine routines();

        public native AsmEntry asmEntries();

        public native Scope scopes();

        public native Namespace namespaces();

        public native UsingDecl usingDeclarations();

        public native UsingDecl usingDirectives();

        public native DynamicInit dynamicInits();

        public native LocalStaticVariableInit localStaticVariableInits();

        public native VlaDimension vlaDimensions();

        public native LocalExprNodeRef exprNodeRefs();

        public native LocalScopeRef scopeRefs();

        public native Pragma pragmas();

        public native int depthInScopeStack();

        public native Symbol symbols();

        public native SourceSequenceEntry sourceSequenceList();

        public native SrcSeqSublist srcSeqSublistList();

        public native HiddenName hiddenNames();

        public native Template templates();

        public native MsAttribute msAttributes();
    }

    public static class ScopeAssocHandler
    extends Scope {
        public ScopeAssocHandler(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitScopeAssocHandler(this);
        }

        public native Handler assocHandler();
    }

    public static class ScopeAssocNamespace
    extends Scope {
        public ScopeAssocNamespace(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitScopeAssocNamespace(this);
        }

        public native Namespace assocNamespace();
    }

    public static class ScopeAssocStatement
    extends Scope {
        public ScopeAssocStatement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitScopeAssocStatement(this);
        }

        public native Statement assocStatement();
    }

    public static class ScopeAssocType
    extends Scope {
        public ScopeAssocType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitScopeAssocType(this);
        }

        public native Type assocType();
    }

    public static enum ScopeKind {
        SCK_FILE,
        SCK_FUNC_PROTOTYPE,
        SCK_BLOCK,
        SCK_NAMESPACE,
        SCK_NAMESPACE_EXTENSION,
        SCK_NAMESPACE_REACTIVATION,
        SCK_CLASS_STRUCT_UNION,
        SCK_CLASS_REACTIVATION,
        SCK_TEMPLATE_DECLARATION,
        SCK_TEMPLATE_INSTANTIATION,
        SCK_INSTANTIATION_CONTEXT,
        SCK_MODULE_DECL_IMPORT,
        SCK_MODULE_ISOLATED,
        SCK_PRAGMA,
        SCK_FUNCTION_ACCESS,
        SCK_CONDITION,
        SCK_ENUM,
        SCK_FUNCTION,
        SCK_NONE;


        public static ScopeKind fromInt(int i) {
            return ScopeKind.values()[i];
        }
    }

    public static class ScopeRoutine
    extends Scope {
        public ScopeRoutine(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitScopeRoutine(this);
        }

        public native Routine ptr();

        public native Variable parameters();

        public native ConstructorInit constructorInits();

        public native ObjectLifetime lifetimeOfLocalStaticVars();

        public native Variable thisParamVariable();

        public native Variable returnValueVariable();
    }

    public static class SeqNumberLookupEntry
    extends CObject {
        public SeqNumberLookupEntry(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSeqNumberLookupEntry(this);
        }

        public native SeqNumberLookupEntry next();

        public native long first();

        public native long last();

        public native long lineNumber();

        public native SourceFile sourceFile();
    }

    public static class SimpleSourcePosition
    extends CObject {
        public SimpleSourcePosition(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSimpleSourcePosition(this);
        }

        public native long seq();

        public native int column();
    }

    public static class SourceCorrespondence
    extends CObject {
        public SourceCorrespondence(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSourceCorrespondence(this);
        }

        public native String assocInfo();

        public native String name();

        public native String unmangledNameOrMangledEncoding();

        public native TransUnitCorresp transUnitCorresp();

        public native Scope parentScope();

        public native Routine enclosingRoutine();

        public native ModuleEntity moduleEntity();

        public native SourcePosition declPosition();

        public native DeclPositionSupplement declPosInfo();

        public native NameReference nameReferences();

        public native int access();

        public native int assemblyAccess();

        public native boolean referenced();

        public native int nameLinkage();

        public native boolean hasAssociatedPragma();

        public native boolean isLocalToFunction();

        public native boolean parentViaLocalScopeRef();

        public native boolean isClassMember();

        public native boolean hasAssociatedAttribute();

        public native boolean nameHasBeenMangled();

        public native boolean mangledNameCannotBeIncludedInOtherName();

        public native boolean finalNameManglingPending();

        public native boolean unnamedEntityGivenFabricatedName();

        public native boolean entityMarked();

        public native boolean isDeclAfterFirstInCommaList();

        public native boolean copiedFromSecondaryTransUnit();

        public native boolean sameNameAsExternalEntityInSecondaryTransUnit();

        public native boolean memberOfUnknownBase();

        public native boolean qualifiedUnknownBaseMember();

        public native boolean memberOfUnknownSuper();

        public native boolean microsoftIdentifierUsed();

        public native boolean markedAsGnuExtension();

        public native boolean isDeprecatedOrUnavailable();

        public native boolean externalized();

        public native boolean maybeUnused();

        public native int scopeDepth();

        public native SourceSequenceEntry sourceSequenceEntry();

        public native Attribute attributes();
    }

    public static class SourceFile
    extends CObject {
        public SourceFile(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSourceFile(this);
        }

        public native String fileName();

        public native String fullName();

        public native String nameAsWritten();

        public native long firstSeqNumber();

        public native long lastSeqNumber();

        public native long firstLineNumber();

        public native SourceFile firstChildFile();

        public native SourceFile lastChildFile();

        public native SourceFile next();

        public native Module assocModule();

        public native boolean isIncludeFile();

        public native boolean includedBySystemInclude();

        public native boolean includedByPreinclude();

        public native boolean preincludeMacrosOnly();

        public native boolean fromSystemIncludeDir();

        public native boolean topLevelFile();

        public native boolean topLevelFileFromPch();

        public native boolean isAssemblyFile();
    }

    public static enum SourceLanguage {
        SL_CPLUSPLUS,
        SL_C;


        public static SourceLanguage fromInt(int i) {
            return SourceLanguage.values()[i];
        }
    }

    public static class SourcePosition
    extends CObject {
        public SourcePosition(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSourcePosition(this);
        }

        public native long seq();

        public native int column();

        public native int origColumn();

        public native long origSeq();

        public native int macroContext();

        public Position getPosition() {
            return EDG.getPositionFromSequenceNumber(this.seq(), this.column());
        }

        public Position getOriginalPosition() {
            return EDG.getPositionFromSequenceNumber(this.origSeq(), this.origColumn());
        }
    }

    public static class SourceRange
    extends CObject {
        public SourceRange(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSourceRange(this);
        }

        public native SourcePosition start();

        public native SourcePosition end();
    }

    public static class SourceSequenceEntry
    extends CObject {
        public SourceSequenceEntry(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSourceSequenceEntry(this);
        }

        public native SourceSequenceEntry next();

        public native SourceSequenceEntry prev();

        public native CObject entity();
    }

    public static enum SpecialFunctionKind {
        SFK_NONE,
        SFK_CONSTRUCTOR,
        SFK_DESTRUCTOR,
        SFK_CONVERSION,
        SFK_UDL_OPERATOR,
        SFK_OPERATOR,
        SFK_LAMBDA_ENTRY_POINT,
        SFK_DEDUCTION_GUIDE,
        SFK_STATIC_CONSTRUCTOR,
        SFK_FINALIZER,
        SFK_IDISPOSABLE_DISPOSE,
        SFK_DISPOSE_BOOL,
        SFK_OBJECT_FINALIZE,
        SFK_PROPERTY_GET,
        SFK_PROPERTY_SET,
        SFK_EVENT_ADD,
        SFK_EVENT_REMOVE,
        SFK_EVENT_RAISE,
        SFK_GNU_SYNC_CONCRETE_FUNCTION,
        SFK_GNU_ATOMIC_NONGENERIC_FUNCTION,
        SFK_GNU_ATOMIC_GENERIC_FUNCTION,
        SFK_BUILTIN_OPERATOR_NEW,
        SFK_BUILTIN_OPERATOR_DELETE,
        SFK_LAST;


        public static SpecialFunctionKind fromInt(int i) {
            return SpecialFunctionKind.values()[i];
        }
    }

    public static class SrcSeqEndOfConstruct
    extends CObject {
        public SrcSeqEndOfConstruct(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSrcSeqEndOfConstruct(this);
        }

        public native SourcePosition position();

        public native CObject entity();
    }

    public static class SrcSeqSecondaryDecl
    extends CObject {
        public SrcSeqSecondaryDecl(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSrcSeqSecondaryDecl(this);
        }

        public native SourcePosition declPosition();

        public native DeclPositionSupplement declPosInfo();

        public native Type declaredType();

        public native NameReference nameReference();

        public native Attribute attributes();

        public native StorageClass declaredStorageClass();

        public native boolean autonomousTagDecl();

        public native boolean embeddedSourceSequenceEntries();

        public native boolean friendDecl();

        public native boolean declaredInFuncPrototype();

        public native boolean specializedWithNewSyntax();

        public native boolean firstDeclaration();

        public native boolean markedAsGnuExtension();

        public native boolean isDeclAfterFirstInCommaList();

        public native boolean explicitStorageClass();

        public native boolean isAlias();

        public native boolean isEventInterface();

        public native CObject entity();
    }

    public static class SrcSeqSublist
    extends CObject {
        public SrcSeqSublist(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSrcSeqSublist(this);
        }

        public native SrcSeqSublist next();

        public native SourceSequenceEntry sourceSequenceList();

        public native SourceSequenceEntry lastSourceSequenceEntry();
    }

    public static class Statement
    extends CObject {
        public Statement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatement(this);
        }

        public native SourcePosition position();

        public native SourcePosition endPosition();

        public native Statement next();

        public native Statement parent();

        public native Attribute attributes();

        public native StatementKind kind();

        public native boolean hasAssociatedPragma();

        public native boolean isInitializationGuard();

        public native boolean isLoweringBoilerplate();

        public native boolean isFallthroughStatement();

        public native boolean isLikely();

        public native boolean isUnlikely();

        public native ExprNode expr();

        public native SourceSequenceEntry sourceSequenceEntry();
    }

    public static class StatementAsmEntry
    extends Statement {
        public StatementAsmEntry(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementAsmEntry(this);
        }

        public native AsmEntry asmEntry();
    }

    public static class StatementAsmFuncBody
    extends Statement {
        public StatementAsmFuncBody(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementAsmFuncBody(this);
        }

        public native String asmFuncBody();
    }

    public static class StatementBlock
    extends Statement {
        public StatementBlock(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementBlock(this);
        }

        public native Statement statements();

        public native Block extraInfo();
    }

    public static class StatementConstexprIf
    extends Statement {
        public StatementConstexprIf(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementConstexprIf(this);
        }

        public native ConstexprIf constexprIf();
    }

    public static class StatementCoroutine
    extends Statement {
        public StatementCoroutine(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementCoroutine(this);
        }

        public native CoroutineDescr descr();
    }

    public static class StatementDecl
    extends Statement {
        public StatementDecl(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementDecl(this);
        }

        public native IlEntityListEntry entities();

        public native boolean hasStaticOrThreadVariable();
    }

    public static class StatementDynamicInit
    extends Statement {
        public StatementDynamicInit(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementDynamicInit(this);
        }

        public native DynamicInit dynamicInit();
    }

    public static class StatementForEachLoop
    extends Statement {
        public StatementForEachLoop(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementForEachLoop(this);
        }

        public native Statement statement();

        public native ForEachLoop extraInfo();
    }

    public static class StatementForLoop
    extends Statement {
        public StatementForLoop(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementForLoop(this);
        }

        public native Statement statement();

        public native ForLoop extraInfo();
    }

    public static class StatementIfStmt
    extends Statement {
        public StatementIfStmt(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementIfStmt(this);
        }

        public native Statement thenStatement();

        public native Statement elseStatement();

        public native SourcePosition elsePosition();
    }

    public static enum StatementKind {
        STMK_EXPR,
        STMK_IF,
        STMK_CONSTEXPR_IF,
        STMK_IF_CONSTEVAL,
        STMK_IF_NOT_CONSTEVAL,
        STMK_WHILE,
        STMK_GOTO,
        STMK_LABEL,
        STMK_RETURN,
        STMK_COROUTINE,
        STMK_COROUTINE_RETURN,
        STMK_BLOCK,
        STMK_END_TEST_WHILE,
        STMK_FOR,
        STMK_RANGE_BASED_FOR,
        STMK_FOR_EACH,
        STMK_SWITCH_CASE,
        STMK_SWITCH,
        STMK_INIT,
        STMK_ASM,
        STMK_ASM_FUNC_BODY,
        STMK_TRY_BLOCK,
        STMK_MICROSOFT_TRY,
        STMK_DECL,
        STMK_SET_VLA_SIZE,
        STMK_VLA_DECL,
        STMK_ASSIGNED_GOTO,
        STMK_EMPTY,
        STMK_STMT_EXPR_RESULT,
        STMK_LAST;


        public static StatementKind fromInt(int i) {
            return StatementKind.values()[i];
        }
    }

    public static class StatementLabel
    extends Statement {
        public StatementLabel(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementLabel(this);
        }

        public native Label ptr();

        public native ObjectLifetime lifetime();
    }

    public static class StatementLoopStatement
    extends Statement {
        public StatementLoopStatement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementLoopStatement(this);
        }

        public native Statement loopStatement();
    }

    public static class StatementMicrosoftTry
    extends Statement {
        public StatementMicrosoftTry(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementMicrosoftTry(this);
        }

        public native MicrosoftTrySupplement microsoftTry();
    }

    public static class StatementRangeBasedForLoop
    extends Statement {
        public StatementRangeBasedForLoop(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementRangeBasedForLoop(this);
        }

        public native Statement statement();

        public native RangeBasedForLoop extraInfo();
    }

    public static class StatementReturnDynamicInit
    extends Statement {
        public StatementReturnDynamicInit(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementReturnDynamicInit(this);
        }

        public native DynamicInit returnDynamicInit();
    }

    public static class StatementStmtExprResult
    extends Statement {
        public StatementStmtExprResult(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementStmtExprResult(this);
        }

        public native DynamicInit dynamicInit();
    }

    public static class StatementSwitchCase
    extends Statement {
        public StatementSwitchCase(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementSwitchCase(this);
        }

        public native Statement switchStatement();

        public native SwitchCaseEntry extraInfo();
    }

    public static class StatementSwitchStmt
    extends Statement {
        public StatementSwitchStmt(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementSwitchStmt(this);
        }

        public native Statement bodyStatement();

        public native SwitchStmtDescr extraInfo();
    }

    public static class StatementTryBlock
    extends Statement {
        public StatementTryBlock(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementTryBlock(this);
        }

        public native TrySupplement tryBlock();
    }

    public static class StatementVla
    extends Statement {
        public StatementVla(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementVla(this);
        }

        public native boolean isTypedefDecl();
    }

    public static class StatementVlaDimension
    extends Statement {
        public StatementVlaDimension(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementVlaDimension(this);
        }

        public native VlaDimension vlaDimension();
    }

    public static class StatementVlaTypedefType
    extends StatementVla {
        public StatementVlaTypedefType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementVlaTypedefType(this);
        }

        public native Type typedefType();
    }

    public static class StatementVlaVariable
    extends StatementVla {
        public StatementVlaVariable(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitStatementVlaVariable(this);
        }

        public native Variable variable();
    }

    public static enum StdcPragmaKind {
        STDC_PK_NONE,
        STDC_PK_FP_CONTRACT,
        STDC_PK_FENV_ACCESS,
        STDC_PK_CX_LIMITED_RANGE,
        STDC_PK_LAST;


        public static StdcPragmaKind fromInt(int i) {
            return StdcPragmaKind.values()[i];
        }
    }

    public static enum StdcPragmaValue {
        STDC_PV_NONE,
        STDC_PV_OFF,
        STDC_PV_ON,
        STDC_PV_DEFAULT;


        public static StdcPragmaValue fromInt(int i) {
            return StdcPragmaValue.values()[i];
        }
    }

    public static enum StorageClass {
        SC_UNSPECIFIED,
        SC_EXTERN,
        SC_STATIC,
        SC_AUTO,
        SC_TYPEDEF,
        SC_REGISTER,
        SC_ASM,
        SC_LAST;


        public static StorageClass fromInt(int i) {
            return StorageClass.values()[i];
        }
    }

    public static class SubobjectPath
    extends CObject {
        public SubobjectPath(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSubobjectPath(this);
        }

        public native SubobjectPath next();

        public native boolean isOffset();

        public native boolean isBaseClass();

        public native boolean isConverted();
    }

    public static class SubobjectPathBaseClass
    extends SubobjectPath {
        public SubobjectPathBaseClass(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSubobjectPathBaseClass(this);
        }

        public native BaseClass baseClass();
    }

    public static class SubobjectPathField
    extends SubobjectPath {
        public SubobjectPathField(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSubobjectPathField(this);
        }

        public native Field field();
    }

    public static class SubobjectPathPtrOffset
    extends SubobjectPath {
        public SubobjectPathPtrOffset(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSubobjectPathPtrOffset(this);
        }

        public native int ptrOffset();
    }

    public static class SwitchCaseEntry
    extends CObject {
        public SwitchCaseEntry(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSwitchCaseEntry(this);
        }

        public native Statement stmt();

        public native Constant caseValue();

        public native Constant rangeEnd();

        public native SwitchCaseEntry next();

        public native SwitchCaseEntry nextOnSortedList();

        public native SourcePosition position();

        public native SourcePosition endPosition();

        public native SourcePosition colonPosition();

        public native boolean reachableByFallThrough();
    }

    public static class SwitchStmtDescr
    extends CObject {
        public SwitchStmtDescr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSwitchStmtDescr(this);
        }

        public native SwitchCaseEntry cases();

        public native SwitchCaseEntry defaultCase();

        public native SwitchCaseEntry sortedCases();
    }

    public static class Symbol
    extends CObject {
        public Symbol(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitSymbol(this);
        }
    }

    public static enum TemplArgKind {
        TAK_TYPE,
        TAK_NONTYPE,
        TAK_TEMPLATE,
        TAK_START_OF_PACK_EXPANSION;


        public static TemplArgKind fromInt(int i) {
            return TemplArgKind.values()[i];
        }
    }

    public static class Template
    extends CObject {
        public Template(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplate(this);
        }

        @Override
        public native SourceCorrespondence sourceCorresp();

        public native Template next();

        public native TemplateKind kind();

        public native boolean isExported();

        public native boolean ignoreExport();

        public native boolean isPack();

        public native boolean isFriendTemplate();

        public native long cacheChecksum();

        public native TemplateParamCoordinate coordinates();

        public native SourcePosition exportPosition();

        public native SourceRange definitionRange();

        public native TemplateSymbolSupplement templateInfo();

        public native TemplateDecl templateDecl();

        public native Routine prototypeInstantiation_routine();

        public native Type prototypeInstantiation_type();

        public native Variable prototypeInstantiation_variable();

        public native ExprNode prototypeInstantiation_constraint();

        public native Template canonicalTemplate();

        public native Template definitionTemplate();

        public native Template prototypeTemplate();

        public native String text();
    }

    public static class TemplateArg
    extends CObject {
        public TemplateArg(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateArg(this);
        }

        public native TemplateArg next();

        public native TemplArgKind kind();

        public native PackExpansionDescr packExpansionDescr();

        public native boolean isArrayBoundOfUnknownType();

        public native boolean explicitlySpecified();

        public native boolean templateTemplateParamChecked();

        public native boolean isPackElement();

        public native boolean isPack();

        public native boolean hasPackEllipsis();

        public native boolean isIntegerPack();

        public native boolean typeIsInjectedClassName();

        public native boolean isProvisionalValue();

        public native boolean isError();

        public native boolean paramIsAuto();

        public native boolean paramIsDecltypeAuto();

        public native ArgOperand argOperand();
    }

    public static class TemplateArgConstant
    extends TemplateArg {
        public TemplateArgConstant(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateArgConstant(this);
        }

        public native Constant constant();
    }

    public static class TemplateArgIntegerValue
    extends TemplateArg {
        public TemplateArgIntegerValue(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateArgIntegerValue(this);
        }

        public native long integerValue();
    }

    public static class TemplateArgTempl
    extends TemplateArg {
        public TemplateArgTempl(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateArgTempl(this);
        }

        public native Template ptr();

        public native Template substitutedParamTemplate();
    }

    public static class TemplateArgType
    extends TemplateArg {
        public TemplateArgType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateArgType(this);
        }

        public native Type type();
    }

    public static class TemplateDecl
    extends CObject {
        public TemplateDecl(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateDecl(this);
        }

        public native TemplateDecl parent();

        public native TemplateParameter paramList();

        public native GenericConstraintClause constraint_whereClauses();

        public native RequiresClause constraint_requiresClause();

        public native Scope scope();

        public native SourcePosition templatePos();

        public native boolean isGeneric();
    }

    public static enum TemplateKind {
        TEMPLK_NONE,
        TEMPLK_CLASS,
        TEMPLK_FUNCTION,
        TEMPLK_VARIABLE,
        TEMPLK_MEMBER_FUNCTION,
        TEMPLK_STATIC_DATA_MEMBER,
        TEMPLK_MEMBER_CLASS,
        TEMPLK_MEMBER_ENUM,
        TEMPLK_TEMPLATE_TEMPLATE_PARAM,
        TEMPLK_CONCEPT;


        public static TemplateKind fromInt(int i) {
            return TemplateKind.values()[i];
        }
    }

    public static enum TemplateParamConstantKind {
        TPCK_PARAM,
        TPCK_EXPRESSION,
        TPCK_MEMBER,
        TPCK_UNKNOWN_FUNCTION,
        TPCK_ADDRESS,
        TPCK_SIZEOF,
        TPCK_DATASIZEOF,
        TPCK_ALIGNOF,
        TPCK_UUIDOF,
        TPCK_TYPEID,
        TPCK_NOEXCEPT,
        TPCK_TEMPLATE_REF,
        TPCK_INTEGER_PACK,
        TPCK_DESTRUCTOR;


        public static TemplateParamConstantKind fromInt(int i) {
            return TemplateParamConstantKind.values()[i];
        }
    }

    public static class TemplateParamCoordinate
    extends CObject {
        public TemplateParamCoordinate(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateParamCoordinate(this);
        }

        public native long position();

        public native int depth();
    }

    public static enum TemplateParamTypeKind {
        TPTK_PARAM,
        TPTK_MEMBER,
        TPTK_UNKNOWN;


        public static TemplateParamTypeKind fromInt(int i) {
            return TemplateParamTypeKind.values()[i];
        }
    }

    public static class TemplateParamTypeSupplement
    extends CObject {
        public TemplateParamTypeSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateParamTypeSupplement(this);
        }

        public native Type classType();

        public native Type origNestedType();

        public native Symbol templateSymbol();

        public native GenericConstraint genericConstraints();

        public native int genericParamSeqNumber();

        public native TemplateParamCoordinate coordinates();

        public native ExprNode constraint_typeConstraint();

        public native Symbol constraint_classTemplateSymbol();
    }

    public static class TemplateParameter
    extends CObject {
        public TemplateParameter(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateParameter(this);
        }

        @Override
        public native SourceCorrespondence sourceCorresp();

        public native TemplateParameter next();

        public native TemplateParameterKind kind();

        public native boolean isPack();

        public native boolean isAbbreviated();
    }

    public static enum TemplateParameterKind {
        TPK_ERROR,
        TPK_TYPE,
        TPK_NONTYPE,
        TPK_TEMPLATE;


        public static TemplateParameterKind fromInt(int i) {
            return TemplateParameterKind.values()[i];
        }
    }

    public static class TemplateParameterNontype
    extends TemplateParameter {
        public TemplateParameterNontype(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateParameterNontype(this);
        }

        public native Constant constant();

        public native Constant defaultArgConstant();
    }

    public static class TemplateParameterTempl
    extends TemplateParameter {
        public TemplateParameterTempl(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateParameterTempl(this);
        }

        public native Template classTemplate();

        public native Template defaultArgTemplate();
    }

    public static class TemplateParameterType
    extends TemplateParameter {
        public TemplateParameterType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateParameterType(this);
        }

        public native Type ptr();

        public native Type defaultArgType();
    }

    public static class TemplateSymbolSupplement
    extends CObject {
        public TemplateSymbolSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTemplateSymbolSupplement(this);
        }
    }

    public static class ThrowSupplement
    extends CObject {
        public ThrowSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitThrowSupplement(this);
        }

        public native Type type();

        public native DynamicInit dynamicInit();

        public native Routine destructor();
    }

    public static class TokenCache
    extends CObject {
        public TokenCache(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTokenCache(this);
        }
    }

    public static enum TokenKind {
        TOK_ERROR,
        TOK_IDENTIFIER,
        TOK_FLOAT_CONSTANT,
        TOK_FIXED_POINT_CONSTANT,
        TOK_INT_CONSTANT,
        TOK_CHAR_CONSTANT,
        TOK_GEN_CONSTANT,
        TOK_STRING_LITERAL,
        TOK_UD_LITERAL,
        TOK_END_OF_SOURCE,
        TOK_NEWLINE,
        TOK_HEADER_NAME,
        TOK_PP_NUMBER,
        TOK_DIGIT_SEQUENCE,
        TOK_CPP_QUOTE,
        TOK_PTR_TO_MEMBER,
        TOK_REMOVED_EXPR,
        TOK_REMOVED_TEMPLATE_BODY,
        TOK_CLI_TYPEID,
        TOK_DECLTYPE_CONSTRUCT,
        TOK_PENDING_IFC_EXPR,
        TOK_IFC_ENTITY_REF,
        TOK_IFC_DECL_REF,
        TOK_IFC_PARAM_REF,
        TOK_IFC_DECL,
        TOK_UNIMPLEMENTED,
        TOK_LBRACKET,
        TOK_RBRACKET,
        TOK_LPAREN,
        TOK_RPAREN,
        TOK_PERIOD,
        TOK_ARROW,
        TOK_PLUS_PLUS,
        TOK_MINUS_MINUS,
        TOK_AMPERSAND,
        TOK_STAR,
        TOK_PLUS,
        TOK_MINUS,
        TOK_COMPL,
        TOK_NOT,
        TOK_DIVIDE,
        TOK_REMAINDER,
        TOK_SHIFT_LEFT,
        TOK_SHIFT_RIGHT,
        TOK_LT,
        TOK_GT,
        TOK_LE,
        TOK_GE,
        TOK_EQ,
        TOK_NE,
        TOK_SPACESHIP,
        TOK_CARET_CARET,
        TOK_EXCL_OR,
        TOK_OR,
        TOK_AND_AND,
        TOK_OR_OR,
        TOK_QUEST_MARK,
        TOK_COLON,
        TOK_ASSIGN,
        TOK_TIMES_ASSIGN,
        TOK_DIVIDE_ASSIGN,
        TOK_REMAINDER_ASSIGN,
        TOK_PLUS_ASSIGN,
        TOK_MINUS_ASSIGN,
        TOK_SHIFT_LEFT_ASSIGN,
        TOK_SHIFT_RIGHT_ASSIGN,
        TOK_AND_ASSIGN,
        TOK_EXCL_OR_ASSIGN,
        TOK_OR_ASSIGN,
        TOK_COMMA,
        TOK_SHARP,
        TOK_PASTE,
        TOK_GNU_MIN,
        TOK_GNU_MAX,
        TOK_LBRACE,
        TOK_RBRACE,
        TOK_LSPLICE,
        TOK_RSPLICE,
        TOK_BACKSLASH,
        TOK_SEMICOLON,
        TOK_ELLIPSIS,
        TOK_AUTO,
        TOK_BREAK,
        TOK_CASE,
        TOK_CHAR,
        TOK_CONST,
        TOK_CONTINUE,
        TOK_DEFAULT,
        TOK_DO,
        TOK_DOUBLE,
        TOK_ELSE,
        TOK_ENUM,
        TOK_EXTERN,
        TOK_FLOAT,
        TOK_FOR,
        TOK_GOTO,
        TOK_IF,
        TOK_INT,
        TOK_LONG,
        TOK_REGISTER,
        TOK_RETURN,
        TOK_SHORT,
        TOK_SIGNED,
        TOK_SIZEOF,
        TOK_STATIC,
        TOK_STRUCT,
        TOK_SWITCH,
        TOK_TYPEDEF,
        TOK_UNION,
        TOK_UNSIGNED,
        TOK_VOID,
        TOK_VOLATILE,
        TOK_WHILE,
        TOK_C99_GENERIC,
        TOK_C99_GENERICFX,
        TOK_EXT_ALIGNOF,
        TOK_INTADDR,
        TOK_VA_START,
        TOK_VA_ARG,
        TOK_VA_END,
        TOK_VA_COPY,
        TOK_BUILTIN_OFFSETOF,
        TOK_RESTRICT,
        TOK_GNU_RESTRICT,
        TOK_C99_BOOL,
        TOK_C99_COMPLEX,
        TOK_C99_IMAGINARY,
        TOK_IMAGINARY_UNIT,
        TOK_NAN,
        TOK_INFINITY,
        TOK_CHAR16_T,
        TOK_CHAR32_T,
        TOK_CHAR8_T,
        TOK_FRACT,
        TOK_ACCUM,
        TOK_SAT,
        TOK_DECLSPEC,
        TOK_ABSTRACT,
        TOK_SEALED,
        TOK_CDECL,
        TOK_FASTCALL,
        TOK_STDCALL,
        TOK_THISCALL,
        TOK_VECTORCALL,
        TOK_CLRCALL,
        TOK_MICROSOFT_INLINE,
        TOK_FORCEINLINE,
        TOK_UNALIGNED,
        TOK_MICROSOFT_TRY,
        TOK_FINALLY,
        TOK_LEAVE,
        TOK_EXCEPT,
        TOK_INT8,
        TOK_INT16,
        TOK_INT32,
        TOK_INT64,
        TOK_BASED,
        TOK_UUIDOF,
        TOK_ASSUME,
        TOK_CHARIZE,
        TOK_IF_EXISTS,
        TOK_IF_NOT_EXISTS,
        TOK_END_OF_IF_EXISTS,
        TOK_SUPER,
        TOK_NOOP,
        TOK_INTERFACE,
        TOK_EVENT,
        TOK_MICROSOFT_PTR32,
        TOK_MICROSOFT_PTR64,
        TOK_MICROSOFT_SPTR,
        TOK_MICROSOFT_UPTR,
        TOK_MICROSOFT_W64,
        TOK_MICROSOFT_LPREFIX,
        TOK_MICROSOFT_LPREFIX_1,
        TOK_MICROSOFT_UPREFIX,
        TOK_MICROSOFT_UPREFIX_1,
        TOK_MICROSOFT_IDENTIFIER,
        TOK_UUID,
        TOK_IN,
        TOK_GCNEW,
        TOK_SAFE_CAST,
        TOK_IMPLEMENTS,
        TOK_UNRESOLVED_TYPE,
        TOK_FOR_EACH,
        TOK_REF_CLASS,
        TOK_REF_STRUCT,
        TOK_VALUE_CLASS,
        TOK_VALUE_STRUCT,
        TOK_ENUM_CLASS,
        TOK_ENUM_STRUCT,
        TOK_INTERFACE_CLASS,
        TOK_INTERFACE_STRUCT,
        TOK_REF_NEW,
        TOK_PARTIAL_REF_CLASS,
        TOK_PARTIAL_REF_STRUCT,
        TOK_PREFIX_REF,
        TOK_PREFIX_VALUE,
        TOK_PREFIX_INTERFACE,
        TOK_PREFIX_FOR,
        TOK_PREFIX_ENUM,
        TOK_PREFIX_PARTIAL,
        TOK_MICROSOFT_ASM,
        TOK_FUNC_NAME,
        TOK_FUNCTION_NAME,
        TOK_PRETTY_FUNCTION_NAME,
        TOK_DECORATED_FUNCTION_NAME,
        TOK_NEAR,
        TOK_FAR,
        TOK_ATTRIBUTE,
        TOK_BUILTIN_TYPES_COMPATIBLE,
        TOK_GNU_REAL,
        TOK_GNU_IMAG,
        TOK_COLON_COLON,
        TOK_PERIOD_STAR,
        TOK_ARROW_STAR,
        TOK_ASM,
        TOK_CATCH,
        TOK_CLASS,
        TOK_DELETE,
        TOK_FRIEND,
        TOK_INLINE,
        TOK_NEW,
        TOK_OPERATOR,
        TOK_PRIVATE,
        TOK_PROTECTED,
        TOK_PUBLIC,
        TOK_TEMPLATE,
        TOK_THIS,
        TOK_THROW,
        TOK_TRY,
        TOK_VIRTUAL,
        TOK_WCHAR_T,
        TOK_CONST_CAST,
        TOK_DYNAMIC_CAST,
        TOK_EXPLICIT,
        TOK_CPP98_EXPORT,
        TOK_EXPORT,
        TOK_EXPORT_KEYWORD,
        TOK_IMPORT,
        TOK_MODULE,
        TOK_MUTABLE,
        TOK_NAMESPACE,
        TOK_REINTERPRET_CAST,
        TOK_STATIC_CAST,
        TOK_TYPEID,
        TOK_USING,
        TOK_BOOL,
        TOK_FALSE,
        TOK_TRUE,
        TOK_TYPENAME,
        TOK_STATIC_ASSERT,
        TOK_DECLTYPE,
        TOK_AUTO_TYPE,
        TOK_EXTENSION,
        TOK_NULL,
        TOK_TYPEOF,
        TOK_TYPEOF_UNQUAL,
        TOK_OVERLOAD,
        TOK_GLOBAL_LINK_SCOPE,
        TOK_SYMBOLIC_LINK_SCOPE,
        TOK_HIDDEN_LINK_SCOPE,
        TOK_THREAD,
        TOK_THREAD_LOCAL,
        TOK_C11_THREAD_LOCAL,
        TOK_HAS_ASSIGN,
        TOK_HAS_COPY,
        TOK_HAS_NOTHROW_ASSIGN,
        TOK_HAS_NOTHROW_CONSTRUCTOR,
        TOK_HAS_NOTHROW_COPY,
        TOK_HAS_TRIVIAL_ASSIGN,
        TOK_HAS_TRIVIAL_CONSTRUCTOR,
        TOK_HAS_TRIVIAL_COPY,
        TOK_HAS_TRIVIAL_DESTRUCTOR,
        TOK_HAS_USER_DESTRUCTOR,
        TOK_HAS_VIRTUAL_DESTRUCTOR,
        TOK_IS_ABSTRACT,
        TOK_IS_BASE_OF,
        TOK_IS_CLASS,
        TOK_IS_CONVERTIBLE_TO,
        TOK_IS_CONVERTIBLE,
        TOK_IS_NOTHROW_CONVERTIBLE,
        TOK_IS_EMPTY,
        TOK_IS_ENUM,
        TOK_IS_SCOPED_ENUM,
        TOK_IS_POD,
        TOK_IS_POLYMORPHIC,
        TOK_IS_UNION,
        TOK_IS_TRIVIAL,
        TOK_IS_STANDARD_LAYOUT,
        TOK_IS_TRIVIALLY_COPYABLE,
        TOK_IS_LITERAL_TYPE,
        TOK_HAS_TRIVIAL_MOVE_CONSTRUCTOR,
        TOK_HAS_TRIVIAL_MOVE_ASSIGN,
        TOK_HAS_NOTHROW_MOVE_ASSIGN,
        TOK_IS_CONSTRUCTIBLE,
        TOK_IS_NOTHROW_CONSTRUCTIBLE,
        TOK_IS_TRIVIALLY_CONSTRUCTIBLE,
        TOK_IS_DESTRUCTIBLE,
        TOK_IS_NOTHROW_DESTRUCTIBLE,
        TOK_IS_TRIVIALLY_DESTRUCTIBLE,
        TOK_IS_NOTHROW_ASSIGNABLE,
        TOK_IS_TRIVIALLY_ASSIGNABLE,
        TOK_IS_VALID_WINRT_TYPE,
        TOK_UNDERLYING_TYPE,
        TOK_HAS_FINALIZER,
        TOK_IS_DELEGATE,
        TOK_IS_INTERFACE_CLASS,
        TOK_IS_REF_ARRAY,
        TOK_IS_REF_CLASS,
        TOK_IS_SEALED,
        TOK_IS_SIMPLE_VALUE_CLASS,
        TOK_IS_VALUE_CLASS,
        TOK_IS_WIN_CLASS,
        TOK_IS_WIN_INTERFACE,
        TOK_NULLPTR,
        TOK_NATIVE_NULLPTR,
        TOK_INTERNAL_ALIAS_DECL,
        TOK_INT128,
        TOK_OVERRIDE,
        TOK_FINAL,
        TOK_IS_FINAL,
        TOK_NOEXCEPT,
        TOK_CONSTEXPR,
        TOK_CONSTEVAL,
        TOK_CONSTINIT,
        TOK_ALIGNOF,
        TOK_ALIGNAS,
        TOK_BASES,
        TOK_DIRECT_BASES,
        TOK_NORETURN,
        TOK_BUILTIN_COMPLEX,
        TOK_C11_GENERIC,
        TOK_C11_ATOMIC,
        TOK_NULLABLE,
        TOK_NONNULL,
        TOK_NULL_UNSPECIFIED,
        TOK_COROUTINE_YIELD,
        TOK_COROUTINE_RETURN,
        TOK_COROUTINE_AWAIT,
        TOK_IS_ASSIGNABLE,
        TOK_IS_TRIVIALLY_COPY_ASSIGNABLE,
        TOK_IS_ASSIGNABLE_NO_PRECONDITION_CHECK,
        TOK_BUILTIN_ADDRESSOF,
        TOK_EDG_INTERNAL_TYPE,
        TOK_EDG_VECTOR_TYPE,
        TOK_EDG_NEON_VECTOR_TYPE,
        TOK_EDG_NEON_POLYVECTOR_TYPE,
        TOK_EDG_SCALABLE_VECTOR_TYPE,
        TOK_EDG_SIZE_TYPE,
        TOK_EDG_PTRDIFF_TYPE,
        TOK_EDG_BOOL_TYPE,
        TOK_EDG_WCHAR_TYPE,
        TOK_EDG_THROW,
        TOK_EDG_INTERNAL_OPND,
        TOK_CLANG_VERSION,
        TOK_DATASIZEOF,
        TOK_HAS_UNIQUE_OBJECT_REPRESENTATIONS,
        TOK_IS_AGGREGATE,
        TOK_INTEGER_PACK,
        TOK_REFERENCE_BINDS_TO_TEMPORARY,
        TOK_REFERENCE_CONSTRUCTS_FROM_TEMPORARY,
        TOK_REFERENCE_CONVERTS_FROM_TEMPORARY,
        TOK_IS_SAME,
        TOK_IS_SAME_AS,
        TOK_IS_FUNCTION,
        TOK_REQUIRES,
        TOK_CONCEPT,
        TOK_BUILTIN_HAS_ATTRIBUTE,
        TOK_BUILTIN_BIT_CAST,
        TOK_IS_LAYOUT_COMPATIBLE,
        TOK_IS_POINTER_INTERCONVERTIBLE_BASE_OF,
        TOK_IS_POINTER_INTERCONVERTIBLE_WITH_CLASS,
        TOK_BUILTIN_IS_POINTER_INTERCONVERTIBLE_WITH_CLASS,
        TOK_IS_CORRESPONDING_MEMBER,
        TOK_BUILTIN_IS_CORRESPONDING_MEMBER,
        TOK_EDG_IS_DEDUCIBLE,
        TOK_IS_ARRAY,
        TOK_ARRAY_RANK,
        TOK_ARRAY_EXTENT,
        TOK_IS_ARITHMETIC,
        TOK_IS_COMPLETE_TYPE,
        TOK_IS_COMPOUND,
        TOK_IS_CONST,
        TOK_IS_FLOATING_POINT,
        TOK_IS_FUNDAMENTAL,
        TOK_IS_INTEGRAL,
        TOK_IS_LVALUE_REFERENCE,
        TOK_IS_MEMBER_FUNCTION_POINTER,
        TOK_IS_MEMBER_OBJECT_POINTER,
        TOK_IS_MEMBER_POINTER,
        TOK_IS_OBJECT,
        TOK_IS_POINTER,
        TOK_IS_REFERENCE,
        TOK_IS_RVALUE_REFERENCE,
        TOK_IS_SCALAR,
        TOK_IS_SIGNED,
        TOK_IS_UNSIGNED,
        TOK_IS_VOID,
        TOK_IS_VOLATILE,
        TOK_FLOAT32,
        TOK_FLOAT32X,
        TOK_FLOAT64,
        TOK_FLOAT64X,
        TOK_FLOAT128,
        TOK_IS_BOUNDED_ARRAY,
        TOK_IS_UNBOUNDED_ARRAY,
        TOK_IS_REFERENCEABLE,
        TOK_ADD_LVALUE_REFERENCE,
        TOK_ADD_POINTER,
        TOK_ADD_RVALUE_REFERENCE,
        TOK_DECAY,
        TOK_MAKE_SIGNED,
        TOK_MAKE_UNSIGNED,
        TOK_REMOVE_ALL_EXTENTS,
        TOK_REMOVE_CONST,
        TOK_REMOVE_CV,
        TOK_REMOVE_CVREF,
        TOK_REMOVE_EXTENT,
        TOK_REMOVE_POINTER,
        TOK_REMOVE_REFERENCE,
        TOK_REMOVE_REFERENCE_T,
        TOK_REMOVE_RESTRICT,
        TOK_REMOVE_VOLATILE,
        TOK_IS_TRIVIALLY_EQUALITY_COMPARABLE,
        TOK_NULLPTR_T,
        TOK_IS_TRIVIALLY_RELOCATABLE,
        TOK_LAST;


        public static TokenKind fromInt(int i) {
            return TokenKind.values()[i];
        }
    }

    public static class TokenSequence
    extends CObject {
        public TokenSequence(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTokenSequence(this);
        }

        public native TokenSequenceEntry tokens();
    }

    public static class TokenSequenceEntry
    extends CObject {
        public TokenSequenceEntry(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTokenSequenceEntry(this);
        }

        public native TokenSequenceEntry next();

        public native TokenKind tokenKind();

        public native SourcePosition position();

        public native String spelling();
    }

    public static class TransUnitCorresp
    extends CObject {
        public TransUnitCorresp(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTransUnitCorresp(this);
        }
    }

    public static class TrySupplement
    extends CObject {
        public TrySupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTrySupplement(this);
        }

        public native boolean isFunctionTryBlock();

        public native Statement statement();

        public native Handler handlers();

        public native Statement finallyStatement();

        public native ObjectLifetime lifetime();
    }

    public static class Type
    extends CObject {
        public Type(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitType(this);
        }

        @Override
        public native SourceCorrespondence sourceCorresp();

        public native Type next();

        public native BasedTypeListMember basedTypes();

        public native long size();

        public native int alignment();

        public native TypeKind kind();

        public native boolean incomplete();

        public native boolean usedInExceptionOrRtti();

        public native boolean declaredInFunctionPrototype();

        public native boolean isInstantiationDependent();

        public native boolean isInstantiationDependentCached();

        public native boolean hasBeenDefined();

        public native boolean typedefDefinitionHasBeenPutOut();

        public native boolean alignmentSetExplicitly();

        public native boolean variablesAreImplicitlyReferenced();

        public native boolean mayAlias();

        public native boolean hasMicrosoftW64Specifier();

        public native boolean isMicrosoftIntrinsic();

        public native boolean autonomousPrimaryTagDecl();

        public native boolean isBuiltinVaList();

        public native boolean isBuiltinVaListFromCstdarg();

        public native boolean vaListGuardMacroWasDefined();

        public native boolean hasGnuAbiTagAttribute();

        public native boolean inGnuAbiTagNamespace();

        public native boolean definitionPending();
    }

    public static class TypeArray
    extends Type {
        public TypeArray(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypeArray(this);
        }

        public native Type elementType();

        public native int qualifiers();

        public native boolean isTemplateDependentSizeArray();

        public native boolean isVariableSizeArray();

        public native boolean isVla();

        public native boolean constantBoundExprInLocalExprNodeRef();

        public native boolean depConstantBoundExprInLocalExprNodeRef();

        public native boolean hasAssocVlaDimension();

        public native boolean boundIsZero();

        public native boolean isStatic();

        public native Constant boundConstant();
    }

    public static class TypeArrayElementCountConstant
    extends TypeArray {
        public TypeArrayElementCountConstant(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypeArrayElementCountConstant(this);
        }

        public native Constant elementCountConstant();
    }

    public static class TypeArrayElementCountExpr
    extends TypeArray {
        public TypeArrayElementCountExpr(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypeArrayElementCountExpr(this);
        }

        public native ExprNode elementCountExpr();
    }

    public static class TypeArrayNumberOfElements
    extends TypeArray {
        public TypeArrayNumberOfElements(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypeArrayNumberOfElements(this);
        }

        public native long numberOfElements();
    }

    public static class TypeClassStructUnion
    extends Type {
        public TypeClassStructUnion(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypeClassStructUnion(this);
        }

        public native Field fieldList();

        public native ClassTypeSupplement extraInfo();

        public native boolean isInterface();

        public native boolean isInterfaceLike();

        public native boolean isDelegateClass();

        public native boolean isGenericDefinition();

        public native boolean isGenericInstance();

        public native boolean isOpenConstructedType();

        public native boolean isGenericConstraint();

        public native boolean isHybridConstraint();

        public native boolean anyInterfaceConstraints();

        public native boolean unconstrained();

        public native boolean sealed();

        public native boolean isFinal();

        public native boolean anyConstMember();

        public native boolean anyVolatileMember();

        public native boolean anyMutableMember();

        public native boolean anyVirtualBaseClasses();

        public native boolean isAbstract();

        public native boolean anyVirtualFunctions();

        public native boolean anyPureVirtualFunctions();

        public native boolean anyVirtualFunctionsIncludingInBaseClasses();

        public native boolean nestedClassDefinedOutsideOfParent();

        public native boolean originallyUnnamed();

        public native boolean isNonstdAnonymousUnionType();

        public native boolean isTemplateClass();

        public native boolean isNonrealClass();

        public native boolean isMsInstantiatedNonrealClass();

        public native boolean isPrototypeInstantiation();

        public native boolean isSpecialized();

        public native boolean specializedWithOldSyntax();

        public native boolean isInClassSpecialization();

        public native boolean explicitlyInstantiated();

        public native boolean doNotInstantiate();

        public native boolean proxyClass();

        public native boolean isEmptyClass();

        public native boolean noProperData();

        public native boolean hasZeroInitComponent();

        public native boolean containsFlexibleArrayMember();

        public native boolean isTransparent();

        public native boolean isPacked();

        public native boolean hasInternalLinkageAttribute();

        public native boolean hasOperatorAmpersand();

        public native boolean virtualFunctionsMarkedAsRequired();

        public native boolean copyAssignmentDeclSuppressed();

        public native boolean copyCtorDeclSuppressed();

        public native boolean defaultCtorDeclSuppressed();

        public native boolean dtorDeclSuppressed();

        public native boolean incClassUsedInArrayType();

        public native int maxMemberAlignment();
    }

    public static class TypeFloatKind
    extends Type {
        public TypeFloatKind(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypeFloatKind(this);
        }

        public native FloatKind floatKind();
    }

    public static class TypeInteger
    extends Type {
        public TypeInteger(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypeInteger(this);
        }

        public native IntegerKind intKind();

        public native boolean explicitlySigned();

        public native boolean microsoftSizedIntType();

        public native boolean hasExplicitEnumBase();

        public native boolean enumType();

        public native boolean isScopedEnum();

        public native boolean packed();

        public native boolean wcharTType();

        public native boolean char8TType();

        public native boolean char16TType();

        public native boolean char32TType();

        public native boolean boolType();

        public native boolean originallyUnnamed();

        public native boolean isTemplateEnum();

        public native boolean isPrototypeInstantiation();

        public native boolean isNonreal();

        public native boolean isSpecialized();

        public native boolean isMsInstantiatedNonrealEnum();

        public native Constant enumInfo_constantList();

        public native Scope enumInfo_assocScope();

        public native Type enumInfo_affiliatedType();

        public native IntegerTypeSupplement extraInfo();
    }

    public static enum TypeKind {
        TK_ERROR,
        TK_VOID,
        TK_INTEGER,
        TK_FLOAT,
        TK_IMAGINARY,
        TK_COMPLEX,
        TK_POINTER,
        TK_ROUTINE,
        TK_ARRAY,
        TK_CLASS,
        TK_STRUCT,
        TK_UNION,
        TK_TYPEREF,
        TK_PTR_TO_MEMBER,
        TK_TEMPLATE_PARAM,
        TK_NULLPTR,
        TK_REFLECTION,
        TK_UNKNOWN;


        public static TypeKind fromInt(int i) {
            return TypeKind.values()[i];
        }
    }

    public static class TypePointer
    extends Type {
        public TypePointer(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypePointer(this);
        }

        public native Type type();

        public native Variable baseVariable();

        public native boolean isReference();

        public native boolean isRvalueReference();

        public native boolean isHandle();

        public native boolean isInteriorPtr();

        public native boolean isPinPtr();

        public native byte modifiers();
    }

    public static class TypePtrToMember
    extends Type {
        public TypePtrToMember(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypePtrToMember(this);
        }

        public native Type classOfWhichAMember();

        public native Type type();

        public native byte modifiers();
    }

    public static class TypeRoutine
    extends Type {
        public TypeRoutine(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypeRoutine(this);
        }

        public native Type returnType();

        public native RoutineTypeSupplement extraInfo();
    }

    public static class TypeTemplateParam
    extends Type {
        public TypeTemplateParam(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypeTemplateParam(this);
        }

        public native TemplateParamTypeKind templateParamKind();

        public native boolean isPack();

        public native boolean isGenericParam();

        public native boolean beingChecked();

        public native boolean isGenericFunctionParam();

        public native boolean isAutoParam();

        public native boolean isDecltypeAuto();

        public native boolean originallyClassTemplateParam();

        public native TemplateParamTypeSupplement extraInfo();
    }

    public static class TypeTyperef
    extends Type {
        public TypeTyperef(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTypeTyperef(this);
        }

        public native Type type();

        public native TyperefTypeSupplement extraInfo();

        public native TyperefKind typerefKind();

        public native int qualifiers();

        public native boolean predeclared();

        public native boolean explicitMemoryAttributeMadeImplicit();

        public native boolean hasVariablyModifiedType();

        public native boolean decltypeExprNotParenthesized();

        public native boolean isDependentTypeOperator();

        public native boolean isNonreal();

        public native boolean isDependent();

        public native boolean isPrototypeInstantiation();

        public native boolean embeddedSourceSequenceEntries();

        public native boolean addedToRecordName();

        public native boolean hasTypenamePrefix();
    }

    public static enum TyperefKind {
        TRK_NONE,
        TRK_IS_DECLTYPE,
        TRK_IS_DEDUCED_DECLTYPE_AUTO,
        TRK_IS_DEDUCED_AUTO,
        TRK_IS_DEDUCED_CLASS,
        TRK_IS_UNDERLYING_TYPE,
        TRK_IS_TYPEOF_WITH_EXPRESSION,
        TRK_IS_TYPEOF_WITH_TYPE_OPERAND,
        TRK_FOR_TYPE_ATTRIBUTES,
        TRK_IS_ALIAS,
        TRK_IS_TEMPLATE_ALIAS,
        TRK_IS_SPLICE,
        TRK_BASES,
        TRK_DIRECT_BASES,
        TRK_ADD_LVALUE_REFERENCE,
        TRK_ADD_POINTER,
        TRK_ADD_RVALUE_REFERENCE,
        TRK_DECAY,
        TRK_MAKE_SIGNED,
        TRK_MAKE_UNSIGNED,
        TRK_REMOVE_ALL_EXTENTS,
        TRK_REMOVE_CONST,
        TRK_REMOVE_CV,
        TRK_REMOVE_CVREF,
        TRK_REMOVE_EXTENT,
        TRK_REMOVE_POINTER,
        TRK_REMOVE_REFERENCE_T,
        TRK_REMOVE_RESTRICT,
        TRK_REMOVE_VOLATILE,
        TRK_REMOVE_REFERENCE;


        public static TyperefKind fromInt(int i) {
            return TyperefKind.values()[i];
        }
    }

    public static class TyperefTypeSupplement
    extends CObject {
        public TyperefTypeSupplement(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitTyperefTypeSupplement(this);
        }

        public native TemplateArg templateArgList();

        public native TemplateArg origTemplateArgList();

        public native Template assocTemplate();

        public native ExprNode expr();

        public native Type proxyClass();

        public native Type operatorTypeArg();

        public native int minTemplateArguments();

        public native SourceRange typeIdRange();
    }

    public static class UsingDecl
    extends CObject {
        public UsingDecl(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitUsingDecl(this);
        }

        public native UsingDecl next();

        public native SourcePosition position();

        public native Attribute attributes();

        public native boolean isUsingDirective();

        public native boolean isClassMember();

        public native boolean isInheritingCtor();

        public native boolean hidden();

        public native boolean compilerGenerated();

        public native boolean inlineNamespace();

        public native boolean strong();

        public native boolean isPackExpansion();

        public native boolean isRepresentative();

        public native boolean isUsingEnum();

        public native boolean isEnumerator();

        public native AccessSpecifier access();

        public native long declSequenceNumber();

        public native SourceSequenceEntry sourceSequenceEntry();

        public native UsingDecl nextInSet();

        public native Type qualifier_classType();

        public native Namespace qualifier_namespacePtr();

        public native CObject entity();
    }

    public static class Variable
    extends CObject {
        public Variable(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitVariable(this);
        }

        @Override
        public native SourceCorrespondence sourceCorresp();

        public native Variable next();

        public native Type type();

        public native StorageClass storageClass();

        public native StorageClass declaredStorageClass();

        public native long declModifiers();

        public native String asmNameOrReg_name();

        public native NamedRegister asmNameOrReg_reg();

        public native int alignment();

        public native Routine cleanupRoutine();

        public native boolean isWeak();

        public native boolean isWeakref();

        public native boolean isGnuAlias();

        public native boolean hasGnuUsedAttribute();

        public native boolean hasGnuAbiTagAttribute();

        public native boolean isNotCommon();

        public native boolean isCommon();

        public native boolean hasInternalLinkageAttribute();

        public native boolean asmNameIsValid();

        public native boolean used();

        public native boolean addressTaken();

        public native boolean isParameter();

        public native boolean isStructBinding();

        public native boolean isStructBindingContainer();

        public native boolean referencedNonLocally();

        public native boolean modifiedWithinTryBlock();

        public native boolean isTemplateVariable();

        public native boolean isPrototypeInstantiation();

        public native boolean isNonreal();

        public native boolean isSpecialized();

        public native boolean specializedWithOldSyntax();

        public native boolean explicitInstantiation();

        public native boolean classExplicitlyInstantiated();

        public native boolean explicitDoNotInstantiate();

        public native boolean paramValueHasBeenChanged();

        public native boolean paramUsedMoreThanOnce();

        public native boolean isHandlerParam();

        public native boolean isThisParameter();

        public native boolean isAnonymousParentObject();

        public native boolean isMemberConstant();

        public native boolean isConstexpr();

        public native boolean declaredConstinit();

        public native boolean isInline();

        public native boolean onInlineVariableList();

        public native boolean suppressInlineDefinition();

        public native boolean inlineInstanceRequired();

        public native boolean supersededExternal();

        public native boolean hasVariablyModifiedType();

        public native boolean isVla();

        public native boolean isCompoundLiteral();

        public native boolean hasExplicitInitializer();

        public native boolean hasParenthesizedInitializer();

        public native boolean hasDirectBracedInitializer();

        public native boolean hasFlexibleArrayInitializer();

        public native boolean declaredWithAutoTypeSpecifier();

        public native boolean declaredWithDecltypeAuto();

        public native boolean declaredWithClassTemplatePlaceholder();

        public native boolean embeddedSourceSequenceEntries();

        public native boolean declaredUsingTypeWithoutLinkage();

        public native boolean isParameterPack();

        public native boolean isPackElement();

        public native boolean isInitonly();

        public native boolean isEnhancedForIterator();

        public native boolean initializerInClass();

        public native boolean constantValued();

        public native boolean isImmutable();

        public native boolean isThreadLocal();

        public native boolean extendsLifetime();

        public native boolean isTemplateParamObject();

        public native boolean compilerGenerated();

        public native boolean isInClassSpecialization();

        public native InitKind initKind();

        public native SourceRange initializerRange();

        public native IlEntityListEntry entitiesDefinedInInitializer();

        public native PropertyOrEventDescr propertyOrEventDescr();

        public native VariableTemplateInfo templateInfo();

        public native String section();

        public native Variable aliasedVariable();

        public native Type declaredType();

        public native Constant initializer_constant();

        public native DynamicInit initializer_dynamic();

        public native ExprNode initializer_boundExpr();
    }

    public static class VariableAssocParamType
    extends Variable {
        public VariableAssocParamType(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitVariableAssocParamType(this);
        }

        public native ParamType assocParamType();
    }

    public static class VariableBindings
    extends Variable {
        public VariableBindings(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitVariableBindings(this);
        }

        public native IlEntityListEntry bindings();
    }

    public static class VariableContainer
    extends Variable {
        public VariableContainer(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitVariableContainer(this);
        }

        public native Variable container();
    }

    public static class VariableTemplateInfo
    extends CObject {
        public VariableTemplateInfo(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitVariableTemplateInfo(this);
        }

        public native TemplateArg templateArgList();

        public native TemplateArg partialSpecTemplateArgList();

        public native Template assocTemplate();
    }

    public static class VlaDimension
    extends CObject {
        public VlaDimension(long ptr) {
            super(ptr);
        }

        @Override
        public void accept(EDGVisitor visitor) {
            visitor.visitVlaDimension(this);
        }

        public native VlaDimension next();

        public native Type type();

        public native ExprNode dimensionExpr();

        public native VlaDimension originalDimension();

        public native boolean inPrototypeScope();

        public native SourcePosition position();
    }
}

