/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import java.util.function.Supplier;

final class PrepareRefreshWorkspaceFilter
extends Filter
implements IWorkspaceFilter {
    private final boolean m_isEnabled;

    PrepareRefreshWorkspaceFilter(boolean enabled) {
        super(null);
        this.m_isEnabled = enabled;
    }

    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public String getPresentationKind() {
        return "File Filter";
    }

    public String getImageResourceName() {
        return "FileFilter";
    }

    public final String getShortName() {
        return "File Filter";
    }

    public boolean invalidatesParserModel() {
        return this.m_isEnabled;
    }

    public String getDescription() {
        return "Exclude files (matches against the 'Identifying Path' property)";
    }

    public final void initialize() {
        if (this.m_isEnabled) {
            super.initialize();
        }
    }

    public final void clear() {
        if (this.m_isEnabled) {
            super.clear();
        }
    }

    public boolean includeFile(Supplier<String> supplier) {
        assert (supplier != null) : "Parameter 'supplier' of method 'add' must not be null";
        if (this.m_isEnabled && this.hasPatterns()) {
            String relPath = supplier.get();
            assert (relPath != null && relPath.length() > 0) : "'relPath' of method 'add' must not be empty";
            return super.include(relPath);
        }
        return true;
    }

    public String getInformation() {
        if (!this.m_isEnabled) {
            return "Disabled";
        }
        return "";
    }
}

