/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.foundation.file.DirectoryMapping;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileBean;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class DirectoryBeanHelper {
    DirectoryBeanHelper() {
    }

    static DirectoryBean getDirectoryBean(Map<TFile, DirectoryBean> directories, TFile dir) {
        assert (dir != null) : "Parameter 'dir' of 'getDirectoryBean' must not be null";
        DirectoryBean result = directories.get(dir);
        if (result == null) {
            DirectoryBean parent = DirectoryBeanHelper.getDirectoryBean(directories, dir.getParentFile());
            result = new DirectoryBean(parent, dir);
            directories.put(dir, result);
        }
        return result;
    }

    static List<DirectoryBean> createRoots(Collection<TFile> fileList, Map<TFile, List<String>> optMap) {
        assert (fileList != null && !fileList.isEmpty()) : "Parameter 'fileList' of method 'createRoots' must not be null or empty";
        HashMap<TFile, DirectoryBean> directories = new HashMap<TFile, DirectoryBean>();
        ArrayList<DirectoryBean> roots = new ArrayList<DirectoryBean>();
        for (DirectoryMapping it : FileUtility.findRootDirectories(fileList)) {
            TFile root = it.getDirectory();
            DirectoryBean rootBean = new DirectoryBean(null, root);
            directories.put(root, rootBean);
            roots.add(rootBean);
            for (TFile file : it.getFiles()) {
                List<String> options;
                List<String> list = options = optMap == null ? Collections.emptyList() : optMap.get(file);
                assert (options != null);
                SourceFileBean bean = new SourceFileBean(file, options);
                DirectoryBean dir = DirectoryBeanHelper.getDirectoryBean(directories, file.getParentFile());
                dir.addFile(bean);
            }
        }
        return roots;
    }
}

