/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SignatureElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettingsSignature;
import com.hello2morrow.sonargraph.core.model.system.settings.RootDirectorySettings;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusInstallationSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ExcludedDirectoryNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class CppExtension
extends Extension {
    protected static InstCompilerDefinition getActiveCompilerDefinition(Installation installation) {
        assert (installation != null) : "Parameter 'installation' of method 'getActiveCompilerDefinition' must not be null";
        CPlusPlusInstallationSettings instSettings = (CPlusPlusInstallationSettings)((Object)installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        assert (instSettings != null) : "C++ installation settings must not be null";
        return instSettings.getActiveCompilerDefinition();
    }

    public static SignatureElement createSimpleSignatureElement(Installation installation, CPlusPlusModule module) {
        InstCompilerDefinition activeCompilerDefinition = CppExtension.getActiveCompilerDefinition(installation);
        StringBuilder sb = new StringBuilder();
        ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        if (activeCompilerDefinition != null) {
            sb.append(activeCompilerDefinition.getName());
        } else {
            sb.append("No active compiler definition");
        }
        return new ModuleSettingsSignature((NamedElement)moduleSettings, HashSupport.SHA.getHexString(sb.toString()));
    }

    protected void createSourceFileNodes(CPlusPlusSystemSettings systemSettings, RootDirectorySettings settings, Map<List<String>, CompilerOptions> optionMap, DirectoryBean rootDirBean) {
        for (SourceFileBean sourceBean : rootDirBean.getAllSourceFiles()) {
            List<String> options = sourceBean.getOptions();
            CompilerOptions co = optionMap.get(options);
            if (co == null) {
                co = new CompilerOptions((NamedElement)systemSettings, "Options");
                systemSettings.addChild((NamedElement)co);
                for (String opt : options) {
                    co.addOption(opt);
                }
                optionMap.put(options, co);
            }
            String relativePath = FileUtility.calculateRelativePath((TFile)sourceBean.getFile(), (TFile)rootDirBean.getDirectory());
            SourceFileNode sn = new SourceFileNode((NamedElement)settings, relativePath, co);
            settings.addChild((NamedElement)sn);
        }
    }

    protected List<DirectoryBean> prepareToAddModules(List<DirectoryBean> dirs, SoftwareSystem system) {
        ArrayList<DirectoryBean> toBeRemoved = new ArrayList<DirectoryBean>();
        for (CPlusPlusModule module : ((Workspace)system.getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusModule.class)) {
            block1: for (CppRootDirectoryPath root : module.getChildren(CppRootDirectoryPath.class)) {
                RootDirectorySettings rootDirSettings = (RootDirectorySettings)root.getFirstChild(RootDirectorySettings.class);
                List<String> excludedDirs = rootDirSettings == null ? Collections.emptyList() : rootDirSettings.getChildren(ExcludedDirectoryNode.class).stream().map(n -> n.getShortName()).collect(Collectors.toList());
                for (DirectoryBean beanRoot : dirs) {
                    DirectoryBean rootBean = beanRoot.markAndLockRoot(root.getFile(), excludedDirs);
                    if (rootBean == null) continue;
                    if (rootBean == beanRoot) {
                        toBeRemoved.add(rootBean);
                        continue block1;
                    }
                    rootBean.remove();
                    continue block1;
                }
            }
        }
        if (!toBeRemoved.isEmpty()) {
            dirs = new ArrayList<DirectoryBean>(dirs);
            dirs.removeAll(toBeRemoved);
        }
        return dirs;
    }

    static void moveRootSettings(CPlusPlusModule sourceModule, CPlusPlusModule targetModule) {
        assert (sourceModule != null) : "Parameter 'sourceModule' of method 'moveRootSettings' must not be null";
        assert (targetModule != null) : "Parameter 'targetModule' of method 'moveRootSettings' must not be null";
        for (CppRootDirectoryPath root : sourceModule.getChildren(CppRootDirectoryPath.class)) {
            RootDirectorySettings rootSettings = (RootDirectorySettings)root.getUniqueChild(RootDirectorySettings.class);
            if (rootSettings == null) continue;
            RootDirectoryPath targetRootPath = (RootDirectoryPath)targetModule.getFirstChild(c -> c.getName().equals(root.getName()), CppRootDirectoryPath.class);
            assert (targetRootPath != null) : "'targetRootPath' of method 'moveRootSettings' must not be null";
            RootDirectorySettings targetRootSettings = (RootDirectorySettings)targetRootPath.getUniqueChild(RootDirectorySettings.class);
            if (targetRootSettings != null) {
                targetRootSettings.remove();
            }
            rootSettings.changeParent((NamedElement)targetRootPath, true);
        }
    }
}

