/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ICompilationUnitContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDGVisitor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppSourceFileElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SourceFileProcessor
extends ElementProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceFileProcessor.class);
    private EDG.IlHeader m_IlHeader;
    private final CppSourceFileElement m_SourceFile;
    private final Map<EDG.SourceFile, CppSourceFileElement> m_FileMap = new HashMap<EDG.SourceFile, CppSourceFileElement>();
    private final Deque<String> m_parentFileStack = new ArrayDeque<String>();
    private final Set<String> m_symLinkedHeaders = new THashSet();

    SourceFileProcessor(ICompilationUnitContext context, CppSourceFileElement sourceFile) {
        super(context);
        this.m_SourceFile = sourceFile;
    }

    @Override
    public EDG.CObject getEDGObject() {
        return this.m_IlHeader;
    }

    EDGVisitor getVisitor() {
        return new HeaderVisitor();
    }

    private void addIncludes(CppSourceFileElement src, EDG.SourceFile sourceFile, String resolvedName) {
        assert (src != null) : "Parameter 'src' of method 'addIncludes' must not be null";
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'addIncludes' must not be null";
        assert (resolvedName != null) : "Parameter 'resolvedName' of method 'addIncludes' must not be null";
        this.m_FileMap.put(sourceFile, src);
        this.m_parentFileStack.push(resolvedName);
        EDG.SourceFile sf = sourceFile.firstChildFile();
        while (sf != null) {
            if (sf.isIncludeFile() && this.m_FileMap.get(sf) == null) {
                String fileName = sf.fullName();
                if (fileName == null) {
                    this.addIncludes(src, sf, resolvedName);
                } else {
                    File file = new File(fileName.trim());
                    if (!file.isAbsolute()) {
                        String parentName = this.m_parentFileStack.peek();
                        TFile parentFile = new TFile(parentName).getParentFile();
                        file = new TFile((File)parentFile, fileName);
                    }
                    if (file.canRead()) {
                        TFile normalizedFile;
                        boolean isSymLink;
                        boolean isExternal = this.getContext().isExternal(file);
                        boolean bl = isSymLink = isExternal ? false : Files.isSymbolicLink(file.toPath());
                        if (isSymLink) {
                            try {
                                normalizedFile = new TFile(file.getCanonicalFile());
                                if (!this.m_symLinkedHeaders.add(normalizedFile.getPath())) {
                                    LOGGER.error("Symlinked header included via symlink and original path: " + file.getPath() + " -> " + normalizedFile.getPath());
                                }
                            }
                            catch (IOException e) {
                                LOGGER.error("Cannot reolve canonical path for " + file.getPath(), (Throwable)e);
                                normalizedFile = new TFile(file).getNormalizedAbsoluteFile();
                            }
                        } else {
                            normalizedFile = new TFile(file).getNormalizedAbsoluteFile();
                        }
                        LOGGER.info("Creating header for " + normalizedFile.getPath());
                        CppSourceFileElement header = this.getContext().addHeader(normalizedFile, isExternal);
                        src.addDependency(header, CppDependencyType.INCLUDES, EDG.getPositionFromSequenceNumber(sf.firstSeqNumber() - 1L, 1).getLineNumber());
                        this.addIncludes(header, sf, normalizedFile.getPath());
                    } else {
                        this.addIncludes(src, sf, new TFile(file).getNormalizedAbsolutePath());
                    }
                }
            }
            sf = sf.next();
        }
        this.m_parentFileStack.pop();
    }

    /*
     * Unable to fully structure code
     */
    private void handleMacros() {
        macro = this.m_IlHeader.macros();
        while (macro != null) {
            if (!macro.isCommandLineDefinition() && !macro.isPredefined()) {
                sc = macro.sourceCorresp();
                name = sc.name();
                sp = sc.declPosition();
                pos = sp.getPosition();
                if (!SourceFileProcessor.$assertionsDisabled && sp.seq() == 0L) {
                    throw new AssertionError();
                }
                macroParent = this.getParentFor(pos);
                if (!SourceFileProcessor.$assertionsDisabled && macroParent == null) {
                    throw new AssertionError();
                }
                if (!macro.isUndef()) {
                    macroElement = new CppProgrammingElement(macroParent, CppElementType.MACRO, name, pos.getLineNumber());
                    macroParent.addChild(macroElement);
                    this.getContext().mapElement(macro, macroElement);
                }
            }
            macro = macro.next();
        }
        invocationCount = this.m_IlHeader.numMacroInvocationRecords();
        rootBlock = this.m_IlHeader.rootMacroInvocationRecordBlock();
        records = new EDG.MacroInvocationRecord[invocationCount];
        invocations = new HashSet<CallSite>();
        i = 0;
        while (i < invocationCount) {
            records[i] = rootBlock.record(i);
            ++i;
        }
        i = 0;
        while (i < invocationCount) {
            block9: {
                invocation = records[i];
                macro = invocation.assocMacro();
                if (macro == null || macro.isPredefined() || macro.isCommandLineDefinition()) break block9;
                element = this.getContext().getElement(macro);
                if (SourceFileProcessor.$assertionsDisabled || element != null) ** GOTO lbl37
                throw new AssertionError();
lbl-1000:
                // 1 sources

                {
                    invocation = records[parentIndex];
lbl37:
                    // 2 sources

                    ** while ((parentIndex = invocation.parentMacroIndex()) > 0)
                }
lbl38:
                // 1 sources

                sp = invocation.start();
                if (sp.seq() != 0L && !(parent = this.getParentFor(pos = EDG.getPositionFromSequenceNumber(sp.seq(), sp.column()))).isExternal() && invocations.add((CallSite)(key = parent.getName() + ":" + element.getName() + ":" + pos.getLineNumber()))) {
                    parent.addDependency(element, CppDependencyType.MACRO_INVOCATION, pos.getLineNumber());
                }
            }
            ++i;
        }
    }

    @Override
    public boolean initElement() {
        EDG.SourceFile sf = this.m_IlHeader.primarySourceFile();
        this.addIncludes(this.m_SourceFile, sf, sf.fullName());
        this.processScope(this.m_IlHeader.primaryScope());
        this.handleMacros();
        this.getContext().parsingFinished();
        return false;
    }

    @Override
    public void processElement() {
    }

    @Override
    public CppSourceFileElement getParentFor(EDG.Position pos) {
        if (pos.getFile() == null) {
            return null;
        }
        CppSourceFileElement fileElement = this.m_FileMap.get(pos.getFile());
        assert (fileElement != null) : "missing file map entry: " + pos.getFile().fileName();
        return fileElement;
    }

    @Override
    public CppElement getElement() {
        return this.m_SourceFile;
    }

    private class HeaderVisitor
    extends EDGVisitor {
        private HeaderVisitor() {
        }

        @Override
        public void visitIlHeader(EDG.IlHeader obj) {
            long time = System.currentTimeMillis();
            SourceFileProcessor.this.m_IlHeader = obj;
            SourceFileProcessor.this.getContext().initSecondaryPositionCache(SourceFileProcessor.this.m_IlHeader.primaryScope().sourceSequenceList());
            SourceFileProcessor.this.initElement();
            time = System.currentTimeMillis() - time;
            LOGGER.info("Backend time: " + time + "ms");
        }
    }
}

