/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISnapshotController;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.ComponentAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.system.IComponentAssignmentExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppWeakRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppComponent;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ComponentAssignmentExtension
extends Extension
implements IComponentAssignmentExtension,
ISoftwareSystemLifecycleListener {
    private final SoftwareSystem m_softwareSystem;
    private final IFinishModelProcessor m_finishModelProcessor;

    public ComponentAssignmentExtension(SoftwareSystem system, IFinishModelProcessor finishModelProcessor) {
        assert (system != null) : "Parameter 'system' of method 'ComponentAssignmentExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'ComponentAssignmentExtension' must not be null";
        this.m_softwareSystem = system;
        this.m_finishModelProcessor = finishModelProcessor;
    }

    public void finishRestore(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToRestore' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToRestore' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishRestore' must not be null";
        if (softwareSystem.getUsedLanguages().contains((Object)CPlusPlusLanguage.INSTANCE)) {
            ComponentAnalyzer.recreateComponents(softwareSystem);
        }
    }

    private void assignToModule(OperationResult result, CppComponent component, CPlusPlusModule module) {
        assert (result != null) : "Parameter 'result' of method 'assignToModule' must not be null";
        assert (component != null) : "Parameter 'component' of method 'assignToModule' must not be null";
        assert (module != null && !module.isAutomatic());
        CPlusPlusModule oldModule = (CPlusPlusModule)((Object)component.getParent(CPlusPlusModule.class, new Class[0]));
        if (oldModule == module) {
            return;
        }
        CppHeaderFile header = (CppHeaderFile)((Object)component.getFirstChild(CppHeaderFile.class));
        assert (header != null);
        TFile file = header.getFile();
        RootDirectoryPath root = module.getChildren(RootDirectoryPath.class).stream().filter(r -> r.getFile().isParentOf((File)file)).findFirst().orElse(null);
        if (root == null) {
            root = new CppWeakRootDirectoryPath((IModelServiceProvider)this.m_softwareSystem, (NamedElement)module, file.getParentFile());
            module.addChild((NamedElement)root);
            root.rebase();
        }
        String relPath = FileUtility.calculateRelativePath((TFile)file.getParentFile(), (TFile)root.getDirectoryFile());
        IDirectoryPath directoryPath = DirectoryFragment.getDirectoryFragmentOrSpecifiedParent((IModelServiceProvider)this.m_softwareSystem, (IDirectoryPath)root, (String)relPath, (DirectoryFragment.IDirectoryFragmentCreator)new DirectoryFragment.IDirectoryFragmentCreator(){

            public DirectoryFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                return new CppDirectoryFragment(msp, parent, name);
            }
        });
        component.changeParent(directoryPath.getNamedElement(), true);
        module.assignAssociatedHeader(file);
        oldModule.removeAssociatedHeader(file);
        this.m_softwareSystem.setNeedsSave(true);
        header.rebase();
    }

    @Override
    public OperationResult assignComponentsToModule(IWorkerContext workerContext, List<CppComponent> components, CPlusPlusModule module) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'assignComponentsToModule' must not be null";
        assert (components != null && components.size() > 0) : "Parameter 'components' of method 'assignComponentsToModule' must not be empty";
        assert (module != null && !module.isAutomatic());
        assert (!this.areAssignableComponents(components).isEmpty()) : "Not assignable: " + String.valueOf(components);
        ISnapshotController snapshotExt = (ISnapshotController)this.m_softwareSystem.getExtension(ISnapshotController.class);
        IAnalyzerExecutionController analyzerExt = (IAnalyzerExecutionController)this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class);
        OperationResult result = new OperationResult("Assigning components to module");
        ArrayList<CppComponent> sortedComponents = new ArrayList<CppComponent>(components);
        snapshotExt.cancelSaveSnapshot();
        analyzerExt.cancelAndResetAllAnalyzers(ResetMode.ALL);
        Collections.sort(sortedComponents, (c1, c2) -> ((CppHeaderFile)((Object)((Object)c1.getFirstChild(CppHeaderFile.class)))).getFile().getParentFile().getPath().length() - ((CppHeaderFile)((Object)((Object)c2.getFirstChild(CppHeaderFile.class)))).getFile().getParentFile().getPath().length());
        sortedComponents.forEach(c -> this.assignToModule(result, (CppComponent)c, module));
        this.m_finishModelProcessor.finishParserModelModification(workerContext, this.m_softwareSystem, result);
        snapshotExt.saveSnapshot();
        analyzerExt.runAutomatedAnalyzers(workerContext);
        return result;
    }

    @Override
    public List<CPlusPlusModule> getValidTargetModules() {
        return ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusModule.class).stream().filter(m -> !m.isAutomatic()).collect(Collectors.toList());
    }

    private List<CppComponent> areAssignableComponents(List<CppComponent> cppComponents) {
        assert (cppComponents != null) : "Parameter 'cppComponents' of method 'areAssignableComponents' must not be null";
        for (CppComponent nextCppComponent : cppComponents) {
            if (nextCppComponent.isUnbound()) continue;
            return Collections.emptyList();
        }
        return cppComponents;
    }

    @Override
    public List<CppComponent> getAssignableComponents(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getAssignableComponents' must not be null";
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CppComponent> cppComponents = new ArrayList<CppComponent>(elements.size());
        for (Element nextElement : elements) {
            if (nextElement instanceof CppComponent) {
                cppComponents.add((CppComponent)nextElement);
                continue;
            }
            return Collections.emptyList();
        }
        return this.areAssignableComponents(cppComponents);
    }
}

