/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.file.SectionedData;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusResourceProviderAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GroovyTemplateElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GroovyTemplatePropertyList;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionFromBundle;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionFromFile;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstCompilerDefinitionBuilder {
    public static final String IDENTIFIER_FOR_NEW_DEFINITION = "IDENTIFIER_FOR_NEW_COMPILER_DEFINITION";
    private static final Logger LOGGER = LoggerFactory.getLogger(InstCompilerDefinitionBuilder.class);
    private static final String PROPERTY_SEPARATOR = "=";
    private static final String DESCRIPTION_KEY = "Description";
    private static final String LONGSIZE_KEY = "LongSize";
    private static final String POINTERSIZE_KEY = "PointerSize";
    private static final String WCHAR_SIZE_KEY = "WideCharSize";
    private final InstCompilerDefinition m_definition;

    public InstCompilerDefinitionBuilder(InstCompilerDefinition definition) {
        this.m_definition = definition;
    }

    public static InstCompilerDefinition createNew(NamedElement parent) {
        InstCompilerDefinitionFromFile definition = new InstCompilerDefinitionFromFile(parent, IDENTIFIER_FOR_NEW_DEFINITION);
        return definition;
    }

    public void processHeader(String headerText, OperationResult result) {
        assert (headerText != null) : "Parameter 'headerText' of method 'processHeader' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processHeader' must not be null";
        GroovyTemplatePropertyList header = new GroovyTemplatePropertyList((NamedElement)this.m_definition, "Header", headerText.trim(), PROPERTY_SEPARATOR);
        String description = header.getStringProperty(DESCRIPTION_KEY);
        this.m_definition.setDescription(description != null ? description : "");
        int pointerSize = header.getIntProperty(POINTERSIZE_KEY, -1);
        if (pointerSize != 4 && pointerSize != 8) {
            result.addError((OperationResult.IMessageCause)CppCauses.INSTALLATION_COMPILER_DEFINITION_HAS_ERRORS, "Missing or invalid mandatory property '%s' in section [%s]", new Object[]{POINTERSIZE_KEY, "Header"});
            return;
        }
        this.m_definition.setPointerSize(pointerSize);
        int longSize = header.getIntProperty(LONGSIZE_KEY, -1);
        if (longSize != 4 && longSize != 8) {
            result.addError((OperationResult.IMessageCause)CppCauses.INSTALLATION_COMPILER_DEFINITION_HAS_ERRORS, "Missing or invalid mandatory property '%s' in section [%s]", new Object[]{LONGSIZE_KEY, "Header"});
            return;
        }
        this.m_definition.setLongSize(longSize);
        if (description != null && description.contains("Microsoft")) {
            this.m_definition.setWideCharSize(header.getIntProperty(WCHAR_SIZE_KEY, 2));
        } else {
            this.m_definition.setWideCharSize(header.getIntProperty(WCHAR_SIZE_KEY, 4));
        }
        this.m_definition.addChild(header);
    }

    public void processOptions(String cSectionText, String cppSectionText, String commonSectionText, OperationResult result) {
        if (cSectionText == null && cppSectionText == null && commonSectionText == null) {
            result.addError((OperationResult.IMessageCause)CppCauses.INSTALLATION_COMPILER_DEFINITION_HAS_ERRORS, "Compiler definition must contain at least one of [%s], [%s], [%s]", new Object[]{"C Options", "CPlusPlus Options", "Common Options"});
            return;
        }
        this.processOptions("C Options", cSectionText);
        this.processOptions("CPlusPlus Options", cppSectionText);
        this.processOptions("Common Options", this.m_definition.addImplicitCommonOptions(commonSectionText));
    }

    private void processTranslation(String translationText) {
        this.m_definition.removeChildren(new Class[]{GroovyTemplatePropertyList.class});
        if (translationText == null || translationText.trim().length() == 0) {
            translationText = "";
        }
        GroovyTemplatePropertyList translationTable = new GroovyTemplatePropertyList((NamedElement)this.m_definition, "Option Translations", translationText.trim(), "=>");
        this.m_definition.addChild(translationTable);
    }

    public void processOptions(String name, String rawText) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'processOptions' must not be empty";
        if (rawText == null) {
            LOGGER.info("No content found for section '" + name + "'.");
            rawText = "";
        }
        if (name.equals("Option Translations")) {
            this.processTranslation(rawText);
            return;
        }
        List templateChildren = this.m_definition.getChildren((NamedElement.IFilter)new NameFilter(name), GroovyTemplateElement.class);
        if (templateChildren.size() > 0) {
            assert (templateChildren.size() == 1) : "Exactly one child '" + name + "' of type '" + GroovyTemplateElement.class.getName() + "' expected";
            this.m_definition.removeChild((NamedElement)templateChildren.get(0));
        }
        GroovyTemplateElement template = new GroovyTemplateElement((NamedElement)this.m_definition, name, rawText.trim());
        this.m_definition.addChild(template);
        if (!template.hasIssues(new IIssueId[0])) {
            List children = this.m_definition.getChildren((NamedElement.IFilter)new NameFilter(name), CompilerOptions.class);
            if (children.size() > 0) {
                assert (children.size() == 1) : "Exactly one child '" + name + "' of type '" + CompilerOptions.class.getName() + "' expected";
                this.m_definition.removeChild((NamedElement)children.get(0));
            }
            CompilerOptions options = new CompilerOptions((NamedElement)this.m_definition, name);
            options.addOptions(StringUtility.multiLineStringToList((String)template.getResolvedText()));
            this.m_definition.addChild((NamedElement)options);
        }
    }

    public static InstCompilerDefinition copy(InstCompilerDefinition source, NamedElement parent) {
        return InstCompilerDefinitionBuilder.copy(source, parent, false);
    }

    public static InstCompilerDefinition copy(InstCompilerDefinition source, NamedElement parent, boolean isCreateFileDefinition) {
        assert (source != null) : "Parameter 'source' of method 'copy' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        InstCompilerDefinition copy = null;
        if (source instanceof InstCompilerDefinitionFromBundle) {
            InstCompilerDefinitionFromBundle fromBundle = (InstCompilerDefinitionFromBundle)source;
            copy = !isCreateFileDefinition ? new InstCompilerDefinitionFromBundle(parent, fromBundle.getUrl(), fromBundle.getCompiler()) : new InstCompilerDefinitionFromFile(parent, null, fromBundle.getCompiler());
        } else if (source instanceof InstCompilerDefinitionFromFile) {
            InstCompilerDefinitionFromFile fromFile = (InstCompilerDefinitionFromFile)source;
            if (fromFile.getName().equals(IDENTIFIER_FOR_NEW_DEFINITION) && fromFile.getFile() != null) {
                InstCompilerDefinitionFromFile definition = new InstCompilerDefinitionFromFile(parent, fromFile.getCompiler());
                definition.setFile(new TFile((File)fromFile.getFile().getParentFile(), fromFile.getCompiler() + CPlusPlusResourceProviderAdapter.CPlusPlusResourceType.COMPILER_DEFINITION.getExtension()));
                copy = definition;
            } else {
                copy = new InstCompilerDefinitionFromFile(parent, fromFile.getFile(), fromFile.getCompiler());
            }
        } else {
            assert (false) : "Unsupported type: " + ((Object)((Object)source)).getClass().getName();
            return null;
        }
        InstCompilerDefinitionBuilder.copyDetails(source, copy);
        return copy;
    }

    public static void copyDetails(InstCompilerDefinition source, InstCompilerDefinition copy) {
        OperationResult result = new OperationResult("Copy compiler definition");
        InstCompilerDefinitionBuilder builder = new InstCompilerDefinitionBuilder(copy);
        copy.setDescription(source.getDescription());
        copy.setLongSize(source.getLongSize());
        copy.setPointerSize(source.getPointerSize());
        Map<String, String> fixedConfigProperties = source.getFixedConfigProperties();
        if (fixedConfigProperties != null) {
            copy.setFixedConfigProperties(fixedConfigProperties);
        }
        builder.processOptions(InstCompilerDefinitionBuilder.getTemplateText(source, "C Options"), InstCompilerDefinitionBuilder.getTemplateText(source, "CPlusPlus Options"), InstCompilerDefinitionBuilder.getTemplateText(source, "Common Options"), result);
        GroovyTemplatePropertyList translationTable = (GroovyTemplatePropertyList)((Object)source.getFirstChild((NamedElement.IFilter)new NameFilter("Option Translations"), GroovyTemplatePropertyList.class));
        if (translationTable == null) {
            return;
        }
        builder.processTranslation(translationTable.getTemplateText());
    }

    static String getTemplateText(InstCompilerDefinition source, String templateName) {
        GroovyTemplateElement template = (GroovyTemplateElement)((Object)source.getFirstChild((NamedElement.IFilter)new NameFilter(templateName), GroovyTemplateElement.class));
        if (template == null) {
            return "";
        }
        return template.getTemplateText();
    }

    public static String getDifference(InstCompilerDefinition def1, InstCompilerDefinition def2) {
        String templateText2;
        if (def1 == null && def2 == null) {
            return "both null";
        }
        if (def1 == def2) {
            return "same identity";
        }
        if (def1 == null || def2 == null) {
            return "one of them is null";
        }
        if (!def1.getName().equals(def2.getName())) {
            return "name differs. name1: " + def1.getName() + ", name2: " + def2.getName();
        }
        if (!def1.getDescription().equals(def2.getDescription())) {
            return "description differs. desc1: " + def1.getDescription() + ", desc2: " + def2.getDescription();
        }
        if (def1.getPointerSize() != def2.getPointerSize()) {
            return "pointer size differs. p1: " + def1.getPointerSize() + ", p2: " + def2.getPointerSize();
        }
        if (def1.getLongSize() != def2.getLongSize()) {
            return "long size differs. l1: " + def1.getLongSize() + ", l2: " + def2.getLongSize();
        }
        if (!InstCompilerDefinitionBuilder.equalsSection(def1, def2, "C Options")) {
            return "C section differs. c1: \n" + InstCompilerDefinitionBuilder.getTemplateText(def1, "C Options") + "\nc2:\n" + InstCompilerDefinitionBuilder.getTemplateText(def2, "C Options");
        }
        if (!InstCompilerDefinitionBuilder.equalsSection(def1, def2, "CPlusPlus Options")) {
            return "C++ section differs. cpp1: \n" + InstCompilerDefinitionBuilder.getTemplateText(def1, "CPlusPlus Options") + "\ncpp2:\n" + InstCompilerDefinitionBuilder.getTemplateText(def2, "CPlusPlus Options");
        }
        if (!InstCompilerDefinitionBuilder.equalsSection(def1, def2, "Common Options")) {
            return "Common section differs. common1: \n" + InstCompilerDefinitionBuilder.getTemplateText(def1, "Common Options") + "\ncommon2:\n" + InstCompilerDefinitionBuilder.getTemplateText(def2, "Common Options");
        }
        GroovyTemplatePropertyList table1 = (GroovyTemplatePropertyList)((Object)def1.getFirstChild((NamedElement.IFilter)new NameFilter("Option Translations"), GroovyTemplatePropertyList.class));
        GroovyTemplatePropertyList table2 = (GroovyTemplatePropertyList)((Object)def2.getFirstChild((NamedElement.IFilter)new NameFilter("Option Translations"), GroovyTemplatePropertyList.class));
        if (table1 != null && table1.getTemplateText() != null && table1.getTemplateText().trim().length() == 0) {
            table1 = null;
        }
        if (table2 != null && table2.getTemplateText() != null && table2.getTemplateText().trim().length() == 0) {
            table2 = null;
        }
        if (table1 == null && table2 == null) {
            return "both translation tables are empty";
        }
        if (table1 == null || table2 == null) {
            return "one of the translation tables (" + (table1 == null ? "table1" : "table2") + ") is empty";
        }
        String templateText1 = StringUtility.harmonizeNewLineBreaks((String)table1.getTemplateText().trim());
        if (templateText1.equals(templateText2 = StringUtility.harmonizeNewLineBreaks((String)table2.getTemplateText().trim()))) {
            return "both templates for translation tables are equal";
        }
        return "template text for translation table differs. t1: \n" + templateText1 + "\nt2: " + templateText2;
    }

    public static boolean areEqual(InstCompilerDefinition def1, InstCompilerDefinition def2) {
        if (def1 == null && def2 == null) {
            return true;
        }
        if (def1 == def2) {
            return true;
        }
        if (def1 == null || def2 == null) {
            return false;
        }
        if (!def1.getName().equals(def2.getName())) {
            return false;
        }
        if (!def1.getDescription().equals(def2.getDescription())) {
            return false;
        }
        if (def1.getPointerSize() != def2.getPointerSize()) {
            return false;
        }
        if (def1.getLongSize() != def2.getLongSize()) {
            return false;
        }
        if (!(InstCompilerDefinitionBuilder.equalsSection(def1, def2, "C Options") && InstCompilerDefinitionBuilder.equalsSection(def1, def2, "CPlusPlus Options") && InstCompilerDefinitionBuilder.equalsSection(def1, def2, "Common Options"))) {
            return false;
        }
        GroovyTemplatePropertyList table1 = (GroovyTemplatePropertyList)((Object)def1.getFirstChild((NamedElement.IFilter)new NameFilter("Option Translations"), GroovyTemplatePropertyList.class));
        GroovyTemplatePropertyList table2 = (GroovyTemplatePropertyList)((Object)def2.getFirstChild((NamedElement.IFilter)new NameFilter("Option Translations"), GroovyTemplatePropertyList.class));
        if (table1 != null && table1.getTemplateText() != null && table1.getTemplateText().trim().length() == 0) {
            table1 = null;
        }
        if (table2 != null && table2.getTemplateText() != null && table2.getTemplateText().trim().length() == 0) {
            table2 = null;
        }
        if (table1 == null && table2 == null) {
            return true;
        }
        if (table1 == null || table2 == null) {
            return false;
        }
        String templateText1 = StringUtility.harmonizeNewLineBreaks((String)table1.getTemplateText().trim());
        String templateText2 = StringUtility.harmonizeNewLineBreaks((String)table2.getTemplateText().trim());
        return templateText1.equals(templateText2);
    }

    private static boolean equalsSection(InstCompilerDefinition def1, InstCompilerDefinition def2, String section) {
        GroovyTemplateElement template1 = (GroovyTemplateElement)((Object)def1.getFirstChild((NamedElement.IFilter)new NameFilter(section), GroovyTemplateElement.class));
        GroovyTemplateElement template2 = (GroovyTemplateElement)((Object)def2.getFirstChild((NamedElement.IFilter)new NameFilter(section), GroovyTemplateElement.class));
        assert (template1 != null && template2 != null) : "Templates of section '" + section + "' must not be null";
        String templateText1 = StringUtility.harmonizeNewLineBreaks((String)template1.getTemplateText()).trim();
        String templateText2 = StringUtility.harmonizeNewLineBreaks((String)template2.getTemplateText()).trim();
        return templateText1.equals(templateText2);
    }

    public String getTemplateListText(String section) {
        GroovyTemplatePropertyList sectionList = (GroovyTemplatePropertyList)((Object)this.m_definition.getFirstChild((NamedElement.IFilter)new NameFilter(section), GroovyTemplatePropertyList.class));
        if (sectionList == null) {
            return "";
        }
        return sectionList.getTemplateText().trim();
    }

    public String getSectionText(String section) {
        assert (section != null && section.length() > 0) : "Parameter 'section' of method 'getSectionText' must not be empty";
        GroovyTemplateElement template = (GroovyTemplateElement)((Object)this.m_definition.getFirstChild((NamedElement.IFilter)new NameFilter(section), GroovyTemplateElement.class));
        if (template == null) {
            return "";
        }
        return template.getTemplateText().trim();
    }

    public String getHeaderText() {
        StringBuilder text = new StringBuilder();
        text.append(DESCRIPTION_KEY).append(PROPERTY_SEPARATOR).append(this.m_definition.getDescription()).append(StringUtility.LINE_SEPARATOR);
        text.append(LONGSIZE_KEY).append(PROPERTY_SEPARATOR).append(this.m_definition.getLongSize()).append(StringUtility.LINE_SEPARATOR);
        text.append(POINTERSIZE_KEY).append(PROPERTY_SEPARATOR).append(this.m_definition.getPointerSize());
        return text.toString();
    }

    public SectionedData createSectionedData() {
        String translationText;
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("Header", this.getHeaderText());
        dataMap.put("C Options", this.getSectionText("C Options"));
        dataMap.put("CPlusPlus Options", this.getSectionText("CPlusPlus Options"));
        dataMap.put("Common Options", this.getSectionText("Common Options"));
        String fixeConfigProperties = this.getFixedConfigSection();
        if (fixeConfigProperties.length() > 0) {
            dataMap.put("Fixed Configuration Properties", fixeConfigProperties);
        }
        if ((translationText = this.getTemplateListText("Option Translations")) != null && translationText.length() > 0) {
            dataMap.put("Option Translations", translationText);
        }
        SectionedData data = SectionedData.fromMap(dataMap);
        return data;
    }

    private String getFixedConfigSection() {
        StringBuilder text = new StringBuilder();
        Map<String, String> fixedConfigProperties = this.m_definition.getFixedConfigProperties();
        if (fixedConfigProperties == null) {
            return "";
        }
        for (Map.Entry<String, String> entry : fixedConfigProperties.entrySet()) {
            text.append(entry.getKey()).append(PROPERTY_SEPARATOR).append(entry.getValue() != null ? entry.getValue() : "").append(StringUtility.LINE_SEPARATOR);
        }
        return text.toString();
    }

    public void setFixedConfigProperties(String fixedConfigSection) {
        LinkedHashMap<String, String> fixedConfigProperties = new LinkedHashMap<String, String>();
        for (String line : StringUtility.multiLineStringToList((String)fixedConfigSection)) {
            String[] parts = line.split(PROPERTY_SEPARATOR);
            if (parts.length > 2) {
                LOGGER.warn("Line of fixed configuration property contains more than one '=', anything after the second '=' will be omitted");
            }
            String key = parts[0];
            String value = null;
            if (parts.length > 1) {
                value = parts[1];
            }
            fixedConfigProperties.put(key, value);
        }
        this.m_definition.setFixedConfigProperties(fixedConfigProperties);
    }
}

