/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CppAccessSpecifier;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMethodType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutine;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppMemberFunction;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import java.io.IOException;

public final class CppMemberFunctionDeclaration
extends CppRoutine
implements ICppMemberFunction {
    private CppMethodType m_kind = CppMethodType.UNDEFINED;
    private CppAccessSpecifier m_accessSpecifier = CppAccessSpecifier.PUBLIC;

    public CppMemberFunctionDeclaration(NamedElement parent) {
        super(parent);
    }

    public CppMemberFunctionDeclaration(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, short noTemplateArgs) {
        super(msp, parent, name, lineNumber, noTemplateArgs);
    }

    public String getInformation() {
        return "Declaration";
    }

    @Override
    public boolean isDefinition() {
        return false;
    }

    public boolean hasMultipleDefinitions() {
        return this.getOutgoingDependencies(new IParserDependencyType[]{CppDependencyType.DECLARES}).size() > 1;
    }

    @Override
    public String getKey() {
        String sig = this.getSignature();
        String prefix = sig.substring(0, sig.indexOf(40));
        String result = super.getKey();
        if (prefix.length() > 0) {
            return result + ":" + prefix;
        }
        return result;
    }

    public String getImageResourceName() {
        switch (this.getAccessSpecifier()) {
            case PRIVATE: {
                return "CppMethodPrivate";
            }
            case PROTECTED: {
                return "CppMethodProtected";
            }
            case PUBLIC: {
                return "CppMethodPublic";
            }
        }
        assert (false) : "Unhandled constant in method 'getImageResourceName'" + String.valueOf((Object)this.getAccessSpecifier());
        return "";
    }

    public boolean isInitializer() {
        return this.getMemberFunctionKind() == CppMethodType.CONSTRUCTOR || this.getMemberFunctionKind() == CppMethodType.STATIC_CONSTRUCTOR;
    }

    public boolean isDestructor() {
        return this.getMemberFunctionKind() == CppMethodType.DESTRUCTOR;
    }

    @Property
    public boolean isAbstract() {
        return this.isPureVirtual();
    }

    public boolean isOverriding() {
        return false;
    }

    @Override
    public CppMethodType getMemberFunctionKind() {
        return this.m_kind;
    }

    @Override
    public void setKind(CppMethodType kind) {
        this.m_kind = kind;
    }

    @Override
    public CppAccessSpecifier getAccessSpecifier() {
        return this.m_accessSpecifier;
    }

    @Override
    public void setAccessSpecifier(CppAccessSpecifier accessSpecifier) {
        this.m_accessSpecifier = accessSpecifier;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_accessSpecifier = CppAccessSpecifier.values()[reader.readByte()];
        this.m_kind = CppMethodType.values()[reader.readByte()];
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeByte((byte)this.m_accessSpecifier.ordinal());
        writer.writeByte((byte)this.m_kind.ordinal());
    }

    @Override
    public CppRoutine getDefinition() {
        ParserDependency dep = this.getFirstDependencyByDependencyType(CppDependencyType.DECLARES);
        return dep == null ? null : (CppRoutine)dep.getTo();
    }

    @Override
    public int clearInvalidDefinitions() {
        return super.clearInvalidDefinitionsImp();
    }

    @Override
    public int addDefinition(CppRoutine r) {
        return super.addDefinitionImp(r);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppMemberFunctionDeclaration(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppMemberFunctionDeclaration(CppMemberFunctionDeclaration var1);
    }
}

