/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

public final class CPlusPlusFileType
extends Enum<CPlusPlusFileType>
implements IFileType {
    public static final /* enum */ CPlusPlusFileType CPP_SOURCE = new CPlusPlusFileType("C++ Source File", ".cpp", ".C", ".cc", ".CPP", ".c++", ".cp", ".cxx");
    public static final /* enum */ CPlusPlusFileType C_SOURCE = new CPlusPlusFileType("C Source File", ".c");
    public static final /* enum */ CPlusPlusFileType HEADER_FILE = new CPlusPlusFileType("Header File", ".h", ".hpp", ".h++", ".hxx");
    public static final /* enum */ CPlusPlusFileType CTP_FILE = new CPlusPlusFileType("Sotograph Command Capturing File", ".ctp");
    public static final /* enum */ CPlusPlusFileType CXX_CONF = new CPlusPlusFileType("Sotograph Compiler Definition File", ".cxxconf");
    public static final /* enum */ CPlusPlusFileType VISUAL_STUDIO_SOLUTION_FILE = new CPlusPlusFileType("Visual Studio Solution File", ".sln");
    public static final /* enum */ CPlusPlusFileType VISUAL_STUDIO_PROJECT_FILE = new CPlusPlusFileType("Visual Studio Project File", ".vcxproj");
    public static final /* enum */ CPlusPlusFileType KEIL_BATCH_FRAGMENT = new CPlusPlusFileType("Keil Batch Fragment", ".__i");
    public static final /* enum */ CPlusPlusFileType KEIL_UVISION_PROJECT_FILE = new CPlusPlusFileType("Keil uVision Project File", ".uvprojx");
    private final String m_presentationName;
    private final String[] m_extensions;
    private static final /* synthetic */ CPlusPlusFileType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new CPlusPlusFileType[]{CPP_SOURCE, C_SOURCE, HEADER_FILE, CTP_FILE, CXX_CONF, VISUAL_STUDIO_SOLUTION_FILE, VISUAL_STUDIO_PROJECT_FILE, KEIL_BATCH_FRAGMENT, KEIL_UVISION_PROJECT_FILE};
    }

    private CPlusPlusFileType(String presentationName, String ... extensions) {
        assert (presentationName != null) : "Parameter 'presentationName' of method 'CPlusPlusFileType' must not be null";
        assert (extensions != null && extensions.length > 0) : "Parameter 'extensions' of method 'CPlusPlusFileType' must not be empty";
        this.m_presentationName = presentationName;
        this.m_extensions = extensions;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public String[] getExtensions() {
        return this.m_extensions;
    }

    public String getDefaultExtension() {
        return this.m_extensions[0];
    }

    public boolean hasExtension(String extension) {
        return FileUtility.hasExtension((IFileType)this, (String)extension);
    }

    public boolean endsWith(String name) {
        assert (name != null) : "'name' must not be null";
        String[] stringArray = this.m_extensions;
        int n = this.m_extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String nextExtension = stringArray[n2];
            if (name.endsWith(nextExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static CPlusPlusFileType determineFileType(String ext) {
        CPlusPlusFileType[] cPlusPlusFileTypeArray = CPlusPlusFileType.values();
        int n = cPlusPlusFileTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CPlusPlusFileType fileType = cPlusPlusFileTypeArray[n2];
            if (FileUtility.hasExtension((IFileType)fileType, (String)ext)) {
                return fileType;
            }
            ++n2;
        }
        return null;
    }

    public static CPlusPlusFileType[] values() {
        CPlusPlusFileType[] cPlusPlusFileTypeArray = ENUM$VALUES;
        int n = cPlusPlusFileTypeArray.length;
        CPlusPlusFileType[] cPlusPlusFileTypeArray2 = new CPlusPlusFileType[n];
        System.arraycopy(ENUM$VALUES, 0, cPlusPlusFileTypeArray2, 0, n);
        return cPlusPlusFileTypeArray2;
    }

    public static CPlusPlusFileType valueOf(String string) {
        return Enum.valueOf(CPlusPlusFileType.class, string);
    }
}

