/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsingRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsingRequest.class);
    private final CPlusPlusModule m_module;
    private final CppSourceFile m_sourceFile;
    private final List<String> m_options;
    private String m_errorFileName;

    public ParsingRequest(CPlusPlusModule module, CppSourceFile sourceFile, List<String> options) {
        this.m_module = module;
        this.m_sourceFile = sourceFile;
        this.m_options = options;
        try {
            this.m_errorFileName = TFile.createTempFile((String)"edg", (String)".txt").getPath();
            options.add(0, "--error_output=" + this.m_errorFileName);
        }
        catch (IOException e) {
            this.m_errorFileName = null;
            LOGGER.error("Problem creating temporary error message file", (Throwable)e);
        }
    }

    public boolean isValid() {
        return this.m_errorFileName != null;
    }

    public String getErrorFileName() {
        return this.m_errorFileName;
    }

    public CPlusPlusModule getModule() {
        return this.m_module;
    }

    public CppSourceFile getSourceFile() {
        return this.m_sourceFile;
    }

    public List<String> getOptions() {
        return this.m_options;
    }
}

