/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ErrorMessage {
    private static final Pattern POSITION_REGEX = Pattern.compile("\"(.*)\", line (\\d+) \\(col. (\\d+)\\)");
    private String m_fileName = "";
    private int m_lineNumber = -1;
    private int m_column = 0;
    private String m_category;
    private String m_message;

    ErrorMessage(String msg) {
        String[] components = msg.split(": ", 3);
        if (components.length == 1) {
            this.m_message = components[0];
        } else if (components.length == 2) {
            this.m_category = components[0];
            this.m_message = components[1];
        } else {
            assert (components.length >= 3) : "bad error message: " + msg;
            Matcher matcher = POSITION_REGEX.matcher(components[0]);
            if (matcher.matches() && matcher.groupCount() == 3) {
                this.m_fileName = matcher.group(1);
                this.m_lineNumber = Integer.parseInt(matcher.group(2));
                this.m_column = Integer.parseInt(matcher.group(3));
            }
            this.m_category = components[1];
            this.m_message = components[2];
        }
    }

    public ErrorMessage(String category, String msg, String fileName, int line, int column) {
        this.m_fileName = fileName;
        this.m_lineNumber = line;
        this.m_column = column;
        this.m_category = category;
        this.m_message = msg;
    }

    public String getCategory() {
        return this.m_category;
    }

    public boolean isInternalError() {
        return this.m_category != null && this.m_category.toLowerCase().contains("internal");
    }

    public int getColumn() {
        return this.m_column;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public String getMessage() {
        return this.m_message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_category == null ? 0 : this.m_category.hashCode());
        result = 31 * result + this.m_column;
        result = 31 * result + (this.m_fileName == null ? 0 : this.m_fileName.hashCode());
        result = 31 * result + this.m_lineNumber;
        result = 31 * result + (this.m_message == null ? 0 : this.m_message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)obj;
        if (this.m_category == null ? other.m_category != null : !this.m_category.equals(other.m_category)) {
            return false;
        }
        if (this.m_column != other.m_column) {
            return false;
        }
        if (this.m_fileName == null ? other.m_fileName != null : !this.m_fileName.equals(other.m_fileName)) {
            return false;
        }
        if (this.m_lineNumber != other.m_lineNumber) {
            return false;
        }
        return !(this.m_message == null ? other.m_message != null : !this.m_message.equals(other.m_message));
    }

    public String toString() {
        if (this.m_fileName == null) {
            return this.m_category + ": " + this.m_message;
        }
        return this.m_fileName + " (" + Integer.toString(this.m_lineNumber) + "," + Integer.toString(this.m_column) + "): " + this.m_category + ": " + this.m_message;
    }
}

