/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.VisualStudioProjectImporter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusVsProjectImportDto;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.VsProjectFileBasedModuleDelta;
import de.schlichtherle.truezip.file.TFile;

class VisualStudioProjectFileValidator
implements IPathValidator {
    private final VsProjectFileBasedModuleDelta m_moduleDelta;

    public VisualStudioProjectFileValidator(VsProjectFileBasedModuleDelta moduleDelta) {
        assert (moduleDelta != null) : "Parameter 'moduleDelta' of method 'VisualStudioProjectFileValidator' must not be null";
        this.m_moduleDelta = moduleDelta;
    }

    public IPathValidator.PathType getType() {
        return IPathValidator.PathType.FILE;
    }

    public ValidationResult isValid(TFile currentInput, TFile newInput) {
        if (newInput == null || newInput.getPath().isEmpty()) {
            ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
            result.addError("Must not be empty");
            return result;
        }
        ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
        if (!newInput.exists()) {
            result.addError("Specified C++ project file '" + newInput.getNormalizedAbsolutePath() + "' does not exist.");
            return result;
        }
        if (!newInput.getAbsolutePath().endsWith(CPlusPlusFileType.VISUAL_STUDIO_PROJECT_FILE.getDefaultExtension())) {
            result.addError("Specified file '" + newInput.getNormalizedAbsolutePath() + "'" + StringUtility.LINE_SEPARATOR + "does not have the expected file extension '" + CPlusPlusFileType.VISUAL_STUDIO_PROJECT_FILE.getDefaultExtension());
            return result;
        }
        VisualStudioProjectImporter importer = new VisualStudioProjectImporter(newInput, null);
        OperationResultWithOutcome<CPlusPlusVsProjectImportDto> operationResult = importer.process();
        if (operationResult.isFailure()) {
            result.addError("Failed to process C# project file " + StringUtility.LINE_SEPARATOR + "'" + newInput.getNormalizedAbsolutePath() + "'");
            return result;
        }
        CPlusPlusVsProjectImportDto importDto = (CPlusPlusVsProjectImportDto)operationResult.getOutcome();
        this.m_moduleDelta.setImportDto(importDto);
        return result;
    }
}

