/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.ICaptureConstants;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.SourceBeanFactory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SotographCaptureFileHelper
implements ICaptureConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(SotographCaptureFileHelper.class);

    public static List<DirectoryBean> importCommandFile(TFile captureFile, StringBuilder buffer) {
        assert (captureFile != null) : "Parameter 'captureFile' of method 'importCommandFile' must not be null";
        SourceBeanFactory factory = new SourceBeanFactory();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader((File)captureFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    List words;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || !(words = StringUtility.parseQuotedLineIntoWords((String)line)).contains("-c")) continue;
                    buffer.append(line).append('\n');
                    factory.processCommand(captureFile.getParentFile(), words);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Problem reading " + captureFile.getPath(), (Throwable)e);
            return null;
        }
        return factory.getRootDirectories();
    }
}

