/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.foundation.file.DirectoryScanner;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CppExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.DirectoryBeanHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.ProjectFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IProjectAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IncludeReference;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SystemCompilerOptions;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CppProjectAnalyzer
extends CppExtension
implements DirectoryScanner.IFileConsumer,
IProjectAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectFile.class);
    private static final Pattern m_pattern = Pattern.compile("^\\s*#\\s*include\\s+[\"<](\\S+?)[\">]");
    private final SoftwareSystem m_softwareSystem;
    private final TFile m_rootDir;
    private final List<ProjectFile> m_files = new ArrayList<ProjectFile>();
    private final List<TFile> m_systemIncludeDirectories = new ArrayList<TFile>();
    private final Set<String> m_resolvedSystemIncludes = new HashSet<String>();
    private final Set<String> m_unresolvedIncludes = new HashSet<String>();
    private final MultipleValueMap<String, ProjectFile> m_fileMap = new MultipleValueMap();
    private final Map<String, TFile> m_includeToDirectoryFileMap = new HashMap<String, TFile>();
    private final Map<String, ProjectFile> m_includeResolutionMap = new HashMap<String, ProjectFile>();
    private final List<TFile> m_extraIncludeDirectories = new ArrayList<TFile>();
    private List<DirectoryBean> m_roots = null;
    private final List<String> m_globalOptions = new ArrayList<String>();
    private int m_sourceFileCount = 0;

    CppProjectAnalyzer(SoftwareSystem system, String compilerDefinitionName, List<TFile> systemIncludeDirectories, List<TFile> extraIncludeDirectories) {
        assert (system != null) : "Parameter 'system' of method 'CppProjectAnalyzer' must not be null";
        assert (systemIncludeDirectories != null && systemIncludeDirectories.size() > 0) : "Parameter 'systemIncludeDirectories' of method 'CppProjectAnalyzer' must not be empty";
        this.m_softwareSystem = system;
        this.m_rootDir = system.getDirectoryFile();
        this.m_systemIncludeDirectories.addAll(systemIncludeDirectories);
        this.m_extraIncludeDirectories.addAll(extraIncludeDirectories);
        CPlusPlusSystemSettings systemSettings = (CPlusPlusSystemSettings)((Object)((Workspace)system.getUniqueExistingChild(Workspace.class)).getUniqueChild(CPlusPlusSystemSettings.class));
        if (systemSettings != null) {
            SystemCompilerOptions systemOptions = (SystemCompilerOptions)((Object)systemSettings.getFirstChild(s -> s.getShortName().equals("Any Compiler"), SystemCompilerOptions.class));
            if (systemOptions != null) {
                this.processOptions(systemOptions);
            }
            if ((systemOptions = (SystemCompilerOptions)((Object)systemSettings.getFirstChild(s -> s.getShortName().equals(compilerDefinitionName), SystemCompilerOptions.class))) != null) {
                this.processOptions(systemOptions);
            }
        }
    }

    private void processOptions(CompilerOptions options) {
        assert (options != null) : "Parameter 'options' of method 'processOptions' must not be null";
        for (ICompilerOption opt : options.getChildren(ICompilerOption.class)) {
            TFile dir;
            String optValue = opt.getValue();
            if (optValue.startsWith("-D")) {
                if (this.m_globalOptions.contains(optValue)) continue;
                this.m_globalOptions.add(optValue);
                continue;
            }
            if (!optValue.startsWith("-I") || this.m_extraIncludeDirectories.contains(dir = new TFile(optValue.substring(2)))) continue;
            this.m_extraIncludeDirectories.add(dir);
        }
    }

    CppProjectAnalyzer(TFile rootDir, List<TFile> systemIncludeDirectories, List<TFile> extraIncludeDirectories) {
        assert (rootDir != null) : "Parameter 'rootDir' of method 'CppProjectAnalyzer' must not be null";
        assert (systemIncludeDirectories != null && systemIncludeDirectories.size() > 0) : "Parameter 'systemIncludeDirectories' of method 'CppProjectAnalyzer' must not be empty";
        this.m_softwareSystem = null;
        this.m_rootDir = rootDir;
        this.m_systemIncludeDirectories.addAll(systemIncludeDirectories);
        this.m_extraIncludeDirectories.addAll(extraIncludeDirectories);
    }

    public IFileType accepts(TFile file) {
        String ext = FileUtility.getExtension((TFile)file);
        CPlusPlusFileType type = CPlusPlusFileType.determineFileType(ext);
        if (type != null) {
            switch (type) {
                case CPP_SOURCE: 
                case C_SOURCE: {
                    ++this.m_sourceFileCount;
                }
                case HEADER_FILE: {
                    break;
                }
                default: {
                    type = null;
                }
            }
        }
        return type;
    }

    @Override
    public TFile getRootDir() {
        return this.m_rootDir;
    }

    @Override
    public List<String> getGlobalOptions() {
        return Collections.unmodifiableList(this.m_globalOptions);
    }

    private void processLine(ProjectFile projectFile, String line, int lineNo) {
        Matcher m = m_pattern.matcher(line);
        if (m.matches()) {
            TFile candidate;
            String includeRef = m.group(1).replace('\\', '/');
            if (this.m_resolvedSystemIncludes.contains(includeRef)) {
                return;
            }
            boolean includeLocal = line.contains("\"");
            boolean saveRef = true;
            if (includeLocal && (candidate = new TFile((File)projectFile.getFile().getParentFile(), includeRef)).canRead()) {
                saveRef = false;
            }
            if (saveRef) {
                TFile incFile;
                if (this.m_includeToDirectoryFileMap.get(includeRef) != null) {
                    return;
                }
                if (this.m_unresolvedIncludes.contains(includeRef)) {
                    projectFile.addReference(new IncludeReference(projectFile.getPath(), includeRef, lineNo, includeLocal));
                    return;
                }
                for (TFile incDir : this.m_systemIncludeDirectories) {
                    incFile = new TFile((File)incDir, includeRef);
                    if (!incFile.canRead()) continue;
                    saveRef = false;
                    this.m_resolvedSystemIncludes.add(includeRef);
                    break;
                }
                for (TFile incDir : this.m_extraIncludeDirectories) {
                    incFile = new TFile((File)incDir, includeRef);
                    if (!incFile.canRead()) continue;
                    saveRef = false;
                    this.m_includeToDirectoryFileMap.put(includeRef, incDir);
                    break;
                }
                if (saveRef) {
                    this.m_unresolvedIncludes.add(includeRef);
                    projectFile.addReference(new IncludeReference(projectFile.getPath(), includeRef, lineNo, includeLocal));
                }
            }
        }
    }

    private void scanForIncludeReferences(ProjectFile file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader((File)file.getFile()));){
                String line;
                int lineNo = 1;
                while ((line = reader.readLine()) != null) {
                    this.processLine(file, line, lineNo++);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Unexpected exception while scanning file for includes: ", (Throwable)e);
        }
    }

    public void consume(TFile rootPathBeingScanned, TFile file, IFileType fileType) {
        String relativePath = FileUtility.calculateRelativePath((TFile)file, (TFile)this.m_rootDir);
        ProjectFile pf = new ProjectFile(file, relativePath, fileType);
        this.m_files.add(pf);
        this.m_fileMap.put((Object)file.getName(), (Object)pf);
    }

    public boolean includeDirectory(TFile dir) {
        return !dir.getName().startsWith(".");
    }

    public List<ProjectFile> getFiles() {
        return this.m_files;
    }

    public boolean analyze(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'analyze' must not be null";
        DirectoryScanner scanner = new DirectoryScanner(LanguageProvider.getIgnoreDirectories(), false);
        workerContext.start("Scanning C,C++ sources for include references...", ActivityMode.NONE, true);
        this.m_sourceFileCount = 0;
        workerContext.setNumberOfSteps(2, new int[]{8, 92});
        scanner.scan(this.m_rootDir, (DirectoryScanner.IFileConsumer)this);
        workerContext.endStep();
        if (this.m_sourceFileCount == 0) {
            workerContext.stop();
            return false;
        }
        workerContext.beginBlockOfWork(this.m_files.size());
        for (ProjectFile pf : this.m_files) {
            this.scanForIncludeReferences(pf);
            workerContext.workItemCompleted();
            if (!workerContext.hasBeenCanceled()) continue;
            workerContext.stop();
            return false;
        }
        Iterator<Object> iterator = this.m_unresolvedIncludes.iterator();
        while (iterator.hasNext()) {
            String unresolved;
            String shortName = unresolved = (String)iterator.next();
            if (unresolved.contains("/")) {
                int slashPos = unresolved.lastIndexOf(47);
                shortName = unresolved.substring(slashPos + 1);
            }
            List matchingFiles = this.m_fileMap.get((Object)shortName);
            ProjectFile match = null;
            for (ProjectFile m : matchingFiles) {
                if (!m.getPath().endsWith("/" + unresolved)) continue;
                match = m;
                break;
            }
            if (match == null) continue;
            int slashCount = StringUtility.countChar((char)'/', (String)unresolved);
            TFile incDir = match.getFile().getParentFile();
            while (slashCount > 0) {
                incDir = incDir.getParentFile();
                --slashCount;
            }
            this.m_includeToDirectoryFileMap.put(unresolved, incDir);
            this.m_includeResolutionMap.put(unresolved, match);
        }
        this.m_unresolvedIncludes.removeAll(this.m_includeToDirectoryFileMap.keySet());
        for (ProjectFile nextProjectFile : this.m_files) {
            HashSet<TFile> incDirs = new HashSet<TFile>();
            for (IncludeReference ref : nextProjectFile.getReferences()) {
                TFile incDir = this.m_includeToDirectoryFileMap.get(ref.getIncludedName());
                if (incDir == null) continue;
                incDirs.add(incDir);
                ProjectFile included = this.m_includeResolutionMap.get(ref.getIncludedName());
                assert (included != null);
                nextProjectFile.addIncludedFile(included);
            }
            nextProjectFile.addRequiredIncludeDirectories(incDirs);
        }
        workerContext.endStep();
        workerContext.stop();
        return true;
    }

    @Override
    public List<IncludeReference> getUnresolvedIncludes() {
        ArrayList<IncludeReference> result = new ArrayList<IncludeReference>();
        HashSet<String> usedNames = new HashSet<String>();
        for (ProjectFile nextProjectFile : this.m_files) {
            for (IncludeReference ref : nextProjectFile.getReferences()) {
                TFile incDir;
                if (!usedNames.add(ref.getIncludedName()) || (incDir = this.m_includeToDirectoryFileMap.get(ref.getIncludedName())) != null) continue;
                result.add(ref);
            }
        }
        return result;
    }

    @Override
    public List<IncludeReference> addExtraIncludeDirectory(TFile dir) {
        assert (dir != null && dir.isDirectory());
        if (!this.m_extraIncludeDirectories.contains(dir)) {
            this.m_extraIncludeDirectories.add(dir);
            for (String unresolved : this.m_unresolvedIncludes) {
                TFile header = new TFile((File)dir, unresolved);
                if (!header.canRead()) continue;
                this.m_includeToDirectoryFileMap.put(unresolved, dir);
            }
            this.m_unresolvedIncludes.removeAll(this.m_includeToDirectoryFileMap.keySet());
        }
        return this.getUnresolvedIncludes();
    }

    @Override
    public List<IncludeReference> removeExtraIncludeDirectories(List<TFile> dirs) {
        assert (dirs != null) : "Parameter 'dirs' of method 'removeExtraIncludeDirectories' must not be null";
        assert (this.m_extraIncludeDirectories.containsAll(dirs));
        ArrayList<String> unresolvedAgain = new ArrayList<String>();
        for (Map.Entry<String, TFile> entry : this.m_includeToDirectoryFileMap.entrySet()) {
            if (!dirs.contains(entry.getValue())) continue;
            unresolvedAgain.add(entry.getKey());
        }
        unresolvedAgain.forEach(unresolved -> {
            TFile tFile = this.m_includeToDirectoryFileMap.remove(unresolved);
        });
        this.m_unresolvedIncludes.addAll(unresolvedAgain);
        dirs.forEach(dir -> {
            boolean bl = this.m_extraIncludeDirectories.remove(dir);
        });
        for (TFile nextIncludeDir : this.m_extraIncludeDirectories) {
            for (String nextUnresolved : this.m_unresolvedIncludes) {
                TFile header = new TFile((File)nextIncludeDir, nextUnresolved);
                if (!header.canRead()) continue;
                this.m_includeToDirectoryFileMap.put(nextUnresolved, nextIncludeDir);
            }
        }
        return this.getUnresolvedIncludes();
    }

    @Override
    public List<TFile> getExtraIncludeDirectories() {
        return Collections.unmodifiableList(this.m_extraIncludeDirectories);
    }

    @Override
    public List<TFile> getSystemIncludeDirectories() {
        return Collections.unmodifiableList(this.m_systemIncludeDirectories);
    }

    @Override
    public int getNumberOfResolvedFiles(TFile extraIncludeDir) {
        assert (extraIncludeDir != null) : "Parameter 'extraIncludeDir' of method 'getNumberOfResolvedFiles' must not be null";
        int count = 0;
        for (Map.Entry<String, TFile> entry : this.m_includeToDirectoryFileMap.entrySet()) {
            if (!entry.getValue().equals((Object)extraIncludeDir)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<DirectoryBean> getRoots() {
        if (this.m_roots == null) {
            List<TFile> sources = this.m_files.stream().filter(pf -> pf.getFileType() != CPlusPlusFileType.HEADER_FILE).map(pf -> pf.getFile()).collect(Collectors.toList());
            this.m_roots = DirectoryBeanHelper.createRoots(sources, null);
            if (this.m_softwareSystem != null) {
                this.m_roots = this.prepareToAddModules(this.m_roots, this.m_softwareSystem);
            }
        }
        return this.m_roots;
    }

    @Override
    public List<String> computeIncludePaths(List<DirectoryBean> moduleRoots) {
        ArrayList<String> result = new ArrayList<String>();
        for (DirectoryBean moduleRoot : moduleRoots) {
            for (SourceFileBean sb : moduleRoot.getAllSourceFiles()) {
                TFile sf = sb.getFile();
                ProjectFile match = null;
                for (ProjectFile pf : this.m_fileMap.get((Object)sf.getName())) {
                    if (!FileUtility.areEqual((TFile)sf, (TFile)pf.getFile())) continue;
                    match = pf;
                    break;
                }
                assert (match != null);
                for (TFile dir : match.getRequiredIncludeDirectories()) {
                    String relPath = FileUtility.calculateRelativePath((TFile)dir, (TFile)this.m_rootDir);
                    if (result.contains(relPath)) continue;
                    result.add(relPath);
                }
            }
        }
        return result;
    }
}

