/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.Path;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.RootDirectorySettings;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CMakeJsonHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CommandLineHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CppExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CppProjectAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.KeilImportHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.SotographCaptureFileHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CCSpyDirectory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CommandFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CxxConfigFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CxxConfigSettingsBlock;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ExcludedDirectoryNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GroovyTemplateElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IProjectAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SystemCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModuleType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICppImportExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ModuleInfo;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.SystemExtraInfo;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CppImportExtension
extends CppExtension
implements ICppImportExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(CppImportExtension.class);
    private static boolean s_isWindows = Platform.isWindows();
    private final IFinishModelProcessor m_fmp;

    public CppImportExtension(Installation installation, IFinishModelProcessor fmp) {
        this.m_fmp = fmp;
    }

    @Override
    public List<DirectoryBean> importCommandFile(TFile commandFile) {
        assert (commandFile != null) : "Parameter 'commandFile' of method 'importCommandFile' must not be null";
        String extension = FileUtility.getExtension((String)commandFile.getPath());
        StringBuilder buffer = new StringBuilder(65536);
        List<DirectoryBean> result = null;
        if (CoreFileType.JSON.hasExtension(extension)) {
            result = CMakeJsonHelper.importCommandFile(commandFile, buffer);
        } else if (CPlusPlusFileType.CTP_FILE.hasExtension(extension)) {
            result = SotographCaptureFileHelper.importCommandFile(commandFile, buffer);
        } else if (CPlusPlusFileType.KEIL_UVISION_PROJECT_FILE.hasExtension(extension)) {
            result = KeilImportHelper.importKeilProject(commandFile, buffer);
        } else assert (false) : "Unknown file type for: " + commandFile.getName();
        buffer.append('\n');
        return result;
    }

    @Override
    public List<DirectoryBean> readCommandFileForSystem(SoftwareSystem system, TFile commandFile, OperationResult result) {
        List<DirectoryBean> dirs = this.importCommandFile(commandFile);
        if (dirs != null) {
            dirs = this.prepareToAddModules(dirs, system);
        }
        return dirs;
    }

    @Override
    public List<DirectoryBean> readCCSpyDirectoryForSystem(SoftwareSystem system, TFile dir) {
        assert (system != null);
        assert (dir != null);
        List<DirectoryBean> dirBeans = this.readCCSpyDirectory(dir, true);
        if (dirBeans != null && !dirBeans.isEmpty()) {
            dirBeans = this.prepareToAddModules(dirBeans, system);
        }
        return dirBeans;
    }

    @Override
    public OperationResultWithOutcome<CxxConfigFile> importCxxConfigFile(TFile cxxConfig) {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Reading Sotograph Compiler Definition");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader((File)cxxConfig));){
                String line;
                State state = State.PREFIX;
                CxxConfigFile config = new CxxConfigFile();
                CxxConfigSettingsBlock settings = null;
                String lastOption = null;
                while ((line = reader.readLine()) != null) {
                    block33: {
                        if ((line = line.trim()).startsWith("#$# SOTO_INTERNAL_INFORMATION_START")) {
                            state = State.INTERNAL;
                            continue;
                        }
                        if (line.startsWith("#$# C_CONFIGURATION_START")) {
                            state = State.C_SETTINGS;
                            settings = config.getCSettings();
                            continue;
                        }
                        if (line.startsWith("#$# C++_CONFIGURATION_START")) {
                            state = State.CPP_SETTINGS;
                            settings = config.getCppSettings();
                            continue;
                        }
                        if (state == State.PREFIX || line.startsWith("#") || line.isEmpty()) continue;
                        if (state != State.INTERNAL) break block33;
                        int equalsPos = line.indexOf("=");
                        if (equalsPos <= 0) continue;
                        String key = line.substring(0, equalsPos).trim();
                        String value = line.substring(equalsPos + 1).trim();
                        switch (key) {
                            case "PRESENTATION_NAME": {
                                config.setPresentationName(value);
                                break;
                            }
                            case "VERSION": {
                                config.setVersion(value);
                            }
                        }
                        continue;
                    }
                    assert (settings != null);
                    if (line.equals("--sys_include")) {
                        settings.addSysIncludeDirectory(reader.readLine().trim());
                        continue;
                    }
                    if (line.startsWith("--sys_include=")) {
                        settings.addSysIncludeDirectory(line.substring(14).trim());
                        continue;
                    }
                    if (line.startsWith("-")) {
                        settings.addOption(line, config);
                        lastOption = line;
                        continue;
                    }
                    if ("--microsoft_version".equals(lastOption)) {
                        config.activateMicrosoftMode();
                        config.setMicrosoftVersion(line);
                        continue;
                    }
                    if (!"--gnu_version".equals(lastOption)) continue;
                    config.activateGnuMode();
                    config.setGnuVersion(line);
                }
                if (state == State.PREFIX) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT);
                } else {
                    result.setOutcome((Object)config);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, e.getMessage(), new Object[0]);
        }
        return result;
    }

    private void setupSystemWithCommandFile(SoftwareSystem system, TFile commandFile) {
        CPlusPlusSystemSettings systemSettings = (CPlusPlusSystemSettings)((Object)((Workspace)system.getUniqueExistingChild(Workspace.class)).getFirstChild(CPlusPlusSystemSettings.class));
        systemSettings.removeChildren(new Class[]{CommandFile.class});
        systemSettings.addChild((NamedElement)new CommandFile((NamedElement)systemSettings, commandFile.getNormalizedAbsoluteFile()));
    }

    private void setupSystemWithCCSpyDir(SoftwareSystem system, TFile ccspyDir) {
        CPlusPlusSystemSettings systemSettings = (CPlusPlusSystemSettings)((Object)((Workspace)system.getUniqueExistingChild(Workspace.class)).getFirstChild(CPlusPlusSystemSettings.class));
        systemSettings.removeChildren(new Class[]{CCSpyDirectory.class});
        systemSettings.addChild((NamedElement)new CCSpyDirectory((NamedElement)systemSettings, ccspyDir.getNormalizedAbsoluteFile()));
    }

    @Override
    public <T extends Path> T getCommandFileOrDirectory(SoftwareSystem system, Class<T> cls) {
        CPlusPlusSystemSettings systemSettings = (CPlusPlusSystemSettings)((Object)((Workspace)system.getUniqueExistingChild(Workspace.class)).getFirstChild(CPlusPlusSystemSettings.class));
        if (systemSettings != null) {
            return (T)((Path)systemSettings.getFirstChild(cls));
        }
        return null;
    }

    private void setupModule(Module module, List<DirectoryBean> roots, Map<List<String>, CompilerOptions> optionMap) {
        SoftwareSystem system = (SoftwareSystem)module.getParent(SoftwareSystem.class, new Class[0]);
        for (DirectoryBean root : roots) {
            CppRootDirectoryPath rootPath = new CppRootDirectoryPath((NamedElement)module, (IModelServiceProvider)system, root.getDirectory());
            module.addChild((NamedElement)rootPath);
            RootDirectorySettings settings = new RootDirectorySettings((NamedElement)rootPath);
            rootPath.addChild((NamedElement)settings);
            for (TFile excluded : root.getAllExcludedDirectories()) {
                String relativePath = FileUtility.calculateRelativePath((TFile)excluded, (TFile)root.getDirectory());
                ExcludedDirectoryNode en = new ExcludedDirectoryNode((NamedElement)settings, relativePath);
                settings.addChild((NamedElement)en);
            }
        }
    }

    @Override
    public OperationResult createModules(IWorkerContext workerContext, SoftwareSystem system, Collection<String> moduleNames, TFile commandFile, TFile ccspyDir, Map<String, List<DirectoryBean>> rootsPerModule) {
        HashMap<List<String>, CompilerOptions> optionMap = new HashMap<List<String>, CompilerOptions>();
        OperationResult result = new OperationResult("Create Modules from Command File / Capturing Files");
        WorkspaceExtension wsExt = (WorkspaceExtension)system.getExtension(WorkspaceExtension.class);
        EnumSet<Modification> modification = EnumSet.noneOf(Modification.class);
        boolean systemSetupCalled = false;
        CPlusPlusModuleType moduleType = commandFile == null ? (ccspyDir == null ? CPlusPlusModuleType.CAPTURE : CPlusPlusModuleType.MANUAL) : CPlusPlusModuleType.CMAKE_JSON;
        for (String moduleName : moduleNames) {
            Module module = wsExt.createModule((Module.IModuleType)moduleType, moduleName, "", modification);
            assert (module != null);
            if (!systemSetupCalled) {
                if (commandFile != null) {
                    this.setupSystemWithCommandFile(system, commandFile);
                } else if (ccspyDir != null) {
                    this.setupSystemWithCCSpyDir(system, ccspyDir);
                }
                systemSetupCalled = true;
            }
            this.setupModule(module, rootsPerModule.get(moduleName), ccspyDir == null ? optionMap : null);
        }
        assert (this.m_fmp != null);
        this.m_fmp.finishModification(workerContext, system, modification, result);
        system.setNeedsSave(true);
        return result;
    }

    @Override
    public void updateModules(List<? extends CPlusPlusModule> modules, CPlusPlusSystemSettings systemSettings, List<DirectoryBean> roots) {
        assert (modules != null) : "Parameter 'modules' of method 'resetModules' must not be null";
        assert (systemSettings != null) : "Parameter 'systemSettings' of method 'resetModules' must not be null";
        assert (roots != null) : "Parameter 'roots' of method 'resetModules' must not be null";
        systemSettings.removeChildren(new Class[]{CompilerOptions.class});
        for (Module module : modules) {
            for (CppRootDirectoryPath root : module.getChildren(CppRootDirectoryPath.class)) {
                RootDirectorySettings rootDirSettings = (RootDirectorySettings)root.getFirstChild(RootDirectorySettings.class);
                if (rootDirSettings == null) {
                    rootDirSettings = new RootDirectorySettings((NamedElement)root);
                    root.addChild((NamedElement)rootDirSettings);
                } else {
                    rootDirSettings.removeChildren(new Class[]{SourceFileNode.class});
                }
                List<String> excludedDirs = rootDirSettings.getChildren(ExcludedDirectoryNode.class).stream().map(n -> n.getShortName()).collect(Collectors.toList());
                for (DirectoryBean beanRoot : roots) {
                    beanRoot.markAndLockRoot(root.getFile(), excludedDirs);
                }
            }
        }
    }

    public static void moveElements(CPlusPlusModule sourceModule, CPlusPlusModule targetModule) {
        CppImportExtension.moveRootSettings(sourceModule, targetModule);
    }

    @Override
    public boolean canAddModules(ISoftwareSystemProvider provider, Class<? extends Path> cls) {
        return provider.hasSoftwareSystem() && this.getCommandFileOrDirectory(provider.getSoftwareSystem(), cls) != null;
    }

    @Override
    public IProjectAnalyzer analyzeProject(IWorkerContext workerContext, TFile dir, List<TFile> systemIncludeDirectories, List<TFile> extraIncludeDirs) {
        CppProjectAnalyzer analyzer = new CppProjectAnalyzer(dir, systemIncludeDirectories, extraIncludeDirs);
        if (analyzer.analyze(workerContext)) {
            return analyzer;
        }
        return null;
    }

    @Override
    public IProjectAnalyzer analyzeProject(IWorkerContext workerContext, SoftwareSystem system, String cdefName, List<TFile> systemIncludeDirectories, List<TFile> extraIncludeDirs) {
        CppProjectAnalyzer analyzer = new CppProjectAnalyzer(system, cdefName, systemIncludeDirectories, extraIncludeDirs);
        if (analyzer.analyze(workerContext)) {
            return analyzer;
        }
        return null;
    }

    private void addExcludePattern(WorkspaceFilter filter, String pattern) {
        filter.addChild((NamedElement)new WildcardPatternExclude((NamedElement)filter, pattern));
    }

    @Override
    public OperationResult createManualModulesAndConfigureSystem(IWorkerContext workerContext, SoftwareSystem system, List<ModuleInfo> modules, SystemExtraInfo extraInfo) {
        OperationResult result = new OperationResult("Creating modules and configuring system");
        EnumSet<Modification> modification = EnumSet.noneOf(Modification.class);
        WorkspaceExtension wsExt = (WorkspaceExtension)system.getExtension(WorkspaceExtension.class);
        TFile rootDir = system.getDirectoryFile();
        Workspace ws = (Workspace)system.getUniqueExistingChild(Workspace.class);
        WorkspaceFilter wsFilter = ws.getWorkspaceFilter();
        for (ModuleInfo moduleInfo : modules) {
            Module module = wsExt.createModule((Module.IModuleType)CPlusPlusModuleType.MANUAL, moduleInfo.getName(), "", modification);
            assert (module != null);
            ModuleSettings settings = (ModuleSettings)module.getUniqueExistingChild(ModuleSettings.class);
            ModuleCompilerOptions moduleOptions = new ModuleCompilerOptions((NamedElement)settings, "Any Compiler");
            settings.addChild((NamedElement)moduleOptions);
            for (DirectoryBean rootBean : moduleInfo.getRoots()) {
                CppRootDirectoryPath rootPath = new CppRootDirectoryPath((NamedElement)module, (IModelServiceProvider)system, rootBean.getDirectory());
                module.addChild((NamedElement)rootPath);
                for (TFile excludedDir : rootBean.getAllExcludedDirectories()) {
                    String relPath = FileUtility.calculateRelativePath((TFile)excludedDir, (TFile)rootDir);
                    this.addExcludePattern(wsFilter, relPath + "/**");
                }
            }
            StringWriter buffer = new StringWriter(1024);
            PrintWriter out = new PrintWriter(buffer);
            for (String opt : moduleInfo.getOptions()) {
                ICompilerOption copt = moduleOptions.addOption(opt);
                if (copt == null) {
                    out.println(opt);
                    continue;
                }
                out.println(copt.getValueForPersistence());
            }
            moduleOptions.addChild(new GroovyTemplateElement((NamedElement)moduleOptions, "Options", buffer.toString()));
        }
        for (String excluded : extraInfo.getExcludedFiles()) {
            this.addExcludePattern(wsFilter, excluded);
        }
        CPlusPlusSystemSettings systemSettings = (CPlusPlusSystemSettings)((Object)ws.getUniqueExistingChild(CPlusPlusSystemSettings.class));
        SystemCompilerOptions systemOptions = (SystemCompilerOptions)((Object)systemSettings.getFirstChild(s -> s.getShortName().equals("Any Compiler"), SystemCompilerOptions.class));
        GroovyTemplateElement optionsTemplate = null;
        if (systemOptions == null) {
            systemOptions = new SystemCompilerOptions((NamedElement)systemSettings, "Any Compiler");
            systemSettings.addChild((NamedElement)systemOptions);
        } else {
            optionsTemplate = (GroovyTemplateElement)((Object)systemOptions.getUniqueChild(GroovyTemplateElement.class));
        }
        ArrayList<String> options = new ArrayList<String>();
        if (optionsTemplate != null) {
            options.addAll(StringUtility.multiLineStringToList((String)optionsTemplate.getTemplateText()));
            optionsTemplate.remove();
        }
        for (String opt : extraInfo.getOptions()) {
            if (options.contains(opt)) continue;
            ICompilerOption copt = systemOptions.addOption(opt);
            if (copt == null) {
                options.add(opt);
                continue;
            }
            options.add(copt.getValueForPersistence());
        }
        StringWriter buffer = new StringWriter(1024);
        PrintWriter out = new PrintWriter(buffer);
        for (String opt : options) {
            out.println(opt);
        }
        optionsTemplate = new GroovyTemplateElement((NamedElement)systemOptions, "Options", buffer.toString());
        systemOptions.addChild(optionsTemplate);
        this.m_fmp.finishModification(workerContext, system, modification, result);
        system.setNeedsSave(true);
        return result;
    }

    private List<SourceFileBean> readCCSpyDirectoryFiles(TFile dir, boolean deleteObsoleteFiles) {
        assert (dir != null && dir.isDirectory());
        TFile[] files = dir.listFiles((d, n) -> n.endsWith(".txt"));
        THashMap optMap = new THashMap();
        ArrayList<SourceFileBean> result = new ArrayList<SourceFileBean>();
        THashSet foundFiles = new THashSet();
        if (files == null) {
            return Collections.emptyList();
        }
        TFile[] tFileArray = files;
        int n2 = files.length;
        int n3 = 0;
        while (n3 < n2) {
            TFile ccspyFile = tFileArray[n3];
            SourceFileBean bean = null;
            String srcPath = null;
            try {
                Throwable throwable = null;
                Object var14_18 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(ccspyFile.getPath()));){
                    boolean added;
                    String opt;
                    int lastColon;
                    String cwdPath = reader.readLine();
                    srcPath = reader.readLine();
                    if (s_isWindows && (lastColon = srcPath.lastIndexOf(58)) > 1) {
                        String fixedVersion = srcPath.substring(lastColon - 1);
                        LOGGER.debug("Fixed ccspy file path from '" + srcPath + "' to '" + fixedVersion + "'");
                        srcPath = fixedVersion;
                    }
                    TFile cwd = new TFile(cwdPath);
                    List<String> options = new ArrayList<String>();
                    boolean expectIncludeDir = false;
                    String dirOpt = "-I";
                    while ((opt = reader.readLine()) != null && opt.length() > 0) {
                        String incDirPath = null;
                        opt = opt.trim();
                        if (expectIncludeDir) {
                            expectIncludeDir = false;
                            incDirPath = opt;
                        } else if (opt.startsWith("-D")) {
                            options.add(opt);
                        } else if (opt.startsWith("-I")) {
                            incDirPath = opt.substring("-I".length());
                        } else if (opt.startsWith("--include=")) {
                            incDirPath = opt.substring("--include=".length());
                        } else if (opt.startsWith("-F") && Platform.isMac()) {
                            dirOpt = "-F";
                            incDirPath = opt.substring(2);
                        }
                        if (incDirPath == null) continue;
                        if (incDirPath.length() == 0) {
                            expectIncludeDir = true;
                            continue;
                        }
                        TFile incDir = new TFile(incDirPath);
                        if (!incDir.isAbsolute()) {
                            incDir = new TFile((File)cwd, incDirPath);
                        }
                        options.add(dirOpt + incDir.getNormalizedAbsolutePath());
                        dirOpt = "-I";
                    }
                    options = CommandLineHelper.filterAndNormalizeItems(cwd, options, false);
                    TFile src = new TFile(srcPath);
                    if (!src.isAbsolute()) {
                        src = new TFile((File)cwd, srcPath);
                    }
                    if ((added = foundFiles.add((src = src.getNormalizedAbsoluteFile()).getPath())) && (!deleteObsoleteFiles || src.canRead())) {
                        List<String> storedOpts = optMap.put(options, options);
                        if (storedOpts != null) {
                            options = storedOpts;
                        }
                        bean = new SourceFileBean(src, options);
                        result.add(bean);
                    }
                    if (!added) {
                        LOGGER.error("Source already added via another ccspy file: " + src.getPath());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                LOGGER.error("Problem reading " + ccspyFile.getPath(), (Throwable)e);
            }
            if (deleteObsoleteFiles && bean == null) {
                try {
                    LOGGER.debug("Deleted ccspy file because '" + srcPath + "' cannot be read");
                    ccspyFile.rm();
                }
                catch (IOException e) {
                    LOGGER.error("Problems deleting " + ccspyFile.getPath(), (Throwable)e);
                }
            }
            ++n3;
        }
        return result;
    }

    private int getLengthOfCommonPrefix(List<TFile> first, List<TFile> second) {
        int result = 0;
        int minSize = Math.min(first.size(), second.size());
        while (result < minSize && first.get(result).equals((Object)second.get(result))) {
            ++result;
        }
        return result;
    }

    private DirectoryBean getBean(Map<String, DirectoryBean> dirMap, DirectoryBean parent, TFile dir) {
        assert (dirMap != null);
        assert (dir != null);
        String dirPath = dir.getAbsolutePath();
        DirectoryBean dirBean = dirMap.get(dirPath);
        if (dirBean == null) {
            dirBean = new DirectoryBean(parent, dir);
            dirMap.put(dirPath, dirBean);
        } else if (parent != null && dirBean.getParent() == null) {
            parent.addSubDirectory(dirBean);
        }
        return dirBean;
    }

    @Override
    public List<DirectoryBean> readCCSpyDirectory(TFile dir, boolean deleteObsoleteFiles) {
        List<SourceFileBean> sources = this.readCCSpyDirectoryFiles(dir, deleteObsoleteFiles);
        if (sources.isEmpty()) {
            return Collections.emptyList();
        }
        THashMap dirMap = new THashMap();
        ArrayList<DirectoryBean> newBeans = new ArrayList<DirectoryBean>();
        for (SourceFileBean src : sources) {
            TFile srcFile = src.getFile();
            TFile d = srcFile.getParentFile();
            assert (d != null);
            String dirPath = d.getAbsolutePath();
            DirectoryBean dirBean = (DirectoryBean)dirMap.get(dirPath);
            if (dirBean == null) {
                dirBean = new DirectoryBean(null, d);
                dirMap.put(dirPath, dirBean);
                newBeans.add(dirBean);
            }
            dirBean.addFile(src);
        }
        DirectoryBean root = null;
        if (newBeans.size() == 1) {
            root = (DirectoryBean)newBeans.get(0);
        } else if (newBeans.size() > 1) {
            List<TFile> baseDirs = FileUtility.getBaseDirectoriesOf((TFile)((DirectoryBean)newBeans.get(0)).getDirectory());
            Collections.reverse(baseDirs);
            baseDirs.add(((DirectoryBean)newBeans.get(0)).getDirectory());
            int i = 1;
            while (i < newBeans.size()) {
                List otherBaseDirs = FileUtility.getBaseDirectoriesOf((TFile)((DirectoryBean)newBeans.get(i)).getDirectory());
                Collections.reverse(otherBaseDirs);
                otherBaseDirs.add(((DirectoryBean)newBeans.get(i)).getDirectory());
                int lengthOfCommonPrefix = this.getLengthOfCommonPrefix(baseDirs, otherBaseDirs);
                if (lengthOfCommonPrefix > 0) {
                    TFile sharedRoot = (TFile)baseDirs.get(lengthOfCommonPrefix - 1);
                    DirectoryBean currentParent = root = this.getBean((Map<String, DirectoryBean>)dirMap, null, sharedRoot);
                    int j = lengthOfCommonPrefix;
                    while (j < baseDirs.size()) {
                        currentParent = this.getBean((Map<String, DirectoryBean>)dirMap, currentParent, (TFile)baseDirs.get(j));
                        ++j;
                    }
                    currentParent = root;
                    j = lengthOfCommonPrefix;
                    while (j < otherBaseDirs.size()) {
                        currentParent = this.getBean((Map<String, DirectoryBean>)dirMap, currentParent, (TFile)otherBaseDirs.get(j));
                        ++j;
                    }
                } else {
                    return Collections.emptyList();
                }
                baseDirs = baseDirs.subList(0, lengthOfCommonPrefix);
                ++i;
            }
            while (root.getParent() != null) {
                root = root.getParent();
            }
        }
        return List.of(root);
    }

    private static enum State {
        PREFIX,
        INTERNAL,
        C_SETTINGS,
        CPP_SETTINGS;

    }
}

