/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ICompilationUnitContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.IElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFlags;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class EnumProcessor
extends ElementProcessor {
    private final EDG.TypeInteger m_EDGEnumType;
    private CppProgrammingElement m_Enum;
    private CppProgrammingElement m_definition;
    private List<CppProgrammingElement> m_declarations = new ArrayList<CppProgrammingElement>();

    EnumProcessor(ICompilationUnitContext context, IElementProcessor parentProcessor, EDG.TypeInteger enumType) {
        super(context, parentProcessor);
        this.m_EDGEnumType = enumType;
    }

    @Override
    public boolean initElement() {
        EDG.SourceCorrespondence sc = this.m_EDGEnumType.sourceCorresp();
        EDG.Position pos = sc.declPosition().getPosition();
        CppElement myParent = this.getParentProcessor().getParentFor(pos);
        if (myParent != null) {
            Object name = sc.name();
            EDG.Constant constant = null;
            if (this.m_EDGEnumType.isScopedEnum()) {
                if (this.m_EDGEnumType.enumInfo_assocScope() != null) {
                    constant = this.m_EDGEnumType.enumInfo_assocScope().constants();
                }
            } else {
                constant = this.m_EDGEnumType.enumInfo_constantList();
            }
            if (name == null || ((String)name).length() == 0) {
                name = "[anonymous]" + HashSupport.MD5.getHexString(pos.getFile().fullName() + pos.getLineNumber());
            }
            Collection<EDG.SourcePosition> positions = this.getContext().getSecondaryPositions(this.m_EDGEnumType, sc.declPosition());
            this.m_Enum = new CppProgrammingElement(myParent, CppElementType.ENUM, (String)name, pos.getLineNumber());
            this.m_Enum.setNamespace(this.getParentProcessor().getNamespace(), this.getParentProcessor().isAnonymousNamespace());
            this.getContext().mapElementPosition(this.m_Enum, sc.declPosition());
            myParent.addChild(this.m_Enum);
            if (constant != null) {
                this.m_Enum.addFlag(CppFlags.DEFINITION);
                this.m_definition = this.m_Enum;
                while (constant != null) {
                    EDG.SourceCorrespondence constantSc = constant.sourceCorresp();
                    CppProgrammingElement c = new CppProgrammingElement(this.m_Enum, CppElementType.CONSTANT, constantSc.name(), constantSc.declPosition().getPosition().getLineNumber());
                    this.m_Enum.addChild(c);
                    this.getContext().mapElement(constant, c);
                    int intValue = -1;
                    if (constant instanceof EDG.ConstantIntegerValue) {
                        EDG.ConstantIntegerValue intConstant = (EDG.ConstantIntegerValue)constant;
                        intValue = (int)intConstant.integerValue();
                    }
                    this.getContext().addEnumConstant(intValue, c);
                    constant = constant.next();
                }
            } else {
                this.m_Enum.addFlag(CppFlags.DECLARATION);
                this.m_declarations.add(this.m_Enum);
            }
            for (EDG.SourcePosition sp : positions) {
                EDG.Position secondaryPos = sp.getPosition();
                CppElement secondaryParent = this.getParentProcessor().getParentFor(secondaryPos);
                if (secondaryParent == myParent) continue;
                CppProgrammingElement decl = new CppProgrammingElement(secondaryParent, CppElementType.ENUM, (String)name, secondaryPos.getLineNumber());
                decl.addFlag(CppFlags.DECLARATION);
                secondaryParent.addChild(decl);
                this.m_declarations.add(decl);
                this.getContext().addSecondaryDeclaration(this.m_Enum, decl);
                this.getContext().mapElementPosition(decl, sp);
            }
            if (this.m_definition != null) {
                for (CppProgrammingElement decl : this.m_declarations) {
                    decl.addDependency(this.m_definition, CppDependencyType.DECLARES, pos.getLineNumber());
                }
            }
            this.getContext().mapElement(this.m_EDGEnumType, this.m_Enum);
        }
        return false;
    }

    @Override
    public void processElement() {
    }

    @Override
    public CppElement getElement() {
        return this.m_Enum;
    }

    @Override
    public EDG.CObject getEDGObject() {
        return this.m_EDGEnumType;
    }
}

