/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ClassStructUnionProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.EnumProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.FieldProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ICompilationUnitContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.IElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.LocalVariableProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.NamespaceProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.RoutineProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.SourceFileProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.TypedefProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.VariableProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDGVisitor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFlags;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFunctionWithBody;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppSourceFileElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppStructuredType;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompilationUnitProcessor
implements ICompilationUnitContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompilationUnitProcessor.class);
    private final CppCompilationUnit m_root;
    private final CppSourceFileElement m_sourceFile;
    private final List<IElementProcessor> m_processors = new ArrayList<IElementProcessor>();
    private final Map<Object, CppProgrammingElement> m_elementMap = new THashMap();
    private final Map<CppProgrammingElement, EDG.SourcePosition> m_elementToPositionMap = new THashMap();
    private final MultipleValueMap<Integer, CppProgrammingElement> m_constantMap = new MultipleValueMap();
    private final MultipleValueMap<CppProgrammingElement, CppProgrammingElement> m_secondaries = new MultipleValueMap();
    private final MultipleValueMap<EDG.CObject, EDG.SourcePosition> m_secondaryPositionCache = new MultipleValueMap();
    private final MultipleValueMap<String, CppProgrammingElement> m_structuredTypeMap = new MultipleValueMap();
    private final MultipleValueMap<String, CppProgrammingElement> m_fields = new MultipleValueMap();
    private final SourceFileProcessor m_sourceProcessor;
    private final Set<EDG.Position> m_friendDeclarations = new THashSet();
    private final List<TFile> m_sysIncludes = new ArrayList<TFile>();
    private final Map<EDG.Position, CppFunctionWithBody> m_friendsDefinedInInstantiation = new THashMap();
    private final Map<EDG.Position, CppStructuredType> m_typeDeclarations = new THashMap();
    private boolean m_parsingFinished = false;

    public CompilationUnitProcessor(TFile sourceFile, List<String> options) {
        this.m_root = new CppCompilationUnit();
        this.m_sourceFile = new CppSourceFileElement(this.m_root, sourceFile.getNormalizedAbsolutePath(), false);
        this.m_root.addChild(this.m_sourceFile);
        this.m_sourceProcessor = new SourceFileProcessor((ICompilationUnitContext)this, this.m_sourceFile);
        options.stream().filter(o -> o.startsWith("--sys_include=")).map(o -> o.substring(14).trim()).map(o -> new TFile(o)).forEach(f -> {
            boolean bl = this.m_sysIncludes.add((TFile)f);
        });
    }

    CppCompilationUnit getRoot() {
        return this.m_root;
    }

    @Override
    public void registerField(CppProgrammingElement field) {
        assert (field != null) : "Parameter 'field' of method 'registerField' must not be null";
        this.m_fields.put((Object)field.getName(), (Object)field);
    }

    @Override
    public boolean isExternal(File file) {
        return this.m_sysIncludes.stream().anyMatch(dir -> dir.isParentOf(file));
    }

    @Override
    public CppSourceFileElement addHeader(TFile file, boolean isExternal) {
        CppSourceFileElement header = new CppSourceFileElement(this.m_root, file.getPath(), isExternal);
        this.m_root.addChild(header);
        return header;
    }

    @Override
    public void initSecondaryPositionCache(EDG.SourceSequenceEntry entry) {
        while (entry != null) {
            EDG.CObject entity = entry.entity();
            if (entity instanceof EDG.SrcSeqSecondaryDecl) {
                EDG.SrcSeqSecondaryDecl decl = (EDG.SrcSeqSecondaryDecl)entity;
                EDG.CObject obj = decl.entity();
                if (!decl.friendDecl()) {
                    EDG.SourcePosition pos;
                    if ((obj instanceof EDG.Routine || obj instanceof EDG.TypeClassStructUnion || obj instanceof EDG.Variable || obj instanceof EDG.TypeTyperef || obj instanceof EDG.TypeInteger) && (pos = decl.declPosition()).seq() != 0L) {
                        if (obj instanceof EDG.TypeClassStructUnion) {
                            EDG.TypeClassStructUnion cls = (EDG.TypeClassStructUnion)obj;
                            if (cls.isTemplateClass()) {
                                this.m_secondaryPositionCache.put((Object)cls.extraInfo().assocTemplate(), (Object)pos);
                            } else {
                                this.m_secondaryPositionCache.put((Object)obj, (Object)pos);
                            }
                        } else {
                            this.m_secondaryPositionCache.put((Object)obj, (Object)pos);
                        }
                    }
                } else if (obj instanceof EDG.Routine) {
                    this.m_friendDeclarations.add(decl.declPosition().getOriginalPosition());
                }
            }
            entry = entry.next();
        }
    }

    @Override
    public void addEnumConstant(int value, CppProgrammingElement constant) {
        assert (constant != null) : "Parameter 'constant' of method 'addEnumConstant' must not be null";
        assert (constant.getType() == CppElementType.CONSTANT);
        this.m_constantMap.put((Object)value, (Object)constant);
    }

    @Override
    public CppProgrammingElement getConstant(CppProgrammingElement enumType, int value) {
        assert (enumType != null) : "Parameter 'enumType' of method 'getConstant' must not be null";
        assert (enumType.getType() == CppElementType.ENUM);
        return this.m_constantMap.get((Object)value).stream().filter(c -> c.getParent() == enumType).findFirst().orElse(null);
    }

    @Override
    public boolean isFriendDeclPosition(EDG.Position pos) {
        return this.m_friendDeclarations.contains(pos);
    }

    @Override
    public Collection<EDG.SourcePosition> getSecondaryPositions(EDG.CObject element, EDG.SourcePosition originalPosition) {
        EDG.TypeClassStructUnion cls;
        EDG.CObject key = element;
        if (key instanceof EDG.TypeClassStructUnion && (cls = (EDG.TypeClassStructUnion)key).isTemplateClass()) {
            key = cls.extraInfo().assocTemplate();
        }
        ArrayList result = this.m_secondaryPositionCache.get((Object)key);
        for (EDG.SourcePosition sp : result) {
            if (sp.seq() != originalPosition.seq()) continue;
            result = new ArrayList(result);
            result.remove(sp);
            break;
        }
        return result;
    }

    @Override
    public CppSourceFileElement getSourceFile() {
        return this.m_sourceFile;
    }

    public EDGVisitor getRootVisitor() {
        return this.m_sourceProcessor.getVisitor();
    }

    @Override
    public CppProgrammingElement selectDependencyTargetForPosition(CppSourceFileElement unused, CppProgrammingElement target, EDG.SourcePosition sp) {
        List secondaryDeclarations = this.m_secondaries.get((Object)target);
        if (secondaryDeclarations.isEmpty()) {
            return target;
        }
        if (sp == null) {
            return null;
        }
        EDG.Position pos = sp.getPosition();
        EDG.SourceFile usageFile = pos.getFile();
        if (usageFile == null) {
            return null;
        }
        long usageSequenceNumber = sp.seq();
        ArrayList<CppProgrammingElement> candidates = new ArrayList<CppProgrammingElement>(secondaryDeclarations);
        if (!target.isExternal() || target.isDefinition() && target.getType().isStructuredType() || target.isDeclaration()) {
            candidates.add(target);
        } else assert (candidates.size() > 0);
        CppProgrammingElement match = null;
        long matchSeq = 0L;
        for (CppProgrammingElement pe : candidates) {
            EDG.SourcePosition p = this.m_elementToPositionMap.get(pe);
            assert (p != null);
            long cs = p.seq();
            if (cs < usageFile.firstSeqNumber()) continue;
            boolean isDefinition = pe.hasFlag(CppFlags.DEFINITION);
            boolean sameFile = p.getPosition().getFile().equals(usageFile);
            if (cs > usageSequenceNumber && !sameFile) continue;
            if (isDefinition || sameFile) {
                return pe;
            }
            if (match != null && cs <= matchSeq) continue;
            match = pe;
            matchSeq = cs;
        }
        if (match == null) {
            match = target;
        }
        return match;
    }

    @Override
    public void mapElementPosition(CppProgrammingElement element, EDG.SourcePosition pos) {
        assert (element != null) : "element must not be null";
        assert (pos != null) : "pos must not be null";
        this.m_elementToPositionMap.put(element, pos);
    }

    @Override
    public EDG.SourcePosition getPositionOf(CppProgrammingElement element) {
        return this.m_elementToPositionMap.get(element);
    }

    @Override
    public void mapElement(Object obj, CppProgrammingElement element) {
        if (obj != null && !this.m_elementMap.containsKey(obj)) {
            this.m_elementMap.put(obj, element);
            if (obj instanceof EDG.TypeClassStructUnion && element.getName().length() > 0) {
                this.m_structuredTypeMap.put((Object)element.getName(), (Object)element);
            }
        }
    }

    @Override
    public CppProgrammingElement getElement(Object obj) {
        CppProgrammingElement result = this.m_elementMap.get(obj);
        if (result == null && obj instanceof EDG.TypeClassStructUnion) {
            EDG.TypeClassStructUnion edgClass = (EDG.TypeClassStructUnion)obj;
            String name = edgClass.sourceCorresp().name();
            if (!edgClass.isTemplateClass()) {
                result = (CppProgrammingElement)this.m_structuredTypeMap.getFirstValue((Object)name);
            }
        }
        return result;
    }

    @Override
    public CppProgrammingElement mapRawType(IElementProcessor proc, EDG.Type rawType, EDG.SourcePosition pos, boolean isRefType) {
        CppProgrammingElement type = this.getElement(rawType);
        if (type == null) {
            EDG.TypeClassStructUnion cls;
            if (rawType instanceof EDG.TypeTemplateParam) {
                return null;
            }
            if (rawType instanceof EDG.TypeClassStructUnion) {
                EDG.TypeClassStructUnion csu = (EDG.TypeClassStructUnion)rawType;
                EDG.Template template = csu.extraInfo().assocTemplate();
                if (template != null) {
                    type = this.getElement(template);
                }
            } else {
                EDG.Scope scope = rawType.sourceCorresp().parentScope();
                if (scope instanceof EDG.ScopeAssocType) {
                    EDG.ScopeAssocType parentScope = (EDG.ScopeAssocType)scope;
                    EDG.Type parentType = parentScope.assocType();
                    assert (parentType instanceof EDG.TypeClassStructUnion);
                    EDG.TypeClassStructUnion csu = (EDG.TypeClassStructUnion)parentType;
                    assert (csu.isTemplateClass() && !csu.isPrototypeInstantiation());
                    EDG.Template template = csu.extraInfo().assocTemplate();
                    CppProgrammingElement cppClass = this.getElement(template);
                    assert (cppClass != null && cppClass.getType().isStructuredType());
                    EDG.SourceCorrespondence sc = rawType.sourceCorresp();
                    String name = sc.name();
                    EDG.Position declPos = sc.declPosition().getPosition();
                    type = cppClass.getChildren(c -> c instanceof CppProgrammingElement && c.getName().equals(name)).stream().map(e -> (CppProgrammingElement)e).filter(e -> e.getLineNo() == declPos.getLineNumber()).findFirst().orElse(null);
                }
            }
            if (type == null && rawType instanceof EDG.TypeClassStructUnion && !(cls = (EDG.TypeClassStructUnion)rawType).proxyClass()) {
                type = this.handleImplicitTypeDeclarations(proc, (EDG.TypeClassStructUnion)rawType);
            }
        }
        while (type == null && rawType instanceof EDG.TypeTyperef) {
            rawType = ((EDG.TypeTyperef)rawType).type();
            type = this.mapRawType(proc, rawType, pos, false);
        }
        if (type == null) {
            if (rawType.sourceCorresp().name() != null) {
                LOGGER.error(String.format("Cannot map element '%s' in file '%s': %d", rawType.sourceCorresp().name(), pos.getPosition().getFile().fullName(), pos.getPosition().getLineNumber()));
            }
            return null;
        }
        EDG.SourcePosition sp = this.m_elementToPositionMap.get(type);
        EDG.SourceFile usageFile = pos.getPosition().getFile();
        if (usageFile != null && sp != null) {
            long lowestSeq = usageFile.firstSeqNumber();
            long seq = pos.seq();
            long bestSeq = sp.seq();
            if ((type.isDeclaration() || isRefType) && (bestSeq < lowestSeq || bestSeq > seq && !usageFile.equals(sp.getPosition().getFile()))) {
                bestSeq = 0L;
                for (CppProgrammingElement decl : this.m_secondaries.get((Object)type)) {
                    long declSeq = this.m_elementToPositionMap.get(decl).seq();
                    if (declSeq > seq || declSeq <= bestSeq || declSeq < lowestSeq) continue;
                    bestSeq = declSeq;
                    type = decl;
                }
            }
        }
        return type;
    }

    private CppProgrammingElement handleImplicitTypeDeclarations(IElementProcessor parentProc, EDG.TypeClassStructUnion rawType) {
        assert (rawType != null) : "Parameter 'rawType' of method 'handleImplicitTypeDeclarations' must not be null";
        String name = rawType.sourceCorresp().name();
        CppProgrammingElement result = null;
        EDG.Position pos = rawType.sourceCorresp().declPosition().getPosition();
        CppElement parent = parentProc.getParentFor(pos);
        if (parent != null && (result = parent.getFirstChild(element -> element.getName().equals(name), CppProgrammingElement.class)) == null) {
            IElementProcessor proc = this.createClassStructUnionProcessor(parentProc, rawType);
            proc.initElement();
            result = (CppProgrammingElement)proc.getElement();
        }
        return result;
    }

    @Override
    public final CppProgrammingElement mapField(EDG.Field field, IElementProcessor proc) {
        if (field == null) {
            return null;
        }
        CppProgrammingElement element = this.getElement(field);
        if (element == null && field.sourceCorresp().name() != null) {
            EDG.SourceCorrespondence sc = field.sourceCorresp();
            EDG.Position pos = sc.declPosition().getPosition();
            List fields = this.m_fields.get((Object)sc.name());
            element = fields.stream().filter(f -> f.getLineNo() == pos.getLineNumber() && f.getParent(CppSourceFileElement.class).getName().equals(pos.getFile().fullName())).findFirst().orElse(null);
            if (element == null) {
                LOGGER.error(String.format("Cannot map field '%s'  (%s)", sc.name(), pos.toString()));
            }
        }
        return element;
    }

    @Override
    public void addSecondaryDeclaration(CppProgrammingElement primary, CppProgrammingElement secondary) {
        this.m_secondaries.putIfNotPresent((Object)primary, (Object)secondary);
    }

    @Override
    public Collection<CppProgrammingElement> getSecondaryDeclarations(CppProgrammingElement primary) {
        return this.m_secondaries.get((Object)primary);
    }

    private void processError(IElementProcessor processor, Throwable ex) {
        assert (processor.getElement() != null);
        CppSourceFileElement source = (CppSourceFileElement)processor.getElement().getSource();
        int line = processor.getElement().getLineNo();
        String msg = String.format("Internal error while processig '%s' in file '%s' (line %d)", processor.getElement().getName(), source.getName(), line);
        LOGGER.error(msg, ex);
    }

    @Override
    public void parsingFinished() {
        this.m_parsingFinished = true;
        for (IElementProcessor processor : this.m_processors) {
            try {
                processor.processElement();
            }
            catch (Throwable t) {
                this.processError(processor, t);
            }
        }
    }

    @Override
    public IElementProcessor createClassStructUnionProcessor(IElementProcessor parent, EDG.TypeClassStructUnion csu) {
        return new ClassStructUnionProcessor(this, parent, csu);
    }

    @Override
    public IElementProcessor createNamespaceProcessor(IElementProcessor parent, EDG.NamespaceAssocScope ns) {
        return new NamespaceProcessor(this, parent, ns);
    }

    @Override
    public IElementProcessor createRoutineProcessor(IElementProcessor parent, EDG.Routine r) {
        return new RoutineProcessor(this, parent, r);
    }

    @Override
    public IElementProcessor createEnumProcessor(IElementProcessor parent, EDG.TypeInteger e) {
        return new EnumProcessor(this, parent, e);
    }

    @Override
    public IElementProcessor createTypedefProcessor(IElementProcessor parent, EDG.TypeTyperef td) {
        return new TypedefProcessor(this, parent, td);
    }

    @Override
    public IElementProcessor createVariableProcessor(IElementProcessor parent, EDG.Variable v) {
        return new VariableProcessor(this, parent, v);
    }

    @Override
    public IElementProcessor createLocalVariableProcessor(IElementProcessor parent, EDG.Variable v) {
        return new LocalVariableProcessor(this, parent, v);
    }

    @Override
    public IElementProcessor createFieldProcessor(IElementProcessor parent, EDG.Field f) {
        return new FieldProcessor(this, parent, f);
    }

    @Override
    public void addProcessor(IElementProcessor proc) {
        assert (proc != null) : "Parameter 'proc' of method 'addProcessor' must not be null";
        if (!this.m_parsingFinished) {
            this.m_processors.add(proc);
        }
    }

    @Override
    public CppFunctionWithBody findFriendDefinedInInstantiation(EDG.Position pos) {
        assert (pos != null);
        return this.m_friendsDefinedInInstantiation.get(pos);
    }

    @Override
    public void registerFriendDefinedInInstantiation(EDG.Position pos, CppFunctionWithBody funct) {
        assert (pos != null);
        assert (funct != null);
        this.m_friendsDefinedInInstantiation.put(pos, funct);
    }

    @Override
    public void registerStructuredTypeDeclaration(EDG.Position pos, CppStructuredType type) {
        assert (pos != null);
        assert (type != null);
        this.m_typeDeclarations.put(pos, type);
    }

    @Override
    public CppStructuredType findStructuredTypeDeclaration(EDG.Position pos) {
        assert (pos != null);
        return this.m_typeDeclarations.get(pos);
    }
}

