/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusCommandId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CreateCompilerDefinitionCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.SystemAndModuleCreationData;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.settings.ICPlusPlusInstallationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICppImportExtension;

public class CreateNewManualSystemCommand
extends AbstractCreateSoftwareSystemCommand {
    private final IInteraction m_interaction;

    public CreateNewManualSystemCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'CreateNewManualSystemCommand' must not be null";
        this.m_interaction = interaction;
    }

    public ICommandId getId() {
        return CPlusPlusCommandId.CREATE_MANUAL_SYSTEM;
    }

    protected void internalRun(IWorkerContext workerContext) {
        OperationResult result;
        CreateSoftwareSystemCommand createSoftwareSystemCommand = new CreateSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (AbstractCreateSoftwareSystemCommand.IInteraction)this.m_interaction);
        if (!createSoftwareSystemCommand.isEnabled().isSuccess()) {
            return;
        }
        this.runPrerequisiteCommand((Command)createSoftwareSystemCommand, workerContext);
        if (createSoftwareSystemCommand.canceled() || !this.getController().hasSoftwareSystem()) {
            return;
        }
        SystemAndModuleCreationData importData = new SystemAndModuleCreationData();
        if (!this.m_interaction.collect(importData)) {
            return;
        }
        if (importData.getSelectedCompilerDefinition() == null) {
            CreateCompilerDefinitionCommand compilerDefinitionCommand = new CreateCompilerDefinitionCommand((ISoftwareSystemProvider)this.getController(), this.m_interaction);
            this.runPrerequisiteCommand((Command)compilerDefinitionCommand, workerContext);
        } else if (!"default".equals(importData.getSelectedCompilerDefinition()) && (result = ((ICPlusPlusInstallationExtension)this.getController().getInstallation().getExtension(ICPlusPlusInstallationExtension.class)).setActiveCompilerDefinitionId(importData.getSelectedCompilerDefinition())).isFailure()) {
            this.m_interaction.processOperationResult(result);
        }
        ICppImportExtension importExtension = (ICppImportExtension)this.getController().getInstallation().getExtension(ICppImportExtension.class);
        OperationResult result2 = importExtension.createManualModulesAndConfigureSystem(workerContext, this.getController().getSoftwareSystem(), importData.getModules(), importData.getExtraSystemInfo());
        if (!result2.isFailure()) {
            result2.addMessagesFrom(this.getController().saveSoftwareSystem(workerContext));
        }
        this.m_interaction.processSaveResult(result2);
    }

    public static interface IInteraction
    extends AbstractCreateSoftwareSystemCommand.IInteraction,
    CreateCompilerDefinitionCommand.IInteraction {
        public boolean collect(SystemAndModuleCreationData var1);

        public void processModuleCreationResult(OperationResult var1);
    }
}

