/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusCommandId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.system.IComponentAssignmentExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppComponent;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import java.util.List;

public final class AssignUnboundComponentsToModuleCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public AssignUnboundComponentsToModuleCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, (ICommandInteraction)interaction);
    }

    public ICommandId getId() {
        return CPlusPlusCommandId.ASSIGN_UNBOUND_COMPONENTS;
    }

    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        AssignUnboundComponentsData data = new AssignUnboundComponentsData();
        if (((IInteraction)this.getInteraction()).collect(data)) {
            IComponentAssignmentExtension ext = (IComponentAssignmentExtension)this.getController().getSoftwareSystem().getExtension(IComponentAssignmentExtension.class);
            OperationResult result = ext.assignComponentsToModule(workerContext, data.getComponents(), data.getModule());
            ((IInteraction)this.getInteraction()).processOperationResult(result);
        }
    }

    public static final class AssignUnboundComponentsData
    implements ICommandInteractionData {
        private List<CppComponent> m_components;
        private CPlusPlusModule m_module;

        List<CppComponent> getComponents() {
            assert (this.m_components != null && this.m_components.size() > 0);
            return this.m_components;
        }

        public void setComponents(List<CppComponent> components) {
            this.m_components = components;
        }

        public boolean hasModule() {
            return this.m_module != null;
        }

        CPlusPlusModule getModule() {
            assert (this.m_module != null);
            return this.m_module;
        }

        public void setModule(CPlusPlusModule module) {
            this.m_module = module;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public void processOperationResult(OperationResult var1);

        public boolean collect(AssignUnboundComponentsData var1);
    }
}

