/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system;

import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.SolutionFileInfo;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusVsProjectImportDto;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.VisualStudioProjectFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusVsProjectFileBasedModule;
import de.schlichtherle.truezip.file.TFile;

public class VsProjectFileBasedModuleDelta {
    private final SolutionFileInfo.ConfigurationAndPlatform m_originalConfiguration;
    private SolutionFileInfo.ConfigurationAndPlatform m_configuration;
    private TFile m_originalProjectFile;
    private CPlusPlusVsProjectImportDto m_importDto;
    private TFile m_projectFile;
    private String m_description;
    private final String m_originalDescription;
    private String m_moduleName;
    private CPlusPlusVsProjectFileBasedModule m_module;
    private boolean m_isModuleNameValid;

    public VsProjectFileBasedModuleDelta(CPlusPlusVsProjectFileBasedModule module) {
        assert (module != null) : "Parameter 'module' of method 'VsProjectFileBasedModuleDelta' must not be null";
        ModuleSettings settings = (ModuleSettings)module.getUniqueExistingChild(ModuleSettings.class);
        VisualStudioProjectFile projectFile = (VisualStudioProjectFile)((Object)settings.getUniqueExistingChild(VisualStudioProjectFile.class));
        this.m_originalProjectFile = projectFile.getFile();
        this.m_originalConfiguration = projectFile.getConfiguration();
        this.m_originalDescription = module.getDescription();
        this.m_moduleName = module.getName();
        this.m_module = module;
        this.init();
    }

    public VsProjectFileBasedModuleDelta() {
        this.m_originalConfiguration = null;
        this.m_originalProjectFile = null;
        this.m_originalDescription = "";
        this.init();
    }

    private void init() {
        this.m_configuration = this.m_originalConfiguration;
        this.m_projectFile = this.m_originalProjectFile;
        this.m_description = this.m_originalDescription;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public SolutionFileInfo.ConfigurationAndPlatform getConfiguration() {
        return this.m_configuration;
    }

    public void setConfiguration(SolutionFileInfo.ConfigurationAndPlatform configuration) {
        this.m_configuration = configuration;
    }

    public void setProjectFile(TFile projectFile) {
        this.m_originalProjectFile = projectFile;
    }

    public TFile getProjectFile() {
        return this.m_originalProjectFile;
    }

    public CPlusPlusVsProjectImportDto getImportDto() {
        return this.m_importDto;
    }

    public void setImportDto(CPlusPlusVsProjectImportDto importDto) {
        this.m_importDto = importDto;
        this.m_moduleName = importDto != null ? importDto.getProjectName() : null;
    }

    public boolean isModified() {
        boolean areFileAndDescriptionEqual;
        boolean bl = areFileAndDescriptionEqual = StringUtility.areEqual((String)this.m_originalDescription, (String)this.m_description) && FileUtility.areEqual((TFile)this.m_originalProjectFile, (TFile)this.m_projectFile);
        if (!areFileAndDescriptionEqual) {
            return true;
        }
        if (this.m_originalConfiguration == null && this.m_configuration == null) {
            return false;
        }
        if (this.m_originalConfiguration == null || this.m_configuration == null) {
            return true;
        }
        return !this.m_originalConfiguration.equals((Object)this.m_configuration);
    }

    public String getModuleName() {
        return this.m_moduleName;
    }

    public CPlusPlusVsProjectFileBasedModule getModule() {
        return this.m_module;
    }

    public SolutionFileInfo.ConfigurationAndPlatform getOriginalConfiguration() {
        return this.m_originalConfiguration;
    }

    public void setModuleNameValid(boolean isValid) {
        this.m_isModuleNameValid = isValid;
    }

    public boolean isModuleNameValid() {
        return this.m_isModuleNameValid;
    }
}

