/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class VisualStudioProjectFileDelta {
    private List<TFile> m_removedFiles = new ArrayList<TFile>();
    private List<TFile> m_filesWithModifiedOptions = new ArrayList<TFile>();
    private RootDirectoryPath m_rootToRemove;

    public void addToRemovedFiles(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'addToRemovedFiles' must not be null";
        this.m_removedFiles.add(file);
    }

    public void setRemovedFiles(List<TFile> files) {
        assert (files != null) : "Parameter 'files' of method 'setRemovedFiles' must not be null";
        this.m_removedFiles = files;
    }

    public List<TFile> getRemovedFiles() {
        return Collections.unmodifiableList(this.m_removedFiles);
    }

    public List<TFile> getFilesWithModifiedOptions() {
        return Collections.unmodifiableList(this.m_filesWithModifiedOptions);
    }

    public void addFileWithModifiedOptions(TFile sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'addFileWithModifiedOptions' must not be null";
        if (!this.m_filesWithModifiedOptions.contains(sourceFile)) {
            this.m_filesWithModifiedOptions.add(sourceFile);
        }
    }

    public void setFilesWithModifiedOptions(List<TFile> sourceFiles) {
        assert (sourceFiles != null) : "Parameter 'sourceFiles' of method 'setFilesWithModifiedOptions' must not be null";
        this.m_filesWithModifiedOptions = sourceFiles;
    }

    public RootDirectoryPath getRootDirectoryToRemove() {
        return this.m_rootToRemove;
    }

    public void setRootDirectoryToRemove(RootDirectoryPath rootPath) {
        assert (rootPath != null) : "Parameter 'rootPath' of method 'setRootDirectoryToRemove' must not be null";
        this.m_rootToRemove = rootPath;
    }
}

