/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.BasePathForIncludes;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CSourceFileExtensions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CppSourceFileExtensions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GroovyTemplateElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleOrSystemCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SystemCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.CppCompilerDefinitionRefMissing;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SettingsBuilder {
    private final NamedElement m_parent;
    private String m_cppExtensions;
    private String m_basePathForIncludes;
    private final Map<String, String> m_compilerOptionsMap;
    private final NamedElement m_settings;

    public SettingsBuilder(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'ModuleSettingsBuilder' must not be null";
        this.m_parent = parent;
        this.m_compilerOptionsMap = new LinkedHashMap<String, String>();
        this.m_settings = this.m_parent instanceof Module ? new ModuleSettings(parent) : new CPlusPlusSystemSettings(parent);
    }

    public void setCppSourceFileExtensions(String extensions) {
        this.m_cppExtensions = extensions;
    }

    public void setBasePathForIncludes(String basePathForIncludes) {
        this.m_basePathForIncludes = basePathForIncludes;
    }

    public void addCompilerOptionsText(String definitionName, String text) {
        if (definitionName == null || definitionName.trim().length() == 0) {
            ModuleCompilerOptions moduleOptions = new ModuleCompilerOptions(this.m_settings);
            moduleOptions.addIssue((Issue)new CppCompilerDefinitionRefMissing((NamedElement)moduleOptions, "No compiler definition referenced."));
            this.m_settings.addChild((NamedElement)moduleOptions);
        } else {
            String moduleOptionsText = "";
            if (text != null) {
                moduleOptionsText = text.trim();
            }
            this.m_compilerOptionsMap.put(definitionName.trim(), moduleOptionsText);
        }
    }

    public final NamedElement create() {
        boolean isModuleLevel = this.m_settings.getParent() instanceof Module;
        if (isModuleLevel) {
            if (this.m_cppExtensions != null) {
                this.m_settings.addChild((NamedElement)new CppSourceFileExtensions(this.m_settings, new HashSet<String>(StringUtility.splitAndTrim((String)this.m_cppExtensions, (String)","))));
            }
            if (this.m_basePathForIncludes == null) {
                this.m_basePathForIncludes = ".";
            }
            BasePathForIncludes basePath = FileUtility.isRelativePath((String)this.m_basePathForIncludes) ? new BasePathForIncludes(this.m_settings, this.m_basePathForIncludes) : new BasePathForIncludes(this.m_settings, new TFile(this.m_basePathForIncludes));
            this.m_settings.addChild((NamedElement)basePath);
        } else if (this.m_cppExtensions != null) {
            this.m_settings.addChild((NamedElement)new CppSourceFileExtensions(this.m_settings, new HashSet<String>(StringUtility.splitAndTrim((String)this.m_cppExtensions, (String)","))));
        }
        for (Map.Entry<String, String> entry : this.m_compilerOptionsMap.entrySet()) {
            ModuleOrSystemCompilerOptions options = isModuleLevel ? new ModuleCompilerOptions(this.m_settings, entry.getKey()) : new SystemCompilerOptions(this.m_settings, entry.getKey());
            String optionsText = entry.getValue().trim();
            GroovyTemplateElement template = new GroovyTemplateElement((NamedElement)options, "Options", optionsText);
            options.addChild(template);
            options.addOptions(StringUtility.multiLineStringToList((String)template.getResolvedText()));
            this.m_settings.addChild((NamedElement)options);
        }
        if (isModuleLevel) {
            this.m_settings.addChild((NamedElement)new SourceFileSettings(this.m_settings));
        }
        return this.m_settings;
    }

    public static final NamedElement copy(NamedElement original) {
        CppSourceFileExtensions originalSourceFileExtensions;
        SettingsBuilder builder = new SettingsBuilder(original.getParent());
        BasePathForIncludes originalBaseDir = (BasePathForIncludes)((Object)original.getUniqueChild(BasePathForIncludes.class));
        if (originalBaseDir != null) {
            builder.setBasePathForIncludes(originalBaseDir.getName());
        }
        if ((originalSourceFileExtensions = (CppSourceFileExtensions)((Object)original.getUniqueChild(CppSourceFileExtensions.class))) != null) {
            builder.setCppSourceFileExtensions(originalSourceFileExtensions.toString());
        }
        for (ModuleOrSystemCompilerOptions originalOptions : original.getChildren(ModuleOrSystemCompilerOptions.class)) {
            GroovyTemplateElement template = (GroovyTemplateElement)((Object)originalOptions.getUniqueChild(GroovyTemplateElement.class));
            String optionsTemplateText = "";
            if (template != null) {
                optionsTemplateText = template.getTemplateText();
            }
            builder.addCompilerOptionsText(originalOptions.getName(), optionsTemplateText);
        }
        NamedElement copy = builder.create();
        return copy;
    }

    private static void addOptionsIfNotPresent(NamedElement settings, String name) {
        List optionsList = settings.getChildren((NamedElement.IFilter)new NameFilter(name), ModuleOrSystemCompilerOptions.class);
        if (optionsList.isEmpty()) {
            ModuleOrSystemCompilerOptions options = settings instanceof CPlusPlusSystemSettings ? new SystemCompilerOptions(settings, name) : new ModuleCompilerOptions(settings, name);
            settings.addChild((NamedElement)options);
            GroovyTemplateElement template = new GroovyTemplateElement((NamedElement)options, "Options", "");
            options.addChild(template);
            options.addOptions(StringUtility.multiLineStringToList((String)template.getResolvedText()));
        }
    }

    public static void addOptionsForMissingDefinitions(NamedElement settings, Collection<String> compilerDefinitionNames) {
        assert (settings != null) : "Parameter 'settings' of method 'addModuleOptionsForMissingDefinitions' must not be null";
        assert (compilerDefinitionNames != null) : "Parameter 'compilerDefinitionNames' of method 'addModuleOptionsForMissingDefinitions' must not be null";
        SettingsBuilder.addOptionsIfNotPresent(settings, "Any Compiler");
        for (String definition : compilerDefinitionNames) {
            SettingsBuilder.addOptionsIfNotPresent(settings, definition);
        }
    }

    public static boolean areEqual(NamedElement settings1, NamedElement settings2) {
        assert (settings1 != null) : "Parameter 'original' of method 'areEqual' must not be null";
        assert (settings2 != null) : "Parameter 'copy' of method 'areEqual' must not be null";
        BasePathForIncludes baseDir1 = (BasePathForIncludes)((Object)settings1.getUniqueChild(BasePathForIncludes.class));
        BasePathForIncludes baseDir2 = (BasePathForIncludes)((Object)settings2.getUniqueChild(BasePathForIncludes.class));
        if (baseDir1 == null || baseDir2 == null ? baseDir1 != baseDir2 : !baseDir1.getAbsolutePath().equals(baseDir2.getAbsolutePath())) {
            return false;
        }
        CppSourceFileExtensions cppExtensions1 = (CppSourceFileExtensions)((Object)settings1.getUniqueChild(CppSourceFileExtensions.class));
        CppSourceFileExtensions cppExtensions2 = (CppSourceFileExtensions)((Object)settings2.getUniqueChild(CppSourceFileExtensions.class));
        if (cppExtensions1 == null || cppExtensions2 == null ? cppExtensions1 != cppExtensions2 : !cppExtensions1.toString().equals(cppExtensions2.toString())) {
            return false;
        }
        CSourceFileExtensions cExtensions1 = (CSourceFileExtensions)((Object)settings1.getUniqueChild(CSourceFileExtensions.class));
        CSourceFileExtensions cExtensions2 = (CSourceFileExtensions)((Object)settings2.getUniqueChild(CSourceFileExtensions.class));
        if (cExtensions1 == null || cExtensions2 == null ? cExtensions1 != cExtensions2 : !cExtensions1.toString().equals(cExtensions2.toString())) {
            return false;
        }
        if (!SettingsBuilder.optionsAreEqual(settings1, settings2)) {
            return false;
        }
        return SettingsBuilder.optionsAreEqual(settings2, settings1);
    }

    private static boolean optionsAreEqual(NamedElement settings1, NamedElement settings2) {
        assert (settings1 != null) : "Parameter 'settings1' of method 'optionsAreEqual' must not be null";
        assert (settings2 != null) : "Parameter 'settings2' of method 'optionsAreEqual' must not be null";
        for (ModuleOrSystemCompilerOptions options1 : settings1.getChildren(ModuleOrSystemCompilerOptions.class)) {
            GroovyTemplateElement template;
            ModuleOrSystemCompilerOptions options2 = (ModuleOrSystemCompilerOptions)((Object)settings2.getUniqueChild((NamedElement.IFilter)new NameFilter(options1.getName()), ModuleOrSystemCompilerOptions.class));
            if (options2 == null && ((template = (GroovyTemplateElement)((Object)options1.getUniqueChild(GroovyTemplateElement.class))) == null || template.getTemplateText() == null || template.getTemplateText().trim().length() == 0)) continue;
            GroovyTemplateElement template1 = (GroovyTemplateElement)((Object)options1.getUniqueChild(GroovyTemplateElement.class));
            String templateText1 = "";
            if (template1 != null) {
                templateText1 = StringUtility.harmonizeNewLineBreaks((String)template1.getTemplateText().trim());
            }
            if (options2 == null) {
                if (templateText1.isEmpty()) continue;
                return false;
            }
            GroovyTemplateElement template2 = (GroovyTemplateElement)((Object)options2.getUniqueChild(GroovyTemplateElement.class));
            String templateText2 = "";
            if (template2 != null) {
                templateText2 = StringUtility.harmonizeNewLineBreaks((String)template2.getTemplateText().trim());
            }
            if (templateText1.equals(templateText2)) continue;
            return false;
        }
        return true;
    }
}

