/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.settings.ConfigurationLevel;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GroovyTemplateElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IncludeOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SysInclude;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.InvalidSysIncludeIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.SystemCompilerDefinitionTemplateIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.SystemIgnoredOptionLineIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.SystemNonExistingIncludeIssue;

public abstract class ModuleOrSystemCompilerOptions
extends CompilerOptions {
    public ModuleOrSystemCompilerOptions(NamedElement parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    public Result validate(boolean addIssues, ConfigurationLevel level) {
        GroovyTemplateElement template;
        NamedElement settings = this.getParent();
        assert (settings != null) : "'settings' must not be null";
        if (addIssues) {
            this.removeIssues();
            settings.removeIssues();
        }
        StringBuilder errorMessage = new StringBuilder();
        for (ICompilerOption option : this.getChildren(ICompilerOption.class)) {
            Result optionResult = option.validate();
            if (!optionResult.isFailure()) continue;
            if (addIssues && option instanceof IncludeOption) {
                settings.addIssue((Issue)new SystemNonExistingIncludeIssue(settings, optionResult.getErrorMessage()));
            } else if (addIssues && option instanceof SysInclude) {
                settings.addIssue((Issue)new InvalidSysIncludeIssue(settings, optionResult.getErrorMessage()));
            } else if (addIssues) assert (false) : "Issues of option type '" + option.getClass().getSimpleName() + "' are not supported";
            errorMessage.append(optionResult.getErrorMessage()).append(StringUtility.LINE_SEPARATOR);
        }
        if (!this.getSkippedOptionLines().isEmpty()) {
            for (String line : this.getSkippedOptionLines()) {
                if (addIssues) {
                    settings.addIssue((Issue)new SystemIgnoredOptionLineIssue(settings, line));
                }
                errorMessage.append("# Ignoring line '" + line + "'");
            }
        }
        if ((template = (GroovyTemplateElement)((Object)this.getUniqueChild(GroovyTemplateElement.class))) != null && template.getErrorMessage() != null) {
            String errorMsg = this.getName() + " issue:" + template.getErrorMessage();
            if (addIssues) {
                this.addIssue((Issue)new SystemCompilerDefinitionTemplateIssue((NamedElement)this, errorMsg));
            }
            errorMessage.append(StringUtility.LINE_SEPARATOR).append(errorMsg);
        }
        Result result = new Result();
        if (errorMessage.length() > 0) {
            result.addErrorMessage(errorMessage.toString());
        }
        return result;
    }

    public static class Validator {
        public ValidationResult isValid(ModuleOrSystemCompilerOptions options, boolean addIssues) {
            ValidationResult result = new ValidationResult(true);
            Result optionValidationResult = options.validate(addIssues, ConfigurationLevel.MODULE);
            if (addIssues) {
                for (Issue issue : options.getIssues()) {
                    result.addError(issue.getDescription());
                }
            } else if (optionValidationResult.isFailure()) {
                result.addError(optionValidationResult.getErrorMessage());
            }
            return result;
        }
    }
}

