/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GroovyTemplateElement;
import gnu.trove.map.hash.THashMap;
import java.util.List;
import java.util.Map;

public final class GroovyTemplatePropertyList
extends GroovyTemplateElement {
    private final Map<String, String> m_properties = new THashMap();

    public GroovyTemplatePropertyList(NamedElement parent, String name, String templateText, String sepRegex) {
        super(parent, name, templateText);
        List resolvedLines = StringUtility.multiLineStringToList((String)this.getResolvedText());
        if (resolvedLines != null) {
            this.resolveProperties(resolvedLines, sepRegex);
        }
    }

    private void resolveProperties(List<String> lines, String sepRegex) {
        for (String line : lines) {
            String[] parts = line.split(sepRegex);
            if (parts.length != 2) continue;
            String key = parts[0].trim();
            String value = parts[1].trim();
            this.m_properties.put(key, value);
        }
    }

    public int getIntProperty(String name, int defaultValue) {
        String val = this.m_properties.get(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(val);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public String getStringProperty(String name) {
        return this.m_properties.get(name);
    }

    public String getStringProperty(String name, String defaultValue) {
        String value = this.m_properties.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

