/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.TemplateUtility;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.windows.WinRegistry;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyTemplateElement
extends NamedElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyTemplateElement.class);
    private static boolean s_checkedForCygwin;
    private static String s_cygwinRoot;
    private static String s_cygwinRoot32;
    private final String m_name;
    private final String m_templateText;
    private final Map<String, Object> m_mappings = new THashMap(System.getenv());
    private String m_resolvedText;
    private String m_errorMsg;

    public GroovyTemplateElement(NamedElement parent, String name, String templateText) {
        super(parent);
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'GroovyTemplate' must not be empty";
        assert (templateText != null) : "Parameter 'templateText' of method 'GroovyTemplate' must not be null";
        this.m_name = name;
        this.m_templateText = templateText;
        if (!s_checkedForCygwin) {
            if (Platform.isWindows()) {
                if (Platform.isOperatingSystem64Bit()) {
                    s_cygwinRoot = WinRegistry.readString((long)-2147483646L, (String)"SOFTWARE\\Cygwin\\setup", (String)"rootdir");
                    s_cygwinRoot32 = WinRegistry.readString((long)-2147483646L, (String)"SOFTWARE\\Wow6432Node\\Cygwin\\setup", (String)"rootdir");
                    if (s_cygwinRoot == null) {
                        LOGGER.warn("No Cygwin root in windows registry");
                    }
                } else {
                    s_cygwinRoot32 = WinRegistry.readString((long)-2147483646L, (String)"SOFTWARE\\Cygwin\\setup", (String)"rootdir");
                    if (s_cygwinRoot32 == null) {
                        LOGGER.warn("No Cygwin32 root in windows registry");
                    }
                }
            }
            s_checkedForCygwin = true;
        }
        if (s_cygwinRoot != null) {
            this.m_mappings.put("CYGWIN_ROOT_64", FileUtility.convertPathToUniversalForm((String)s_cygwinRoot));
            if (Platform.isOperatingSystem64Bit()) {
                this.m_mappings.put("CYGWIN_ROOT", FileUtility.convertPathToUniversalForm((String)s_cygwinRoot));
            }
        }
        if (s_cygwinRoot32 != null) {
            this.m_mappings.put("CYGWIN_ROOT_32", FileUtility.convertPathToUniversalForm((String)s_cygwinRoot32));
            if (!Platform.isOperatingSystem64Bit()) {
                this.m_mappings.put("CYGWIN_ROOT", FileUtility.convertPathToUniversalForm((String)s_cygwinRoot32));
            }
        }
        TFile homeDir = CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir();
        this.m_mappings.put("SONARGRAPH_HOME", FileUtility.convertPathToUniversalForm((String)homeDir.getAbsolutePath()));
        TFile cppHome = new TFile((File)homeDir, "cplusplus");
        cppHome.mkdirs();
        this.m_mappings.put("SONARGRAPH_CPP_HOME", FileUtility.convertPathToUniversalForm((String)cppHome.getAbsolutePath()));
        try {
            this.m_resolvedText = TemplateUtility.expandTemplateText((String)this.m_templateText.trim().replace("\\", "\\\\"), this.m_mappings);
        }
        catch (Throwable e) {
            this.m_errorMsg = "Failed to expand groovy template text for " + this.getName() + ": " + e.getMessage();
            this.m_resolvedText = this.m_errorMsg;
        }
    }

    public final String getShortName() {
        return this.m_name;
    }

    public final String getTemplateText() {
        return this.m_templateText;
    }

    public final String getResolvedText() {
        return this.m_resolvedText;
    }

    public final Map<String, ? extends Object> getMappings() {
        return this.m_mappings;
    }

    public final String getErrorMessage() {
        return this.m_errorMsg;
    }

    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public static boolean areEqual(GroovyTemplateElement template1, GroovyTemplateElement template2) {
        if (template1 == template2) {
            return true;
        }
        if (template1 == null || template2 == null) {
            return false;
        }
        if (!((Object)((Object)template1)).getClass().equals(((Object)((Object)template2)).getClass())) {
            return false;
        }
        if (!template1.getName().equals(template2.getName())) {
            return false;
        }
        if (!StringUtility.harmonizeNewLineBreaks((String)template1.getTemplateText()).trim().equals(StringUtility.harmonizeNewLineBreaks((String)template2.getTemplateText()).trim())) {
            return false;
        }
        if (template1.getResolvedText() == null && template2.getResolvedText() == null) {
            return true;
        }
        if (template1.getResolvedText() == null && template2.getResolvedText() != null) {
            return false;
        }
        return template1.getResolvedText().equals(template2.getResolvedText());
    }

    public final List<String> getTemplateTextLinesWithoutComments() {
        if (this.getTemplateText() == null) {
            return null;
        }
        ArrayList<String> textLines = new ArrayList<String>();
        for (String line : StringUtility.multiLineStringToList((String)this.getTemplateText())) {
            if (line.length() <= 0 || line.startsWith("#") || line.startsWith("//")) continue;
            textLines.add(line);
        }
        return textLines;
    }
}

