/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CppAccessSpecifier;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMethodType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutineDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppMemberFunction;
import java.io.IOException;

public final class CppMemberFunction
extends CppRoutineDefinition
implements ICppMemberFunction {
    private CppAccessSpecifier m_accessSpecifier = CppAccessSpecifier.PUBLIC;
    private CppMethodType m_kind = CppMethodType.UNDEFINED;

    public CppMemberFunction(NamedElement parent) {
        super(parent);
    }

    public CppMemberFunction(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, short noTemplateArgs) {
        super(msp, parent, name, lineNumber, noTemplateArgs);
    }

    public String getImageResourceName() {
        switch (this.getAccessSpecifier()) {
            case PRIVATE: {
                return "CppMethodPrivate";
            }
            case PROTECTED: {
                return "CppMethodProtected";
            }
            case PUBLIC: {
                return "CppMethodPublic";
            }
        }
        assert (false) : "Unhandled constant in method 'getImageResourceName'" + String.valueOf((Object)this.getAccessSpecifier());
        return "";
    }

    @Override
    public String getKey() {
        String sig = this.getSignature();
        String prefix = sig.substring(0, sig.indexOf(40));
        String result = super.getKey();
        if (prefix.length() > 0) {
            return result + ":" + prefix;
        }
        return result;
    }

    public boolean isInitializer() {
        return this.getMemberFunctionKind() == CppMethodType.CONSTRUCTOR || this.getMemberFunctionKind() == CppMethodType.STATIC_CONSTRUCTOR;
    }

    public boolean isDestructor() {
        return this.getMemberFunctionKind() == CppMethodType.DESTRUCTOR;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isOverriding() {
        return false;
    }

    @Override
    public void setKind(CppMethodType kind) {
        this.m_kind = kind;
    }

    @Override
    public CppMethodType getMemberFunctionKind() {
        return this.m_kind;
    }

    @Override
    public CppAccessSpecifier getAccessSpecifier() {
        return this.m_accessSpecifier;
    }

    @Override
    public void setAccessSpecifier(CppAccessSpecifier accessSpecifier) {
        this.m_accessSpecifier = accessSpecifier;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_accessSpecifier = CppAccessSpecifier.values()[reader.readByte()];
        this.m_kind = CppMethodType.values()[reader.readByte()];
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeByte((byte)this.m_accessSpecifier.ordinal());
        writer.writeByte((byte)this.m_kind.ordinal());
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppMemberFunction(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppMemberFunction(CppMemberFunction var1);
    }
}

