/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path;

import com.hello2morrow.sonargraph.core.model.element.IFixedNameElement;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IPhysicalContainer;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IUnmodifiableElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusStructureItem;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppExternalHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.ICppComponent;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;

public final class CppIncludeDirectory
extends RootDirectoryPath
implements IPhysicalContainer,
IFixedNameElement,
IUnmodifiableElement {
    private boolean m_isSystemInclude;
    private boolean m_needsBaseDirectory;

    public CppIncludeDirectory(NamedElement parent) {
        super(parent);
    }

    public CppIncludeDirectory(IModelServiceProvider msp, NamedElement parent, TFile directory, boolean isSystemInclude) {
        super(msp, parent, directory);
        this.m_isSystemInclude = isSystemInclude;
    }

    public boolean containsSourceFiles() {
        return this.getChildren(ICppComponent.class).stream().anyMatch(c -> c.containsAtLeastOneSourceFile());
    }

    public boolean isExternal() {
        return this.getParent().isExternal();
    }

    public boolean isSystemInclude() {
        return this.m_isSystemInclude;
    }

    public String getImageResourceName() {
        return DirectoryPath.class.getSimpleName();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeBoolean(this.m_isSystemInclude);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_isSystemInclude = reader.readBoolean();
        this.m_needsBaseDirectory = this.getName().startsWith(".");
    }

    public IBaseDirectory getBaseDirectory() {
        return this.m_needsBaseDirectory ? super.getBaseDirectory() : null;
    }

    protected void lastChildRemoved() {
        if (!this.m_isSystemInclude) {
            this.remove();
        }
    }

    public CppExternalHeaderFile getExternalHeader(IModelServiceProvider msp, TFile file) {
        assert (msp != null) : "Parameter 'msp' of method 'getExternalHeader' must not be null";
        assert (file != null) : "Parameter 'file' of method 'getExternalHeader' must not be null";
        for (CppExternalHeaderFile header : this.getChildrenRecursively(CppExternalHeaderFile.class, new Class[0])) {
            if (!header.getFile().equals((Object)file)) continue;
            return header;
        }
        String relPath = FileUtility.calculateRelativePath((TFile)file.getParentFile(), (TFile)this.getDirectoryFile());
        IDirectoryPath parent = DirectoryFragment.getDirectoryFragmentOrSpecifiedParent((IModelServiceProvider)msp, (IDirectoryPath)this, (String)relPath, (DirectoryFragment.IDirectoryFragmentCreator)new DirectoryFragment.IDirectoryFragmentCreator(){

            public DirectoryFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                return new CppDirectoryFragment(msp, parent, name);
            }
        });
        CppExternalHeaderFile header = new CppExternalHeaderFile(this.getModelServiceProvider(), parent.getNamedElement(), file);
        parent.getNamedElement().addChild((NamedElement)header);
        return header;
    }

    public String getInformation() {
        int numberOfFiles = this.getNumberOfFiles();
        return numberOfFiles != -1 ? numberOfFiles + " header file(s) found" : "";
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppIncludeDirectory(this);
        } else {
            super.accept(visitor);
        }
    }

    public boolean ignoreInModelRepresentation() {
        return false;
    }

    public IStructureItem getStructureItem() {
        return CPlusPlusStructureItem.ROOT_DIRECTORY_PATH;
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppIncludeDirectory(CppIncludeDirectory var1);
    }
}

