/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssueWithDescription;
import java.io.IOException;

public abstract class CPlusPlusIssueWithDescriptionLineAndColumn
extends CPlusPlusIssueWithDescription {
    private int m_line;
    private int m_column;

    public CPlusPlusIssueWithDescriptionLineAndColumn() {
    }

    public CPlusPlusIssueWithDescriptionLineAndColumn(NamedElement element, String description, int line, int column) {
        super(element, description);
        this.m_line = line;
        this.m_column = column;
    }

    @Override
    public final int getLineNumber() {
        return this.m_line;
    }

    public final int getColumn() {
        return this.m_column;
    }

    public String getDescriptorContribution() {
        return HashSupport.MD5.getHexString(this.getDescription());
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_line);
        writer.writeInt(this.m_column);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_line = reader.readInt();
        this.m_column = reader.readInt();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(((Object)((Object)this)).getClass().getName()).append(": ");
        result.append(this.getDescription()).append(" (").append(this.getLineNumber()).append(", ").append(this.getColumn()).append(")\n");
        return result.toString();
    }
}

