/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.TemplateUtility;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.settings.InstallationConfigCause;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.TDirectoryFileFilter;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.windows.VisualStudioInstallationsDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CppExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.IVisualStudioInstallationsExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.settings.ICPlusPlusInstallationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VisualStudioInstallationsExtension
extends CppExtension
implements IVisualStudioInstallationsExtension {
    public static final String INSTALLATION_DIR = "instDir";
    public static final String ARCHITECTURE = "arch";
    private static final Logger LOGGER = LoggerFactory.getLogger(VisualStudioInstallationsExtension.class);
    private static final String LOCATION_FILE = "VisualStudioLocations.txt";
    private static final String GENERATED_DEFINITIONS_PATH = "generated";
    private static final String OPTSPY = "optspy";
    private static final String OPTSPY_C = "optspy.c";
    private static final String OPTSPY_EXE = "optspy.exe";
    private static final String PROPERTY_DESCRIPTION = "description";
    private static final String PROPERTY_OPTIONS = "Options";
    private static final String COMPILER_DEF_TEMPLATE = "compilerDefinition/VisualCpp.cdef";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+)[\\.\\d]+.*");
    private final Installation m_installation;
    private final TFile m_cppHomeDirectory;
    private final List<VisualStudioInstallationsDetector.Location> m_locations = new ArrayList<VisualStudioInstallationsDetector.Location>();
    private final TFile m_configDirectory;

    public VisualStudioInstallationsExtension(Installation installation, TFile cppHomeDirectory) {
        TFile locationsFile;
        assert (installation != null);
        assert (cppHomeDirectory != null && cppHomeDirectory.isDirectory());
        this.m_installation = installation;
        this.m_cppHomeDirectory = cppHomeDirectory;
        this.m_configDirectory = new TFile((File)this.m_cppHomeDirectory, GENERATED_DEFINITIONS_PATH);
        if (!this.m_configDirectory.isDirectory()) {
            this.m_configDirectory.mkdir();
        }
        if ((locationsFile = new TFile((File)this.m_cppHomeDirectory, LOCATION_FILE)).canRead()) {
            try {
                for (String line : FileUtility.getFileLinesWithoutLineBreaks((TFile)locationsFile)) {
                    String[] fields = line.split(";");
                    if (fields.length == 2) {
                        this.m_locations.add(new VisualStudioInstallationsDetector.Location(fields[0].trim(), new TFile(fields[1].trim())));
                        continue;
                    }
                    LOGGER.warn("Ignoring locations line: " + line);
                }
            }
            catch (IOException e) {
                LOGGER.error("Unexpected exception while reading " + locationsFile.getPath(), (Throwable)e);
            }
        }
    }

    @Override
    public String getDefaultVisualCppCompilerDefinition() {
        double highestVersion = 0.0;
        String highestVersionString = null;
        for (VisualStudioInstallationsDetector.Location loc : this.m_locations) {
            String v = loc.getVersion();
            double version = Double.valueOf(v);
            if (!(version > highestVersion)) continue;
            highestVersion = version;
            highestVersionString = v;
        }
        if (highestVersionString == null) {
            return null;
        }
        return this.generateDefinitionName(highestVersionString, "x86");
    }

    @Override
    public List<VisualStudioInstallationsDetector.Location> getInstallationLocations() {
        return Collections.unmodifiableList(this.m_locations);
    }

    static List<String> readOutput(InputStream input) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    static String extractVersion(List<String> lines) {
        for (String line : lines) {
            int pos = line.indexOf("Microsoft (R) C/C++");
            if (pos < 0) continue;
            line = line.substring(pos + 19);
            pos = 0;
            while (pos < line.length()) {
                Matcher matcher;
                if (Character.isDigit(line.charAt(pos)) && (matcher = VERSION_PATTERN.matcher(line.substring(pos))).matches()) {
                    return matcher.group(1);
                }
                ++pos;
            }
        }
        return null;
    }

    public static TFile getVcVarsallBat(TFile visualStudioInstallationDirectory) {
        assert (visualStudioInstallationDirectory != null) : "Parameter 'visualStudioInstallationDirectory' of method 'getShellPath' must not be null";
        OperationResult result = new OperationResult("Getting installation descriptor");
        InstallationDescriptor descriptor = VisualStudioInstallationsExtension.getInstallationDescriptor(visualStudioInstallationDirectory, result);
        if (result.isSuccess()) {
            return descriptor.getPath();
        }
        return null;
    }

    private static InstallationDescriptor getInstallationDescriptor(TFile location, OperationResult result) {
        assert (location != null) : "Parameter 'location' of method 'getInstallationDescriptor' must not be null";
        assert (result != null) : "Parameter 'result' of method 'getInstallationDescriptor' must not be null";
        TFile path = new TFile((File)location, "vcvarsall.bat");
        if (!path.isFile()) {
            path = new TFile((File)location, "VC\\vcvarsall.bat");
        }
        if (!path.isFile()) {
            path = new TFile((File)location, "VC\\Auxiliary\\Build\\vcvarsall.bat");
            if (!path.isFile()) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, path.getAbsolutePath() + " does not exist", new Object[0]);
                return null;
            }
            return new InstallationDescriptor(path, true);
        }
        return new InstallationDescriptor(path, false);
    }

    @Override
    public String determineVersion(TFile location, OperationResult result) {
        assert (location != null) : "Parameter 'location' of method 'determineVersion' must not be null";
        InstallationDescriptor descriptor = VisualStudioInstallationsExtension.getInstallationDescriptor(location, result);
        if (descriptor == null) {
            return null;
        }
        String version = null;
        try {
            Process process = new ProcessBuilder(descriptor.getPath().getPath(), "x64", "&&", "cl").start();
            List<String> lines = VisualStudioInstallationsExtension.readOutput(process.getInputStream());
            lines.addAll(VisualStudioInstallationsExtension.readOutput(process.getErrorStream()));
            version = VisualStudioInstallationsExtension.extractVersion(lines);
            if (version == null) {
                result.addError((OperationResult.IMessageCause)InstallationConfigCause.CANNOT_EXTRACT_VERSION, "Cannot extract version from 'cl' output: " + lines.toString(), new Object[0]);
            }
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Unexpected exception while trying to determine CL version in " + location.getPath(), (Throwable)e);
        }
        return version;
    }

    @Override
    public OperationResult updateLocations(IWorkerContext workerContext, List<VisualStudioInstallationsDetector.Location> added, List<VisualStudioInstallationsDetector.Location> removed) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'updateLocations' must not be null";
        assert (added != null) : "Parameter 'added' of method 'updateLocations' must not be null";
        assert (removed != null) : "Parameter 'removed' of method 'updateLocations' must not be null";
        OperationResult result = new OperationResult("Updating Visual Studio installation locactions");
        TFile optSpySource = null;
        try {
            optSpySource = this.writeOptSpySource();
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)CppCauses.VS_COMPILER_DEF_GENERATION_FAILURE, (Throwable)e, "Compiler definition generation failed", new Object[0]);
            return result;
        }
        for (VisualStudioInstallationsDetector.Location loc : added) {
            if (!this.generateCompilerDefinitionsFor(workerContext, result, loc)) continue;
            this.m_locations.add(loc);
        }
        try {
            optSpySource.rm();
        }
        catch (IOException loc) {
            // empty catch block
        }
        ICPlusPlusInstallationExtension instExt = (ICPlusPlusInstallationExtension)this.m_installation.getExtension(ICPlusPlusInstallationExtension.class);
        for (VisualStudioInstallationsDetector.Location loc : removed) {
            this.m_locations.remove(loc);
            this.removeCompilerDefinitionsFor(workerContext, result, instExt, loc);
        }
        TFile locationsFile = new TFile((File)this.m_cppHomeDirectory, LOCATION_FILE);
        try {
            Object object = null;
            Object var9_13 = null;
            try (PrintWriter writer = new PrintWriter((Writer)new TFileWriter(locationsFile));){
                for (VisualStudioInstallationsDetector.Location loc : this.m_locations) {
                    writer.print(loc.getVersion());
                    writer.print(";");
                    writer.println(loc.getFile().getPath());
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)CppCauses.VS_COMPILER_DEF_GENERATION_FAILURE, "Problem writing to " + locationsFile.getPath(), new Object[0]);
            LOGGER.error("Failed to write " + locationsFile.getPath(), (Throwable)e);
        }
        return result;
    }

    private void removeCompilerDefinitionsFor(IWorkerContext workerContext, OperationResult result, ICPlusPlusInstallationExtension instExt, VisualStudioInstallationsDetector.Location loc) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'removeCompilerDefinitionsFor' must not be null";
        assert (result != null) : "Parameter 'result' of method 'removeCompilerDefinitionsFor' must not be null";
        assert (instExt != null) : "Parameter 'instExt' of method 'removeCompilerDefinitionsFor' must not be null";
        assert (loc != null) : "Parameter 'loc' of method 'removeCompilerDefinitionsFor' must not be null";
        String prefix = this.generateDefinitionName(loc.getVersion(), "");
        TFile[] files = this.m_configDirectory.listFiles();
        if (files == null) {
            result.addError((OperationResult.IMessageCause)CppCauses.VS_COMPILER_DEF_GENERATION_FAILURE, "Could not find any generated compiler definitions", new Object[0]);
            return;
        }
        workerContext.working("Removing compiler definitions for CL " + loc.getVersion() + "...", true);
        TFile[] tFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            TFile file = tFileArray[n2];
            if (file.getName().startsWith(prefix)) {
                try {
                    if (file.isDirectory()) {
                        file.rm_r();
                    } else {
                        String defName = FileUtility.getFileNameWithoutExtension((TFile)file);
                        instExt.forgetCompilerDefinition(defName);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Could not delete " + file.getPath(), (Throwable)e);
                }
            }
            ++n2;
        }
    }

    private boolean generateCompilerDefinitionsFor(IWorkerContext workerContext, OperationResult result, VisualStudioInstallationsDetector.Location location) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'generateCompilerDefinitionsFor' must not be null";
        assert (result != null) : "Parameter 'result' of method 'generateCompilerDefinitionsFor' must not be null";
        assert (location != null) : "Parameter 'location' of method 'generateCompilerDefinitionsFor' must not be null";
        LOGGER.info("Generating compiler definition for location {}", (Object)location.getFile());
        InstallationDescriptor descriptor = VisualStudioInstallationsExtension.getInstallationDescriptor(location.getFile(), result);
        if (descriptor == null) {
            String msg = "Could not find valid Visual Studio installation at " + location.getFile().getPath();
            result.addError((OperationResult.IMessageCause)CppCauses.VS_COMPILER_DEF_GENERATION_FAILURE, msg, new Object[0]);
            LOGGER.error(msg);
            return false;
        }
        if (descriptor.isIs2017orNewer()) {
            return this.generateArchitectureDefinitionsForVS2017OrNewer(workerContext, result, location, descriptor);
        }
        return this.generateArchitectureDefinitionsForClassicVS(workerContext, result, location, descriptor);
    }

    private boolean generateArchitectureDefinitionsForClassicVS(IWorkerContext workerContext, OperationResult result, VisualStudioInstallationsDetector.Location location, InstallationDescriptor descriptor) {
        TFile[] dirs;
        boolean success;
        String arch;
        block9: {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'generateArchitectureDefinitionsForClassicVS' must not be null";
            assert (result != null) : "Parameter 'result' of method 'generateArchitectureDefinitionsForClassicVS' must not be null";
            assert (location != null) : "Parameter 'location' of method 'generateArchitectureDefinitionsForClassicVS' must not be null";
            assert (descriptor != null) : "Parameter 'descriptor' of method 'generateArchitectureDefinitionsForClassicVS' must not be null";
            arch = "x86";
            success = false;
            this.generateConfigurationFor(workerContext, result, location, descriptor, arch);
            TFile binDir = new TFile((File)new TFile((File)location.getFile(), "vc"), "bin");
            dirs = binDir.listFiles((FileFilter)new TDirectoryFileFilter());
            if (dirs != null) break block9;
            return false;
        }
        try {
            TFile[] tFileArray = dirs;
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                TFile cl;
                TFile nextDir = tFileArray[n2];
                if (!nextDir.getName().contains("arm") && (cl = new TFile((File)nextDir, "cl.exe")).exists() && this.generateConfigurationFor(workerContext, result, location, descriptor, arch = nextDir.getName()) != null) {
                    success = true;
                }
                ++n2;
            }
        }
        catch (IOException | InterruptedException e) {
            result.addError((OperationResult.IMessageCause)CppCauses.VS_COMPILER_DEF_GENERATION_FAILURE, "Failed to generate compiler definition for " + arch + ": " + e.getMessage(), new Object[0]);
        }
        return success;
    }

    private boolean generateArchitectureDefinitionsForVS2017OrNewer(IWorkerContext workerContext, OperationResult result, VisualStudioInstallationsDetector.Location loc, InstallationDescriptor id) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'generateArchitectureDefinitionsForVS2017OrNewer' must not be null";
        assert (result != null) : "Parameter 'result' of method 'generateArchitectureDefinitionsForVS2017OrNewer' must not be null";
        assert (loc != null) : "Parameter 'loc' of method 'generateArchitectureDefinitionsForVS2017OrNewer' must not be null";
        assert (id != null) : "Parameter 'id' of method 'generateArchitectureDefinitionsForVS2017OrNewer' must not be null";
        Pattern pattern = Pattern.compile("Host(.+)");
        TFile compilerRootDir = new TFile((File)loc.getFile(), "VC/Tools/MSVC");
        boolean success = false;
        TFile[] tFileArray = compilerRootDir.listFiles((FileFilter)new TDirectoryFileFilter());
        int n = tFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            TFile compilerDir = tFileArray[n2];
            TFile binDir = new TFile((File)compilerDir, "bin");
            if (binDir.exists()) {
                TFile[] tFileArray2 = binDir.listFiles((FileFilter)new TDirectoryFileFilter());
                int n3 = tFileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TFile hostDir = tFileArray2[n4];
                    String folderName = hostDir.getName();
                    Matcher matcher = pattern.matcher(folderName);
                    if (matcher.find()) {
                        String host = matcher.group(1).toLowerCase();
                        TFile[] tFileArray3 = hostDir.listFiles((FileFilter)new TDirectoryFileFilter());
                        int n5 = tFileArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            TFile targetArch = tFileArray3[n6];
                            String targetArchitectureName = targetArch.getName().toLowerCase();
                            if (!targetArchitectureName.contains("arm")) {
                                Object arch = host.equals(targetArchitectureName) ? host : host + "_" + targetArchitectureName;
                                try {
                                    if (this.generateConfigurationFor(workerContext, result, loc, id, (String)arch) != null) {
                                        success = true;
                                    }
                                }
                                catch (IOException | InterruptedException e) {
                                    result.addError((OperationResult.IMessageCause)CppCauses.VS_COMPILER_DEF_GENERATION_FAILURE, "Failed to generate compiler definition for " + (String)arch + ": " + e.getMessage(), new Object[0]);
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return success;
    }

    private TFile writeOptSpySource() throws IOException {
        InputStream s = this.getClass().getClassLoader().getResourceAsStream(OPTSPY_C);
        TFile cSourceFile = new TFile((File)this.m_configDirectory, OPTSPY_C);
        if (cSourceFile.exists()) {
            cSourceFile.rm();
        }
        byte[] bytes = new byte[4046];
        int len = s.read(bytes);
        assert (len > 0 && len < bytes.length);
        String optSpySource = new String(bytes, 0, len);
        FileUtility.writeFileContent((String)optSpySource, (TFile)cSourceFile);
        return cSourceFile;
    }

    private String generateFileName(String version, String arch) {
        return this.generateDefinitionName(version, arch) + ".cdef";
    }

    private String generateDefinitionName(String version, String arch) {
        return "VisualCpp_" + version + "_" + arch;
    }

    private String nextToken(StringReader reader) throws IOException {
        StringWriter writer = new StringWriter();
        int c = reader.read();
        while (c > 0 && Character.isWhitespace(c)) {
            c = reader.read();
        }
        if (c < 0) {
            return null;
        }
        if (c == 34) {
            c = reader.read();
            while (c != 34) {
                assert (c > 0);
                writer.write(c);
                c = reader.read();
            }
            return writer.toString();
        }
        writer.write(c);
        c = reader.read();
        while (c > 0 && c != 32) {
            writer.write(c);
            c = reader.read();
        }
        return writer.toString();
    }

    private List<String> parseOptions(Map<String, Object> props, String val) throws IOException {
        String token;
        assert (props != null) : "Parameter 'props' of method 'parseOptions' must not be null";
        assert (val != null && val.length() > 0) : "Parameter 'val' of method 'parseOptions' must not be empty";
        ArrayList<String> opts = new ArrayList<String>();
        StringReader reader = new StringReader(val);
        while ((token = this.nextToken(reader)) != null) {
            if (token.startsWith("-D")) {
                opts.add(token);
                if (!token.startsWith("-D_MSC_VER=")) continue;
                props.put("version", token.substring(11));
                continue;
            }
            if (token.equals("-I")) {
                opts.add(this.nextToken(reader));
                continue;
            }
            if (!token.startsWith("-I")) continue;
            opts.add(token.substring(2));
        }
        return opts;
    }

    private Map<String, Object> analyzeCompilerOutput(List<String> output) throws IOException {
        assert (output != null) : "Parameter 'output' of method 'analyzeCompilerOutput' must not be null";
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        for (String it : output) {
            if (it.contains("Microsoft (R)")) {
                propertiesMap.put(PROPERTY_DESCRIPTION, it);
                continue;
            }
            int eqPos = it.indexOf(61);
            if (eqPos <= 0) continue;
            String key = it.substring(0, eqPos);
            String val = it.substring(eqPos + 1);
            if (!key.equals("MSC_CMD_FLAGS")) {
                propertiesMap.put(key, val);
                continue;
            }
            propertiesMap.put(PROPERTY_OPTIONS, this.parseOptions(propertiesMap, val));
        }
        if (propertiesMap.get(PROPERTY_DESCRIPTION) == null) {
            propertiesMap.put(PROPERTY_DESCRIPTION, "");
        }
        if (propertiesMap.get(PROPERTY_OPTIONS) == null) {
            propertiesMap.put(PROPERTY_OPTIONS, Collections.emptyList());
        }
        return propertiesMap;
    }

    private TFile generateConfigurationFor(IWorkerContext workerContext, OperationResult opResult, VisualStudioInstallationsDetector.Location location, InstallationDescriptor descriptor, String arch) throws IOException, InterruptedException {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'generateConfigurationFor' must not be null";
        assert (opResult != null) : "Parameter 'opResult' of method 'generateConfigurationFor' must not be null";
        assert (location != null) : "Parameter 'location' of method 'generateConfigurationFor' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'generateConfigurationFor' must not be null";
        assert (arch != null && arch.length() > 0) : "Parameter 'arch' of method 'generateConfigurationFor' must not be empty";
        String version = location.getVersion();
        TFile compilerConfigDir = new TFile((File)this.m_configDirectory, this.generateDefinitionName(version, arch));
        String fileName = this.generateFileName(version, arch);
        workerContext.working("Generating compiler definition for CL " + location.getVersion() + " (" + arch + ")", true);
        LOGGER.info("Generate C++ Compiler Definition '" + fileName + "', location '" + String.valueOf(location.getFile()) + "' in directory '" + this.m_configDirectory.getAbsolutePath() + "'");
        compilerConfigDir.mkdir();
        TFile configProperties = new TFile((File)compilerConfigDir, "config.properties");
        if (configProperties.exists()) {
            configProperties.rm();
        }
        String instDirStr = location.getFile().getPath().replace("\\", "\\\\");
        String config = "instDir=" + instDirStr + StringUtility.LINE_SEPARATOR + "arch=" + arch + StringUtility.LINE_SEPARATOR;
        FileUtility.writeFileContent((String)config, (TFile)configProperties);
        ArrayList<String> baseCommand = new ArrayList<String>();
        baseCommand.add(descriptor.getPath().getPath());
        baseCommand.add(arch);
        baseCommand.add("&&");
        baseCommand.add("cl");
        ArrayList<String> createExecutableCommand = new ArrayList<String>(baseCommand);
        createExecutableCommand.add("/MD");
        createExecutableCommand.add("-Fo" + new TFile((File)compilerConfigDir, "optspy.obj").getPath());
        createExecutableCommand.add("-Fe" + new TFile((File)compilerConfigDir, OPTSPY_EXE).getPath());
        createExecutableCommand.add(new TFile((File)this.m_configDirectory, OPTSPY_C).getPath());
        LOGGER.debug("Executing: {}", createExecutableCommand);
        Process proc = new ProcessBuilder(createExecutableCommand).start();
        List<String> output = VisualStudioInstallationsExtension.readOutput(proc.getErrorStream());
        output.addAll(VisualStudioInstallationsExtension.readOutput(proc.getInputStream()));
        int result = proc.waitFor();
        TFile objFile = new TFile((File)compilerConfigDir, "optspy.obj");
        if (objFile.exists()) {
            objFile.rm();
        }
        if (result != 0) {
            String msg = "Cannot compile or link optspy: " + StringUtility.concat(output, (String)StringUtility.LINE_SEPARATOR) + StringUtility.LINE_SEPARATOR;
            LOGGER.error(msg);
            opResult.addError((OperationResult.IMessageCause)CppCauses.VS_COMPILER_DEF_GENERATION_FAILURE, "optspy failed for architecture " + arch, new Object[0]);
            compilerConfigDir.rm_r();
            return null;
        }
        ArrayList<String> createCOptionsCommand = new ArrayList<String>(baseCommand);
        createCOptionsCommand.add("-B1" + new TFile((File)compilerConfigDir, OPTSPY_EXE).getPath());
        createCOptionsCommand.add("x.c");
        LOGGER.debug("Executing: {}", createCOptionsCommand);
        proc = new ProcessBuilder(createCOptionsCommand).start();
        output = VisualStudioInstallationsExtension.readOutput(proc.getErrorStream());
        output.addAll(VisualStudioInstallationsExtension.readOutput(proc.getInputStream()));
        result = proc.waitFor();
        String outputString = StringUtility.concat(output, (String)StringUtility.LINE_SEPARATOR) + StringUtility.LINE_SEPARATOR;
        if (result < 0) {
            LOGGER.error("Failed to execute command for analyzing C options for " + version + ", " + arch + ": " + outputString);
        } else {
            LOGGER.debug("C compiler output: " + outputString);
        }
        Map<String, Object> cProperties = this.analyzeCompilerOutput(output);
        List cOptions = (List)cProperties.get(PROPERTY_OPTIONS);
        if (cOptions.isEmpty()) {
            LOGGER.warn("No C options determined for compiler: architecture '" + arch + "', version '" + version + "'. \nCompiler output: " + outputString);
        }
        ArrayList<String> createCppOptionsCommand = new ArrayList<String>(baseCommand);
        createCppOptionsCommand.add("-Bx" + new TFile((File)compilerConfigDir, OPTSPY_EXE).getPath());
        createCppOptionsCommand.add("x.cpp");
        LOGGER.debug("Executing: {}", createCppOptionsCommand);
        proc = new ProcessBuilder(createCppOptionsCommand).start();
        output = VisualStudioInstallationsExtension.readOutput(proc.getErrorStream());
        output.addAll(VisualStudioInstallationsExtension.readOutput(proc.getInputStream()));
        result = proc.waitFor();
        outputString = StringUtility.concat(output, (String)StringUtility.LINE_SEPARATOR) + StringUtility.LINE_SEPARATOR;
        if (result < 0) {
            LOGGER.error("Failed to execute command for analyzing C++ options: " + outputString);
        } else {
            LOGGER.debug("C++ compiler output: " + outputString);
        }
        Map<String, Object> cppProperties = this.analyzeCompilerOutput(output);
        List cppOptions = (List)cppProperties.get(PROPERTY_OPTIONS);
        if (cppOptions.isEmpty()) {
            LOGGER.warn("No C++ options determined for compiler: architecture '" + arch + "', version '" + version + "'. \nCompiler output: " + outputString);
        }
        ArrayList<String> sharedOptions = new ArrayList<String>();
        for (String opt : cOptions) {
            if (!cppOptions.contains(opt)) continue;
            sharedOptions.add(opt);
        }
        cOptions.removeAll(sharedOptions);
        cppOptions.removeAll(sharedOptions);
        Map<String, Object> props = cProperties;
        props.remove(PROPERTY_OPTIONS);
        props.put("sharedOptions", sharedOptions);
        props.put("cOptions", cOptions);
        props.put("cppOptions", cppOptions);
        ArrayList<CallSite> fixedProps = new ArrayList<CallSite>();
        fixedProps.add((CallSite)((Object)("instDir=" + location.getFile().getPath())));
        fixedProps.add((CallSite)((Object)("arch=" + arch)));
        props.put("fixedProperties", fixedProps);
        InputStream templateStream = this.getClass().getClassLoader().getResourceAsStream(COMPILER_DEF_TEMPLATE);
        StringBuilder writer = new StringBuilder();
        Throwable throwable = null;
        Object var31_33 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(templateStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.append(line).append('\n');
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        TFile compilerDefinitionFile = new TFile((File)this.m_configDirectory, fileName);
        try {
            String expandedTemplate = TemplateUtility.expandTemplateText((String)writer.toString(), props);
            FileUtility.writeFileContent((String)expandedTemplate, (TFile)compilerDefinitionFile);
        }
        catch (Throwable t) {
            LOGGER.error("Fail to expand C++ Visual Studio compiler definition groovy template: {}", (Object)ExceptionUtility.collectFirstAndLast((Throwable)t));
            if (compilerDefinitionFile.exists()) {
                compilerDefinitionFile.rm();
            }
            opResult.addError((OperationResult.IMessageCause)CppCauses.VS_COMPILER_DEF_GENERATION_FAILURE, "Groovy template error for architecture " + arch, new Object[0]);
            return null;
        }
        return compilerDefinitionFile;
    }

    private static class InstallationDescriptor {
        private final TFile m_shellPath;
        private final boolean m_is2017orNewer;

        public InstallationDescriptor(TFile shellPath, boolean is2017orNewer) {
            this.m_shellPath = shellPath;
            this.m_is2017orNewer = is2017orNewer;
        }

        public TFile getPath() {
            return this.m_shellPath;
        }

        boolean isIs2017orNewer() {
            return this.m_is2017orNewer;
        }
    }
}

