/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.IBooleanValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementProxy;
import com.hello2morrow.sonargraph.core.model.event.ConfigurationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SearchPathModifiedEvent;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SignatureElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.settings.InstallationSearchPath;
import com.hello2morrow.sonargraph.core.model.system.settings.InstallationSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathDelta;
import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathValidator;
import com.hello2morrow.sonargraph.core.persistence.system.settings.SearchPathFilePersistence;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.SearchPath;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CPlusPlusSoftwareSystemSettingsExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CppSearchPathValidator;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.IVisualStudioInstallationsExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.InstCompilerDefinitionActiveValidator;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.InstCompilerDefinitionNameValidator;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.NoActiveCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.settings.ICPlusPlusInstallationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusResourceProviderAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssueId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.AnyCompiler;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.BuiltInCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusInstallationSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionModel;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionSearchPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GeneratedInstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerDefinitionPersistence;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IPersistenceProviderFactory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionBuilder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionDelta;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionFromFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.CppCompilerDefinitionSearchPathIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.installation.CompilerDefinitionPersistenceProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.installation.PersistenceProviderFactory;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CPlusPlusInstallationExtension
extends Extension
implements ICPlusPlusInstallationExtension {
    static final String CPP_CONFIG_FILENAME = "CPlusPlusConfiguration.properties";
    private static final String BUILT_IN_PREFIX = "CPlusPlus:";
    private static final String GENERATED_DEFINITIONS_PATH = "generated";
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusInstallationExtension.class);
    private final TFile m_sonargraphCppHome;
    private final Installation m_installation;
    private final IPersistenceProviderFactory m_persistenceFactory;
    private final String m_generatedDefinitionPath;
    private String m_activeDefinitionId;
    private boolean m_useCompilerDefinitionProperty = true;
    private boolean m_initialized = false;

    public CPlusPlusInstallationExtension(Installation installation, TFile cppUserHomeDir, String generatedDefinitionPath) {
        this(installation, cppUserHomeDir, generatedDefinitionPath, PersistenceProviderFactory.INSTANCE);
    }

    public CPlusPlusInstallationExtension(Installation installation, TFile cppUserHomeDir, String generatedDefinitionPath, IPersistenceProviderFactory providerFactory) {
        assert (installation != null) : "Parameter 'installation' of method 'InstallationSettingsProvider' must not be null";
        assert (cppUserHomeDir != null) : "Parameter 'cppUserHomeDir' of method 'InstallationSettingsProvider' must not be null";
        assert (providerFactory != null) : "Parameter 'providerFactory' of method 'CppInstallationSettingsProvider' must not be null";
        this.m_installation = installation;
        this.m_sonargraphCppHome = cppUserHomeDir;
        this.m_persistenceFactory = providerFactory;
        this.m_generatedDefinitionPath = generatedDefinitionPath;
    }

    public void useCompilerDefinitionProperty(boolean use) {
        this.m_useCompilerDefinitionProperty = use;
    }

    @Override
    public boolean useCompilerDefintionProperty() {
        return this.m_useCompilerDefinitionProperty;
    }

    TFile getGeneratedCompilerDefinitionDir() {
        if (this.m_generatedDefinitionPath == null) {
            return new TFile((File)this.m_sonargraphCppHome, GENERATED_DEFINITIONS_PATH);
        }
        return new TFile(this.m_generatedDefinitionPath);
    }

    @Override
    public ITextValidator getDefinitionNameValidator() {
        HashSet<String> definitionNames = new HashSet<String>(this.listAvailableCompilerDefinitionIds());
        return new InstCompilerDefinitionNameValidator(definitionNames);
    }

    @Override
    public IBooleanValidator<InstCompilerDefinition> getActiveDefinitionValidator() {
        return new InstCompilerDefinitionActiveValidator();
    }

    private Set<String> getGeneratedDefinitions() {
        if (!Platform.isWindows()) {
            return Collections.emptySet();
        }
        TFile[] files = this.getGeneratedCompilerDefinitionDir().listFiles();
        if (files == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        TFile[] tFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            TFile file = tFileArray[n2];
            if (file.isFile() && file.getName().endsWith(".cdef")) {
                result.add(FileUtility.getFileNameWithoutExtension((TFile)file));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public void forgetCompilerDefinition(String id) {
        assert (id != null && id.length() > 0);
        CPlusPlusInstallationSettings settings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        InstCompilerDefinition definition = (InstCompilerDefinition)((Object)settings.getUniqueChild((NamedElement.IFilter)new NameFilter(id), InstCompilerDefinition.class));
        if (definition != null) {
            this.delete(definition);
        }
    }

    public void finishInstallationInitialization() {
        CPlusPlusInstallationSettings settings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        assert (settings == null) : "No child of type '" + CPlusPlusInstallationSettings.class.getName() + "' expected";
        settings = new CPlusPlusInstallationSettings(this.m_installation);
        this.m_installation.addChild((NamedElement)settings);
        CompilerDefinitionSearchPath searchPath = new CompilerDefinitionSearchPath((NamedElement)settings, this.m_sonargraphCppHome);
        settings.addChild((NamedElement)searchPath);
        if (!this.m_sonargraphCppHome.exists()) {
            this.m_sonargraphCppHome.mkdirs();
        }
        assert (this.m_sonargraphCppHome.exists());
        TFile configFile = this.getConfigurationFile();
        if (configFile.exists()) {
            String instSpecDirPath;
            SearchPathFilePersistence preferenceProvider = (SearchPathFilePersistence)this.m_persistenceFactory.createPreferenceProvider(configFile);
            OperationResult result = new OperationResult("Load C,C++ preferences");
            preferenceProvider.load(result);
            if (result.isFailure()) {
                searchPath.addIssue((Issue)new CppCompilerDefinitionSearchPathIssue((NamedElement)searchPath, result.getDescription()));
            }
            if ((instSpecDirPath = preferenceProvider.getValue("installationSpecificCompilerDefinitionsDir")) == null || instSpecDirPath.trim().length() == 0) {
                searchPath.setInstSpecificDir(this.m_sonargraphCppHome);
            } else {
                TFile instSpecDir = new TFile(instSpecDirPath);
                if (!instSpecDir.exists() || !instSpecDir.isDirectory()) {
                    String msg = "Specified path '" + instSpecDirPath + "' for installation specific compiler definitions points to an invalid directory";
                    searchPath.addIssue((Issue)new CppCompilerDefinitionSearchPathIssue((NamedElement)searchPath, msg));
                    LOGGER.warn((String)msg + "; using the default directory '" + this.m_sonargraphCppHome.getNormalizedAbsolutePath() + "'");
                    searchPath.setInstSpecificDir(this.m_sonargraphCppHome);
                } else {
                    searchPath.setInstSpecificDir(instSpecDir);
                }
            }
            for (TFile dir : preferenceProvider.getSearchPath().getDirectories()) {
                searchPath.getSearchPath().add(dir);
            }
            String activeDefinitionId = preferenceProvider.getValue("activeCompilerDefinition");
            if (activeDefinitionId != null && activeDefinitionId.trim().length() > 0) {
                OperationResultWithOutcome<InstCompilerDefinition> activeDefinitionResult = this.getCompilerDefinition(activeDefinitionId);
                if (activeDefinitionResult.isFailure() || activeDefinitionResult.getOutcome() == null) {
                    String msg = "C++ compiler definition '" + activeDefinitionId + "' cannot be set as active definition. Applying default definition if possible.";
                    LOGGER.warn(msg);
                    String defaultDefinitionId = this.getDefaultDefinitionIdForPlatform();
                    if (defaultDefinitionId != null) {
                        OperationResult setActiveDefinitionResult = this.setActiveCompilerDefinitionId(defaultDefinitionId);
                        if (setActiveDefinitionResult.isFailure()) {
                            settings.addIssue((Issue)new NoActiveCompilerDefinition((NamedElement)settings));
                        }
                    } else {
                        settings.addIssue((Issue)new NoActiveCompilerDefinition((NamedElement)settings));
                    }
                } else {
                    this.setActiveCompilerDefinition((InstCompilerDefinition)((Object)activeDefinitionResult.getOutcome()));
                }
                this.m_initialized = true;
                return;
            }
        }
        this.initActiveDefinitionForOs();
        LOGGER.debug("C++ configuration file '" + configFile.getAbsolutePath() + "' does not exist. Working with default installation settings only.");
        this.m_initialized = true;
    }

    @Override
    public OperationResult persistConfiguration() {
        if (!this.m_sonargraphCppHome.exists()) {
            this.m_sonargraphCppHome.mkdir();
        }
        CPlusPlusInstallationSettings settings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        assert (settings != null) : "CppInstallationSettings must exist as child of Installation root";
        InstCompilerDefinition activeDefinition = this.getActiveCompilerDefinition();
        OperationResult result = new OperationResult("Persist C++ configuration");
        TFile configFile = new TFile((File)this.m_sonargraphCppHome, CPP_CONFIG_FILENAME);
        SearchPathFilePersistence preferenceProvider = (SearchPathFilePersistence)this.m_persistenceFactory.createPreferenceProvider(configFile);
        InstallationSearchPath cppSearchPath = (InstallationSearchPath)settings.getUniqueChild(CompilerDefinitionSearchPath.class);
        preferenceProvider.setSearchPath(cppSearchPath.getSearchPath());
        String activeDefinitionId = null;
        activeDefinitionId = activeDefinition == null ? this.getDefaultDefinitionIdForPlatform() : activeDefinition.getName();
        if (activeDefinitionId == null) {
            activeDefinitionId = "";
        }
        preferenceProvider.setValue("activeCompilerDefinition", activeDefinitionId);
        preferenceProvider.setValue("installationSpecificCompilerDefinitionsDir", cppSearchPath.getInstSpecificDir().getNormalizedAbsolutePath());
        preferenceProvider.save(result);
        return result;
    }

    TFile getConfigurationFile() {
        return new TFile((File)this.m_sonargraphCppHome, CPP_CONFIG_FILENAME).getNormalizedAbsoluteFile();
    }

    private InstCompilerDefinition initActiveDefinitionForOs() {
        this.m_activeDefinitionId = this.getDefaultDefinitionIdForPlatform();
        if (this.m_activeDefinitionId == null) {
            this.m_activeDefinitionId = "";
        }
        OperationResultWithOutcome<InstCompilerDefinition> loadDefResult = this.getCompilerDefinition(this.m_activeDefinitionId);
        CPlusPlusInstallationSettings settings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        settings.removeIssues(new IIssueId[]{CPlusPlusIssueId.ACTIVE_COMPILER_DEFINITION_MISSING});
        if (loadDefResult.getOutcome() == null) {
            settings.addIssue((Issue)new NoActiveCompilerDefinition((NamedElement)settings));
        } else {
            this.replaceActiveDefinitionElementProxy((InstCompilerDefinition)((Object)loadDefResult.getOutcome()));
        }
        return (InstCompilerDefinition)((Object)loadDefResult.getOutcome());
    }

    private IVisualStudioInstallationsExtension getVisualStudioInstallationsExtension() {
        return (IVisualStudioInstallationsExtension)this.m_installation.getExtension(IVisualStudioInstallationsExtension.class);
    }

    @Override
    public String getDefaultDefinitionIdForPlatform() {
        BuiltInCompilerDefinition cdef = BuiltInCompilerDefinition.getDefaultDefinitionForPlatform();
        return cdef != null ? cdef.getStandardName() : this.getVisualStudioInstallationsExtension().getDefaultVisualCppCompilerDefinition();
    }

    private OperationResultWithOutcome<Map<String, InstCompilerDefinition>> loadBuiltInCompilerDefinitions() {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading built in C++ compiler definitions");
        HashMap<String, InstCompilerDefinition> definitions = new HashMap<String, InstCompilerDefinition>();
        BuiltInCompilerDefinition[] builtInCompilerDefinitionArray = BuiltInCompilerDefinition.values();
        int n = builtInCompilerDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltInCompilerDefinition definition = builtInCompilerDefinitionArray[n2];
            if (definition.isWindows() == Platform.isWindows()) {
                String definitionId = definition.getStandardName();
                OperationResultWithOutcome<InstCompilerDefinition> loadResult = this.loadBuildInDefinition(definitionId);
                result.addMessagesFrom(loadResult);
                if (loadResult.getOutcome() != null) {
                    InstCompilerDefinition def = (InstCompilerDefinition)((Object)loadResult.getOutcome());
                    definitions.put(def.getName(), def);
                }
            }
            ++n2;
        }
        result.setOutcome(definitions);
        return result;
    }

    public List<String> listAvailableCompilerDefinitionIds() {
        ArrayList<String> availableDefinitionIds = new ArrayList<String>();
        BuiltInCompilerDefinition[] builtInCompilerDefinitionArray = BuiltInCompilerDefinition.values();
        int n = builtInCompilerDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltInCompilerDefinition definition = builtInCompilerDefinitionArray[n2];
            availableDefinitionIds.add(definition.getStandardName());
            ++n2;
        }
        CPlusPlusInstallationSettings instSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        assert (instSettings != null) : "CppInstallationSettings must have been added as a child previously";
        CompilerDefinitionSearchPath searchPath = (CompilerDefinitionSearchPath)((Object)instSettings.getUniqueChild(CompilerDefinitionSearchPath.class));
        List<TFile> files = searchPath.getCompilerDefinitionFiles();
        for (TFile file : files) {
            availableDefinitionIds.add(FileUtility.getFileNameWithoutExtension((TFile)file));
        }
        return Collections.unmodifiableList(availableDefinitionIds);
    }

    @Override
    public OperationResultWithOutcome<Map<String, InstCompilerDefinition>> loadRelevantDefinitions() {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading effective C++ compiler definitions");
        InstCompilerDefinition activeDefinition = this.getActiveCompilerDefinition();
        CPlusPlusInstallationSettings instSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        assert (instSettings != null) : "CppInstallationSettings must have been added as a child previously";
        List definitions = instSettings.getChildren(InstCompilerDefinition.class);
        for (InstCompilerDefinition definition : definitions) {
            if (((Object)((Object)definition)).equals((Object)activeDefinition) || definition instanceof GeneratedInstCompilerDefinition) continue;
            definition.remove();
        }
        for (String definitionId : this.getGeneratedDefinitions()) {
            if (instSettings.getUniqueChild((NamedElement.IFilter)new NameFilter(definitionId), InstCompilerDefinition.class) != null) continue;
            this.loadCompilerDefinition(definitionId);
        }
        this.m_installation.removeIssuesOfInvalidElements();
        LinkedHashMap<String, InstCompilerDefinition> definitionsMap = new LinkedHashMap<String, InstCompilerDefinition>();
        for (InstCompilerDefinition definition : instSettings.getChildren(InstCompilerDefinition.class)) {
            definitionsMap.put(definition.getName(), definition);
        }
        OperationResultWithOutcome<Map<String, InstCompilerDefinition>> builtInDefResult = this.loadBuiltInCompilerDefinitions();
        result.addMessagesFrom(builtInDefResult);
        if (builtInDefResult.getOutcome() != null) {
            definitionsMap.putAll((Map)builtInDefResult.getOutcome());
        }
        CompilerDefinitionSearchPath searchPath = this.getCompilerDefinitionSearchPath();
        ICompilerDefinitionPersistence persistence = this.m_persistenceFactory.createCompilerDefinitionPersistence(instSettings);
        for (TFile definitionFile : searchPath.getCompilerDefinitionFiles()) {
            String definitionId = FileUtility.getFileNameWithoutExtension((TFile)definitionFile);
            if (definitionsMap.containsKey(definitionId)) {
                if (activeDefinition == null || definitionId.equals(activeDefinition.getName())) continue;
                LOGGER.warn("Omitting C++ compiler definition with name '" + definitionId + "', because it is already found in search path.");
                continue;
            }
            OperationResultWithOutcome<InstCompilerDefinition> defResult = persistence.readDefinition(definitionFile, false);
            result.addMessagesFrom(defResult);
            InstCompilerDefinition definition = (InstCompilerDefinition)((Object)defResult.getOutcome());
            if (definition == null) continue;
            definitionsMap.put(definition.getName(), definition);
            if (instSettings.getUniqueChild((NamedElement.IFilter)new NameFilter(definition.getName()), InstCompilerDefinition.class) == null) {
                instSettings.addChild((NamedElement)definition);
                continue;
            }
            LOGGER.debug(String.format("Definition with name '%s' already exists and won't be added to CppInstallationSettings element", definition.getName()));
        }
        activeDefinition = (InstCompilerDefinition)((Object)definitionsMap.get(this.m_activeDefinitionId));
        if (activeDefinition != null) {
            if (!((Object)((Object)activeDefinition)).equals((Object)this.getActiveCompilerDefinition())) {
                this.replaceActiveDefinitionElementProxy(activeDefinition);
            }
        } else {
            this.initActiveDefinitionForOs();
        }
        definitionsMap.remove("Any Compiler");
        result.setOutcome(definitionsMap);
        return result;
    }

    @Override
    public OperationResultWithOutcome<Map<String, InstCompilerDefinition>> loadRelevantDefinitionsWithoutErrors() {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load all compiler definitions without errors");
        OperationResultWithOutcome<Map<String, InstCompilerDefinition>> innerResult = this.loadRelevantDefinitions();
        result.addMessagesFrom(innerResult);
        Map allRelevantDefinitions = (Map)innerResult.getOutcome();
        Map<String, InstCompilerDefinition> filtered = allRelevantDefinitions.entrySet().stream().filter(entry -> ((InstCompilerDefinition)((Object)((Object)entry.getValue()))).validate(false).isSuccess()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (InstCompilerDefinition)((Object)((Object)entry.getValue()))));
        result.setOutcome(filtered);
        return result;
    }

    @Override
    public Map<TFile, List<TFile>> listAllInstCompilerDefinitions() {
        CompilerDefinitionSearchPath searchPath = this.getCompilerDefinitionSearchPath();
        return searchPath.createEffectiveSearchPath().locateAllFiles(CompilerDefinitionSearchPath.COMPILER_DEF_FILE_REGEXP);
    }

    @Override
    public OperationResultWithOutcome<InstCompilerDefinition> getCompilerDefinition(String definitionId) {
        OperationResultWithOutcome loadDefinitionResult = new OperationResultWithOutcome("Load compiler definition");
        if (definitionId == null || definitionId.isEmpty()) {
            return loadDefinitionResult;
        }
        CPlusPlusInstallationSettings installationSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        List definitions = installationSettings.getChildren((NamedElement.IFilter)new NameFilter(definitionId), InstCompilerDefinition.class);
        assert (definitions.size() <= 1) : "At most one compiler definition with the same id '" + definitionId + "' is allowed to exist";
        if (definitions.size() == 1) {
            OperationResultWithOutcome result = new OperationResultWithOutcome("Returning previously loaded compiler definition '" + definitionId + "'");
            InstCompilerDefinition definition = (InstCompilerDefinition)((Object)definitions.get(0));
            result.setOutcome((Object)definition);
            return result;
        }
        return this.loadCompilerDefinition(definitionId);
    }

    private OperationResultWithOutcome<InstCompilerDefinition> loadBuildInDefinition(String definitionId) {
        CPlusPlusInstallationSettings installationSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        ICompilerDefinitionPersistence persistence = this.m_persistenceFactory.createCompilerDefinitionPersistence(installationSettings);
        URL url = CPlusPlusResourceProviderAdapter.getInstance().getResourceUrl(CPlusPlusResourceProviderAdapter.CPlusPlusResourceType.COMPILER_DEFINITION, "compilerDefinition/" + definitionId);
        OperationResultWithOutcome<InstCompilerDefinition> result = persistence.readDefinition(url);
        this.addDefinitionAsChildIfSuccess(installationSettings, result);
        return result;
    }

    private void addDefinitionAsChildIfSuccess(CPlusPlusInstallationSettings installationSettings, OperationResultWithOutcome<InstCompilerDefinition> result) {
        if (result.isFailure()) {
            return;
        }
        InstCompilerDefinition definition = (InstCompilerDefinition)((Object)result.getOutcome());
        if (definition == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No compiler definition exist in result, no child to be added to CppInstallationSettings element.");
            }
            return;
        }
        InstCompilerDefinition previous = (InstCompilerDefinition)((Object)installationSettings.getUniqueChild((NamedElement.IFilter)new NameFilter(definition.getName()), InstCompilerDefinition.class));
        installationSettings.addChild((NamedElement)definition);
        if (definition.getName().equals(this.m_activeDefinitionId)) {
            this.replaceActiveDefinitionElementProxy(definition);
        }
        if (previous != null) {
            LOGGER.debug("Replacing active C++ compiler definition named element '" + definition.getName() + "'");
            assert (previous.getParent() != null) : "Compiler definition '" + previous.getName() + "' must have a parent";
            previous.removeIssues();
            previous.remove();
        }
    }

    private CompilerDefinitionSearchPath getCompilerDefinitionSearchPath() {
        CPlusPlusInstallationSettings instSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        assert (instSettings != null) : "Child of type '" + CPlusPlusInstallationSettings.class.getName() + "' must exist in Installation";
        return (CompilerDefinitionSearchPath)((Object)instSettings.getUniqueChild(CompilerDefinitionSearchPath.class));
    }

    public void persistSearchPath(SearchPath searchPath, TFile installationSpecificDir, OperationResult result) {
        assert (searchPath != null) : "Parameter 'searchPath' of method 'persistSearchPath' must not be null";
        assert (installationSpecificDir != null) : "Parameter 'installationSpecificDir' of method 'persistSearchPath' must not be null";
        assert (result != null) : "Parameter 'result' of method 'persistSearchPath' must not be null";
        CompilerDefinitionSearchPath cppSearchPath = this.getCompilerDefinitionSearchPath();
        if (cppSearchPath.getSearchPath().equals((Object)searchPath) && installationSpecificDir.equals((Object)cppSearchPath.getInstSpecificDir())) {
            LOGGER.debug("Search path did not change, nothing to be done");
            return;
        }
        if (!installationSpecificDir.exists() || !installationSpecificDir.isDirectory()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.DIRECTORY_NOT_FOUND, "The specified directory '" + installationSpecificDir.getNormalizedAbsolutePath() + "' does not point to an existing directory", new Object[0]);
            return;
        }
        this.getSearchPathValidator().validate(searchPath, installationSpecificDir, result);
        if (result.containsError()) {
            LOGGER.error("Aborting persistence of search path due to errors");
            return;
        }
        InstCompilerDefinition activeCompilerDefinition = this.getActiveCompilerDefinition();
        if (activeCompilerDefinition != null) {
            String activeDefinitionId = activeCompilerDefinition.getName();
            if (result.getWarningCauses().contains((Object)CppCauses.ACTIVE_COMPILER_DEFINITION_NON_EXISTENT)) {
                LOGGER.debug("Active definition '" + activeDefinitionId + "' is no longer found in the search path.");
                this.m_activeDefinitionId = null;
                NamedElementProxy activeDefinitionProxy = this.getActiveDefinitionProxy();
                if (activeDefinitionProxy != null) {
                    activeDefinitionProxy.remove();
                }
            }
        }
        cppSearchPath.setSearchPath(searchPath);
        cppSearchPath.setInstSpecificDir(installationSpecificDir);
        result.addMessagesFrom(this.persistConfiguration());
        OperationResultWithOutcome<InstCompilerDefinition> activeDefinitionResult = this.getCompilerDefinition(this.m_activeDefinitionId);
        if (activeDefinitionResult.isFailure() || activeDefinitionResult.getOutcome() == null) {
            this.initActiveDefinitionForOs();
        } else {
            this.setActiveCompilerDefinition((InstCompilerDefinition)((Object)activeDefinitionResult.getOutcome()));
        }
        result.addMessagesFrom(this.loadRelevantDefinitions());
        EventManager.getInstance().dispatch((Object)this, (Event)new SearchPathModifiedEvent((ISoftwareSystemProvider)this.m_installation.getExtension(ISoftwareSystemProvider.class), (Language)CPlusPlusLanguage.INSTANCE));
    }

    public void readPathToDelta(SearchPathDelta searchPathDelta, TFile dir, OperationResult result) {
        assert (searchPathDelta != null) : "Parameter 'searchPathDelta' of method 'readPathToDelta' must not be null";
        assert (dir != null) : "Parameter 'dir' of method 'readPathToDelta' must not be null";
        TFile directory = dir.getNormalizedAbsoluteFile();
        List<TFile> files = Arrays.asList(FileUtility.listFilesInDir((TFile)directory, (String)CompilerDefinitionSearchPath.COMPILER_DEF_FILE_REGEXP));
        searchPathDelta.getNewMap().put(directory, files);
    }

    @Override
    public List<TFile> listDefinitionsFromDir(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'loadDefinitionsFromDir' must not be null";
        assert (dir.exists() && dir.isDirectory()) : "Parameter 'dir' [" + dir.getAbsolutePath() + "] of method 'loadDefinitionsFromDir' must be an existing directory";
        return Arrays.asList(FileUtility.listFilesInDir((TFile)dir, (String)CompilerDefinitionSearchPath.COMPILER_DEF_FILE_REGEXP));
    }

    public OperationResultWithOutcome<InstCompilerDefinition> create(InstCompilerDefinitionDelta delta) {
        assert (delta != null) : "Parameter 'delta' of method 'create' must not be null";
        assert (delta.getModified() instanceof InstCompilerDefinitionFromFile) : "Unexpected class: " + ((Object)((Object)delta.getModified())).getClass().getName();
        InstCompilerDefinitionFromFile definition = (InstCompilerDefinitionFromFile)delta.getModified();
        OperationResultWithOutcome result = new OperationResultWithOutcome("Validating compiler definition");
        if (!this.getDefinitionNameValidator().isValid(null, definition.getName()).isSuccess()) {
            String msg = "Compiler definition with the same name '" + definition.getName() + "' already exists.";
            result.addError((OperationResult.IMessageCause)CppCauses.INSTALLATION_COMPILER_DEFINITION_GENERAL_ERROR, msg, new Object[]{new Throwable(msg)});
        }
        if (result.isFailure()) {
            return result;
        }
        CPlusPlusInstallationSettings instSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        InstCompilerDefinitionFromFile newDefinition = (InstCompilerDefinitionFromFile)InstCompilerDefinitionBuilder.copy(definition, (NamedElement)instSettings, true);
        ICompilerDefinitionPersistence persistence = this.m_persistenceFactory.createCompilerDefinitionPersistence(instSettings);
        OperationResultWithOutcome<InstCompilerDefinition> saveResult = persistence.writeDefinition(newDefinition, newDefinition.getFile());
        this.addDefinitionAsChildIfSuccess(instSettings, saveResult);
        newDefinition.removeIssues();
        result.addMessagesFrom(saveResult);
        if (result.isFailure()) {
            return result;
        }
        result.setOutcome((Object)newDefinition);
        result.addMessagesFrom(this.persistConfiguration());
        delta.dispose();
        EventManager.getInstance().dispatch((Object)this, (Event)new ConfigurationModifiedEvent((ISoftwareSystemProvider)this.m_installation.getExtension(ISoftwareSystemProvider.class), (Language)CPlusPlusLanguage.INSTANCE, EnumSet.of(ConfigurationModifiedEvent.Change.CONFIGURATION_CHANGED)));
        return result;
    }

    public OperationResultWithOutcome<InstCompilerDefinition> delete(InstCompilerDefinition definition) {
        assert (definition != null) : "Parameter 'definition' of method 'delete' must not be null ";
        assert (definition instanceof InstCompilerDefinitionFromFile) : "Unexpected class: " + ((Object)((Object)definition)).getClass().getName();
        InstCompilerDefinitionFromFile definitionFromFile = (InstCompilerDefinitionFromFile)definition;
        boolean isActiveChanged = false;
        if (definitionFromFile.getName().equals(this.m_activeDefinitionId)) {
            isActiveChanged = true;
        }
        CPlusPlusInstallationSettings instSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        assert (instSettings.getChildren().contains((Object)definitionFromFile)) : "CompilerDefinition must be an existing child of the CppInstallationSettings!";
        ICompilerDefinitionPersistence persistence = this.m_persistenceFactory.createCompilerDefinitionPersistence(instSettings);
        OperationResultWithOutcome<InstCompilerDefinition> result = persistence.writeDefinition(null, definitionFromFile.getFile());
        if (isActiveChanged) {
            this.resetActiveDefinition();
            definition.remove();
            InstCompilerDefinition activeDefinition = this.initActiveDefinitionForOs();
            if (activeDefinition != null) {
                this.setActiveCompilerDefinition(activeDefinition);
            }
            result.addMessagesFrom(this.persistConfiguration());
        } else {
            definition.remove();
        }
        EventManager.getInstance().dispatch((Object)this, (Event)new ConfigurationModifiedEvent((ISoftwareSystemProvider)this.m_installation.getExtension(ISoftwareSystemProvider.class), (Language)CPlusPlusLanguage.INSTANCE, EnumSet.of(ConfigurationModifiedEvent.Change.CONFIGURATION_CHANGED)));
        if (result.isFailure()) {
            LOGGER.error("Failed to delete compiler definition file '" + definitionFromFile.getFile().getNormalizedAbsolutePath() + "'");
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<InstCompilerDefinition> update(InstCompilerDefinitionDelta delta) {
        assert (delta != null) : "Parameter 'delta' of method 'save' must not be null";
        OperationResultWithOutcome<InstCompilerDefinition> result = new OperationResultWithOutcome<InstCompilerDefinition>("Saving changes to installation compiler definition");
        if (!delta.isModified()) {
            delta.dispose();
            return result;
        }
        if (!InstCompilerDefinitionBuilder.areEqual(delta.getOriginal(), delta.getModified())) {
            result = this.updateCompilerDefinition(delta);
        }
        delta.dispose();
        return result;
    }

    private OperationResultWithOutcome<InstCompilerDefinition> updateCompilerDefinition(InstCompilerDefinitionDelta delta) {
        CPlusPlusInstallationSettings instSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        ICompilerDefinitionPersistence persistence = this.m_persistenceFactory.createCompilerDefinitionPersistence(instSettings);
        InstCompilerDefinition modified = delta.getModified();
        InstCompilerDefinition originalDefinition = delta.getOriginal();
        String definitionName = modified.getName();
        OperationResultWithOutcome result = new OperationResultWithOutcome("Updating C++ compiler definition '" + modified.getName() + "'");
        assert (originalDefinition instanceof InstCompilerDefinitionFromFile) : "Definitions of type '" + ((Object)((Object)originalDefinition)).getClass().getName() + "' cannot be updated";
        InstCompilerDefinitionFromFile modifiedFromFile = (InstCompilerDefinitionFromFile)modified;
        OperationResultWithOutcome<InstCompilerDefinition> persistResult = persistence.writeDefinition(modifiedFromFile, modifiedFromFile.getFile());
        result.addMessagesFrom(persistResult);
        if (persistResult.isSuccess()) {
            TFile originalFile = ((InstCompilerDefinitionFromFile)originalDefinition).getFile();
            if (originalFile != null && !FileUtility.areEqual((TFile)originalFile, (TFile)modifiedFromFile.getFile())) {
                try {
                    originalFile.rm();
                }
                catch (IOException ex) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, "Failed to remove outdated file '" + originalFile.getNormalizedAbsolutePath(), new Object[0]);
                }
                return result;
            }
            assert (modifiedFromFile.getParent() == instSettings) : "Definition must have CppInstallationSettings as parent";
            InstCompilerDefinition updatedDefinition = InstCompilerDefinitionBuilder.copy(modifiedFromFile, (NamedElement)instSettings, true);
            assert (InstCompilerDefinitionBuilder.areEqual(updatedDefinition, modifiedFromFile)) : "copied compiler definitions must be equal. Detected difference: " + InstCompilerDefinitionBuilder.getDifference(updatedDefinition, modifiedFromFile);
            instSettings.addChild((NamedElement)updatedDefinition);
            InstCompilerDefinition activeDefinition = this.getActiveCompilerDefinition();
            if (activeDefinition != null && activeDefinition.getName().equals(definitionName)) {
                this.replaceActiveDefinitionElementProxy(updatedDefinition);
            }
            originalDefinition.remove();
            result.setOutcome((Object)updatedDefinition);
        }
        return result;
    }

    @Override
    public InstCompilerDefinition getActiveCompilerDefinition() {
        NamedElementProxy activeDefProxy = this.getActiveDefinitionProxy();
        CPlusPlusInstallationSettings instSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        instSettings.removeIssues(new IIssueId[]{CPlusPlusIssueId.ACTIVE_COMPILER_DEFINITION_MISSING});
        if (activeDefProxy == null) {
            instSettings.addIssue((Issue)new NoActiveCompilerDefinition((NamedElement)instSettings));
            return null;
        }
        InstCompilerDefinition activeDefinition = (InstCompilerDefinition)activeDefProxy.getElement();
        if (activeDefinition.getUniqueChild(SignatureElement.class) == null) {
            ICompilerDefinitionPersistence persistence = this.m_persistenceFactory.createCompilerDefinitionPersistence(instSettings);
            persistence.addSignatureToDefinition(activeDefinition);
        }
        return activeDefinition;
    }

    private NamedElementProxy getActiveDefinitionProxy() {
        NamedElementProxy activeProxy = null;
        CPlusPlusInstallationSettings installationSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        for (NamedElementProxy proxy : installationSettings.getChildren(NamedElementProxy.class)) {
            if (!(proxy.getElement() instanceof InstCompilerDefinition)) continue;
            assert (activeProxy == null) : "Only one elementproxy for InstCompilerDefinition is allowed";
            activeProxy = proxy;
        }
        return activeProxy;
    }

    @Override
    public OperationResult setActiveCompilerDefinitionId(String definitionId) {
        String msg = "Set compiler defintion '" + definitionId + "' as active definition.";
        OperationResult result = new OperationResult(msg);
        if (definitionId != null && definitionId.equals(this.m_activeDefinitionId)) {
            return result;
        }
        OperationResultWithOutcome<InstCompilerDefinition> loadResult = this.getCompilerDefinition(definitionId);
        if (loadResult.isSuccess()) {
            this.setActiveCompilerDefinition((InstCompilerDefinition)((Object)loadResult.getOutcome()));
        } else {
            result.addMessagesFrom(loadResult);
        }
        return result;
    }

    public void setActiveCompilerDefinition(InstCompilerDefinition newActiveDefinition) {
        if (newActiveDefinition != null) {
            this.m_activeDefinitionId = newActiveDefinition.getName();
            this.replaceActiveDefinitionElementProxy(newActiveDefinition);
            return;
        }
        this.resetActiveDefinition();
    }

    private void resetActiveDefinition() {
        CPlusPlusInstallationSettings installationSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        if (!installationSettings.hasIssues(new IIssueId[]{CPlusPlusIssueId.ACTIVE_COMPILER_DEFINITION_MISSING})) {
            installationSettings.addIssue((Issue)new NoActiveCompilerDefinition((NamedElement)installationSettings));
        }
        this.m_activeDefinitionId = null;
        NamedElementProxy activeDefinitionProxy = this.getActiveDefinitionProxy();
        if (activeDefinitionProxy == null) {
            return;
        }
        InstCompilerDefinition previous = (InstCompilerDefinition)activeDefinitionProxy.getElement();
        previous.removeIssues();
        activeDefinitionProxy.remove();
        if (this.m_initialized) {
            EventManager.getInstance().dispatch((Object)this, (Event)new ConfigurationModifiedEvent((ISoftwareSystemProvider)this.m_installation.getExtension(ISoftwareSystemProvider.class), (Language)CPlusPlusLanguage.INSTANCE, EnumSet.of(ConfigurationModifiedEvent.Change.ACTIVE_CONFIGURATION_CHANGED)));
        }
    }

    private void replaceActiveDefinitionElementProxy(InstCompilerDefinition newActiveDefinition) {
        assert (newActiveDefinition != null) : "Parameter 'newActiveDefinition' of method 'replaceActiveDefinitionElementProxy' must not be null";
        CPlusPlusInstallationSettings installationSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        installationSettings.removeIssues(new IIssueId[]{CPlusPlusIssueId.ACTIVE_COMPILER_DEFINITION_MISSING});
        NamedElementProxy activeDefinitionProxy = this.getActiveDefinitionProxy();
        boolean activeDefinitionChanged = true;
        if (activeDefinitionProxy != null) {
            InstCompilerDefinition previous = (InstCompilerDefinition)activeDefinitionProxy.getElement();
            if (InstCompilerDefinitionBuilder.areEqual(previous, newActiveDefinition)) {
                activeDefinitionChanged = false;
            }
            assert (previous.getParent() != null) : "Parent must exist for definition '" + previous.getName() + "'";
            previous.removeIssues();
            activeDefinitionProxy.remove();
        }
        newActiveDefinition.validate(true);
        NamedElementProxy proxy = new NamedElementProxy((NamedElement)installationSettings, (NamedElement)newActiveDefinition);
        installationSettings.addChild((NamedElement)proxy);
        if (activeDefinitionChanged) {
            ISoftwareSystemProvider controller = (ISoftwareSystemProvider)this.m_installation.getExtension(ISoftwareSystemProvider.class);
            if (controller.hasSoftwareSystem() && controller.getSoftwareSystem().getUsedLanguages().contains((Object)CPlusPlusLanguage.INSTANCE) && controller.getSoftwareSystem().getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT) {
                ((CPlusPlusSoftwareSystemSettingsExtension)controller.getSoftwareSystem().getExtension(CPlusPlusSoftwareSystemSettingsExtension.class)).handleChangeOfActiveCompilerDefinition(newActiveDefinition.getName());
            }
            if (this.m_initialized) {
                EventManager.getInstance().dispatch((Object)this, (Event)new ConfigurationModifiedEvent((ISoftwareSystemProvider)this.m_installation.getExtension(ISoftwareSystemProvider.class), (Language)CPlusPlusLanguage.INSTANCE, EnumSet.of(ConfigurationModifiedEvent.Change.ACTIVE_CONFIGURATION_CHANGED)));
            }
        }
    }

    @Override
    public Map<String, InstCompilerDefinition> listRelevantDefinitions(boolean includeAny) {
        LinkedHashMap<String, InstCompilerDefinition> result = new LinkedHashMap<String, InstCompilerDefinition>();
        if (includeAny) {
            AnyCompiler any = new AnyCompiler();
            result.put(any.getName(), any);
        }
        CPlusPlusInstallationSettings settings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        for (InstCompilerDefinition definition : settings.getChildren(InstCompilerDefinition.class)) {
            result.put(definition.getName(), definition);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public OperationResultWithOutcome<InstCompilerDefinition> loadCompilerDefinition(String definitionId) {
        if (!$assertionsDisabled) {
            if (definitionId == null) throw new AssertionError((Object)"Parameter 'definitionId' of method 'loadCompilerDefinition' must not be empty");
            if (definitionId.length() <= 0) {
                throw new AssertionError((Object)"Parameter 'definitionId' of method 'loadCompilerDefinition' must not be empty");
            }
        }
        BuiltInCompilerDefinition[] builtInCompilerDefinitionArray = BuiltInCompilerDefinition.values();
        int n = builtInCompilerDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltInCompilerDefinition id = builtInCompilerDefinitionArray[n2];
            if (id.getStandardName().equals(definitionId)) {
                return this.loadBuildInDefinition(definitionId);
            }
            ++n2;
        }
        CPlusPlusInstallationSettings installationSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        ICompilerDefinitionPersistence persistence = this.m_persistenceFactory.createCompilerDefinitionPersistence(installationSettings);
        OperationResultWithOutcome result = null;
        if (this.getGeneratedDefinitions().contains(definitionId)) {
            TFile dir = this.getGeneratedCompilerDefinitionDir();
            TFile definitionFile = new TFile((File)dir, definitionId + CPlusPlusResourceProviderAdapter.CPlusPlusResourceType.COMPILER_DEFINITION.getExtension());
            if (!definitionFile.exists()) {
                result = new OperationResultWithOutcome("Loading compiler definition '" + definitionId + "'");
                result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Compiler definition '" + definitionId + "' does not exist at '" + definitionFile.getAbsolutePath() + "'", new Object[0]);
                return result;
            }
            result = persistence.readDefinition(definitionFile, true);
        } else {
            InstallationSearchPath searchPath = (InstallationSearchPath)installationSettings.getUniqueChild(CompilerDefinitionSearchPath.class);
            assert (searchPath != null) : "child searchpath must exist!";
            TFile definitionFile = searchPath.locateFile(definitionId);
            if (definitionFile == null) {
                result = new OperationResultWithOutcome("Loading compiler definition '" + definitionId + "'");
                result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Compiler definition '" + definitionId + "' does not exist in specified search path", new Object[0]);
                return result;
            }
            result = persistence.readDefinition(definitionFile, false);
        }
        this.addDefinitionAsChildIfSuccess(installationSettings, (OperationResultWithOutcome<InstCompilerDefinition>)result);
        return result;
    }

    @Override
    public SearchPathValidator getSearchPathValidator() {
        return new CppSearchPathValidator(this);
    }

    public InstCompilerDefinitionDelta createDelta(InstCompilerDefinition definition, boolean createModifiableDelta) {
        CPlusPlusInstallationSettings cppInstallationSettings = (CPlusPlusInstallationSettings)((Object)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        if (definition == null) {
            definition = new InstCompilerDefinitionFromFile((NamedElement)cppInstallationSettings, "IDENTIFIER_FOR_NEW_COMPILER_DEFINITION");
            InstCompilerDefinitionDelta delta = new InstCompilerDefinitionDelta(definition, false, (NamedElement)cppInstallationSettings);
            InstCompilerDefinitionBuilder.copyDetails(delta.getModified(), delta.getOriginal());
            return delta;
        }
        InstCompilerDefinition activeCompilerDefinition = this.getActiveCompilerDefinition();
        boolean isOriginalActive = activeCompilerDefinition != null && activeCompilerDefinition.getName().equals(definition.getName());
        return new InstCompilerDefinitionDelta(definition, isOriginalActive, (NamedElement)cppInstallationSettings, createModifiableDelta);
    }

    @Override
    public TFile getConfigurationDirForDefinition(InstCompilerDefinition compilerDefinition) {
        assert (compilerDefinition != null) : "Parameter 'compilerDefinition' of method 'getConfigurationDirForDefinition' must not be null";
        assert (compilerDefinition instanceof GeneratedInstCompilerDefinition) : "Unexpected class: " + ((Object)((Object)compilerDefinition)).getClass().getName();
        TFile configurationDirectory = new TFile((File)this.getGeneratedCompilerDefinitionDir(), compilerDefinition.getName());
        return configurationDirectory;
    }

    @Override
    public IPathValidator getMakefileValidator() {
        return new IPathValidator(){

            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.DIRECTORY;
            }

            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                if (newInput == null) {
                    ValidationResult result = new ValidationResult(false);
                    result.addError("Path must not be empty");
                    return result;
                }
                if (newInput.exists() && newInput.isDirectory()) {
                    return new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                }
                ValidationResult result = new ValidationResult(FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                result.addError(String.valueOf(IOMessageCause.DIRECTORY_NOT_FOUND) + " : " + newInput.getPath());
                return result;
            }
        };
    }

    public void setActiveCompilerDefinition(String activeCompilerDefinitionPath, OperationResult result) {
        String definitionId;
        Object path;
        assert (activeCompilerDefinitionPath != null && activeCompilerDefinitionPath.length() > 0) : "Parameter 'activeCompilerDefinitionPath' of method 'setActiveCompilerDefinition' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'setActiveCompilerDefinition' must not be null";
        String extension = CPlusPlusResourceProviderAdapter.CPlusPlusResourceType.COMPILER_DEFINITION.getExtension();
        if (activeCompilerDefinitionPath.endsWith(extension)) {
            path = activeCompilerDefinitionPath;
            definitionId = activeCompilerDefinitionPath.substring(0, activeCompilerDefinitionPath.length() - extension.length());
        } else {
            path = activeCompilerDefinitionPath + CPlusPlusResourceProviderAdapter.CPlusPlusResourceType.COMPILER_DEFINITION.getExtension();
            definitionId = activeCompilerDefinitionPath;
        }
        if (definitionId.startsWith(BUILT_IN_PREFIX)) {
            String definitionIdToActivate = definitionId.substring(BUILT_IN_PREFIX.length());
            OperationResult activateDefinitionById = this.setActiveCompilerDefinitionId(definitionIdToActivate);
            if (activateDefinitionById.isFailure()) {
                result.addMessagesFrom(activateDefinitionById);
            }
            return;
        }
        TFile definitionFile = new TFile((String)path);
        if (!definitionFile.exists()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Compiler definition '" + (String)path + "' does not exist", new Object[0]);
            return;
        }
        if (!definitionFile.isFile()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_FILE, "Compiler definition '" + (String)path + "' is not a file", new Object[0]);
            return;
        }
        if (!definitionFile.canRead()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NO_PERMISSION, "No permission to read compiler definition '" + (String)path + "'", new Object[0]);
            return;
        }
        CompilerDefinitionPersistenceProvider persistence = new CompilerDefinitionPersistenceProvider((InstallationSettings)this.m_installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        OperationResultWithOutcome<InstCompilerDefinition> loadedResult = persistence.readDefinition(definitionFile, false);
        if (loadedResult.isFailure()) {
            result.addMessagesFrom(loadedResult);
            return;
        }
        this.setActiveCompilerDefinition((InstCompilerDefinition)((Object)loadedResult.getOutcome()));
    }

    @Override
    public OperationResult createCompilerDefinition(CompilerDefinitionModel model) {
        assert (model != null) : "Parameter 'model' of method 'createCompilerDefinition' must not be null";
        OperationResult result = new OperationResult("Creating new compiler definition");
        TFile cdefFile = new TFile((File)this.m_sonargraphCppHome, model.getName() + ".cdef");
        CompilerDefinitionPersistenceProvider.createCompilerDefinition(model, cdefFile, result);
        this.loadCompilerDefinition(model.getName());
        if (result.isSuccess() && model.isActivate()) {
            this.setActiveCompilerDefinition(cdefFile.getAbsolutePath(), result);
        }
        return result;
    }
}

