/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CommandLineHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.DirectoryBeanHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public final class CMakeJsonHelper {
    private final List<TFile> m_fileList = new ArrayList<TFile>();
    private final Map<TFile, List<String>> m_optMap = new HashMap<TFile, List<String>>();
    private final Map<List<String>, List<String>> m_listMap = new HashMap<List<String>, List<String>>();

    private CMakeJsonHelper() {
    }

    private void handleEntry(TFile basedir, JSONObject entry, StringBuilder buffer) {
        TFile file;
        List<Object> options;
        String directory = (String)entry.get((Object)"directory");
        String cmd = (String)entry.get((Object)"command");
        Object arguments = entry.get((Object)"arguments");
        String fileName = (String)entry.get((Object)"file");
        if (cmd == null && arguments == null || fileName == null) {
            return;
        }
        TFile dir = basedir;
        if (directory != null) {
            dir = new TFile(directory);
        }
        if (!new TFile(fileName = fileName.replace('\\', '/')).isAbsolute()) {
            if (dir == null) {
                return;
            }
            fileName = new TFile((File)dir, fileName).getNormalizedAbsolutePath();
        }
        if (cmd != null) {
            cmd = cmd.replace('\\', '/');
            buffer.append(cmd).append(": ").append(fileName).append('\n');
            options = CommandLineHelper.processCommandLine(basedir, cmd, false);
        } else {
            assert (arguments instanceof JSONArray);
            JSONArray args = (JSONArray)arguments;
            options = new ArrayList(args.size() - 1);
            int i = 1;
            while (i < args.size()) {
                options.add((String)args.get(i));
                ++i;
            }
            options = CommandLineHelper.filterAndNormalizeItems(dir, options, false);
        }
        List<String> optionsRep = this.m_listMap.get(options);
        if (optionsRep == null) {
            this.m_listMap.put(options, options);
            optionsRep = options;
        }
        if (!this.m_fileList.contains(file = new TFile(fileName))) {
            this.m_fileList.add(file);
            this.m_optMap.put(file, optionsRep);
        }
    }

    private List<DirectoryBean> createRoots() {
        return DirectoryBeanHelper.createRoots(this.m_fileList, this.m_optMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<DirectoryBean> importCommandFile(TFile jsonFile, StringBuilder buffer) {
        CMakeJsonHelper helper = new CMakeJsonHelper();
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (FileReader reader = new FileReader((File)jsonFile);){
                TFile basedir = jsonFile.getParentFile();
                JSONParser parser = new JSONParser();
                Object jsonData = parser.parse((Reader)reader);
                if (!(jsonData instanceof JSONArray)) return null;
                Iterator iterator = ((JSONArray)jsonData).iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return helper.createRoots();
                    }
                    Object item = iterator.next();
                    if (!(item instanceof JSONObject)) continue;
                    JSONObject commandItem = (JSONObject)item;
                    helper.handleEntry(basedir, commandItem, buffer);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

