/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.CodeAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.CppSignatureEncoder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ICompilationUnitContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.IElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.TemplateArgumentCollector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFlags;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFunctionSpec;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFunctionWithBody;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class RoutineProcessor
extends ElementProcessor {
    private final EDG.Routine m_edgRoutine;
    private final Set<CppFunctionSpec> m_declarations = new LinkedHashSet<CppFunctionSpec>();
    private final List<EDG.Routine> m_lambdaBodies = new ArrayList<EDG.Routine>();
    private final Map<CppFunctionSpec, EDG.SourcePosition> m_declarationPositionMap = new HashMap<CppFunctionSpec, EDG.SourcePosition>();
    private CppFunctionWithBody m_definition;
    private long m_lowestSeq;

    RoutineProcessor(ICompilationUnitContext context, IElementProcessor parentProcessor, EDG.Routine r) {
        super(context, parentProcessor);
        this.m_edgRoutine = r;
    }

    @Override
    public CppElement getElement() {
        if (this.m_definition != null) {
            return this.m_definition;
        }
        return this.m_declarations.iterator().next();
    }

    @Override
    public EDG.CObject getEDGObject() {
        return this.m_edgRoutine;
    }

    private Collection<EDG.SourcePosition> findSecondaryPositions(EDG.SourceCorrespondence sc, EDG.SourcePosition originalPosition) {
        Collection<EDG.SourcePosition> declPositions = this.getContext().getSecondaryPositions(this.m_edgRoutine, originalPosition);
        if (declPositions.isEmpty() && this.m_edgRoutine.isTemplateFunction()) {
            EDG.Template template = this.m_edgRoutine.assocTemplate();
            if (this.m_edgRoutine.defined() || template != null && template.definitionTemplate() != null) {
                EDG.SourcePosition sp;
                long seq;
                EDG.DeclPositionSupplement dps;
                EDG.SourceCorrespondence tsc;
                EDG.SourceSequenceEntry entry = sc.sourceSequenceEntry();
                if (entry != null) {
                    EDG.SourcePosition sp2;
                    long seq2;
                    EDG.SrcSeqSecondaryDecl decl;
                    EDG.CObject obj = entry.entity();
                    if (obj instanceof EDG.SrcSeqSecondaryDecl && (decl = (EDG.SrcSeqSecondaryDecl)obj).entity().equals(this.m_edgRoutine) && (seq2 = (sp2 = decl.declPosition()).seq()) != 0L && seq2 != originalPosition.seq()) {
                        declPositions = new ArrayList<EDG.SourcePosition>();
                        declPositions.add(sp2);
                        if (seq2 < this.m_lowestSeq) {
                            this.m_lowestSeq = seq2;
                        }
                    }
                } else if (template != null && (tsc = template.sourceCorresp()) != null && (dps = tsc.declPosInfo()) != null && (seq = (sp = dps.identifierRange().start()).seq()) != 0L && seq != originalPosition.seq()) {
                    declPositions = new ArrayList<EDG.SourcePosition>();
                    declPositions.add(sp);
                    if (seq < this.m_lowestSeq) {
                        this.m_lowestSeq = seq;
                    }
                }
            }
        }
        return declPositions;
    }

    private void mapRoutineElement(CppFunctionSpec element, EDG.SourcePosition originalPosition) {
        this.m_declarationPositionMap.put(element, originalPosition);
        this.getContext().mapElement(this.m_edgRoutine, element);
        this.getContext().mapElementPosition(element, originalPosition);
        if (this.m_edgRoutine.isTemplateFunction()) {
            this.getContext().mapElement(this.m_edgRoutine.assocTemplate(), element);
            if (originalPosition.seq() != 0L) {
                this.getContext().mapElement(originalPosition.getOriginalPosition(), element);
            }
        }
    }

    @Override
    public boolean initElement() {
        if (this.m_edgRoutine.isDeleted() || !this.m_edgRoutine.isPrototypeInstantiation() && this.m_edgRoutine.isTemplateFunction()) {
            return false;
        }
        EDG.SourceCorrespondence sc = this.m_edgRoutine.sourceCorresp();
        EDG.SourcePosition originalPosition = sc.declPosition();
        EDG.Position pos = originalPosition.getPosition();
        CppElement parent = this.getParentProcessor().getParentFor(pos);
        CppFunctionSpec element = null;
        if (parent == null) {
            return false;
        }
        this.m_lowestSeq = originalPosition.seq();
        Object name = this.getElementName(sc);
        Collection<EDG.SourcePosition> declPositions = this.findSecondaryPositions(sc, originalPosition);
        if (this.getContext().isFriendDeclPosition(originalPosition.getOriginalPosition())) {
            for (EDG.SourcePosition sp : declPositions) {
                if (!sp.getPosition().getFile().equals(pos.getFile())) continue;
                ArrayList<EDG.SourcePosition> secondaryDecls = new ArrayList<EDG.SourcePosition>(declPositions);
                secondaryDecls.remove(sp);
                declPositions = secondaryDecls;
                pos = sp.getPosition();
                break;
            }
        }
        ArrayList<CppFunctionSpec> declarations = new ArrayList<CppFunctionSpec>();
        boolean mightBeDefinition = this.m_edgRoutine.defined() || this.m_edgRoutine.isDefaulted() || this.m_edgRoutine.definedInFriendDecl();
        short noTemplateArguments = 0;
        if (this.m_edgRoutine.isPrototypeInstantiation()) {
            EDG.Template template;
            if (!mightBeDefinition && (template = this.m_edgRoutine.assocTemplate()) != null) {
                mightBeDefinition = template.definitionTemplate() != null;
            }
            TemplateArgumentCollector collector = new TemplateArgumentCollector();
            Object arg = this.m_edgRoutine.templateArgList();
            while (arg != null) {
                ((EDG.TemplateArg)arg).accept(collector);
                noTemplateArguments = (short)(noTemplateArguments + 1);
                arg = ((EDG.TemplateArg)arg).next();
            }
            if (noTemplateArguments > 0) {
                name = (String)name + collector.getResult();
            }
        }
        if (mightBeDefinition) {
            CppFunctionWithBody funct;
            if ((this.m_edgRoutine.friendDefinedInInstantiation() || this.m_edgRoutine.definedInFriendDecl()) && (funct = this.getContext().findFriendDefinedInInstantiation(pos)) != null) {
                this.getContext().mapElement(this.m_edgRoutine, funct);
                return false;
            }
            this.m_definition = (CppFunctionWithBody)this.getParentProcessor().createRoutine(parent, (String)name, pos.getLineNumber(), true, noTemplateArguments);
            parent.addChild(this.m_definition);
            if (this.m_edgRoutine.friendDefinedInInstantiation() || this.m_edgRoutine.definedInFriendDecl()) {
                this.getContext().registerFriendDefinedInInstantiation(pos, this.m_definition);
                this.m_definition.addFlag(CppFlags.FRIEND_IN_INSTANTIATION);
            }
            if (this.m_edgRoutine.defined() && !this.m_definition.isExternal() && this.m_edgRoutine.getScope() != null) {
                this.processScope(this.m_edgRoutine.getScope());
            }
            element = this.m_definition;
        } else {
            element = this.getParentProcessor().createRoutine(parent, (String)name, pos.getLineNumber(), false, noTemplateArguments);
            parent.addChild(element);
            declarations.add(element);
        }
        if (element != null) {
            if (this.m_edgRoutine.isDefaulted()) {
                element.addFlag(CppFlags.DEFAULTED);
            }
            this.mapRoutineElement(element, originalPosition);
        }
        for (EDG.SourcePosition sp : declPositions) {
            EDG.Position declPos = sp.getPosition();
            CppElement declParent = this.getParentProcessor().getParentFor(declPos);
            if (declParent == null || this.m_definition != null && declParent == this.m_definition.getParent()) continue;
            CppFunctionSpec decl = this.getParentProcessor().createRoutine(declParent, (String)name, declPos.getLineNumber(), false, noTemplateArguments);
            declParent.addChild(decl);
            if (this.m_edgRoutine.isDefaulted()) {
                decl.addFlag(CppFlags.DEFAULTED);
            }
            if (declarations.contains(decl)) continue;
            declarations.add(decl);
            this.m_declarationPositionMap.put(decl, sp);
            this.getContext().mapElement(sp.getOriginalPosition(), decl);
        }
        if (parent.isExternal()) {
            boolean noDefinitionNeeded = false;
            for (CppFunctionSpec decl : declarations) {
                if (decl.getParent() != parent) continue;
                noDefinitionNeeded = true;
                this.mapRoutineElement(decl, this.m_declarationPositionMap.get(decl));
                element = decl;
                break;
            }
            if (!noDefinitionNeeded && mightBeDefinition && this.m_definition == null) {
                CppFunctionSpec mainDecl = this.getParentProcessor().createRoutine(parent, (String)name, pos.getLineNumber(), false, noTemplateArguments);
                if (this.m_edgRoutine.isDefaulted()) {
                    mainDecl.addFlag(CppFlags.DEFAULTED);
                }
                parent.addChild(mainDecl);
                element = mainDecl;
                this.mapRoutineElement(mainDecl, originalPosition);
                declarations.add(0, mainDecl);
            }
        }
        assert (element != null);
        for (CppFunctionSpec decl : declarations) {
            if (this.m_definition != null) {
                decl.addDependency(this.m_definition, CppDependencyType.DECLARES, decl.getLineNo());
            }
            this.m_declarations.add(decl);
            if (decl == element) continue;
            this.getContext().addSecondaryDeclaration(element, decl);
            this.getContext().mapElementPosition(decl, this.m_declarationPositionMap.get(decl));
        }
        return true;
    }

    private void processMemberFunction(CppFunctionSpec funct) {
        switch (this.m_edgRoutine.specialKind()) {
            case SFK_NONE: {
                if (((EDG.TypeRoutine)this.m_edgRoutine.type()).extraInfo().thisClass() != null) break;
                funct.addFlag(CppFlags.STATIC);
                break;
            }
            case SFK_CONSTRUCTOR: {
                funct.addFlag(CppFlags.CONSTRUCTOR);
                break;
            }
            case SFK_STATIC_CONSTRUCTOR: {
                funct.addFlag(CppFlags.CONSTRUCTOR);
                funct.addFlag(CppFlags.STATIC);
                break;
            }
            case SFK_DESTRUCTOR: {
                funct.addFlag(CppFlags.DESTRUCTOR);
                break;
            }
            default: {
                funct.addFlag(CppFlags.SPECIAL_MEMBER_FUNCTION);
            }
        }
        if (this.m_edgRoutine.isVirtual()) {
            funct.addFlag(CppFlags.VIRTUAL);
        }
        if (this.m_edgRoutine.isFinal()) {
            funct.addFlag(CppFlags.FINAL);
        }
        if (this.m_edgRoutine.isInline()) {
            funct.addFlag(CppFlags.INLINE);
        }
        if (this.m_edgRoutine.isDeleted()) {
            funct.addFlag(CppFlags.DELETED);
        }
        if (this.m_edgRoutine.pureVirtual()) {
            funct.addFlag(CppFlags.PURE_VIRTUAL);
        }
        switch (this.m_edgRoutine.sourceCorresp().access()) {
            case 0: {
                funct.addFlag(CppFlags.PUBLIC);
                break;
            }
            case 1: {
                funct.addFlag(CppFlags.PROTECTED);
                break;
            }
            case 2: {
                funct.addFlag(CppFlags.PRIVATE);
            }
        }
    }

    private void processFunction(CppFunctionSpec funct) {
        if (this.m_edgRoutine.isInline()) {
            funct.addFlag(CppFlags.INLINE);
        }
        if (this.m_edgRoutine.declaredStorageClass() == EDG.StorageClass.SC_STATIC) {
            funct.addFlag(CppFlags.STATIC);
        }
    }

    @Override
    protected void processScope(EDG.Scope scope) {
        ElementProcessor.ScopeVisitor visitor = new ElementProcessor.ScopeVisitor();
        scope.accept(visitor);
        assert (this.m_definition != null);
        this.m_definition.addToNumberOfStatements(visitor.getStatementCounter());
        this.m_definition.addToCyclomaticComplexity(visitor.getCyclomaticComplexity());
        this.m_definition.addToModifiedCyclomaticComplexity(visitor.getModifiedCyclomaticComplexity());
        this.m_definition.setMaxNesting(visitor.getMaxNesting());
    }

    @Override
    protected void addLambdaBodyRoutine(EDG.Routine lambdaBodyRoutine) {
        EDG.Scope lambdaBodyScope = lambdaBodyRoutine.getScope();
        ElementProcessor.ScopeVisitor visitor = new ElementProcessor.ScopeVisitor();
        lambdaBodyScope.accept(visitor);
        this.m_definition.addToNumberOfStatements(visitor.getStatementCounter());
        this.m_definition.addToCyclomaticComplexity(visitor.getCyclomaticComplexity() - 1);
        this.m_definition.addToModifiedCyclomaticComplexity(visitor.getModifiedCyclomaticComplexity() - 1);
        this.m_lambdaBodies.add(lambdaBodyRoutine);
    }

    private void process(CppFunctionSpec funct, EDG.SourcePosition sp, boolean ignoreSignatureDeps) {
        String sig = CppSignatureEncoder.encode(this, this.m_edgRoutine.type(), this.getContext(), ignoreSignatureDeps ? null : funct, null, sp, nop -> funct.setNumberOfParameters(nop.shortValue()));
        if (ignoreSignatureDeps) {
            funct.setSignature(CppSignature.UNDEFINED_ROUTINE);
        } else {
            funct.setSignature(sig);
        }
        switch (funct.getType()) {
            case MEMBER_FUNCTION: {
                this.processMemberFunction(funct);
                break;
            }
            case FUNCTION: {
                this.processFunction(funct);
                break;
            }
            default: {
                assert (false) : "Unexpected element type " + this.m_definition.getType().name();
                break;
            }
        }
    }

    @Override
    public void processElement() {
        if (this.m_definition != null) {
            EDG.SourcePosition sp = this.m_edgRoutine.sourceCorresp().declPosition();
            this.process(this.m_definition, sp, this.m_edgRoutine.friendDefinedInInstantiation() || this.m_edgRoutine.definedInFriendDecl());
            if (this.m_edgRoutine.defined() && !this.m_definition.isExternal() && this.m_edgRoutine.memoryRegion() != 0) {
                int numberOfLogicalOps = CodeAnalyzer.analyze(this.m_definition, this.getContext(), this, this.m_edgRoutine.getScope());
                this.m_definition.addToLogicalOperations(numberOfLogicalOps);
                for (EDG.Routine lambdaBody : this.m_lambdaBodies) {
                    numberOfLogicalOps = CodeAnalyzer.analyze(this.m_definition, this.getContext(), this, lambdaBody.getScope());
                    this.m_definition.addToLogicalOperations(numberOfLogicalOps);
                }
            }
        }
        for (CppFunctionSpec decl : this.m_declarations) {
            this.process(decl, this.m_declarationPositionMap.get(decl), false);
        }
    }

    @Override
    protected void processStaticVariable(EDG.Variable v) {
        this.processLocalVariable(v);
    }

    @Override
    public CppElement getParentFor(EDG.Position pos) {
        if (this.m_definition != null) {
            return this.m_definition;
        }
        assert (this.m_declarations.size() == 1);
        return this.m_declarations.iterator().next();
    }
}

