/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.ISourceElementCountProvider;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.HeaderNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.IComponentAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Link;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Node;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.SourceNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.MisplacedDeclarationIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeader;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppWeakRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppComponent;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

final class Component {
    private final List<HeaderNode> m_headers = new ArrayList<HeaderNode>();
    private final List<SourceNode> m_sources = new ArrayList<SourceNode>();
    private final MultipleValueMap<String, SourceNode> m_rootMap = new MultipleValueMap();
    private String m_name;
    private CppComponent m_modelComponent;
    private boolean m_primaryDirectoryEstablished = false;
    private TFile m_primaryDirectory;
    private boolean m_avoidMisplacedDeclarationWarning = false;
    private CPlusPlusModule m_anchorModule = null;

    Component() {
    }

    void setAvoidMisplacedDeclarationearnings() {
        this.m_avoidMisplacedDeclarationWarning = true;
    }

    boolean avoidMisplacedDeclarationWarnings() {
        return this.m_avoidMisplacedDeclarationWarning;
    }

    public void setAnchorModule(CPlusPlusModule anchorModule) {
        this.m_anchorModule = anchorModule;
    }

    final void addHeader(HeaderNode header) {
        this.m_headers.add(header);
        header.setComponent(this);
    }

    final void addSource(SourceNode sourceNode) {
        assert (sourceNode != null) : "Parameter 'sourceNode' of method 'addSource' must not be null";
        this.m_sources.add(sourceNode);
        sourceNode.setComponent(this);
        String dir = sourceNode.getSource().getFile().getParentFile().getNormalizedAbsolutePath();
        this.m_rootMap.put((Object)dir, (Object)sourceNode);
    }

    boolean isAnchored() {
        return this.m_anchorModule != null || this.m_sources.size() > 0;
    }

    String getName() {
        if (this.m_name == null) {
            if (this.m_headers.size() == 1) {
                this.m_name = this.m_headers.get(0).getName();
            } else if (this.m_sources.size() == 1) {
                this.m_name = this.m_sources.get(0).getName();
            } else {
                List headerNames = this.m_headers.stream().map(h -> h.getName()).collect(Collectors.toList());
                List sourceNames = this.m_sources.stream().map(s -> s.getName()).collect(Collectors.toList());
                ArrayList jointNames = new ArrayList(headerNames);
                jointNames.retainAll(sourceNames);
                this.m_name = !jointNames.isEmpty() ? (String)jointNames.get(0) : (!headerNames.isEmpty() ? (String)headerNames.get(0) : (String)sourceNames.get(0));
            }
        }
        return this.m_name;
    }

    CPlusPlusModule getAnchorModule() {
        assert (this.isAnchored()) : "Not anchored: " + String.valueOf(this);
        return this.m_anchorModule != null ? this.m_anchorModule : (CPlusPlusModule)((Object)this.m_sources.get(0).getSource().getParent(CPlusPlusModule.class, new Class[0]));
    }

    boolean contains(Node node) {
        assert (node != null) : "Parameter 'node' of method 'contains' must not be null";
        return this.m_headers.contains(node) || this.m_sources.contains(node);
    }

    CppComponent getModelComponent() {
        return this.m_modelComponent;
    }

    private IDirectoryPath getSourceDirectory() {
        if (this.m_sources.size() == 0) {
            return null;
        }
        return this.m_sources.get(0).getDirectory();
    }

    boolean mustBeSplit() {
        HeaderNode node;
        if (this.m_rootMap.size() > 1) {
            return true;
        }
        String name = this.getName();
        return this.m_headers.size() > 1 && this.m_sources.size() == 1 && (node = (HeaderNode)this.m_headers.stream().filter(n -> n.getName().equalsIgnoreCase(name)).findFirst().orElse(null)) != null;
    }

    boolean isHeaderOnly() {
        return this.m_sources.size() == 0;
    }

    Collection<? extends Component> split() {
        if (this.m_rootMap.size() == 1) {
            return this.simpleSplit();
        }
        ArrayList<Component> result = new ArrayList<Component>();
        MultipleValueMap nameMap = new MultipleValueMap();
        ArrayList<HeaderNode> processedHeaders = new ArrayList<HeaderNode>();
        for (String root : this.m_rootMap.keySet()) {
            Component component = new Component();
            result.add(component);
            for (SourceNode sourceNode : this.m_rootMap.get((Object)root)) {
                String name = sourceNode.getName();
                TFile srcDir = sourceNode.getDirectoryFile();
                component.addSource(sourceNode);
                nameMap.put((Object)name, (Object)sourceNode);
                for (HeaderNode headerNode : this.m_headers) {
                    TFile headerDir = headerNode.getDirectoryFile();
                    if (!srcDir.equals((Object)headerDir)) continue;
                    processedHeaders.add(headerNode);
                    component.addHeader(headerNode);
                }
                this.m_headers.removeAll(processedHeaders);
                processedHeaders.clear();
                for (HeaderNode headerNode : this.m_headers) {
                    if (!name.equals(headerNode.getName())) continue;
                    processedHeaders.add(headerNode);
                    component.addHeader(headerNode);
                }
                this.m_headers.removeAll(processedHeaders);
                processedHeaders.clear();
            }
        }
        for (HeaderNode headerNode : this.m_headers) {
            HashSet<Component> targets = new HashSet<Component>();
            HashMap<Component, Integer> weightMap = new HashMap<Component, Integer>();
            int maxWeight = 0;
            int totalWeight = 0;
            Component bestComponent = null;
            for (Link link : headerNode.getOutgoing()) {
                Node to = link.getTo();
                if (to.getComponent() == this || to.getComponent() == null) continue;
                targets.add(to.getComponent());
                Integer weight = (Integer)weightMap.get(to.getComponent());
                weight = weight == null ? Integer.valueOf(link.getWeight()) : Integer.valueOf(weight + link.getWeight());
                weightMap.put(to.getComponent(), weight);
                if (weight > maxWeight) {
                    maxWeight = weight;
                    bestComponent = to.getComponent();
                }
                totalWeight += link.getWeight();
            }
            if (targets.size() == 1) {
                ((Component)targets.iterator().next()).addHeader(headerNode);
                continue;
            }
            targets.clear();
            for (Node targetNode : nameMap.get((Object)headerNode.getName())) {
                targets.add(targetNode.getComponent());
            }
            if (targets.size() == 1) {
                ((Component)targets.iterator().next()).addHeader(headerNode);
                continue;
            }
            if (totalWeight > 0 && maxWeight == totalWeight) {
                assert (bestComponent != null);
                bestComponent.addHeader(headerNode);
                continue;
            }
            Component comp = new Component();
            comp.addHeader(headerNode);
            result.add(comp);
        }
        return result;
    }

    private Collection<? extends Component> simpleSplit() {
        ArrayList<Component> result = new ArrayList<Component>();
        Component main = new Component();
        CPlusPlusModule anchorModule = this.getAnchorModule();
        result.add(main);
        for (HeaderNode header : this.m_headers) {
            if (header.getName().equalsIgnoreCase(this.m_name)) {
                main.addHeader(header);
                continue;
            }
            Component comp = new Component();
            comp.addHeader(header);
            comp.setAvoidMisplacedDeclarationearnings();
            comp.setAnchorModule(anchorModule);
            result.add(comp);
        }
        this.m_sources.forEach(s -> main.addSource((SourceNode)s));
        return result;
    }

    void createdMisplacedDeclarationWarnings() {
        if (this.avoidMisplacedDeclarationWarnings()) {
            return;
        }
        for (HeaderNode header : this.m_headers) {
            if (header.getModule() == null) continue;
            for (Link link : header.getOutgoing()) {
                Node target = link.getTo();
                if (target.getComponent() == header.getComponent()) continue;
                link.getDeclarations().forEach(pe -> pe.addIssue((Issue)new MisplacedDeclarationIssue((NamedElement)pe)));
            }
        }
    }

    private String determinePrimaryHeader() {
        if (this.m_headers.size() == 1) {
            return this.m_headers.get(0).getName();
        }
        String name = null;
        int biggestHeaderSize = 0;
        HeaderNode biggest = null;
        for (HeaderNode headerNode : this.m_headers) {
            int size = 0;
            if (headerNode.getIncoming().size() != 0) continue;
            for (ISourceElementCountProvider nextProgrammingElement : headerNode.getSource().getChildrenRecursively(ISourceElementCountProvider.class, new Class[0])) {
                int nextSec = nextProgrammingElement.getSourceElementCount();
                if (nextSec == -1) continue;
                size += nextSec;
            }
            if (biggest != null && size <= biggestHeaderSize) continue;
            biggestHeaderSize = size;
            biggest = headerNode;
            name = headerNode.getName();
        }
        if (biggest != null && this.m_headers.indexOf(biggest) > 0) {
            this.m_headers.remove(biggest);
            this.m_headers.add(0, biggest);
        }
        return name;
    }

    boolean createModelComponent(IComponentAnalyzer analyzer) {
        assert (analyzer != null) : "Parameter 'analyzer' of method 'createModelComponent' must not be null";
        Object componentParent = this.getSourceDirectory();
        boolean explicit = false;
        if (componentParent == null) {
            CPlusPlusModule module;
            CPlusPlusModule cPlusPlusModule = module = this.isAnchored() ? this.getAnchorModule() : null;
            if (module == null) {
                for (HeaderNode header : this.m_headers) {
                    module = header.getModule();
                    if (module != null) break;
                }
            }
            if (module != null) {
                TFile primaryDir = this.getPrimaryDirectory();
                Object root = module.getChildren(RootDirectoryPath.class).stream().filter(r -> r.getFile().equals((Object)primaryDir) || r.getFile().isParentOf((File)primaryDir)).findFirst().orElse(null);
                if (root == null) {
                    root = new CppWeakRootDirectoryPath((IModelServiceProvider)module.getParent(SoftwareSystem.class, new Class[0]), (NamedElement)module, primaryDir);
                    module.addChild(root.getNamedElement());
                    componentParent = root;
                } else {
                    componentParent = root.getFile().equals((Object)primaryDir) ? root : analyzer.getDirectoryFragmentFor((RootDirectoryPath)root.getNamedElement(), primaryDir);
                }
                explicit = true;
            }
        }
        String name = this.getName();
        CppComponent modelComponent = null;
        if (componentParent != null) {
            modelComponent = (CppComponent)componentParent.getNamedElement().getUniqueChild((NamedElement.IFilter)new ShortNameFilter(name), CppComponent.class);
        }
        if (modelComponent == null) {
            modelComponent = this.m_modelComponent = analyzer.createModelComponent((IDirectoryPath)componentParent, name);
            modelComponent.setAssignmentReason(explicit ? CppComponent.AssignmentReason.EXPLICIT : CppComponent.AssignmentReason.ANCHORED);
        }
        for (HeaderNode header : this.m_headers) {
            analyzer.moveToParent((NamedElement)header.getSource(), (NamedElement)modelComponent);
        }
        for (SourceNode source : this.m_sources) {
            analyzer.moveToParent((NamedElement)source.getSource(), (NamedElement)modelComponent);
        }
        return componentParent != null;
    }

    List<TFile> getDirectories() {
        TFile dir;
        ArrayList<TFile> directories = new ArrayList<TFile>();
        for (SourceNode source : this.m_sources) {
            dir = source.getSource().getFile().getParentFile().getNormalizedAbsoluteFile();
            if (directories.contains(dir)) continue;
            directories.add(dir);
        }
        for (HeaderNode header : this.m_headers) {
            dir = header.getSource().getFile().getParentFile().getNormalizedAbsoluteFile();
            if (directories.contains(dir)) continue;
            directories.add(dir);
        }
        return directories;
    }

    private List<Node> getNodes() {
        ArrayList<Node> result = new ArrayList<Node>();
        this.m_headers.forEach(n -> {
            boolean bl = result.add((Node)n);
        });
        this.m_sources.forEach(n -> {
            boolean bl = result.add((Node)n);
        });
        return result;
    }

    List<TFile> getRelevantHeaderDirectories() {
        String name = this.getName();
        return this.m_headers.stream().filter(n -> n.getName().equals(name)).map(n -> n.getSource().getFile().getParentFile().getNormalizedAbsoluteFile()).distinct().collect(Collectors.toList());
    }

    TFile getPrimaryDirectory() {
        if (!this.m_primaryDirectoryEstablished) {
            this.m_primaryDirectoryEstablished = true;
            this.determinePrimaryHeader();
            this.m_primaryDirectory = this.getNodes().stream().filter(n -> n.getIncoming().size() > 0).map(n -> n.getSource().getFile().getParentFile()).findFirst().orElse(this.getDirectories().get(0));
        }
        return this.m_primaryDirectory;
    }

    CppHeader getPrimaryHeader() {
        this.getPrimaryDirectory();
        return this.m_headers.get(0).getSource();
    }

    void rebaseHeaders() {
        if (this.m_modelComponent.getParent() == null) {
            return;
        }
        for (HeaderNode header : this.m_headers) {
            header.getSource().rebase();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        if (this.m_modelComponent != null && this.m_modelComponent.getParent() != null) {
            sb.append(this.m_modelComponent.getName());
            sb.append(": ");
        }
        sb.append(this.m_headers.toString());
        sb.append(this.m_sources.toString());
        sb.append(')');
        return sb.toString();
    }
}

