/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CxxConfigFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IncludeAndOptionModel;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public final class CompilerDefinitionModel {
    private String m_name;
    private String m_description;
    private int m_pointerSize = 4;
    private int m_longSize = 4;
    private int m_wcharSize = 4;
    private boolean m_unsignedCharacters;
    private boolean m_vla;
    private boolean m_microsoftMode;
    private String m_microsoftVersion;
    private boolean m_gnuMode;
    private String m_gnuVersion;
    private boolean m_clangMode;
    private String m_clangVersion;
    private boolean m_allowCpp = true;
    private boolean m_allCpp;
    private boolean m_cpp03;
    private boolean m_cpp11;
    private boolean m_cpp14;
    private boolean m_cpp17;
    private boolean m_cpp20;
    private boolean m_enableExceptionHandling = true;
    private boolean m_cfront21;
    private boolean m_cfront30;
    private boolean m_allowC = true;
    private boolean m_c89;
    private boolean m_c99;
    private boolean m_c11;
    private boolean m_activate = true;
    private final IncludeAndOptionModel m_cModel = new IncludeAndOptionModel();
    private final IncludeAndOptionModel m_cppModel = new IncludeAndOptionModel();

    public boolean isComplete() {
        return !(this.m_name == null || this.m_description == null || this.m_name.length() <= 0 || this.m_description.length() <= 0 || !this.m_allowC && !this.m_allowCpp || this.m_allowC && !this.m_cModel.hasSystemIncludes() || this.m_allowCpp && !this.m_cppModel.hasSystemIncludes());
    }

    public String getName() {
        return this.m_name == null ? "" : this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getDescription() {
        return this.m_description == null ? "" : this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public int getPointerSize() {
        return this.m_pointerSize;
    }

    public void setPointerSize(int pointerSize) {
        this.m_pointerSize = pointerSize;
    }

    public int getLongSize() {
        return this.m_longSize;
    }

    public void setLongSize(int longSize) {
        this.m_longSize = longSize;
    }

    public int getWcharSize() {
        return this.m_wcharSize;
    }

    public void setWcharSize(int wcharSize) {
        this.m_wcharSize = wcharSize;
    }

    public boolean isUnsignedCharacters() {
        return this.m_unsignedCharacters;
    }

    public void setUnsignedCharacters(boolean unsignedCharacters) {
        this.m_unsignedCharacters = unsignedCharacters;
    }

    public boolean isEnableExceptionHandling() {
        return this.m_enableExceptionHandling;
    }

    public void setEnableExceptionHandling(boolean enableExceptionHandling) {
        this.m_enableExceptionHandling = enableExceptionHandling;
    }

    public boolean isMicrosoftMode() {
        return this.m_microsoftMode;
    }

    public void setMicrosoftMode(boolean microsoftMode) {
        this.m_microsoftMode = microsoftMode;
    }

    public String getMicrosoftVersion() {
        return this.m_microsoftVersion == null ? "" : this.m_microsoftVersion;
    }

    public void setMicrosoftVersion(String microsoftVersion) {
        this.m_microsoftVersion = microsoftVersion;
    }

    public boolean isGnuMode() {
        return this.m_gnuMode;
    }

    public void setGnuMode(boolean gnuMode) {
        this.m_gnuMode = gnuMode;
    }

    public String getGnuVersion() {
        return this.m_gnuVersion == null ? "" : this.m_gnuVersion;
    }

    public void setGnuVersion(String gnuVersion) {
        this.m_gnuVersion = gnuVersion;
    }

    public final String getClangVersion() {
        return this.m_clangVersion == null ? "" : this.m_clangVersion;
    }

    public final void setClangVersion(String clangVersion) {
        this.m_clangVersion = clangVersion;
    }

    public boolean isClangMode() {
        return this.m_clangMode;
    }

    public void setClangMode(boolean clangMode) {
        this.m_clangMode = clangMode;
    }

    public boolean isAllowCpp() {
        return this.m_allowCpp;
    }

    public void setAllowCpp(boolean allowCpp) {
        this.m_allowCpp = allowCpp;
        if (!allowCpp) {
            this.m_allCpp = false;
            this.m_cpp03 = false;
            this.m_cpp11 = false;
            this.m_cpp14 = false;
            this.m_cpp17 = false;
            this.m_cfront21 = false;
            this.m_cfront30 = false;
        }
    }

    public boolean isAllCpp() {
        return this.m_allCpp;
    }

    public void setAllCpp(boolean allCpp) {
        this.m_allCpp = allCpp;
        this.setAllowC(!allCpp);
    }

    public boolean isCpp03() {
        return this.m_cpp03;
    }

    public void setCpp03(boolean cpp03) {
        this.m_cpp03 = cpp03;
        if (cpp03) {
            this.m_cpp17 = false;
            this.m_cpp14 = false;
            this.m_cpp11 = false;
        }
    }

    public boolean isCpp11() {
        return this.m_cpp11;
    }

    public void setCpp11(boolean cpp11) {
        this.m_cpp11 = cpp11;
        if (cpp11) {
            this.m_cfront30 = false;
            this.m_cfront21 = false;
            this.m_cpp03 = false;
        }
    }

    public boolean isCpp14() {
        return this.m_cpp14;
    }

    public void setCpp14(boolean cpp14) {
        this.m_cpp14 = cpp14;
        if (cpp14) {
            this.m_cfront30 = false;
            this.m_cfront21 = false;
            this.m_cpp03 = false;
        }
    }

    public boolean isCpp17() {
        return this.m_cpp17;
    }

    public void setCpp17(boolean cpp17) {
        this.m_cpp17 = cpp17;
        if (cpp17) {
            this.m_cfront30 = false;
            this.m_cfront21 = false;
            this.m_cpp03 = false;
        }
    }

    public boolean isCpp20() {
        return this.m_cpp20;
    }

    public void setCpp20(boolean cpp20) {
        this.m_cpp20 = cpp20;
        if (cpp20) {
            this.m_cfront30 = false;
            this.m_cfront21 = false;
            this.m_cpp03 = false;
        }
    }

    public boolean isCfront21() {
        return this.m_cfront21;
    }

    public void setCfront21(boolean cfront21) {
        this.m_cfront21 = cfront21;
        if (cfront21) {
            this.m_cfront30 = false;
            this.m_cpp17 = false;
            this.m_cpp14 = false;
            this.m_cpp11 = false;
        }
    }

    public boolean isCfront30() {
        return this.m_cfront30;
    }

    public void setCfront30(boolean cfront30) {
        this.m_cfront30 = cfront30;
        if (cfront30) {
            this.m_cfront21 = false;
            this.m_cpp17 = false;
            this.m_cpp14 = false;
            this.m_cpp11 = false;
        }
    }

    public boolean isVla() {
        return this.m_vla;
    }

    public void setVla(boolean vla) {
        this.m_vla = vla;
    }

    public boolean isAllowC() {
        return this.m_allowC;
    }

    public void setAllowC(boolean allowC) {
        this.m_allowC = allowC;
        if (!allowC) {
            this.m_c11 = false;
            this.m_c99 = false;
            this.m_c89 = false;
        }
    }

    public boolean isC89() {
        return this.m_c89;
    }

    public void setC89(boolean c89) {
        this.m_c89 = c89;
        if (c89) {
            this.m_c11 = false;
            this.m_c99 = false;
        }
    }

    public boolean isC99() {
        return this.m_c99;
    }

    public void setC99(boolean c99) {
        this.m_c99 = c99;
        if (c99) {
            this.m_c11 = false;
            this.m_c89 = false;
        }
    }

    public boolean isC11() {
        return this.m_c11;
    }

    public void setC11(boolean c11) {
        this.m_c11 = c11;
        if (c11) {
            this.m_c99 = false;
            this.m_c89 = false;
        }
    }

    public boolean isActivate() {
        return this.m_activate;
    }

    public void setActivate(boolean activate) {
        this.m_activate = activate;
    }

    public IncludeAndOptionModel getcModel() {
        return this.m_cModel;
    }

    public IncludeAndOptionModel getCppModel() {
        return this.m_cppModel;
    }

    public void init(CxxConfigFile config) {
        assert (config != null) : "Parameter 'config' of method 'init' must not be null";
        this.setUnsignedCharacters(config.getCSettings().isUnsignedChars() || config.getCppSettings().isUnsignedChars());
        this.setName(config.getPresentationName() + " " + config.getVersion());
        this.setDescription(this.getName());
        this.setC99(config.getCSettings().isC99());
        this.setVla(config.getCSettings().isVariableLengthArrays() || config.getCppSettings().isVariableLengthArrays());
        this.setGnuMode(config.isGnuMode());
        if (this.isGnuMode()) {
            this.m_pointerSize = 8;
            this.m_longSize = 8;
        }
        this.setMicrosoftMode(config.isMicrosoftMode());
        if (this.isMicrosoftMode()) {
            this.m_wcharSize = 2;
        }
        this.setGnuVersion(config.getGnuVersion());
        this.setMicrosoftVersion(config.getMicrosoftVersion());
        this.m_cModel.getSystemIncludes().clear();
        this.m_cppModel.getSystemIncludes().clear();
        this.m_cModel.getSystemIncludes().addAll(config.getCSettings().getSysIncludeDirectories());
        this.m_cppModel.getSystemIncludes().addAll(config.getCppSettings().getSysIncludeDirectories());
        this.m_cModel.getOptions().clear();
        this.m_cppModel.getOptions().clear();
        this.m_cModel.getOptions().addAll(config.getCSettings().getOptions());
        this.m_cppModel.getOptions().addAll(config.getCppSettings().getOptions());
        this.setEnableExceptionHandling(config.getCppSettings().isEnableExceptionHandling());
    }

    public List<TFile> getAllSystemIncludeDirectories() {
        LinkedHashSet result = new LinkedHashSet();
        this.m_cModel.getSystemIncludes().forEach(inc -> {
            boolean bl = result.add(new TFile(inc));
        });
        this.m_cppModel.getSystemIncludes().forEach(inc -> {
            boolean bl = result.add(new TFile(inc));
        });
        return new ArrayList<TFile>(result);
    }
}

