/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.Type;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.TypeVisitor;

public class BasicType
extends Type {
    private final Kind m_Kind;

    private BasicType(Kind kind) {
        this.m_Kind = kind;
    }

    public static BasicType get(Kind kind) {
        return kind.getBasicType();
    }

    public Kind getKind() {
        return this.m_Kind;
    }

    public static BasicType getByEncoding(int c) {
        Kind[] kindArray = Kind.values();
        int n = kindArray.length;
        int n2 = 0;
        while (n2 < n) {
            Kind k = kindArray[n2];
            if (c == k.getEncodedBy()) {
                return k.getBasicType();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void accept(TypeVisitor v) {
        ((IVisitor)((Object)v)).visitBasicType(this);
    }

    public static interface IVisitor {
        public void visitBasicType(BasicType var1);
    }

    public static enum Kind {
        VOID("void", 'v'),
        CHAR("char", 'c'),
        SIGNED_CHAR("signed char", 'C'),
        WCHAR_T("wchar_t", 'w'),
        SHORT("short", 'h'),
        INT("int", 'i'),
        LONG("long", 'l'),
        LONG_LONG("long long", 'x'),
        INT128("__int128_t", 'y'),
        UNSIGNED_CHAR("unsigned char", 'B'),
        UNSIGNED_SHORT("unsigned short", 'H'),
        UNSIGNED_INT("unsigned int", 'I'),
        UNSIGNED_LONG("unsigned long", 'L'),
        UNSIGNED_LONG_LONG("unsigned long long", 'X'),
        UINT128("__uint128_t", 'Y'),
        FLOAT("float", 'f'),
        DOUBLE("double", 'd'),
        LONG_DOUBLE("long double", 'D'),
        BOOL("bool", 'b'),
        ERROR("error", 'e'),
        NULL("null", 'n'),
        UNKNOWN("unknown", 'u');

        private final BasicType m_BasicType = new BasicType(this);
        private final String m_Literal;
        private final char m_EncodedBy;

        private Kind(String lit, char encodedBy) {
            this.m_Literal = lit;
            this.m_EncodedBy = encodedBy;
        }

        public char getEncodedBy() {
            return this.m_EncodedBy;
        }

        public String getLiteral() {
            return this.m_Literal;
        }

        private BasicType getBasicType() {
            return this.m_BasicType;
        }
    }
}

