/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CompilationUnitFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSource;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class CppHeader
extends CppSource {
    private List<CompilationUnitFragment> m_fragments;
    private boolean m_hasCppElements = false;
    private short m_serialNumber = 0;

    protected CppHeader(NamedElement parent) {
        super(parent);
    }

    protected CppHeader(IModelServiceProvider msp, NamedElement parent, TFile file) {
        super(msp, parent, file);
    }

    private static TFile getFile(CppHeader header) {
        assert (header != null) : "Parameter 'header' of method 'getFile' must not be null";
        return header.getFile().getAbsoluteFile();
    }

    public final void setSerialNumber(int serialNumber) {
        this.m_serialNumber = (short)serialNumber;
    }

    protected CppHeader(IModelServiceProvider msp, NamedElement parent, CppHeader header) {
        super(msp, parent, CppHeader.getFile(header));
        this.m_fragments = header.m_fragments;
        this.m_serialNumber = header.m_serialNumber;
        header.m_fragments = null;
        if (this.m_fragments != null) {
            for (CompilationUnitFragment f : this.m_fragments) {
                assert (f.getAssociatedHeader() == header);
                f.setAssociatedHeader(this);
            }
        }
        this.setModifiableChildrenList(header.getModifiableChildrenList());
        if (this.getModifiableChildrenList() != null) {
            for (NamedElement child : this.getModifiableChildrenList()) {
                child.setParent((NamedElement)this);
            }
        }
        header.setModifiableChildrenList(null);
        this.m_hasCppElements = header.m_hasCppElements;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        String result = "(header)" + super.getFullyQualifiedNamePart();
        if (this.m_serialNumber > 0) {
            result = result + INNER_NAME_PARTS_SEPARATOR + Short.toString(this.m_serialNumber);
        }
        return result;
    }

    public void markAsCPlusPlus() {
        this.m_hasCppElements = true;
    }

    public IFileType getFileType() {
        if (this.m_hasCppElements) {
            return CPlusPlusFileType.CPP_SOURCE;
        }
        return CPlusPlusFileType.C_SOURCE;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeBoolean(this.m_hasCppElements);
        writer.writeShort(this.m_serialNumber);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        int size;
        super.retrieve(reader);
        this.m_hasCppElements = reader.readBoolean();
        if (reader.getVersion() >= 6 && reader.getVersion() < 10 && (size = reader.readInt()) > 0) {
            while (size-- > 0) {
                reader.readInt();
            }
        }
        if (reader.getVersion() >= 20) {
            this.m_serialNumber = reader.readShort();
        }
    }

    public final String getImageResourceName() {
        return "CppHeaderFile";
    }

    public boolean isIncluded() {
        return this.m_fragments != null && this.m_fragments.size() > 0;
    }

    public void remove() {
        if (this.m_fragments != null) {
            ArrayList<CompilationUnitFragment> fragments = new ArrayList<CompilationUnitFragment>(this.m_fragments);
            for (CompilationUnitFragment fragment : fragments) {
                fragment.remove();
            }
            assert (this.m_fragments == null);
        }
        super.remove();
    }

    public Collection<CppHeader> getIncludedHeaders() {
        HashSet<CppHeader> includedHeaders = new HashSet<CppHeader>();
        if (this.m_fragments != null) {
            for (CompilationUnitFragment fragment : this.m_fragments) {
                for (CompilationUnitFragment child : fragment.getChildrenRecursively(CompilationUnitFragment.class, new Class[0])) {
                    if (child.getAssociatedHeader() == this) continue;
                    includedHeaders.add(child.getAssociatedHeader());
                }
            }
        }
        return includedHeaders;
    }

    public void addFragment(CompilationUnitFragment fragment) {
        if (this.m_fragments == null) {
            this.m_fragments = new ArrayList<CompilationUnitFragment>();
        }
        this.m_fragments.add(fragment);
    }

    public void removeFragment(CompilationUnitFragment fragment) {
        if (this.m_fragments != null) {
            this.m_fragments.remove((Object)fragment);
            if (this.m_fragments.size() == 0) {
                this.m_fragments = null;
                this.remove();
            }
        }
    }

    public List<CompilationUnitFragment> getFragments() {
        if (this.m_fragments == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_fragments);
    }

    @Override
    public Collection<CppSource> getSourcesDependingOnMe() {
        LinkedHashSet<CppSource> result = new LinkedHashSet<CppSource>();
        if (this.m_fragments != null) {
            for (CompilationUnitFragment fragment : this.m_fragments) {
                CppSource sourceFile = (CppSource)fragment.getParent().getElement();
                assert (sourceFile != null) : "'fragment' must have a SourceFile parent";
                result.add(sourceFile);
            }
        }
        return result;
    }

    public List<CppSourceFile> getSourceFilesIncludingMe() {
        IncludeDependencyVisitor visitor = new IncludeDependencyVisitor();
        this.accept(visitor);
        return visitor.m_result;
    }

    @Override
    public boolean isIncludeFile() {
        return true;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppHeader(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppHeader(CppHeader var1);
    }

    private class IncludeDependencyVisitor
    extends NamedElementVisitor
    implements IVisitor,
    CppSourceFile.IVisitor {
        private final List<CppSourceFile> m_result = new ArrayList<CppSourceFile>();
        private final Set<CppHeader> m_visited = new HashSet<CppHeader>();

        private IncludeDependencyVisitor() {
        }

        @Override
        public void visitCppSourceFile(CppSourceFile element) {
            this.m_result.add(element);
        }

        @Override
        public void visitCppHeader(CppHeader element) {
            if (this.m_visited.add(element)) {
                element.getSourcesDependingOnMe().forEach(s -> s.accept(this));
            }
        }
    }
}

