/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import java.util.Collections;
import java.util.List;

public final class CPlusPlusIssueId
extends Enum<CPlusPlusIssueId>
implements IIssueId {
    public static final /* enum */ CPlusPlusIssueId CPP_PARSER_ERROR = new CPlusPlusIssueId("C,Cpp Parser error", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.ELEMENT, false, true, true);
    public static final /* enum */ CPlusPlusIssueId INTERNAL_ERROR = new CPlusPlusIssueId("Internal error", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.ELEMENT, false, true, true);
    public static final /* enum */ CPlusPlusIssueId NON_HEADER_DECLARATION = new CPlusPlusIssueId("External declaration should be placed in a header file", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.ELEMENT, true, true);
    @Deprecated
    public static final /* enum */ CPlusPlusIssueId VAR_DEFINED_IN_HEADER = new CPlusPlusIssueId("Global variables should not be defined in header files", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.ELEMENT, true, true);
    @Deprecated
    public static final /* enum */ CPlusPlusIssueId SOURCE_HAS_MULTIPLE_HEADERS = new CPlusPlusIssueId("Elements are declared in more than one header file", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.ELEMENT, true, true);
    public static final /* enum */ CPlusPlusIssueId MISPLACED_DECLARATION = new CPlusPlusIssueId("Element should not be declared in this header file", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.ELEMENT, true, true);
    public static final /* enum */ CPlusPlusIssueId COMPONENT_HAS_MORE_THAN_ONE_HEADER = new CPlusPlusIssueId("Component has more than one header file", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.ELEMENT, true, true);
    public static final /* enum */ CPlusPlusIssueId SOURCE_WITHOUT_HEADER = new CPlusPlusIssueId("Source has no associated header file", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.ELEMENT, true, true);
    public static final /* enum */ CPlusPlusIssueId EMPTY_SOURCE = new CPlusPlusIssueId("Source file does not contain any definitions", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.ELEMENT, true, true);
    public static final /* enum */ CPlusPlusIssueId MULTIPLE_DEFINITIONS = new CPlusPlusIssueId("Element defined more than once", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.ELEMENT, true);
    public static final /* enum */ CPlusPlusIssueId SYSTEM_COMPILER_DEFINITION_GROOVY_TEMPLATE_ERROR = new CPlusPlusIssueId("Groovy template cannot be resolved (System)", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR));
    public static final /* enum */ CPlusPlusIssueId INST_COMPILER_DEFINITION_GROOVY_TEMPLATE_ERROR = new CPlusPlusIssueId("Groovy template cannot be resolved (Installation)", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.ERROR));
    public static final /* enum */ CPlusPlusIssueId NO_SYSINCLUDES = new CPlusPlusIssueId("Missing C,C++ system includes", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId SYSINCLUDE_INVALID = new CPlusPlusIssueId("System include invalid (Installation)", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId SYSTEM_SYSINCLUDE_INVALID = new CPlusPlusIssueId("System include invalid (System)", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId INST_INCLUDE_INVALID = new CPlusPlusIssueId("Include option invalid (Installation)", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId SYSTEM_INCLUDE_INVALID = new CPlusPlusIssueId("Include option invalid (System)", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId SEARCH_PATH_INVALID_OR_MISSING = new CPlusPlusIssueId("Search path invalid or missing", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.WARNING));
    public static final /* enum */ CPlusPlusIssueId MISSING_COMPILER_DEFINITION_REFERENCE = new CPlusPlusIssueId("No compiler definition referenced", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId ACTIVE_COMPILER_DEFINITION_MISSING = new CPlusPlusIssueId("No active compiler definition specified", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.WARNING));
    public static final /* enum */ CPlusPlusIssueId MAKE_FILE_ERROR = new CPlusPlusIssueId("Error processing Makefile", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId MAKE_FILE_WARNING = new CPlusPlusIssueId("Warning processing Makefile", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId MAKE_FILE_ADDITIONAL_OPTIONS_ERROR = new CPlusPlusIssueId("Groovy template for additional Makefile options is invalid", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId MAKE_FILE_ADDITIONAL_PROPERTIES_ERROR = new CPlusPlusIssueId("Additional properties for analyzing the Makefile are invalid", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId INST_INVALID_COMPILER_OPTIONS = new CPlusPlusIssueId("Compiler options contain ignored lines", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId VISUAL_STUDIO_PROJECT_FILE_NOT_FOUND = new CPlusPlusIssueId("Visual Studio Project file does not exist", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId VISUAL_STUDIO_PROJECT_FILE_PROCESSING_ERROR = new CPlusPlusIssueId("Failed to process C,C++ Visual Studio project file", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CPlusPlusIssueId VISUAL_STUDIO_MODULE_COMPILER_DEFINITION_MISMATCH = new CPlusPlusIssueId("Active definition is not generated based on Visual Studio installation", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, false);
    public static final /* enum */ CPlusPlusIssueId MSBUILD_FAILURE = new CPlusPlusIssueId("Failed to execute MSBuild", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, false);
    public static final /* enum */ CPlusPlusIssueId VISUAL_STUDIO_GENERATE_COMPILER_DEFINITION_ERROR = new CPlusPlusIssueId("Failed to generate compiler definitions", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, false);
    private final String m_presentationName;
    private final IssueCategory m_category;
    private final List<Severity> m_supportedSeverities;
    private final IIssueId.PatternEditMode m_patternEditMode;
    private final boolean m_requiresIndividualResolution;
    private final boolean m_persist;
    private final boolean m_previewOnly;
    private static final /* synthetic */ CPlusPlusIssueId[] ENUM$VALUES;

    static {
        ENUM$VALUES = new CPlusPlusIssueId[]{CPP_PARSER_ERROR, INTERNAL_ERROR, NON_HEADER_DECLARATION, VAR_DEFINED_IN_HEADER, SOURCE_HAS_MULTIPLE_HEADERS, MISPLACED_DECLARATION, COMPONENT_HAS_MORE_THAN_ONE_HEADER, SOURCE_WITHOUT_HEADER, EMPTY_SOURCE, MULTIPLE_DEFINITIONS, SYSTEM_COMPILER_DEFINITION_GROOVY_TEMPLATE_ERROR, INST_COMPILER_DEFINITION_GROOVY_TEMPLATE_ERROR, NO_SYSINCLUDES, SYSINCLUDE_INVALID, SYSTEM_SYSINCLUDE_INVALID, INST_INCLUDE_INVALID, SYSTEM_INCLUDE_INVALID, SEARCH_PATH_INVALID_OR_MISSING, MISSING_COMPILER_DEFINITION_REFERENCE, ACTIVE_COMPILER_DEFINITION_MISSING, MAKE_FILE_ERROR, MAKE_FILE_WARNING, MAKE_FILE_ADDITIONAL_OPTIONS_ERROR, MAKE_FILE_ADDITIONAL_PROPERTIES_ERROR, INST_INVALID_COMPILER_OPTIONS, VISUAL_STUDIO_PROJECT_FILE_NOT_FOUND, VISUAL_STUDIO_PROJECT_FILE_PROCESSING_ERROR, VISUAL_STUDIO_MODULE_COMPILER_DEFINITION_MISMATCH, MSBUILD_FAILURE, VISUAL_STUDIO_GENERATE_COMPILER_DEFINITION_ERROR};
    }

    public static CPlusPlusIssueId fromStandardName(String standardName) throws IllegalArgumentException {
        assert (standardName != null) : "'standardName' must not be null";
        assert (standardName.length() > 0) : "'standardName' must not be empty";
        String name = StringUtility.convertStandardNameToConstantName((String)standardName);
        return CPlusPlusIssueId.valueOf(name);
    }

    private CPlusPlusIssueId(String presentationName, IssueCategory category, List<Severity> severities) {
        this(presentationName, category, severities, null, false, false, false);
    }

    private CPlusPlusIssueId(String presentationName, IssueCategory category, List<Severity> severities, IIssueId.PatternEditMode matchingMode, boolean requiresIndividualResolution, boolean persist) {
        this(presentationName, category, severities, matchingMode, requiresIndividualResolution, persist, false);
    }

    private CPlusPlusIssueId(String presentationName, IssueCategory category, List<Severity> severity, IIssueId.PatternEditMode matchingMode, boolean requiresIndividualResolution) {
        this(presentationName, category, severity, matchingMode, requiresIndividualResolution, false);
    }

    private CPlusPlusIssueId(String presentationName, IssueCategory category, List<Severity> severities, IIssueId.PatternEditMode matchingMode, boolean requiresIndividualResolution, boolean persist, boolean previewOnly) {
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'JavaIssueId' must not be empty";
        assert (category != null) : "Parameter 'category' of method 'JavaIssueId' must not be null";
        assert (severities != null && !severities.isEmpty()) : "Parameter 'severities' of method 'CPlusPlusIssueId' must not be empty";
        this.m_presentationName = presentationName;
        this.m_category = category;
        this.m_supportedSeverities = severities;
        this.m_patternEditMode = matchingMode;
        this.m_requiresIndividualResolution = requiresIndividualResolution;
        this.m_persist = persist;
        this.m_previewOnly = previewOnly;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public IssueCategory getCategory() {
        return this.m_category;
    }

    public List<Severity> getSupportedSeverities() {
        return this.m_supportedSeverities;
    }

    public boolean isParserModelIssue() {
        return true;
    }

    public boolean previewOnly() {
        return this.m_previewOnly;
    }

    public boolean persist() {
        return this.m_persist;
    }

    public boolean isResolvable() {
        return this.m_patternEditMode != null;
    }

    public IIssueId.PatternEditMode getPatternEditMode() {
        return this.m_patternEditMode;
    }

    public boolean requiresIndividualResolution() {
        return this.m_requiresIndividualResolution;
    }

    public String getProviderName() {
        return CPlusPlusLanguage.INSTANCE.getStandardName();
    }

    public static CPlusPlusIssueId[] values() {
        CPlusPlusIssueId[] cPlusPlusIssueIdArray = ENUM$VALUES;
        int n = cPlusPlusIssueIdArray.length;
        CPlusPlusIssueId[] cPlusPlusIssueIdArray2 = new CPlusPlusIssueId[n];
        System.arraycopy(ENUM$VALUES, 0, cPlusPlusIssueIdArray2, 0, n);
        return cPlusPlusIssueIdArray2;
    }

    public static CPlusPlusIssueId valueOf(String string) {
        return Enum.valueOf(CPlusPlusIssueId.class, string);
    }
}

