/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.RootDirectorySettings;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusDeltaDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileNode;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.Collections;

final class CPlusPlusSourceNodeDeltaDetector
extends CPlusPlusDeltaDetector {
    CPlusPlusSourceNodeDeltaDetector(IWorkerContext workerContext, ILanguageProvider languageProvider, IWorkspaceFilter filter, Module module, boolean firstModificationOnly) {
        super(workerContext, languageProvider, filter, module, Collections.emptyList(), firstModificationOnly);
    }

    protected void prepareScan(OperationResult result) {
    }

    @Override
    protected void scanRootDirectory(RootDirectoryPath root) {
        if (this.scanningIsDone()) {
            return;
        }
        RootDirectorySettings settingsNode = (RootDirectorySettings)root.getFirstChild(RootDirectorySettings.class);
        if (settingsNode != null) {
            TFile rootDir = root.getFile();
            for (SourceFileNode sourceNode : settingsNode.getChildren(SourceFileNode.class)) {
                String fileName = sourceNode.getPath();
                CPlusPlusFileType fileType = fileName.endsWith(".c") ? CPlusPlusFileType.C_SOURCE : CPlusPlusFileType.CPP_SOURCE;
                TFile file = new TFile((File)rootDir, fileName);
                this.consume(rootDir, file.getNormalizedFile(), fileType);
            }
        }
    }
}

