/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDGVisitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class TemplateArgumentCollector
extends EDGVisitor {
    private final List<String> m_argNames = new ArrayList<String>();
    private final Map<Object, String> m_argNameMap = new LinkedHashMap<Object, String>();

    TemplateArgumentCollector() {
    }

    @Override
    public void visitTemplateArg(EDG.TemplateArg obj) {
    }

    private void addArgName(String name) {
        this.m_argNames.add(name);
    }

    private void addToLast(String suffix) {
        int last = this.m_argNames.size() - 1;
        assert (last >= 0);
        String val = this.m_argNames.get(last);
        this.m_argNames.set(last, val + suffix);
    }

    @Override
    public void visitTemplateArgType(EDG.TemplateArgType obj) {
        EDG.Type type = obj.type();
        if (type instanceof EDG.TypeTemplateParam) {
            Object argName = this.m_argNameMap.get(type);
            if (argName == null) {
                argName = type.sourceCorresp().name();
                if (argName == null) {
                    type.accept(this);
                } else {
                    if (obj.isPackElement() && obj.isPack()) {
                        argName = (String)argName + "...";
                    }
                    this.m_argNameMap.put(type, (String)argName);
                    this.addArgName((String)argName);
                }
            } else {
                this.addArgName((String)argName);
            }
        } else {
            type.accept(this);
        }
    }

    @Override
    public void visitTemplateArgTempl(EDG.TemplateArgTempl obj) {
        String name;
        assert (obj != null) : "Parameter 'obj' of method 'visitTemplateArgTempl' must not be null";
        EDG.Template tmpl = obj.ptr();
        EDG.Type type = tmpl.prototypeInstantiation_type();
        if (type != null && (name = type.sourceCorresp().name()) != null) {
            this.addArgName(name);
            return;
        }
        this.m_argNames.add("_");
    }

    @Override
    public void visitTypeInteger(EDG.TypeInteger obj) {
        if (obj.boolType()) {
            this.addArgName("bool");
        }
        switch (obj.intKind()) {
            case IK_CHAR: {
                this.addArgName("char");
                break;
            }
            case IK_INT: {
                this.addArgName("int");
                break;
            }
            case IK_INT128: {
                this.addArgName("int128");
                break;
            }
            case IK_LONG: {
                this.addArgName("long");
                break;
            }
            case IK_LONG_LONG: {
                this.addArgName("long long");
                break;
            }
            case IK_SHORT: {
                this.addArgName("short");
                break;
            }
            case IK_SIGNED_CHAR: {
                this.addArgName("signed char");
                break;
            }
            case IK_UNSIGNED_CHAR: {
                this.addArgName("unsigned char");
                break;
            }
            case IK_UNSIGNED_INT: {
                this.addArgName("unsigned int");
                break;
            }
            case IK_UNSIGNED_INT128: {
                this.addArgName("uint128");
                break;
            }
            case IK_UNSIGNED_LONG: {
                this.addArgName("unsigned long");
                break;
            }
            case IK_UNSIGNED_LONG_LONG: {
                this.addArgName("unsigned long long");
                break;
            }
            case IK_UNSIGNED_SHORT: {
                this.addArgName("unsigned short");
                break;
            }
            default: {
                this.addArgName("undefined int");
            }
        }
    }

    @Override
    public void visitTypeClassStructUnion(EDG.TypeClassStructUnion obj) {
        super.visitTypeClassStructUnion(obj);
        EDG.ClassTypeSupplement extraInfo = obj.extraInfo();
        if (extraInfo.templateArgList() != null) {
            String sep = "";
            this.addToLast("<");
            EDG.TemplateArg arg = extraInfo.templateArgList();
            while (arg != null) {
                if (arg.kind() != EDG.TemplArgKind.TAK_START_OF_PACK_EXPANSION) {
                    this.addToLast(sep);
                    sep = ",";
                    arg.accept(this);
                    this.addToLast(this.getAndDeleteLast());
                }
                arg = arg.next();
            }
            this.addToLast(">");
        }
    }

    @Override
    public void visitTypeFloatKind(EDG.TypeFloatKind obj) {
        switch (obj.floatKind()) {
            case FK_DOUBLE: {
                this.addArgName("double");
                break;
            }
            case FK_FLOAT: {
                this.addArgName("float");
                break;
            }
            case FK_FLOAT128: {
                this.addArgName("float128");
                break;
            }
            case FK_FLOAT80: {
                this.addArgName("float80");
                break;
            }
            case FK_LONG_DOUBLE: {
                this.addArgName("long double");
                break;
            }
            default: {
                this.addArgName("undefined float");
            }
        }
    }

    @Override
    public void visitTypePointer(EDG.TypePointer obj) {
        EDG.Type type = obj.type();
        type.accept(this);
        String tok = obj.isReference() ? "&" : "*";
        if (type instanceof EDG.TypeRoutine) {
            String spec = this.getAndDeleteLast();
            int index = spec.indexOf(40);
            this.addArgName(spec.substring(0, index) + " (" + tok + ")" + spec.substring(index));
        } else {
            this.addToLast(tok);
        }
    }

    @Override
    public void visitTypeArray(EDG.TypeArray obj) {
        obj.elementType().accept(this);
        this.addToLast("[]");
    }

    @Override
    public void visitTypeTyperef(EDG.TypeTyperef obj) {
        if (obj.sourceCorresp().name() == null) {
            obj.type().accept(this);
            int q = obj.qualifiers();
            if ((q & 3) != 0) {
                Object typeStr = this.getAndDeleteLast();
                if ((q & 2) != 0) {
                    typeStr = "volatile " + (String)typeStr;
                }
                if ((q & 1) != 0) {
                    typeStr = "const " + (String)typeStr;
                }
                this.addArgName((String)typeStr);
            }
        } else {
            super.visitTypeTyperef(obj);
        }
    }

    @Override
    public void visitType(EDG.Type obj) {
        if (obj.kind() == EDG.TypeKind.TK_VOID) {
            this.addArgName("void");
        } else {
            this.addArgName(obj.sourceCorresp().name());
        }
    }

    @Override
    public void visitTypeTemplateParam(EDG.TypeTemplateParam obj) {
        if (obj.sourceCorresp().name() == null) {
            this.addArgName("class");
        } else {
            this.addArgName(obj.sourceCorresp().name());
        }
    }

    @Override
    public void visitTemplateArgConstant(EDG.TemplateArgConstant obj) {
        EDG.Constant c = obj.constant();
        String type = c.type().sourceCorresp().name();
        if (c.sourceCorresp().name() == null) {
            if (c instanceof EDG.ConstantIntegerValue) {
                long val = ((EDG.ConstantIntegerValue)c).integerValue();
                if (type != null && type.equals("bool")) {
                    this.addArgName(val != 0L ? "true" : "false");
                } else {
                    this.addArgName(Long.toString(val));
                }
            } else if (type != null) {
                this.addArgName(type);
            } else {
                c.type().accept(this);
            }
        } else if (type != null) {
            this.addArgName(type);
        } else {
            this.addArgName(c.sourceCorresp().name());
        }
    }

    private String getAndDeleteLast() {
        int last = this.m_argNames.size() - 1;
        String val = this.m_argNames.get(last);
        this.m_argNames.remove(last);
        return val;
    }

    @Override
    public void visitTypeRoutine(EDG.TypeRoutine obj) {
        obj.returnType().accept(this);
        String sep = "";
        this.addToLast("(");
        EDG.ParamType pt = obj.extraInfo().paramTypeList();
        while (pt != null) {
            this.addToLast(sep);
            sep = ",";
            pt.type().accept(this);
            this.addToLast(this.getAndDeleteLast());
            pt = pt.next();
        }
        this.addToLast(")");
    }

    @Override
    public void visitTypePtrToMember(EDG.TypePtrToMember obj) {
        EDG.Type type = obj.type();
        String typeName = obj.classOfWhichAMember().sourceCorresp().name();
        type.accept(this);
        if (type instanceof EDG.TypeRoutine) {
            String spec = this.getAndDeleteLast();
            int index = spec.indexOf(40);
            this.addArgName(spec.substring(0, index) + " (" + typeName + "::*)" + spec.substring(index));
        } else {
            this.addToLast(" " + typeName + "::*");
        }
    }

    @Override
    public void visitTemplateArgIntegerValue(EDG.TemplateArgIntegerValue obj) {
        this.addArgName(Long.toString(obj.integerValue()));
    }

    String getResult() {
        return String.format("<%s>", String.join((CharSequence)",", this.m_argNames));
    }
}

