/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Component;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.ComponentBuilder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.ComponentRemovalVisitor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.IComponentAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CPlusPlusSoftwareSystemSettingsExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssueId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.MultipleHeaderComponentIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppExternalHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeader;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppIncludeDirectory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSource;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppWeakRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppComponent;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppFunctionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMemberFunctionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppVariable;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusExternal;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusUnboundComponents;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.settings.CPlusPlusUnboundExternalFilter;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComponentAnalyzer
implements IComponentAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentAnalyzer.class);
    private final Map<TFile, CPlusPlusModule> m_headerFileToModuleMap = new THashMap();
    private final List<CPlusPlusModule> m_modules = new ArrayList<CPlusPlusModule>();
    private final MultipleValueMap<TFile, CPlusPlusModule> m_directoryToModule = new MultipleValueMap();
    private final MultipleValueMap<TFile, CPlusPlusModule> m_rootsToModules = new MultipleValueMap();
    private final Collection<TFile> m_otherIncludeRoots;
    private final SoftwareSystem m_softwareSystem;
    private final CPlusPlusUnboundExternalFilter m_externalFilter;
    private List<Component> m_components = new ArrayList<Component>();

    private ComponentAnalyzer(SoftwareSystem softwareSystem, Collection<TFile> otherIncludes) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ComponentAnalyzer' must not be null";
        assert (otherIncludes != null) : "Parameter 'otherIncludes' of method 'ComponentAnalyzer' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_otherIncludeRoots = otherIncludes.stream().sorted((f1, f2) -> f2.getPath().length() - f1.getPath().length()).collect(Collectors.toList());
        for (CPlusPlusModule module : ((Workspace)softwareSystem.getUniqueChild(Workspace.class)).getChildren(CPlusPlusModule.class)) {
            this.m_modules.add(module);
            for (TFile header : module.getAssociatedHeaders()) {
                this.m_headerFileToModuleMap.put(header, module);
            }
            for (RootDirectoryPath root : module.getChildren(RootDirectoryPath.class)) {
                if (root.isAutomatic()) continue;
                this.m_rootsToModules.put((Object)root.getFile(), (Object)module);
            }
        }
        this.m_externalFilter = ((CPlusPlusSoftwareSystemSettingsExtension)softwareSystem.getExtension(CPlusPlusSoftwareSystemSettingsExtension.class)).getUnboundExternalFilter();
        this.m_softwareSystem.getParserModel().removeElementIssues(new IIssueId[]{CPlusPlusIssueId.SOURCE_HAS_MULTIPLE_HEADERS, CPlusPlusIssueId.MISPLACED_DECLARATION});
    }

    private CPlusPlusModule getAnchorModule(TFile dir) {
        List modules = this.m_directoryToModule.get((Object)dir);
        if (modules.size() == 1) {
            return (CPlusPlusModule)((Object)modules.iterator().next());
        }
        if (modules.size() == 0) {
            for (TFile root : this.m_rootsToModules.keySet()) {
                if (!FileUtility.areEqual((TFile)dir, (TFile)root) && !root.isParentOf((File)dir) || (modules = this.m_rootsToModules.get((Object)root)).size() != 1) continue;
                return (CPlusPlusModule)((Object)modules.iterator().next());
            }
        }
        return null;
    }

    private List<Component> createModelComponents() {
        ArrayList<Component> unboundComponentList = new ArrayList<Component>();
        Iterator<Component> iter = this.m_components.iterator();
        while (iter.hasNext()) {
            Component component = iter.next();
            if (!component.createModelComponent(this)) {
                assert (component.getModelComponent() != null);
                unboundComponentList.add(component);
                continue;
            }
            if (component.getModelComponent() != null) continue;
            iter.remove();
        }
        return unboundComponentList;
    }

    private boolean hasInternalDependencies(Component comp, Set<CppComponent> anchored) {
        for (ProgrammingElement pe : comp.getModelComponent().getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
            for (ParserDependency dep : pe.getOutgoingDependencies(new IParserDependencyType[0])) {
                if (!dep.isArchitectureRelevant()) continue;
                ProgrammingElement target = dep.getTo();
                IComponent targetComp = (IComponent)target.getParent(IComponent.class, new Class[0]);
                if (targetComp == null) {
                    LOGGER.error("Dependency target does not belong to component: " + target.getDebugInfo());
                    LOGGER.error("Dependency: " + dep.getDebugInfo());
                    LOGGER.error("From: " + dep.getFrom().getDebugInfo());
                    pe.removeDependency(dep);
                    continue;
                }
                if (targetComp.isExternal() || !anchored.contains(targetComp)) continue;
                return true;
            }
        }
        return false;
    }

    private CppHeader makeExternal(CppHeader header) {
        assert (header != null) : "Parameter 'header' of method 'makeExternal' must not be null";
        External externalNode = (External)((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild(CPlusPlusExternal.class);
        List includeDirectories = externalNode.getChildren(CppIncludeDirectory.class);
        TFile headerFile = header.getFile();
        TFile dir = headerFile.getParentFile();
        CppIncludeDirectory incDir = includeDirectories.stream().filter(d -> d.getFile().isParentOf((File)headerFile)).findFirst().orElse(null);
        if (incDir == null) {
            TFile root = this.getRootFor(dir);
            incDir = new CppIncludeDirectory((IModelServiceProvider)this.m_softwareSystem, (NamedElement)externalNode, root, false);
            externalNode.addChild((NamedElement)incDir);
        }
        IDirectoryPath headerParent = this.getDirectoryFragmentFor(incDir, dir);
        CppExternalHeaderFile extHeader = new CppExternalHeaderFile((IModelServiceProvider)this.m_softwareSystem, headerParent.getNamedElement(), header);
        header.remove();
        headerParent.getNamedElement().addChild((NamedElement)extHeader);
        return extHeader;
    }

    private boolean containsDeclarations(CppSource source) {
        if (!source.getChildrenRecursively(CppMemberFunctionDeclaration.class, new Class[0]).isEmpty()) {
            return true;
        }
        if (!source.getChildrenRecursively(CppFunctionDeclaration.class, new Class[0]).isEmpty()) {
            return true;
        }
        for (CppVariable var : source.getChildrenRecursively(CppVariable.class, new Class[0])) {
            if (var.isDefinition()) continue;
            return true;
        }
        return false;
    }

    private void checkComponentSize() {
        HashSet<CppComponent> seen = new HashSet<CppComponent>();
        for (Component nextComponent : this.m_components) {
            CppComponent cppComp = nextComponent.getModelComponent();
            if (!seen.add(cppComp)) continue;
            List members = cppComp.getChildren(CppSource.class);
            long headers = members.stream().filter(m -> m.isIncludeFile() && this.containsDeclarations((CppSource)((Object)m))).count();
            if (members.size() <= 2 || headers <= 1L) continue;
            cppComp.addIssue((Issue)new MultipleHeaderComponentIssue((NamedElement)cppComp));
        }
    }

    private void run(Collection<CppHeaderFile> headers, Collection<CppSourceFile> sources) {
        ComponentBuilder builder = new ComponentBuilder(headers, sources, this.m_headerFileToModuleMap, this.m_rootsToModules);
        this.m_components = builder.buildComponents();
        Collections.sort(this.m_components, (c1, c2) -> c1.getPrimaryDirectory().getPath().length() - c2.getPrimaryDirectory().getPath().length());
        for (Component nextComponent : this.m_components) {
            if (!nextComponent.isAnchored()) continue;
            CPlusPlusModule anchorModule = nextComponent.getAnchorModule();
            for (TFile dir : nextComponent.getRelevantHeaderDirectories()) {
                this.m_directoryToModule.putIfNotPresent((Object)dir, (Object)anchorModule);
            }
        }
        List<Component> unboundComponentList = this.createModelComponents();
        this.handleUnboundComponents(unboundComponentList);
        for (CppHeader cppHeader : headers) {
            if (!cppHeader.isValid() || cppHeader.isExternal()) continue;
            cppHeader.rebase();
        }
        this.mergeComponentsWithSameName();
        this.checkComponentSize();
    }

    private TFile getRootFor(TFile dir) {
        for (TFile incRoot : this.m_otherIncludeRoots) {
            if (!incRoot.isParentOf((File)dir) && !FileUtility.areEqual((TFile)dir, (TFile)incRoot)) continue;
            return incRoot;
        }
        return dir;
    }

    private void assignToModule(Component comp, CPlusPlusModule mod) {
        TFile dir = comp.getPrimaryDirectory();
        Object matchingRoot = mod.getChildren(RootDirectoryPath.class).stream().filter(r -> r.getFile().equals((Object)dir) || r.getFile().isParentOf((File)dir)).findFirst().orElse(null);
        if (matchingRoot == null) {
            TFile root = this.getRootFor(dir);
            CppWeakRootDirectoryPath weakRoot = new CppWeakRootDirectoryPath((IModelServiceProvider)this.m_softwareSystem, (NamedElement)mod, root);
            mod.addChild((NamedElement)weakRoot);
            matchingRoot = weakRoot;
        }
        IDirectoryPath dirFrag = this.getDirectoryFragmentFor((RootDirectoryPath)matchingRoot.getNamedElement(), dir);
        this.moveToParent((NamedElement)comp.getModelComponent(), dirFrag.getNamedElement());
    }

    private void handleUnboundComponents(List<Component> unbounds) {
        int changes;
        ArrayList<Component> potentialExternalComponents = new ArrayList<Component>();
        for (Component nextUnbound : unbounds) {
            TFile dir = nextUnbound.getPrimaryDirectory();
            CPlusPlusModule module = this.getAnchorModule(dir);
            if (module != null) {
                this.assignToModule(nextUnbound, module);
                continue;
            }
            potentialExternalComponents.add(nextUnbound);
        }
        if (this.m_externalFilter.hasPatterns()) {
            Iterator iter = potentialExternalComponents.iterator();
            while (iter.hasNext()) {
                Component comp = (Component)iter.next();
                CppHeader header = comp.getPrimaryHeader();
                TFile path = header.getFile();
                String relPath = FileUtility.calculateRelativePath((TFile)path, (TFile)this.m_softwareSystem.getDirectoryFile());
                if (!this.m_externalFilter.includesPath(relPath)) continue;
                iter.remove();
                for (CppHeader h : comp.getModelComponent().getChildren(CppHeader.class)) {
                    this.makeExternal(h);
                }
            }
        }
        Set<CppComponent> anchoredComponents = this.m_components.stream().filter(c -> !potentialExternalComponents.contains(c)).map(c -> c.getModelComponent()).collect(Collectors.toSet());
        HashSet<Component> unboundComponents = new HashSet<Component>();
        do {
            changes = 0;
            for (Component nextComponent : potentialExternalComponents) {
                if (!this.hasInternalDependencies(nextComponent, anchoredComponents)) continue;
                ++changes;
                unboundComponents.add(nextComponent);
                anchoredComponents.add(nextComponent.getModelComponent());
            }
            potentialExternalComponents.removeAll(unboundComponents);
        } while (changes > 0);
        Workspace workspace = (Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        CPlusPlusModule unboundComponentsContainer = (CPlusPlusModule)((Object)workspace.getUniqueChild(CPlusPlusUnboundComponents.class));
        if (!unboundComponents.isEmpty()) {
            ArrayList unboundComponentList = new ArrayList(unboundComponents);
            Collections.sort(unboundComponentList, (c1, c2) -> c1.getPrimaryDirectory().getPath().length() - c2.getPrimaryDirectory().getPath().length());
            CPlusPlusModule targetModule = null;
            if (this.m_modules.size() == 1) {
                targetModule = this.m_modules.get(0);
            } else {
                if (unboundComponentsContainer == null) {
                    unboundComponentsContainer = new CPlusPlusUnboundComponents((NamedElement)workspace);
                    workspace.addChild((NamedElement)unboundComponentsContainer);
                }
                targetModule = unboundComponentsContainer;
            }
            for (Component nextComponent : unboundComponentList) {
                this.assignToModule(nextComponent, targetModule);
            }
        } else if (unboundComponentsContainer != null) {
            unboundComponentsContainer.remove();
        }
        if (!potentialExternalComponents.isEmpty()) {
            Iterator iter = potentialExternalComponents.iterator();
            ArrayList roots = new ArrayList();
            for (CPlusPlusModule mod : this.m_modules) {
                roots.addAll(mod.getChildren(RootDirectoryPath.class));
            }
            while (iter.hasNext()) {
                Component comp = (Component)iter.next();
                TFile dir = comp.getPrimaryDirectory();
                RootDirectoryPath root = roots.stream().filter(r -> r.getDirectoryFile().equals((Object)dir) || r.getDirectoryFile().isParentOf((File)dir)).findFirst().orElse(null);
                if (root == null) continue;
                iter.remove();
                this.assignToModule(comp, (CPlusPlusModule)((Object)root.getParent(CPlusPlusModule.class, new Class[0])));
            }
            for (Component nextComponent : potentialExternalComponents) {
                for (CppHeader header : nextComponent.getModelComponent().getChildren(CppHeader.class)) {
                    this.makeExternal(header);
                }
            }
        }
    }

    @Override
    public void moveToParent(NamedElement child, NamedElement parent) {
        assert (child != null) : "Parameter 'child' of method 'moveToParent' must not be null";
        NamedElement currentParent = child.getParent();
        if (currentParent != null) {
            currentParent.removeChild(child);
            child.setParent(null);
        }
        if (parent != null) {
            child.setParent(parent);
            parent.addChild(child);
        }
    }

    @Override
    public IDirectoryPath getDirectoryFragmentFor(RootDirectoryPath root, TFile primaryDir) {
        assert (root != null) : "Parameter 'root' of method 'getDirectoryFragmentFor' must not be null";
        assert (primaryDir != null);
        String relPath = FileUtility.calculateRelativePath((TFile)primaryDir, (TFile)root.getFile());
        return DirectoryFragment.getDirectoryFragmentOrSpecifiedParent((IModelServiceProvider)this.m_softwareSystem, (IDirectoryPath)root, (String)relPath, (DirectoryFragment.IDirectoryFragmentCreator)new DirectoryFragment.IDirectoryFragmentCreator(){

            public DirectoryFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                return new CppDirectoryFragment(msp, parent, name);
            }
        });
    }

    @Override
    public CppComponent createModelComponent(IDirectoryPath componentParent, String name) {
        CppComponent result = new CppComponent((IModelServiceProvider)this.m_softwareSystem, componentParent != null ? componentParent.getNamedElement() : null, name, componentParent == null);
        if (componentParent != null) {
            componentParent.getNamedElement().addChild((NamedElement)result);
        }
        return result;
    }

    private void mergeComponentsWithSameName() {
        MultipleValueMap nameToComponents = new MultipleValueMap();
        for (CppComponent cppComp : this.m_components.stream().map(c -> c.getModelComponent()).collect(Collectors.toList())) {
            if (cppComp.getParent() != null) {
                nameToComponents.put((Object)cppComp.getShortName(), (Object)cppComp);
                continue;
            }
            if (!cppComp.hasChildren()) continue;
            for (NamedElement child : cppComp.getChildren()) {
                LOGGER.error(String.format("*** Unexpected child '%s' (class %s) for discarded component", child.getName(), child.getClass().getName()));
                child.remove();
            }
        }
        for (String cname : nameToComponents.keySet()) {
            List comps = nameToComponents.get((Object)cname);
            if (comps.size() <= 1) continue;
            MultipleValueMap parentToComps = new MultipleValueMap();
            for (CppComponent comp : comps) {
                parentToComps.put((Object)comp.getParent(), (Object)comp);
            }
            if (parentToComps.size() >= comps.size()) continue;
            for (NamedElement parent : parentToComps.keySet()) {
                List compsWithSameParentAndName = parentToComps.get((Object)parent);
                if (compsWithSameParentAndName.size() <= 1) continue;
                Iterator iter = compsWithSameParentAndName.iterator();
                CppComponent master = (CppComponent)iter.next();
                while (iter.hasNext()) {
                    CppComponent next = (CppComponent)iter.next();
                    for (CppSource src : next.getChildren(CppSource.class)) {
                        src.changeParent((NamedElement)master, true);
                    }
                    next.remove();
                }
            }
        }
    }

    public static void createComponents(SoftwareSystem system, Collection<CppHeaderFile> headers, Collection<CppSourceFile> sources, Collection<TFile> otherIncludes) {
        ComponentAnalyzer analyzer = new ComponentAnalyzer(system, otherIncludes);
        analyzer.run(headers, sources);
    }

    public static void recreateComponents(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'recreateComponents' must not be null";
        ArrayList<TFile> otherIncludes = new ArrayList<TFile>();
        Workspace workspace = (Workspace)system.getUniqueExistingChild(Workspace.class);
        workspace.getChildrenRecursively(CppWeakRootDirectoryPath.class, new Class[]{SourceFile.class, External.class}).forEach(d -> {
            boolean bl = otherIncludes.add(d.getFile());
        });
        ((CPlusPlusExternal)((Object)workspace.getUniqueExistingChild(CPlusPlusExternal.class))).getChildren(CppIncludeDirectory.class).stream().filter(dir -> !dir.isSystemInclude()).forEach(d -> {
            boolean bl = otherIncludes.add(d.getFile());
        });
        ComponentRemovalVisitor visitor = new ComponentRemovalVisitor(system);
        ((Workspace)system.getUniqueExistingChild(Workspace.class)).accept((NamedElement.INamedElementVisitor)visitor);
        ComponentAnalyzer.createComponents(system, visitor.getProjectHeaders(), visitor.getProjectSources(), otherIncludes);
    }
}

