/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.architecture;

import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.architecture.controller.ArchitectureReader;
import com.hello2morrow.sonargraph.integration.architecture.model.ArchitecturalModel;
import java.io.File;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class ArchitectureReaderTest {
    @Test
    public void readArchitectureTest() {
        Result result = new Result("Reading Architecture");
        ArchitectureReader reader = new ArchitectureReader();
        Optional<ArchitecturalModel> modelOptional = reader.readArchitectureFile(new File("src/test/data/architecture/anytest.xml"), result);
        Assert.assertTrue((String)"Failed to read architecture", (boolean)result.isSuccess());
        Assert.assertTrue((boolean)modelOptional.isPresent());
        ArchitecturalModel architecturalModel = modelOptional.get();
        Assert.assertEquals((String)"Wrong number of artifacts", (long)2L, (long)architecturalModel.getArtifacts().size());
        Assert.assertNotNull((String)"Missing artifact", (Object)architecturalModel.findArtifact("Alarm.App"));
        Assert.assertNotNull((String)"Missing interface", (Object)architecturalModel.findInterface("Alarm.App.default"));
        Assert.assertNotNull((String)"Missing connector", (Object)architecturalModel.findConnector("Alarm.App.default"));
        Assert.assertEquals((String)"Wrong version", (Object)"9.11.2.100", (Object)architecturalModel.getVersion());
        Assert.assertEquals((String)"Wrong system path", (Object)"D:\\00_repo\\sgng\\com.hello2morrow.sonargraph.language.provider.java\\src\\test\\architecture\\AlarmClockWithArchitecture\\AlarmClock.sonargraph", (Object)architecturalModel.getSystemPath());
        Assert.assertEquals((String)"Wrong system id", (Object)"4df288656010188b4d84a2a03bb0ecb9", (Object)architecturalModel.getSystemId());
        Assert.assertEquals((String)"Wrong timestamp", (long)1562668320367L, (long)architecturalModel.getTimestamp());
    }
}

