/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.foundation.Utility;
import com.hello2morrow.sonargraph.integration.access.model.BaselineCurrent;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssueDelta;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.IThresholdViolationIssue;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public final class IssueDeltaImpl
implements IIssueDelta {
    private static final long serialVersionUID = -3056194877234260699L;
    private static final String BASELINE_CURRENT = " (baseline/current): ";
    private final List<IIssue> addedIssues = new ArrayList<IIssue>();
    private final List<IIssue> removedIssues = new ArrayList<IIssue>();
    private final List<BaselineCurrent<IIssue>> issuesWithChangedResolutionType = new ArrayList<BaselineCurrent<IIssue>>();
    private final List<BaselineCurrent<IThresholdViolationIssue>> improvedThresholdViolationIssues = new ArrayList<BaselineCurrent<IThresholdViolationIssue>>();
    private final List<BaselineCurrent<IThresholdViolationIssue>> worsenedThresholdViolationIssues = new ArrayList<BaselineCurrent<IThresholdViolationIssue>>();
    private final Map<String, String> addedToCycle = new TreeMap<String, String>();
    private final Map<String, String> removedFromCycle = new TreeMap<String, String>();
    private final Map<String, BaselineCurrent<Integer>> improvedCycleParticipation = new TreeMap<String, BaselineCurrent<Integer>>();
    private final Map<String, BaselineCurrent<Integer>> worsenedCycleParticipation = new TreeMap<String, BaselineCurrent<Integer>>();
    private final Map<String, BaselineCurrent<Integer>> changedDuplicateCodeBlockParticipation = new HashMap<String, BaselineCurrent<Integer>>();
    private BaselineCurrent<Integer> improvedDuplicateCodeParticipation;
    private BaselineCurrent<Integer> worsenedDuplicateCodeParticipation;

    public void added(IIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'added' must not be null";
        this.addedIssues.add(issue);
    }

    public void removed(IIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'removed' must not be null";
        this.removedIssues.add(issue);
    }

    public void changedResolutionType(BaselineCurrent<IIssue> baselineCurrent) {
        assert (baselineCurrent != null) : "Parameter 'baselineCurrent' of method 'changedResolutionType' must not be null";
        this.issuesWithChangedResolutionType.add(baselineCurrent);
    }

    public void improved(BaselineCurrent<IThresholdViolationIssue> baselineCurrent) {
        assert (baselineCurrent != null) : "Parameter 'baselineCurrent' of method 'improved' must not be null";
        this.improvedThresholdViolationIssues.add(baselineCurrent);
    }

    public void worsened(BaselineCurrent<IThresholdViolationIssue> baselineCurrent) {
        assert (baselineCurrent != null) : "Parameter 'baselineCurrent' of method 'worsened' must not be null";
        this.worsenedThresholdViolationIssues.add(baselineCurrent);
    }

    public void addedToCycle(String namedElementFqName, String cycleInfo) {
        assert (namedElementFqName != null && namedElementFqName.length() > 0) : "Parameter 'namedElementFqName' of method 'addedToCycle' must not be empty";
        assert (cycleInfo != null && cycleInfo.length() > 0) : "Parameter 'cycleInfo' of method 'addedToCycle' must not be empty";
        this.addedToCycle.put(namedElementFqName, cycleInfo);
    }

    public void removedFromCycle(String namedElementFqName, String cycleInfo) {
        assert (namedElementFqName != null && namedElementFqName.length() > 0) : "Parameter 'namedElementFqName' of method 'removedFromCycle' must not be empty";
        assert (cycleInfo != null && cycleInfo.length() > 0) : "Parameter 'cycleInfo' of method 'removedFromCycle' must not be empty";
        this.removedFromCycle.put(namedElementFqName, cycleInfo);
    }

    public void improvedCycleParticipation(String cycleInfo, BaselineCurrent<Integer> baselineCurrent) {
        assert (cycleInfo != null && cycleInfo.length() > 0) : "Parameter 'cycleInfo' of method 'improvedCycleParticipation' must not be empty";
        assert (baselineCurrent != null) : "Parameter 'baselineCurrent' of method 'improvedCycleParticipation' must not be null";
        this.improvedCycleParticipation.put(cycleInfo, baselineCurrent);
    }

    public void worsenedCycleParticipation(String cycleInfo, BaselineCurrent<Integer> baselineCurrent) {
        assert (cycleInfo != null && cycleInfo.length() > 0) : "Parameter 'cycleInfo' of method 'worsenedCycleParticipation' must not be empty";
        assert (baselineCurrent != null) : "Parameter 'baselineCurrent' of method 'worsenedCycleParticipation' must not be null";
        this.worsenedCycleParticipation.put(cycleInfo, baselineCurrent);
    }

    public void changedDuplicateCodeParticipation(String namedElementFqName, BaselineCurrent<Integer> baselineCurrent) {
        assert (namedElementFqName != null) : "Parameter 'namedElementFqName' of method 'changedDuplicateCodeParticipation' must not be null";
        assert (baselineCurrent != null) : "Parameter 'baselineCurrent' of method 'changedDuplicateCodeParticipation' must not be null";
        this.changedDuplicateCodeBlockParticipation.put(namedElementFqName, baselineCurrent);
    }

    public void improvedDuplicateCodeParticipation(BaselineCurrent<Integer> baselineCurrent) {
        assert (baselineCurrent != null) : "Parameter 'baselineCurrent' of method 'improvedDuplicateCodeParticipation' must not be null";
        this.improvedDuplicateCodeParticipation = baselineCurrent;
    }

    public void worsenedDuplicateCodeParticipation(BaselineCurrent<Integer> baselineCurrent) {
        assert (baselineCurrent != null) : "Parameter 'baselineCurrent' of method 'worsenedDuplicateCodeParticipation' must not be null";
        this.worsenedDuplicateCodeParticipation = baselineCurrent;
    }

    @Override
    public List<IIssue> getAdded() {
        return Collections.unmodifiableList(this.addedIssues);
    }

    @Override
    public List<IIssue> getRemoved() {
        return Collections.unmodifiableList(this.removedIssues);
    }

    @Override
    public List<BaselineCurrent<IIssue>> getChangedResolutionType() {
        return Collections.unmodifiableList(this.issuesWithChangedResolutionType);
    }

    @Override
    public List<BaselineCurrent<IThresholdViolationIssue>> getWorsenedThresholdViolation() {
        return Collections.unmodifiableList(this.worsenedThresholdViolationIssues);
    }

    @Override
    public List<BaselineCurrent<IThresholdViolationIssue>> getImprovedThresholdViolation() {
        return Collections.unmodifiableList(this.improvedThresholdViolationIssues);
    }

    @Override
    public Map<String, String> getAddedToCycle() {
        return Collections.unmodifiableMap(this.addedToCycle);
    }

    @Override
    public Map<String, String> getRemovedFromCycle() {
        return Collections.unmodifiableMap(this.removedFromCycle);
    }

    @Override
    public Map<String, BaselineCurrent<Integer>> getImprovedCycleParticipation() {
        return Collections.unmodifiableMap(this.improvedCycleParticipation);
    }

    @Override
    public Map<String, BaselineCurrent<Integer>> getWorsenedCycleParticipation() {
        return Collections.unmodifiableMap(this.worsenedCycleParticipation);
    }

    @Override
    public Optional<BaselineCurrent<Integer>> getImprovedDuplicateCodeParticipation() {
        return Optional.ofNullable(this.improvedDuplicateCodeParticipation);
    }

    @Override
    public Optional<BaselineCurrent<Integer>> getWorsenedDuplicateCodeParticipation() {
        return Optional.ofNullable(this.worsenedDuplicateCodeParticipation);
    }

    @Override
    public Map<String, BaselineCurrent<Integer>> getChangedDuplicateCodeBlockParticipation() {
        return Collections.unmodifiableMap(this.changedDuplicateCodeBlockParticipation);
    }

    @Override
    public boolean isEmpty() {
        return this.addedIssues.isEmpty() && this.removedIssues.isEmpty() && this.issuesWithChangedResolutionType.isEmpty() && this.improvedThresholdViolationIssues.isEmpty() && this.worsenedThresholdViolationIssues.isEmpty() && this.addedToCycle.isEmpty() && this.removedFromCycle.isEmpty() && this.improvedCycleParticipation.isEmpty() && this.worsenedCycleParticipation.isEmpty() && this.changedDuplicateCodeBlockParticipation.isEmpty() && this.improvedDuplicateCodeParticipation == null && this.worsenedDuplicateCodeParticipation == null;
    }

    private void addAffectedNamedElementsInfo(StringBuilder builder, IIssue issue) {
        assert (builder != null) : "Parameter 'builder' of method 'addAffectedNamedElementsInfo' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'addAffectedNamedElementsInfo' must not be null";
        for (INamedElement nextNamedElement : issue.getAffectedNamedElements()) {
            builder.append("\n").append("   ").append("   ").append("   ").append(nextNamedElement.getFqName()).append(" [").append(nextNamedElement.getKind()).append("]");
        }
    }

    private void addIssuesInfo(StringBuilder builder, List<IIssue> issues) {
        assert (builder != null) : "Parameter 'builder' of method 'addIssuesInfo' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'addIssuesInfo' must not be null";
        for (IIssue nextIssue : issues) {
            builder.append("\n").append("   ").append("   ").append(nextIssue.getKey());
            ResolutionType nextResolutionType = nextIssue.getResolutionType();
            if (!ResolutionType.NONE.equals(nextResolutionType)) {
                builder.append(" [").append(nextResolutionType.getPresentationName()).append("]");
            }
            this.addAffectedNamedElementsInfo(builder, nextIssue);
        }
    }

    public String toString() {
        BaselineCurrent nextBaselineCurrent;
        IThresholdViolationIssue nextCurrent;
        IIssue nextBaseline;
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("   ").append("Added issues (").append(this.addedIssues.size()).append(")");
        this.addIssuesInfo(builder, this.addedIssues);
        builder.append("\n").append("   ").append("Removed issues (").append(this.removedIssues.size()).append(")");
        this.addIssuesInfo(builder, this.removedIssues);
        builder.append("\n").append("   ").append("Issues with changed resolution type (").append(this.issuesWithChangedResolutionType.size()).append(")");
        for (BaselineCurrent<IIssue> baselineCurrent : this.issuesWithChangedResolutionType) {
            nextBaseline = baselineCurrent.getBaseline();
            builder.append("\n").append("   ").append("   ").append(nextBaseline.getKey()).append(BASELINE_CURRENT).append(nextBaseline.getResolutionType().getPresentationName()).append("/").append(baselineCurrent.getCurrent().getResolutionType().getPresentationName());
        }
        builder.append("\n").append("   ").append("Improved metric values of threshold violations (").append(this.improvedThresholdViolationIssues.size()).append(")");
        for (BaselineCurrent<IIssue> baselineCurrent : this.improvedThresholdViolationIssues) {
            nextBaseline = (IThresholdViolationIssue)baselineCurrent.getBaseline();
            nextCurrent = (IThresholdViolationIssue)baselineCurrent.getCurrent();
            builder.append("\n").append("   ").append("   ").append(nextBaseline.getKey()).append(BASELINE_CURRENT).append(Utility.getRoundedValueAsString(nextBaseline.getMetricValue(), 2)).append("/").append(Utility.getRoundedValueAsString(nextCurrent.getMetricValue(), 2));
            this.addAffectedNamedElementsInfo(builder, nextCurrent);
        }
        builder.append("\n").append("   ").append("Worsened metric values of threshold violations (").append(this.worsenedThresholdViolationIssues.size()).append(")");
        for (BaselineCurrent<IIssue> baselineCurrent : this.worsenedThresholdViolationIssues) {
            nextBaseline = (IThresholdViolationIssue)baselineCurrent.getBaseline();
            nextCurrent = (IThresholdViolationIssue)baselineCurrent.getCurrent();
            builder.append("\n").append("   ").append("   ").append(nextBaseline.getKey()).append(BASELINE_CURRENT).append(Utility.getRoundedValueAsString(nextBaseline.getMetricValue(), 2)).append("/").append(Utility.getRoundedValueAsString(nextCurrent.getMetricValue(), 2));
            this.addAffectedNamedElementsInfo(builder, nextCurrent);
        }
        builder.append("\n").append("   ").append("Elements added to cycles (").append(this.addedToCycle.size()).append(")");
        for (Map.Entry entry : this.addedToCycle.entrySet()) {
            builder.append("\n").append("   ").append("   ").append("   ").append((String)entry.getKey()).append(" [").append((String)entry.getValue()).append("]");
        }
        builder.append("\n").append("   ").append("Elements removed from cycles (").append(this.removedFromCycle.size()).append(")");
        for (Map.Entry entry : this.removedFromCycle.entrySet()) {
            builder.append("\n").append("   ").append("   ").append("   ").append((String)entry.getKey()).append(" [").append((String)entry.getValue()).append("]");
        }
        builder.append("\n").append("   ").append("Overall cycle participation improved (").append(this.improvedCycleParticipation.size()).append(")");
        for (Map.Entry entry : this.improvedCycleParticipation.entrySet()) {
            nextBaselineCurrent = (BaselineCurrent)entry.getValue();
            builder.append("\n").append("   ").append("   ").append((String)entry.getKey()).append(" - number of cyclic elements (baseline/current): ").append(nextBaselineCurrent.getBaseline()).append("/").append(nextBaselineCurrent.getCurrent());
        }
        builder.append("\n").append("   ").append("Overall cycle participation worsened (").append(this.worsenedCycleParticipation.size()).append(")");
        for (Map.Entry entry : this.worsenedCycleParticipation.entrySet()) {
            nextBaselineCurrent = (BaselineCurrent)entry.getValue();
            builder.append("\n").append("   ").append("   ").append((String)entry.getKey()).append(" - number of cyclic elements (baseline/current): ").append(nextBaselineCurrent.getBaseline()).append("/").append(nextBaselineCurrent.getCurrent());
        }
        builder.append("\n").append("   ").append("Elements with changed number of duplicate code block occurrences (").append(this.changedDuplicateCodeBlockParticipation.size()).append(")");
        for (Map.Entry entry : this.changedDuplicateCodeBlockParticipation.entrySet()) {
            builder.append("\n").append("   ").append("   ").append("   ").append((String)entry.getKey());
            BaselineCurrent nextValue = (BaselineCurrent)entry.getValue();
            builder.append(BASELINE_CURRENT).append(nextValue.getBaseline()).append("/").append(nextValue.getCurrent());
        }
        if (this.improvedDuplicateCodeParticipation != null) {
            builder.append("\n").append("   ").append("Overall number of duplicate code block occurrences improved (baseline/current): ").append(this.improvedDuplicateCodeParticipation.getBaseline()).append("/").append(this.improvedDuplicateCodeParticipation.getCurrent());
        } else if (this.worsenedDuplicateCodeParticipation == null) {
            builder.append("\n").append("   ").append("Overall number of duplicate code block occurences not improved");
        }
        if (this.worsenedDuplicateCodeParticipation != null) {
            builder.append("\n").append("   ").append("Overall number of duplicate code block occurrences worsened (baseline/current): ").append(this.worsenedDuplicateCodeParticipation.getBaseline()).append("/").append(this.worsenedDuplicateCodeParticipation.getCurrent());
        } else if (this.improvedDuplicateCodeParticipation == null) {
            builder.append("\n").append("   ").append("Overall number of duplicate code block occurences not worsened");
        }
        return builder.toString();
    }
}

