/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IFilter;
import com.hello2morrow.sonargraph.integration.access.model.IWildcardPattern;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementWithDescriptionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractFilterImpl
extends ElementWithDescriptionImpl
implements IFilter {
    private static final long serialVersionUID = 1L;
    private final int numberOfExcludedElements;
    private final String information;
    private final List<IWildcardPattern> includePatterns = new ArrayList<IWildcardPattern>();
    private final List<IWildcardPattern> excludePatterns = new ArrayList<IWildcardPattern>();

    public AbstractFilterImpl(String name, String presentationName, String description, String information, int numberOfExcludedElements) {
        super(name, presentationName, description);
        assert (information != null) : "Parameter 'information' of method 'FilterImpl' must not be null";
        this.information = information;
        this.numberOfExcludedElements = numberOfExcludedElements;
    }

    @Override
    public final String getInformation() {
        return this.information;
    }

    @Override
    public final int getNumberOfExcludedElements() {
        return this.numberOfExcludedElements;
    }

    public final void addIncludePattern(IWildcardPattern pattern) {
        assert (pattern != null) : "Parameter 'pattern' of method 'addIncludePattern' must not be null";
        this.includePatterns.add(pattern);
    }

    @Override
    public final List<IWildcardPattern> getIncludePatterns() {
        return Collections.unmodifiableList(this.includePatterns);
    }

    public final void addExcludePattern(IWildcardPattern pattern) {
        assert (pattern != null) : "Parameter 'pattern' of method 'addExcludePattern' must not be null";
        this.excludePatterns.add(pattern);
    }

    @Override
    public final List<IWildcardPattern> getExcludePatterns() {
        return Collections.unmodifiableList(this.excludePatterns);
    }
}

